"""
This file contains the chosen files and hardcoded output for testing main_objs.
"""

import numpy as np

# Name of the files for unit testing
TEST_FILES = [
    # example model
    'CRIM_Model_0001.mei',
    # model with additional massaging for incorrect measure offsets
    'CRIM_Model_0009.mei',
    # example mass
    'CRIM_Mass_0001_1.mei',
]

# measure number offsets of the files for unit testing
TEST_FILES_MS = [{'Superius': {0.0: 1, 8.0: 2, 320.0: 41, 536.0: 68, 1072.0: 134},
                  'Contratenor': {0.0: 1, 8.0: 2, 320.0: 41, 536.0: 68, 1072.0: 134},
                  'PrimusTenor': {0.0: 1, 8.0: 2, 320.0: 41, 536.0: 68, 1072.0: 134},
                  'SecundusTenor': {0.0: 1, 8.0: 2, 320.0: 41, 536.0: 68, 1072.0: 134},
                  'Bassus': {0.0: 1, 8.0: 2, 320.0: 41, 536.0: 68, 1072.0: 134}},
                 {'Superius': {0.0: 1, 8.0: 2, 72.0: 10, 120.0: 16, 240.0: 31},
                  'Contratenor': {0.0: 1, 8.0: 2, 72.0: 10, 120.0: 16, 240.0: 31},
                  'Tenor': {0.0: 1, 8.0: 2, 72.0: 10, 120.0: 16, 240.0: 31},
                  'Bassus': {0.0: 1, 8.0: 2, 72.0: 10, 120.0: 16, 240.0: 31}},
                 {'Superius': {0.0: 1, 8.0: 2, 64.0: 9, 120.0: 15, 232.0: 28},
                  'Contratenor': {0.0: 1, 8.0: 2, 64.0: 9, 120.0: 15, 232.0: 28},
                  'Tenor': {0.0: 1, 8.0: 2, 64.0: 9, 120.0: 15, 232.0: 28},
                  'Bassus': {0.0: 1, 8.0: 2, 64.0: 9, 120.0: 15, 232.0: 28}}]

# sounding count of the random lines of the files for unit testing
TEST_FILES_SC = [{0.0: 1, 4.0: 1, 310.0: 4, 528.0: 4, 1072.0: 5},
                 {0.0: 1, 4.0: 2, 72.0: 4, 116.0: 4, 246.0: 4},
                 {0.0: 4, 6.0: 4, 62.0: 4, 118.0: 4, 236.0: 4}]

# time signature of the files for unit testing
TEST_FILES_TS = [{'Superius': {0.0: '4/2', 560.0: '8/2', 576.0: '4/2', 1072.0: '8/2'},
                  'Contratenor': {0.0: '4/2', 560.0: '8/2', 576.0: '4/2', 1072.0: '8/2'},
                  'PrimusTenor': {0.0: '4/2', 560.0: '8/2', 576.0: '4/2', 1072.0: '8/2'},
                  'SecundusTenor': {0.0: '4/2', 560.0: '8/2', 576.0: '4/2', 1072.0: '8/2'},
                  'Bassus': {0.0: '4/2', 560.0: '8/2', 576.0: '4/2', 1072.0: '8/2'}},
                 {'Superius': {0.0: '4/2'},
                  'Contratenor': {0.0: '4/2'},
                  'Tenor': {0.0: '4/2'},
                  'Bassus': {0.0: '4/2'}},
                 {'Superius': {0.0: '4/2',
                               72.0: '8/2',
                               88.0: '4/2',
                               152.0: '8/2',
                               168.0: '4/2',
                               232.0: '10/2'},
                  'Contratenor': {0.0: '4/2',
                                  72.0: '8/2',
                                  88.0: '4/2',
                                  152.0: '8/2',
                                  168.0: '4/2',
                                  232.0: '10/2'},
                  'Tenor': {0.0: '4/2',
                            72.0: '8/2',
                            88.0: '4/2',
                            152.0: '8/2',
                            168.0: '4/2',
                            232.0: '10/2'},
                  'Bassus': {0.0: '4/2',
                             72.0: '8/2',
                             88.0: '4/2',
                             152.0: '8/2',
                             168.0: '4/2',
                             232.0: '10/2'}}]

# harmonic intervals in different setting hardcoded
TEST_FILES_HARMONIC_QTT = [
    {'Bassus_SecundusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'Rest', 528.0: 'Rest', 663.0: 'P4', 1072.0: 'M3'},
     'Bassus_PrimusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'Rest', 528.0: 'P5', 663.0: np.nan, 1072.0: 'P1'},
     'Bassus_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: np.nan, 528.0: 'P8', 663.0: np.nan, 1072.0: 'P5'},
     'Bassus_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: 'Rest', 528.0: 'M10', 663.0: np.nan, 1072.0: 'P8'},
     'SecundusTenor_PrimusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: '-m3', 528.0: 'Rest', 663.0: 'M2', 1072.0: '-M3'},
     'SecundusTenor_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'M3', 528.0: 'Rest', 663.0: 'P5', 1072.0: 'm3'},
     'SecundusTenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: 'M6', 528.0: 'Rest', 663.0: 'M9', 1072.0: 'm6'},
     'PrimusTenor_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'P5', 528.0: 'P4', 663.0: np.nan, 1072.0: 'P5'},
     'PrimusTenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: 'P8', 528.0: 'M6', 663.0: np.nan, 1072.0: np.nan},
     'Contratenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: 'P4', 528.0: 'M3', 663.0: np.nan, 1072.0: 'P4'}},
    {'Bassus_Tenor': {0.0: 'Rest', 4.0: 'P1', 72.0: 'm3', 116.0: 'm3', 144.0: 'P4', 246.0: np.nan},
     'Bassus_Contratenor': {0.0: 'Rest', 4.0: 'Rest', 72.0: 'P5', 116.0: 'P5', 144.0: 'M6', 246.0: np.nan},
     'Bassus_Superius': {0.0: 'Rest', 4.0: 'Rest', 72.0: 'P8', 116.0: 'm10', 144.0: 'Rest', 246.0: 'm10'},
     'Tenor_Contratenor': {0.0: 'Rest', 4.0: 'Rest', 72.0: 'M3', 116.0: 'M3', 144.0: 'M3', 246.0: np.nan},
     'Tenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 72.0: 'M6', 116.0: 'P8', 144.0: 'Rest', 246.0: 'm6'},
     'Contratenor_Superius': {0.0: 'Rest', 4.0: np.nan, 72.0: 'P4', 116.0: 'm6', 144.0: 'Rest', 246.0: 'm3'}},
    {'Bassus_Tenor': {0.0: 'm3', 6.0: 'm3', 62.0: 'P8', 118.0: 'm6', 138.0: 'A4', 236.0: 'P1'},
     'Bassus_Contratenor': {0.0: 'P5', 6.0: 'P5', 62.0: 'M10', 118.0: 'm13', 138.0: 'M6', 236.0: 'P5'},
     'Bassus_Superius': {0.0: 'P8', 6.0: 'P8', 62.0: 'M13', 118.0: 'P15', 138.0: 'M10', 236.0: 'P8'},
     'Tenor_Contratenor': {0.0: 'M3', 6.0: 'M3', 62.0: 'M3', 118.0: 'P8', 138.0: 'm3', 236.0: 'P5'},
     'Tenor_Superius': {0.0: 'M6', 6.0: 'M6', 62.0: 'M6', 118.0: 'M10', 138.0: 'm7', 236.0: 'P8'},
     'Contratenor_Superius': {0.0: 'P4', 6.0: 'P4', 62.0: 'P4', 118.0: 'M3', 138.0: 'P5', 236.0: 'P4'}}]
TEST_FILES_HARMONIC_QTF = [
    {'Bassus_SecundusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'Rest', 528.0: 'Rest', 663.0: 'P4', 1072.0: 'M3'},
     'Bassus_PrimusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'Rest', 528.0: 'P5', 663.0: np.nan, 1072.0: '-P1'},
     'Bassus_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: np.nan, 528.0: 'P8', 663.0: np.nan, 1072.0: 'P5'},
     'Bassus_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: 'Rest', 528.0: 'M3', 663.0: np.nan, 1072.0: 'P8'},
     'SecundusTenor_PrimusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: '-m3', 528.0: 'Rest', 663.0: 'M2', 1072.0: '-M3'},
     'SecundusTenor_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'M3', 528.0: 'Rest', 663.0: 'P5', 1072.0: 'm3'},
     'SecundusTenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: 'M6', 528.0: 'Rest', 663.0: 'M2', 1072.0: 'm6'},
     'PrimusTenor_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'P5', 528.0: 'P4', 663.0: np.nan, 1072.0: 'P5'},
     'PrimusTenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: 'P8', 528.0: 'M6', 663.0: np.nan, 1072.0: np.nan},
     'Contratenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: 'P4', 528.0: 'M3', 663.0: np.nan, 1072.0: 'P4'}},
    {'Bassus_Tenor': {0.0: 'Rest', 4.0: '-P1', 72.0: 'm3', 116.0: 'm3', 144.0: 'P4', 246.0: np.nan},
     'Bassus_Contratenor': {0.0: 'Rest', 4.0: 'Rest', 72.0: 'P5', 116.0: 'P5', 144.0: 'M6', 246.0: np.nan},
     'Bassus_Superius': {0.0: 'Rest', 4.0: 'Rest', 72.0: 'P8', 116.0: 'm3', 144.0: 'Rest', 246.0: 'm3'},
     'Tenor_Contratenor': {0.0: 'Rest', 4.0: 'Rest', 72.0: 'M3', 116.0: 'M3', 144.0: 'M3', 246.0: np.nan},
     'Tenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 72.0: 'M6', 116.0: 'P8', 144.0: 'Rest', 246.0: 'm6'},
     'Contratenor_Superius': {0.0: 'Rest', 4.0: np.nan, 72.0: 'P4', 116.0: 'm6', 144.0: 'Rest', 246.0: 'm3'}},
    {'Bassus_Tenor': {0.0: 'm3', 6.0: 'm3', 62.0: 'P8', 118.0: 'm6', 138.0: 'A4', 236.0: '-P1'},
     'Bassus_Contratenor': {0.0: 'P5', 6.0: 'P5', 62.0: 'M3', 118.0: 'm6', 138.0: 'M6', 236.0: 'P5'},
     'Bassus_Superius': {0.0: 'P8', 6.0: 'P8', 62.0: 'M6', 118.0: 'P8', 138.0: 'M3', 236.0: 'P8'},
     'Tenor_Contratenor': {0.0: 'M3', 6.0: 'M3', 62.0: 'M3', 118.0: 'P8', 138.0: 'm3', 236.0: 'P5'},
     'Tenor_Superius': {0.0: 'M6', 6.0: 'M6', 62.0: 'M6', 118.0: 'M3', 138.0: 'm7', 236.0: 'P8'},
     'Contratenor_Superius': {0.0: 'P4', 6.0: 'P4', 62.0: 'P4', 118.0: 'M3', 138.0: 'P5', 236.0: 'P4'}}]
TEST_FILES_HARMONIC_DTT = [
    {'Bassus_SecundusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'Rest', 528.0: 'Rest', 663.0: '4', 1072.0: '3'},
     'Bassus_PrimusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'Rest', 528.0: '5', 663.0: np.nan, 1072.0: '1'},
     'Bassus_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: np.nan, 528.0: '8', 663.0: np.nan, 1072.0: '5'},
     'Bassus_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: 'Rest', 528.0: '10', 663.0: np.nan, 1072.0: '8'},
     'SecundusTenor_PrimusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: '-3', 528.0: 'Rest', 663.0: '2', 1072.0: '-3'},
     'SecundusTenor_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: '3', 528.0: 'Rest', 663.0: '5', 1072.0: '3'},
     'SecundusTenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: '6', 528.0: 'Rest', 663.0: '9', 1072.0: '6'},
     'PrimusTenor_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: '5', 528.0: '4', 663.0: np.nan, 1072.0: '5'},
     'PrimusTenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: '8', 528.0: '6', 663.0: np.nan, 1072.0: np.nan},
     'Contratenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: '4', 528.0: '3', 663.0: np.nan, 1072.0: '4'}},
    {'Bassus_Tenor': {0.0: 'Rest', 4.0: '1', 72.0: '3', 116.0: '3', 144.0: '4', 246.0: np.nan},
     'Bassus_Contratenor': {0.0: 'Rest', 4.0: 'Rest', 72.0: '5', 116.0: '5', 144.0: '6', 246.0: np.nan},
     'Bassus_Superius': {0.0: 'Rest', 4.0: 'Rest', 72.0: '8', 116.0: '10', 144.0: 'Rest', 246.0: '10'},
     'Tenor_Contratenor': {0.0: 'Rest', 4.0: 'Rest', 72.0: '3', 116.0: '3', 144.0: '3', 246.0: np.nan},
     'Tenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 72.0: '6', 116.0: '8', 144.0: 'Rest', 246.0: '6'},
     'Contratenor_Superius': {0.0: 'Rest', 4.0: np.nan, 72.0: '4', 116.0: '6', 144.0: 'Rest', 246.0: '3'}},
    {'Bassus_Tenor': {0.0: '3', 6.0: '3', 62.0: '8', 118.0: '6', 138.0: '4', 236.0: '1'},
     'Bassus_Contratenor': {0.0: '5', 6.0: '5', 62.0: '10', 118.0: '13', 138.0: '6', 236.0: '5'},
     'Bassus_Superius': {0.0: '8', 6.0: '8', 62.0: '13', 118.0: '15', 138.0: '10', 236.0: '8'},
     'Tenor_Contratenor': {0.0: '3', 6.0: '3', 62.0: '3', 118.0: '8', 138.0: '3', 236.0: '5'},
     'Tenor_Superius': {0.0: '6', 6.0: '6', 62.0: '6', 118.0: '10', 138.0: '7', 236.0: '8'},
     'Contratenor_Superius': {0.0: '4', 6.0: '4', 62.0: '4', 118.0: '3', 138.0: '5', 236.0: '4'}}]
TEST_FILES_HARMONIC_DTF = [
    {'Bassus_SecundusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'Rest', 528.0: 'Rest', 663.0: '4', 1072.0: '3'},
     'Bassus_PrimusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'Rest', 528.0: '5', 663.0: np.nan, 1072.0: '1'},
     'Bassus_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: np.nan, 528.0: '8', 663.0: np.nan, 1072.0: '5'},
     'Bassus_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: 'Rest', 528.0: '3', 663.0: np.nan, 1072.0: '8'},
     'SecundusTenor_PrimusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: '-3', 528.0: 'Rest', 663.0: '2', 1072.0: '-3'},
     'SecundusTenor_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: '3', 528.0: 'Rest', 663.0: '5', 1072.0: '3'},
     'SecundusTenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: '6', 528.0: 'Rest', 663.0: '2', 1072.0: '6'},
     'PrimusTenor_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: '5', 528.0: '4', 663.0: np.nan, 1072.0: '5'},
     'PrimusTenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: '8', 528.0: '6', 663.0: np.nan, 1072.0: np.nan},
     'Contratenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: '4', 528.0: '3', 663.0: np.nan, 1072.0: '4'}},
    {'Bassus_Tenor': {0.0: 'Rest', 4.0: '1', 72.0: '3', 116.0: '3', 144.0: '4', 246.0: np.nan},
     'Bassus_Contratenor': {0.0: 'Rest', 4.0: 'Rest', 72.0: '5', 116.0: '5', 144.0: '6', 246.0: np.nan},
     'Bassus_Superius': {0.0: 'Rest', 4.0: 'Rest', 72.0: '8', 116.0: '3', 144.0: 'Rest', 246.0: '3'},
     'Tenor_Contratenor': {0.0: 'Rest', 4.0: 'Rest', 72.0: '3', 116.0: '3', 144.0: '3', 246.0: np.nan},
     'Tenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 72.0: '6', 116.0: '8', 144.0: 'Rest', 246.0: '6'},
     'Contratenor_Superius': {0.0: 'Rest', 4.0: np.nan, 72.0: '4', 116.0: '6', 144.0: 'Rest', 246.0: '3'}},
    {'Bassus_Tenor': {0.0: '3', 6.0: '3', 62.0: '8', 118.0: '6', 138.0: '4', 236.0: '1'},
     'Bassus_Contratenor': {0.0: '5', 6.0: '5', 62.0: '3', 118.0: '6', 138.0: '6', 236.0: '5'},
     'Bassus_Superius': {0.0: '8', 6.0: '8', 62.0: '6', 118.0: '8', 138.0: '3', 236.0: '8'},
     'Tenor_Contratenor': {0.0: '3', 6.0: '3', 62.0: '3', 118.0: '8', 138.0: '3', 236.0: '5'},
     'Tenor_Superius': {0.0: '6', 6.0: '6', 62.0: '6', 118.0: '3', 138.0: '7', 236.0: '8'},
     'Contratenor_Superius': {0.0: '4', 6.0: '4', 62.0: '4', 118.0: '3', 138.0: '5', 236.0: '4'}}]
TEST_FILES_HARMONIC_DFT = [
    {'Bassus_SecundusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'Rest', 528.0: 'Rest', 663.0: '4', 1072.0: '3'},
     'Bassus_PrimusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'Rest', 528.0: '5', 663.0: np.nan, 1072.0: '1'},
     'Bassus_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: np.nan, 528.0: '8', 663.0: np.nan, 1072.0: '5'},
     'Bassus_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: 'Rest', 528.0: '10', 663.0: np.nan, 1072.0: '8'},
     'SecundusTenor_PrimusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: '3', 528.0: 'Rest', 663.0: '2', 1072.0: '3'},
     'SecundusTenor_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: '3', 528.0: 'Rest', 663.0: '5', 1072.0: '3'},
     'SecundusTenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: '6', 528.0: 'Rest', 663.0: '9', 1072.0: '6'},
     'PrimusTenor_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: '5', 528.0: '4', 663.0: np.nan, 1072.0: '5'},
     'PrimusTenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: '8', 528.0: '6', 663.0: np.nan, 1072.0: np.nan},
     'Contratenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: '4', 528.0: '3', 663.0: np.nan, 1072.0: '4'}},
    {'Bassus_Tenor': {0.0: 'Rest', 4.0: '1', 72.0: '3', 116.0: '3', 144.0: '4', 246.0: np.nan},
     'Bassus_Contratenor': {0.0: 'Rest', 4.0: 'Rest', 72.0: '5', 116.0: '5', 144.0: '6', 246.0: np.nan},
     'Bassus_Superius': {0.0: 'Rest', 4.0: 'Rest', 72.0: '8', 116.0: '10', 144.0: 'Rest', 246.0: '10'},
     'Tenor_Contratenor': {0.0: 'Rest', 4.0: 'Rest', 72.0: '3', 116.0: '3', 144.0: '3', 246.0: np.nan},
     'Tenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 72.0: '6', 116.0: '8', 144.0: 'Rest', 246.0: '6'},
     'Contratenor_Superius': {0.0: 'Rest', 4.0: np.nan, 72.0: '4', 116.0: '6', 144.0: 'Rest', 246.0: '3'}},
    {'Bassus_Tenor': {0.0: '3', 6.0: '3', 62.0: '8', 118.0: '6', 138.0: '4', 236.0: '1'},
     'Bassus_Contratenor': {0.0: '5', 6.0: '5', 62.0: '10', 118.0: '13', 138.0: '6', 236.0: '5'},
     'Bassus_Superius': {0.0: '8', 6.0: '8', 62.0: '13', 118.0: '15', 138.0: '10', 236.0: '8'},
     'Tenor_Contratenor': {0.0: '3', 6.0: '3', 62.0: '3', 118.0: '8', 138.0: '3', 236.0: '5'},
     'Tenor_Superius': {0.0: '6', 6.0: '6', 62.0: '6', 118.0: '10', 138.0: '7', 236.0: '8'},
     'Contratenor_Superius': {0.0: '4', 6.0: '4', 62.0: '4', 118.0: '3', 138.0: '5', 236.0: '4'}}]
TEST_FILES_HARMONIC_ZTT = [
    {'Bassus_SecundusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'Rest', 528.0: 'Rest', 663.0: '3', 1072.0: '2'},
     'Bassus_PrimusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'Rest', 528.0: '4', 663.0: np.nan, 1072.0: '0'},
     'Bassus_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: np.nan, 528.0: '7', 663.0: np.nan, 1072.0: '4'},
     'Bassus_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: 'Rest', 528.0: '9', 663.0: np.nan, 1072.0: '7'},
     'SecundusTenor_PrimusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: '-2', 528.0: 'Rest', 663.0: '1', 1072.0: '-2'},
     'SecundusTenor_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: '2', 528.0: 'Rest', 663.0: '4', 1072.0: '2'},
     'SecundusTenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: '5', 528.0: 'Rest', 663.0: '8', 1072.0: '5'},
     'PrimusTenor_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: '4', 528.0: '3', 663.0: np.nan, 1072.0: '4'},
     'PrimusTenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: '7', 528.0: '5', 663.0: np.nan, 1072.0: np.nan},
     'Contratenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: '3', 528.0: '2', 663.0: np.nan, 1072.0: '3'}},
    {'Bassus_Tenor': {0.0: 'Rest', 4.0: '0', 72.0: '2', 116.0: '2', 144.0: '3', 246.0: np.nan},
     'Bassus_Contratenor': {0.0: 'Rest', 4.0: 'Rest', 72.0: '4', 116.0: '4', 144.0: '5', 246.0: np.nan},
     'Bassus_Superius': {0.0: 'Rest', 4.0: 'Rest', 72.0: '7', 116.0: '9', 144.0: 'Rest', 246.0: '9'},
     'Tenor_Contratenor': {0.0: 'Rest', 4.0: 'Rest', 72.0: '2', 116.0: '2', 144.0: '2', 246.0: np.nan},
     'Tenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 72.0: '5', 116.0: '7', 144.0: 'Rest', 246.0: '5'},
     'Contratenor_Superius': {0.0: 'Rest', 4.0: np.nan, 72.0: '3', 116.0: '5', 144.0: 'Rest', 246.0: '2'}},
    {'Bassus_Tenor': {0.0: '2', 6.0: '2', 62.0: '7', 118.0: '5', 138.0: '3', 236.0: '0'},
     'Bassus_Contratenor': {0.0: '4', 6.0: '4', 62.0: '9', 118.0: '12', 138.0: '5', 236.0: '4'},
     'Bassus_Superius': {0.0: '7', 6.0: '7', 62.0: '12', 118.0: '14', 138.0: '9', 236.0: '7'},
     'Tenor_Contratenor': {0.0: '2', 6.0: '2', 62.0: '2', 118.0: '7', 138.0: '2', 236.0: '4'},
     'Tenor_Superius': {0.0: '5', 6.0: '5', 62.0: '5', 118.0: '9', 138.0: '6', 236.0: '7'},
     'Contratenor_Superius': {0.0: '3', 6.0: '3', 62.0: '3', 118.0: '2', 138.0: '4', 236.0: '3'}}]
TEST_FILES_HARMONIC_CTT = [
    {'Bassus_SecundusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'Rest', 528.0: 'Rest', 663.0: '5', 1072.0: '4'},
     'Bassus_PrimusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'Rest', 528.0: '7', 663.0: np.nan, 1072.0: '0'},
     'Bassus_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: np.nan, 528.0: '12', 663.0: np.nan, 1072.0: '7'},
     'Bassus_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: 'Rest', 528.0: '16', 663.0: np.nan, 1072.0: '12'},
     'SecundusTenor_PrimusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: '-3', 528.0: 'Rest', 663.0: '2', 1072.0: '-4'},
     'SecundusTenor_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: '4', 528.0: 'Rest', 663.0: '7', 1072.0: '3'},
     'SecundusTenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: '9', 528.0: 'Rest', 663.0: '14', 1072.0: '8'},
     'PrimusTenor_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: '7', 528.0: '5', 663.0: np.nan, 1072.0: '7'},
     'PrimusTenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: '12', 528.0: '9', 663.0: np.nan, 1072.0: np.nan},
     'Contratenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: '5', 528.0: '4', 663.0: np.nan, 1072.0: '5'}},
    {'Bassus_Tenor': {0.0: 'Rest', 4.0: '0', 72.0: '3', 116.0: '3', 144.0: '5', 246.0: np.nan},
     'Bassus_Contratenor': {0.0: 'Rest', 4.0: 'Rest', 72.0: '7', 116.0: '7', 144.0: '9', 246.0: np.nan},
     'Bassus_Superius': {0.0: 'Rest', 4.0: 'Rest', 72.0: '12', 116.0: '15', 144.0: 'Rest', 246.0: '15'},
     'Tenor_Contratenor': {0.0: 'Rest', 4.0: 'Rest', 72.0: '4', 116.0: '4', 144.0: '4', 246.0: np.nan},
     'Tenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 72.0: '9', 116.0: '12', 144.0: 'Rest', 246.0: '8'},
     'Contratenor_Superius': {0.0: 'Rest', 4.0: np.nan, 72.0: '5', 116.0: '8', 144.0: 'Rest', 246.0: '3'}},
    {'Bassus_Tenor': {0.0: '3', 6.0: '3', 62.0: '12', 118.0: '8', 138.0: '6', 236.0: '0'},
     'Bassus_Contratenor': {0.0: '7', 6.0: '7', 62.0: '16', 118.0: '20', 138.0: '9', 236.0: '7'},
     'Bassus_Superius': {0.0: '12', 6.0: '12', 62.0: '21', 118.0: '24', 138.0: '16', 236.0: '12'},
     'Tenor_Contratenor': {0.0: '4', 6.0: '4', 62.0: '4', 118.0: '12', 138.0: '3', 236.0: '7'},
     'Tenor_Superius': {0.0: '9', 6.0: '9', 62.0: '9', 118.0: '16', 138.0: '10', 236.0: '12'},
     'Contratenor_Superius': {0.0: '5', 6.0: '5', 62.0: '5', 118.0: '4', 138.0: '7', 236.0: '5'}}]
TEST_FILES_HARMONIC_CFF = [
    {'Bassus_SecundusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'Rest', 528.0: 'Rest', 663.0: '5', 1072.0: '4'},
     'Bassus_PrimusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'Rest', 528.0: '7', 663.0: np.nan, 1072.0: '0'},
     'Bassus_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: np.nan, 528.0: '0', 663.0: np.nan, 1072.0: '7'},
     'Bassus_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: 'Rest', 528.0: '4', 663.0: np.nan, 1072.0: '0'},
     'SecundusTenor_PrimusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: '3', 528.0: 'Rest', 663.0: '2', 1072.0: '4'},
     'SecundusTenor_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: '4', 528.0: 'Rest', 663.0: '7', 1072.0: '3'},
     'SecundusTenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: '9', 528.0: 'Rest', 663.0: '2', 1072.0: '8'},
     'PrimusTenor_Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: '7', 528.0: '5', 663.0: np.nan, 1072.0: '7'},
     'PrimusTenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: '0', 528.0: '9', 663.0: np.nan, 1072.0: np.nan},
     'Contratenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 310.0: '5', 528.0: '4', 663.0: np.nan, 1072.0: '5'}},
    {'Bassus_Tenor': {0.0: 'Rest', 4.0: '0', 72.0: '3', 116.0: '3', 144.0: '5', 246.0: np.nan},
     'Bassus_Contratenor': {0.0: 'Rest', 4.0: 'Rest', 72.0: '7', 116.0: '7', 144.0: '9', 246.0: np.nan},
     'Bassus_Superius': {0.0: 'Rest', 4.0: 'Rest', 72.0: '0', 116.0: '3', 144.0: 'Rest', 246.0: '3'},
     'Tenor_Contratenor': {0.0: 'Rest', 4.0: 'Rest', 72.0: '4', 116.0: '4', 144.0: '4', 246.0: np.nan},
     'Tenor_Superius': {0.0: 'Rest', 4.0: 'Rest', 72.0: '9', 116.0: '0', 144.0: 'Rest', 246.0: '8'},
     'Contratenor_Superius': {0.0: 'Rest', 4.0: np.nan, 72.0: '5', 116.0: '8', 144.0: 'Rest', 246.0: '3'}},
    {'Bassus_Tenor': {0.0: '3', 6.0: '3', 62.0: '0', 118.0: '8', 138.0: '6', 236.0: '0'},
     'Bassus_Contratenor': {0.0: '7', 6.0: '7', 62.0: '4', 118.0: '8', 138.0: '9', 236.0: '7'},
     'Bassus_Superius': {0.0: '0', 6.0: '0', 62.0: '9', 118.0: '0', 138.0: '4', 236.0: '0'},
     'Tenor_Contratenor': {0.0: '4', 6.0: '4', 62.0: '4', 118.0: '0', 138.0: '3', 236.0: '7'},
     'Tenor_Superius': {0.0: '9', 6.0: '9', 62.0: '9', 118.0: '4', 138.0: '10', 236.0: '0'},
     'Contratenor_Superius': {0.0: '5', 6.0: '5', 62.0: '5', 118.0: '4', 138.0: '7', 236.0: '5'}}]

FILES_PART_NAMES = [['Superius', 'Contratenor', 'PrimusTenor', 'SecundusTenor', 'Bassus'], ['Superius', 'Contratenor', 'Tenor', 'Bassus'], ['Superius', 'Contratenor', 'Tenor', 'Bassus']]

FILES_NOTE_RESTS = [{'Superius': {0.0: 'G4', 4.0: 'D5', 310.0: 'D5', 528.0: 'A4', 1072.0: None},
                     'Contratenor': {0.0: 'Rest', 4.0: np.nan, 310.0: np.nan, 528.0: 'F4', 1072.0: 'D4'},
                     'PrimusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'D4', 528.0: 'C4', 1072.0: None},
                     'SecundusTenor': {0.0: 'Rest', 4.0: np.nan, 310.0: 'F4', 528.0: 'Rest', 1072.0: 'B3'},
                     'Bassus': {0.0: 'Rest', 4.0: np.nan, 310.0: np.nan, 528.0: 'F3', 1072.0: 'G3'}},
                    {'Superius': {0.0: 'Rest', 4.0: np.nan, 72.0: None, 116.0: 'F5', 246.0: 'C#5'},
                     'Contratenor': {0.0: 'Rest', 4.0: np.nan, 72.0: 'E4', 116.0: 'A4', 246.0: np.nan},
                     'Tenor': {0.0: 'Rest', 4.0: 'A3', 72.0: 'C4', 116.0: 'F4', 246.0: np.nan},
                     'Bassus': {0.0: 'A3', 4.0: 'A3', 72.0: 'A3', 116.0: 'D4', 246.0: np.nan}},
                    {'Superius': {0.0: 'G4', 6.0: 'G4', 62.0: 'A4', 118.0: 'D5', 236.0: 'G4'},
                     'Contratenor': {0.0: 'D4', 6.0: 'D4', 62.0: 'E4', 118.0: 'B-4', 236.0: 'D4'},
                     'Tenor': {0.0: 'B-3', 6.0: 'B-3', 62.0: 'C4', 118.0: 'B-3', 236.0: 'G3'},
                     'Bassus': {0.0: 'G3', 6.0: 'G3', 62.0: 'C3', 118.0: np.nan, 236.0: 'G3'}}]
# visualization constants
# files for testing
EXAMPLE_CRIM_FILE = 'https://crimproject.org/mei/CRIM_Model_0017.mei'
# a subset of relationships from http://crimproject.org/data/relationships/
RELATIONSHIPS_DICT_EXAMPLE = {
    'Unnamed: 0': {0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, 10: 10, 11: 11, 12: 12, 13: 13, 14: 14,
                   15: 15, 16: 16, 17: 17, 18: 18, 19: 19, 20: 20, 21: 21, 22: 22, 23: 23, 24: 24, 25: 25, 26: 26,
                   27: 27, 28: 28, 29: 29},
    'url': {0: 'http://crimproject.org/data/relationships/1/', 1: 'http://crimproject.org/data/relationships/2/',
            2: 'http://crimproject.org/data/relationships/3/', 3: 'http://crimproject.org/data/relationships/4/',
            4: 'http://crimproject.org/data/relationships/5/', 5: 'http://crimproject.org/data/relationships/6/',
            6: 'http://crimproject.org/data/relationships/7/', 7: 'http://crimproject.org/data/relationships/8/',
            8: 'http://crimproject.org/data/relationships/9/', 9: 'http://crimproject.org/data/relationships/10/',
            10: 'http://crimproject.org/data/relationships/11/', 11: 'http://crimproject.org/data/relationships/12/',
            12: 'http://crimproject.org/data/relationships/13/', 13: 'http://crimproject.org/data/relationships/14/',
            14: 'http://crimproject.org/data/relationships/15/', 15: 'http://crimproject.org/data/relationships/16/',
            16: 'http://crimproject.org/data/relationships/17/', 17: 'http://crimproject.org/data/relationships/18/',
            18: 'http://crimproject.org/data/relationships/19/', 19: 'http://crimproject.org/data/relationships/20/',
            20: 'http://crimproject.org/data/relationships/21/', 21: 'http://crimproject.org/data/relationships/22/',
            22: 'http://crimproject.org/data/relationships/23/', 23: 'http://crimproject.org/data/relationships/24/',
            24: 'http://crimproject.org/data/relationships/25/', 25: 'http://crimproject.org/data/relationships/26/',
            26: 'http://crimproject.org/data/relationships/27/', 27: 'http://crimproject.org/data/relationships/28/',
            28: 'http://crimproject.org/data/relationships/29/', 29: 'http://crimproject.org/data/relationships/30/'},
    'id': {0: 1, 1: 2, 2: 3, 3: 4, 4: 5, 5: 6, 6: 7, 7: 8, 8: 9, 9: 10, 10: 11, 11: 12, 12: 13, 13: 14, 14: 15, 15: 16,
           16: 17, 17: 18, 18: 19, 19: 20, 20: 21, 21: 22, 22: 23, 23: 24, 24: 25, 25: 26, 26: 27, 27: 28, 28: 29,
           29: 30},
    'relationship_type': {0: 'Quotation', 1: 'Non-mechanical transformation', 2: 'Non-mechanical transformation',
                          3: 'Non-mechanical transformation', 4: 'Quotation', 5: 'Mechanical transformation',
                          6: 'Non-mechanical transformation', 7: 'Mechanical transformation', 8: 'Quotation',
                          9: 'Mechanical transformation', 10: 'Quotation', 11: 'Non-mechanical transformation',
                          12: 'Mechanical transformation', 13: 'Quotation', 14: 'Non-mechanical transformation',
                          15: 'Non-mechanical transformation', 16: 'Non-mechanical transformation',
                          17: 'Non-mechanical transformation', 18: 'Non-mechanical transformation',
                          19: 'Mechanical transformation', 20: 'Non-mechanical transformation',
                          21: 'Non-mechanical transformation', 22: 'Non-mechanical transformation',
                          23: 'Non-mechanical transformation', 24: 'Non-mechanical transformation',
                          25: 'Non-mechanical transformation', 26: 'Quotation, Non-mechanical transformation',
                          27: 'Non-mechanical transformation', 28: 'Non-mechanical transformation',
                          29: 'Non-mechanical transformation'},
    'musical_type': {0: 'Fuga', 1: 'Fuga', 2: 'Fuga', 3: 'Fuga', 4: 'Soggetto', 5: 'Fuga', 6: 'Fuga', 7: 'Fuga',
                     8: 'Fuga', 9: 'Fuga', 10: 'Non-imitative duo', 11: 'Cantus firmus', 12: 'Fuga', 13: 'Soggetto',
                     14: 'Non-imitative duo', 15: 'Fuga', 16: 'Soggetto', 17: 'Fuga', 18: 'Soggetto',
                     19: 'Non-imitative duo', 20: 'Soggetto', 21: 'Fuga', 22: 'Homorhythm', 23: 'Counter-soggetto',
                     24: 'Non-imitative duo', 25: 'Fuga', 26: 'Counter-soggetto', 27: 'Periodic entry',
                     28: 'Periodic entry', 29: 'Imitative duo'},
    'rt_q': {0: True, 1: False, 2: False, 3: False, 4: True, 5: False, 6: False, 7: False, 8: True, 9: False, 10: True,
             11: False, 12: False, 13: True, 14: False, 15: False, 16: False, 17: False, 18: False, 19: False,
             20: False, 21: False, 22: False, 23: False, 24: False, 25: False, 26: True, 27: False, 28: False,
             29: False},
    'rt_q_x': {0: True, 1: False, 2: False, 3: False, 4: True, 5: False, 6: False, 7: False, 8: False, 9: False,
               10: True, 11: False, 12: False, 13: False, 14: False, 15: False, 16: False, 17: False, 18: False,
               19: False, 20: False, 21: False, 22: False, 23: False, 24: False, 25: False, 26: True, 27: False,
               28: False, 29: False},
    'rt_q_monnayage': {0: False, 1: False, 2: False, 3: False, 4: False, 5: False, 6: False, 7: False, 8: True,
                       9: False, 10: False, 11: False, 12: False, 13: True, 14: False, 15: False, 16: False, 17: False,
                       18: False, 19: False, 20: False, 21: False, 22: False, 23: False, 24: False, 25: False,
                       26: False, 27: False, 28: False, 29: False},
    'rt_tm': {0: False, 1: False, 2: False, 3: False, 4: False, 5: True, 6: False, 7: True, 8: False, 9: True,
              10: False, 11: False, 12: True, 13: False, 14: False, 15: False, 16: False, 17: False, 18: False,
              19: True, 20: False, 21: False, 22: False, 23: False, 24: False, 25: False, 26: False, 27: False,
              28: False, 29: False},
    'rt_tm_snd': {0: False, 1: False, 2: False, 3: False, 4: False, 5: True, 6: False, 7: False, 8: False, 9: False,
                  10: False, 11: False, 12: False, 13: False, 14: False, 15: False, 16: False, 17: False, 18: False,
                  19: False, 20: False, 21: False, 22: False, 23: False, 24: False, 25: False, 26: False, 27: False,
                  28: False, 29: False},
    'rt_tm_minv': {0: False, 1: False, 2: False, 3: False, 4: False, 5: False, 6: False, 7: False, 8: False, 9: False,
                   10: False, 11: False, 12: False, 13: False, 14: False, 15: False, 16: False, 17: False, 18: False,
                   19: True, 20: False, 21: False, 22: False, 23: False, 24: False, 25: False, 26: False, 27: False,
                   28: False, 29: False},
    'rt_tm_retrograde': {0: False, 1: False, 2: False, 3: False, 4: False, 5: False, 6: False, 7: False, 8: False,
                         9: False, 10: False, 11: False, 12: False, 13: False, 14: False, 15: False, 16: False,
                         17: False, 18: False, 19: False, 20: False, 21: False, 22: False, 23: False, 24: False,
                         25: False, 26: False, 27: False, 28: False, 29: False},
    'rt_tm_ms': {0: False, 1: False, 2: False, 3: False, 4: False, 5: True, 6: False, 7: True, 8: False, 9: False,
                 10: False, 11: False, 12: False, 13: False, 14: False, 15: False, 16: False, 17: False, 18: False,
                 19: False, 20: False, 21: False, 22: False, 23: False, 24: False, 25: False, 26: False, 27: False,
                 28: False, 29: False},
    'rt_tm_transposed': {0: False, 1: False, 2: False, 3: False, 4: False, 5: True, 6: False, 7: False, 8: False,
                         9: True, 10: False, 11: False, 12: True, 13: False, 14: False, 15: False, 16: False, 17: False,
                         18: False, 19: False, 20: False, 21: False, 22: False, 23: False, 24: False, 25: False,
                         26: False, 27: False, 28: False, 29: False},
    'rt_tm_invertible': {0: False, 1: False, 2: False, 3: False, 4: False, 5: False, 6: False, 7: False, 8: False,
                         9: False, 10: False, 11: False, 12: False, 13: False, 14: False, 15: False, 16: False,
                         17: False, 18: False, 19: False, 20: False, 21: False, 22: False, 23: False, 24: False,
                         25: False, 26: False, 27: False, 28: False, 29: False},
    'rt_tnm': {0: False, 1: True, 2: True, 3: True, 4: False, 5: False, 6: True, 7: False, 8: False, 9: False,
               10: False, 11: True, 12: False, 13: False, 14: True, 15: True, 16: True, 17: True, 18: True, 19: False,
               20: True, 21: True, 22: True, 23: True, 24: True, 25: True, 26: True, 27: True, 28: True, 29: True},
    'rt_tnm_embellished': {0: False, 1: False, 2: False, 3: True, 4: False, 5: False, 6: False, 7: False, 8: False,
                           9: False, 10: False, 11: False, 12: False, 13: False, 14: False, 15: False, 16: False,
                           17: False, 18: False, 19: False, 20: True, 21: False, 22: False, 23: False, 24: False,
                           25: False, 26: False, 27: False, 28: False, 29: False},
    'rt_tnm_reduced': {0: False, 1: False, 2: False, 3: False, 4: False, 5: False, 6: False, 7: False, 8: False,
                       9: False, 10: False, 11: False, 12: False, 13: False, 14: False, 15: False, 16: False, 17: False,
                       18: False, 19: False, 20: False, 21: False, 22: False, 23: False, 24: False, 25: False, 26: True,
                       27: False, 28: False, 29: False},
    'rt_tnm_amplified': {0: False, 1: False, 2: False, 3: False, 4: False, 5: False, 6: True, 7: False, 8: False,
                         9: False, 10: False, 11: True, 12: False, 13: False, 14: False, 15: False, 16: False,
                         17: False, 18: True, 19: False, 20: True, 21: False, 22: True, 23: False, 24: True, 25: True,
                         26: False, 27: True, 28: True, 29: False},
    'rt_tnm_truncated': {0: False, 1: False, 2: False, 3: False, 4: False, 5: False, 6: False, 7: False, 8: False,
                         9: False, 10: False, 11: False, 12: False, 13: False, 14: False, 15: False, 16: False,
                         17: False, 18: False, 19: False, 20: False, 21: False, 22: False, 23: False, 24: False,
                         25: False, 26: False, 27: False, 28: False, 29: True},
    'rt_tnm_ncs': {0: False, 1: False, 2: False, 3: False, 4: False, 5: False, 6: False, 7: False, 8: False, 9: False,
                   10: False, 11: False, 12: False, 13: False, 14: True, 15: False, 16: False, 17: False, 18: False,
                   19: False, 20: False, 21: False, 22: False, 23: False, 24: False, 25: False, 26: False, 27: False,
                   28: False, 29: False},
    'rt_tnm_ocs': {0: False, 1: True, 2: True, 3: True, 4: False, 5: False, 6: True, 7: False, 8: False, 9: False,
                   10: False, 11: False, 12: False, 13: False, 14: False, 15: True, 16: False, 17: True, 18: False,
                   19: False, 20: False, 21: True, 22: False, 23: False, 24: True, 25: True, 26: False, 27: True,
                   28: False, 29: True},
    'rt_tnm_ocst': {0: False, 1: False, 2: True, 3: True, 4: False, 5: False, 6: True, 7: False, 8: False, 9: False,
                    10: False, 11: False, 12: False, 13: False, 14: True, 15: True, 16: False, 17: True, 18: False,
                    19: False, 20: False, 21: True, 22: False, 23: False, 24: True, 25: True, 26: False, 27: True,
                    28: True, 29: True},
    'rt_tnm_nc': {0: False, 1: False, 2: False, 3: False, 4: False, 5: False, 6: False, 7: False, 8: False, 9: False,
                  10: False, 11: False, 12: False, 13: False, 14: False, 15: False, 16: True, 17: False, 18: True,
                  19: False, 20: False, 21: False, 22: False, 23: True, 24: False, 25: False, 26: False, 27: False,
                  28: False, 29: False},
    'rt_nm': {0: False, 1: False, 2: False, 3: False, 4: False, 5: False, 6: False, 7: False, 8: False, 9: False,
              10: False, 11: False, 12: False, 13: False, 14: False, 15: False, 16: False, 17: False, 18: False,
              19: False, 20: False, 21: False, 22: False, 23: False, 24: False, 25: False, 26: False, 27: False,
              28: False, 29: False},
    'rt_om': {0: False, 1: False, 2: False, 3: False, 4: False, 5: False, 6: False, 7: False, 8: False, 9: False,
              10: False, 11: False, 12: False, 13: False, 14: False, 15: False, 16: False, 17: False, 18: False,
              19: False, 20: False, 21: False, 22: False, 23: False, 24: False, 25: False, 26: False, 27: False,
              28: False, 29: False}, 'remarks': {0: np.nan, 1: 'Shifted and transposed', 2: np.nan,
                                                 3: 'GENERAL COMMENT. General rewriting of a SATB model in a Missa a vocibus paribus TTTB (meaning S of model is most of the time transposed 8- in Mass).',
                                                 4: 'Deux brèves de silence interpolées m.16 et 17 à la voix de tenor primus',
                                                 5: 'The Canon at Unisson 4 breves is made possible by the interpolation of 2 pauses (mes. 16-17 and 33-34)',
                                                 6: 'Several repetitions of Sogetto, one first note added (4th below)',
                                                 7: np.nan, 8: np.nan,
                                                 9: 'Fuga in Palestrina is 1+ instead of 8+, but otherwise exact quotation',
                                                 10: np.nan, 11: np.nan,
                                                 12: 'Fuga in Palestrina is 1+ instead of 8+, but otherwise exact quotation\nSame as Palestrina mes.7',
                                                 13: np.nan, 14: np.nan, 15: np.nan, 16: np.nan, 17: np.nan, 18: np.nan,
                                                 19: np.nan, 20: np.nan, 21: np.nan, 22: np.nan, 23: np.nan, 24: np.nan,
                                                 25: np.nan, 26: np.nan,
                                                 27: 'First entry is different, creating a new combination, but the three other entries are exactly the same (even if the last is transposed 8-)',
                                                 28: 'Some voices are transposed 8-, others not',
                                                 29: 'In the Mass, one of the ID is identical to the model, the other is transposed in different voices'},
    'created': {0: '2017-06-19T19:22:54-04:00', 1: '2017-06-19T19:31:29-04:00', 2: '2017-06-19T20:36:44-04:00',
                3: '2017-06-20T12:18:12-04:00', 4: '2017-06-20T13:13:54-04:00', 5: '2017-06-20T13:27:22-04:00',
                6: '2017-06-20T13:44:52-04:00', 7: '2017-06-20T14:25:43-04:00', 8: '2017-08-03T19:02:41-04:00',
                9: '2017-08-03T19:05:22-04:00', 10: '2017-06-29T20:38:07-04:00', 11: '2017-06-30T01:30:23-04:00',
                12: '2017-06-30T01:38:07-04:00', 13: '2017-06-30T01:42:24-04:00', 14: '2017-06-30T02:00:59-04:00',
                15: '2017-06-30T17:26:18-04:00', 16: '2017-06-30T17:35:31-04:00', 17: '2017-06-30T17:42:59-04:00',
                18: '2017-06-30T17:51:11-04:00', 19: '2017-08-03T19:00:17-04:00', 20: '2017-06-30T18:17:07-04:00',
                21: '2017-08-03T19:15:38-04:00', 22: '2017-08-03T19:15:38-04:00', 23: '2017-08-03T19:45:50-04:00',
                24: '2017-06-30T19:10:04-04:00', 25: '2017-06-30T19:22:43-04:00', 26: '2017-06-30T19:25:41-04:00',
                27: '2017-08-03T19:43:20-04:00', 28: '2017-08-03T19:20:26-04:00', 29: '2017-08-03T19:21:43-04:00'},
    'updated': {0: '2019-08-28T13:16:29.931000-04:00', 1: '2019-06-26T18:00:56.788000-04:00',
                2: '2020-08-02T16:19:42.196741-04:00', 3: '2019-06-26T18:00:55.843000-04:00',
                4: '2019-06-26T17:55:46.732000-04:00', 5: '2019-06-26T17:55:38.436000-04:00',
                6: '2019-06-26T17:55:38.585000-04:00', 7: '2019-06-26T17:55:39.134000-04:00',
                8: '2019-11-13T08:12:59.651000-05:00', 9: '2019-06-26T17:55:39.710000-04:00',
                10: '2019-11-13T08:17:17.619000-05:00', 11: '2019-06-26T17:55:40.192000-04:00',
                12: '2019-06-26T17:55:40.776000-04:00', 13: '2019-06-26T17:55:41.153000-04:00',
                14: '2019-06-26T17:55:40.484000-04:00', 15: '2019-06-26T17:55:41.542000-04:00',
                16: '2019-06-26T17:55:41.770000-04:00', 17: '2019-06-26T18:00:56.024000-04:00',
                18: '2019-06-26T17:55:42.076000-04:00', 19: '2019-06-26T17:55:41.894000-04:00',
                20: '2019-06-26T17:55:42.412000-04:00', 21: '2019-06-26T17:55:42.264000-04:00',
                22: '2020-08-30T12:56:09.001368-04:00', 23: '2019-06-26T17:55:42.708000-04:00',
                24: '2020-08-30T13:32:42.107347-04:00', 25: '2019-06-26T17:55:43.384000-04:00',
                26: '2019-06-26T17:55:43.708000-04:00', 27: '2019-06-26T18:00:52.715000-04:00',
                28: '2020-08-30T13:37:23.186397-04:00', 29: '2019-06-26T18:01:43.030000-04:00'},
    'curated': {0: True, 1: True, 2: True, 3: True, 4: True, 5: True, 6: True, 7: True, 8: True, 9: True, 10: True,
                11: True, 12: True, 13: True, 14: True, 15: True, 16: True, 17: True, 18: True, 19: True, 20: True,
                21: True, 22: True, 23: True, 24: True, 25: True, 26: True, 27: True, 28: True, 29: True},
    'observer.url': {0: 'http://crimproject.org/data/people/CRIM_Person_1012/',
                     1: 'http://crimproject.org/data/people/CRIM_Person_1012/',
                     2: 'http://crimproject.org/data/people/CRIM_Person_1010/',
                     3: 'http://crimproject.org/data/people/CRIM_Person_1003/',
                     4: 'http://crimproject.org/data/people/CRIM_Person_1015/',
                     5: 'http://crimproject.org/data/people/CRIM_Person_1003/',
                     6: 'http://crimproject.org/data/people/CRIM_Person_1017/',
                     7: 'http://crimproject.org/data/people/CRIM_Person_1003/',
                     8: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     9: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     10: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     11: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     12: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     13: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     14: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     15: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     16: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     17: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     18: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     19: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     20: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     21: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     22: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     23: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     24: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     25: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     26: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     27: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     28: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     29: 'http://crimproject.org/data/people/CRIM_Person_1016/'},
    'observer.name': {0: 'Ian Lorenz', 1: 'Ian Lorenz', 2: 'Drew Ivarson', 3: 'David Fiala', 4: 'Anne Nautré',
                      5: 'David Fiala', 6: 'Raphaëlle Rouzic', 7: 'David Fiala', 8: 'Alexis Risler', 9: 'Alexis Risler',
                      10: 'Alexis Risler', 11: 'Alexis Risler', 12: 'Alexis Risler', 13: 'Alexis Risler',
                      14: 'Alexis Risler', 15: 'Alexis Risler', 16: 'Alexis Risler', 17: 'Alexis Risler',
                      18: 'Alexis Risler', 19: 'Alexis Risler', 20: 'Alexis Risler', 21: 'Alexis Risler',
                      22: 'Alexis Risler', 23: 'Alexis Risler', 24: 'Alexis Risler', 25: 'Alexis Risler',
                      26: 'Alexis Risler', 27: 'Alexis Risler', 28: 'Alexis Risler', 29: 'Alexis Risler'},
    'model_observation.url': {0: 'http://crimproject.org/data/observations/1/',
                              1: 'http://crimproject.org/data/observations/3/',
                              2: 'http://crimproject.org/data/observations/5/',
                              3: 'http://crimproject.org/data/observations/7/',
                              4: 'http://crimproject.org/data/observations/9/',
                              5: 'http://crimproject.org/data/observations/11/',
                              6: 'http://crimproject.org/data/observations/13/',
                              7: 'http://crimproject.org/data/observations/15/',
                              8: 'http://crimproject.org/data/observations/17/',
                              9: 'http://crimproject.org/data/observations/19/',
                              10: 'http://crimproject.org/data/observations/21/',
                              11: 'http://crimproject.org/data/observations/23/',
                              12: 'http://crimproject.org/data/observations/25/',
                              13: 'http://crimproject.org/data/observations/27/',
                              14: 'http://crimproject.org/data/observations/29/',
                              15: 'http://crimproject.org/data/observations/31/',
                              16: 'http://crimproject.org/data/observations/33/',
                              17: 'http://crimproject.org/data/observations/35/',
                              18: 'http://crimproject.org/data/observations/37/',
                              19: 'http://crimproject.org/data/observations/39/',
                              20: 'http://crimproject.org/data/observations/41/',
                              21: 'http://crimproject.org/data/observations/43/',
                              22: 'http://crimproject.org/data/observations/45/',
                              23: 'http://crimproject.org/data/observations/47/',
                              24: 'http://crimproject.org/data/observations/49/',
                              25: 'http://crimproject.org/data/observations/51/',
                              26: 'http://crimproject.org/data/observations/53/',
                              27: 'http://crimproject.org/data/observations/55/',
                              28: 'http://crimproject.org/data/observations/57/',
                              29: 'http://crimproject.org/data/observations/59/'},
    'model_observation.id': {0: 1, 1: 3, 2: 5, 3: 7, 4: 9, 5: 11, 6: 13, 7: 15, 8: 17, 9: 19, 10: 21, 11: 23, 12: 25,
                             13: 27, 14: 29, 15: 31, 16: 33, 17: 35, 18: 37, 19: 39, 20: 41, 21: 43, 22: 45, 23: 47,
                             24: 49, 25: 51, 26: 53, 27: 55, 28: 57, 29: 59},
    'model_observation.piece.url': {0: 'http://crimproject.org/data/pieces/CRIM_Model_0011/',
                                    1: 'http://crimproject.org/data/pieces/CRIM_Model_0011/',
                                    2: 'http://crimproject.org/data/pieces/CRIM_Model_0011/',
                                    3: 'http://crimproject.org/data/pieces/CRIM_Model_0011/',
                                    4: 'http://crimproject.org/data/pieces/CRIM_Model_0018/',
                                    5: 'http://crimproject.org/data/pieces/CRIM_Model_0018/',
                                    6: 'http://crimproject.org/data/pieces/CRIM_Model_0018/',
                                    7: 'http://crimproject.org/data/pieces/CRIM_Model_0018/',
                                    8: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    9: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    10: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    11: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    12: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    13: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    14: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    15: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    16: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    17: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    18: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    19: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    20: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    21: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    22: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    23: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    24: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    25: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    26: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    27: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    28: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                                    29: 'http://crimproject.org/data/pieces/CRIM_Model_0017/'},
    'model_observation.piece.piece_id': {0: 'CRIM_Model_0011', 1: 'CRIM_Model_0011', 2: 'CRIM_Model_0011',
                                         3: 'CRIM_Model_0011', 4: 'CRIM_Model_0018', 5: 'CRIM_Model_0018',
                                         6: 'CRIM_Model_0018', 7: 'CRIM_Model_0018', 8: 'CRIM_Model_0017',
                                         9: 'CRIM_Model_0017', 10: 'CRIM_Model_0017', 11: 'CRIM_Model_0017',
                                         12: 'CRIM_Model_0017', 13: 'CRIM_Model_0017', 14: 'CRIM_Model_0017',
                                         15: 'CRIM_Model_0017', 16: 'CRIM_Model_0017', 17: 'CRIM_Model_0017',
                                         18: 'CRIM_Model_0017', 19: 'CRIM_Model_0017', 20: 'CRIM_Model_0017',
                                         21: 'CRIM_Model_0017', 22: 'CRIM_Model_0017', 23: 'CRIM_Model_0017',
                                         24: 'CRIM_Model_0017', 25: 'CRIM_Model_0017', 26: 'CRIM_Model_0017',
                                         27: 'CRIM_Model_0017', 28: 'CRIM_Model_0017', 29: 'CRIM_Model_0017'},
    'model_observation.piece.full_title': {0: 'Tota pulchra es', 1: 'Tota pulchra es', 2: 'Tota pulchra es',
                                           3: 'Tota pulchra es', 4: 'Baisez moy', 5: 'Baisez moy', 6: 'Baisez moy',
                                           7: 'Baisez moy', 8: 'Benedicta es', 9: 'Benedicta es', 10: 'Benedicta es',
                                           11: 'Benedicta es', 12: 'Benedicta es', 13: 'Benedicta es',
                                           14: 'Benedicta es', 15: 'Benedicta es', 16: 'Benedicta es',
                                           17: 'Benedicta es', 18: 'Benedicta es', 19: 'Benedicta es',
                                           20: 'Benedicta es', 21: 'Benedicta es', 22: 'Benedicta es',
                                           23: 'Benedicta es', 24: 'Benedicta es', 25: 'Benedicta es',
                                           26: 'Benedicta es', 27: 'Benedicta es', 28: 'Benedicta es',
                                           29: 'Benedicta es'},
    'model_observation.ema': {0: '1-6/1,1,1-2,1-2,2,2/@1,@1-3,@1-3+@1,@1-3+@1-3,@1-3,@1',
                              1: '5-9/1,1,1-2,2,2/@3,@1-4,@1-2+@4,@1-4,@1-2',
                              2: '5-9,14-18/1,1,1-2,1-2,1-2,3,3,3-4,3-4,3-4/@3,@1-4,@1-4+@4,@1-4+@1-4,@1-3+@1-2,@3,@1-4,@1-4+@4,@1-4+@1-4,@1-3+@1-2',
                              3: '5-9/1,1,1-2,2,2/@3,@1-4,@1-2+@4,@1-4,@1-2',
                              4: '1-38/6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6/@1,@1,@1,@1-3,@1,@1,@all,@1-4,@1-3,@1-4,@1,@1-4,@1-3,@1-4,@1-3,@1,@1,@1,@1-3,@1,@1,@all,@1-4,@1-3,@1-4.5,@1,@1-4,@1-3,@1-4,@1-3,@1,@1,@1,@1-3,@1,@1,@1,@1',
                              5: '1-38/3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6,3+6/@all+@1,@1+@1,@1+@1,@1+@1-3,@1-3+@1,@1+@1,@1+@all,@all+@1-4,@1-4+@1-3,@1-3+@1-4,@1-4+@1,@1+@1-4,@1-4+@1-3,@1-3+@1-4,@1-4+@1-3,@1-3+@1,@1+@1,@1+@1,@1+@1-3,@1-3+@1,@1+@1,@1+@all,@all+@1-4,@1-4+@1-3,@1-3+@1-4.5,@1-4.5+@1,@1+@1-4,@1-4+@1-3,@1-3+@1-4,@1-4.5+@1-3,@1-3+@1,@1+@1,@1+@1,@1+@1-3,@1-3+@1,@1+@1,@1+@1,@1+@1',
                              6: '1-4/2,1-2,1-2,1/@3,@3+@1-3,@1-3+@1,@1',
                              7: '1-5/1-2,1-2,1-2,1-2,1/@all+@3,@1-3+@1-3,@1-3+@1-4.5,@1-4.5+@1,@1',
                              8: '1-10/1,1,1,1,1+3,1+3,3,3,3,3/@1,@1,@1,@1,@1+@1,@1+@1,@1,@1,@1,@1',
                              9: '68/1-2/@1-4+@1-3',
                              10: '1-12/1-2,1-2,1-2,1-2,1-5,3-5,3-5,3-5,3-6,6,6,6/@1+@1-4.5,@1+@1-4,@1+@1-4,@1+@1-4.5,@1+@1+@1+@all+@1-4.5,@1+@all+@1-4,@1+@all+@1-4,@1+@all+@1-4.5,@1+@1+@1+@1-4.5,@1-4,@1-4.5,@1',
                              11: '1-6/1,1,1,1,1,1/@1,@1,@1,@1,@1,@1', 12: '68-69/1-2,1/@2-4+@1-3,@1',
                              13: '11-16/1,1,1,1,1,1/@1,@1-3,@1-3,@1-3,@1-3,@1',
                              14: '11-20/1+5,1+5,1+5,1+5,1+3+5-6,1+3+6,3+6,3+6,3+6,3+6/@1+@3,@1-3+@1-4.5,@1-3+@1-3,@1-3+@1-3,@1-3+@1+@1+@3,@1+@1-3+@1-4.5,@1-3+@1-3,@1-3+@1-3,@1-3+@1,@1+@1',
                              15: '19-21,23-25/1+5,1+4-5,1+4-5,3+6,3-4+6,3-4+6/@1+@3,@1-4+@2-3+@1-3,@1+@1-3+@1-3,@1+@3,@1-4+@2-3+@1-3,@1+@1-3+@1-3',
                              16: '37-40/5,5,5,5/@1,@1,@1-3,@1-3', 17: '40-41/4+6,4+6/@2-4.5+@3-4.5,@1+@1-2',
                              18: '50-53/4,4,4,4/@3,@1-4,@1-4,@1',
                              19: '49-51,56-58/1+5,1+5,1,3+6,3+6,3/@3+@3,@1-4+@1,@1,@1+@1-3,@1-4+@1-3,@1',
                              20: '38-43/1,1,1,1,1,1/@1,@1-3,@1-3,@1-3,@1-4.5,@1-3',
                              21: '38-46/1,1,1,1+3,1+3,1+3,3,3,3/@1,@1-3,@1-3,@1-3+@1,@1-4.5+@1-3,@1-3+@1-3,@1-4,@1-3,@1',
                              22: '82-85/5-6,3+5-6,3+5-6,3+5-6/@3+@3,@1-4+@1-3+@1-3,@1-4+@1-3+@1-4.5,@1+@1+@1',
                              23: '28-31/4,4,4,4/@3,@1-4,@1-3,@1',
                              24: '27-38/1,1+4,1+4,1+3-4,1+3-4+6,3+6,2-3+6,2-3+5-6,2+5,2+5,2+5,5/@3,@1-4.5+@3,@1-4.5+@1-4,@1-4.5+@3+@1-3,@1+@1-4.5+@1+@3,@1-4.5+@1-4,@3+@1-4.5+@1-3,@1-4.5+@1+@3+@1,@1-4.5+@1-4,@1-4.5+@1-3,@1+@1,@1',
                              25: '40-41/4+6,4+6/@2-4.5+@3-4.5,@1+@1-2', 26: '37-40/5,5,5,5/@1,@1,@1-3,@1-3',
                              27: '88-91/3,1-3,1-4,1+4/@3,@3+@1-4+@1-3,@1-3+@1-3+@1+@1-4,@1+@1-3',
                              28: '88-91/3,1-3,1-4,1+4/@3,@3+@1-4+@1-3,@1-3+@1-3+@1+@1-4,@1+@1-3',
                              29: '73-79/5,3+5,3+5-6,3+5-6,3+5-6,3+6,6/@3,@3+@1-3,@1-3+@1+@1-4,@1-3+@1-4+@1-3,@1-3+@1-3+@3,@1+@1-3,@1'},
    'derivative_observation.url': {0: 'http://crimproject.org/data/observations/2/',
                                   1: 'http://crimproject.org/data/observations/4/',
                                   2: 'http://crimproject.org/data/observations/6/',
                                   3: 'http://crimproject.org/data/observations/8/',
                                   4: 'http://crimproject.org/data/observations/10/',
                                   5: 'http://crimproject.org/data/observations/12/',
                                   6: 'http://crimproject.org/data/observations/14/',
                                   7: 'http://crimproject.org/data/observations/16/',
                                   8: 'http://crimproject.org/data/observations/18/',
                                   9: 'http://crimproject.org/data/observations/20/',
                                   10: 'http://crimproject.org/data/observations/22/',
                                   11: 'http://crimproject.org/data/observations/24/',
                                   12: 'http://crimproject.org/data/observations/26/',
                                   13: 'http://crimproject.org/data/observations/28/',
                                   14: 'http://crimproject.org/data/observations/30/',
                                   15: 'http://crimproject.org/data/observations/32/',
                                   16: 'http://crimproject.org/data/observations/34/',
                                   17: 'http://crimproject.org/data/observations/36/',
                                   18: 'http://crimproject.org/data/observations/38/',
                                   19: 'http://crimproject.org/data/observations/40/',
                                   20: 'http://crimproject.org/data/observations/42/',
                                   21: 'http://crimproject.org/data/observations/44/',
                                   22: 'http://crimproject.org/data/observations/46/',
                                   23: 'http://crimproject.org/data/observations/48/',
                                   24: 'http://crimproject.org/data/observations/50/',
                                   25: 'http://crimproject.org/data/observations/52/',
                                   26: 'http://crimproject.org/data/observations/54/',
                                   27: 'http://crimproject.org/data/observations/56/',
                                   28: 'http://crimproject.org/data/observations/58/',
                                   29: 'http://crimproject.org/data/observations/60/'},
    'derivative_observation.id': {0: 2, 1: 4, 2: 6, 3: 8, 4: 10, 5: 12, 6: 14, 7: 16, 8: 18, 9: 20, 10: 22, 11: 24,
                                  12: 26, 13: 28, 14: 30, 15: 32, 16: 34, 17: 36, 18: 38, 19: 40, 20: 42, 21: 44,
                                  22: 46, 23: 48, 24: 50, 25: 52, 26: 54, 27: 56, 28: 58, 29: 60},
    'derivative_observation.piece.url': {0: 'http://crimproject.org/data/pieces/CRIM_Mass_0009_3/',
                                         1: 'http://crimproject.org/data/pieces/CRIM_Mass_0009_3/',
                                         2: 'http://crimproject.org/data/pieces/CRIM_Mass_0009_5/',
                                         3: 'http://crimproject.org/data/pieces/CRIM_Mass_0009_3/',
                                         4: 'http://crimproject.org/data/pieces/CRIM_Mass_0017_4/',
                                         5: 'http://crimproject.org/data/pieces/CRIM_Mass_0017_4/',
                                         6: 'http://crimproject.org/data/pieces/CRIM_Mass_0017_4/',
                                         7: 'http://crimproject.org/data/pieces/CRIM_Mass_0017_5/',
                                         8: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         9: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         10: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         11: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         12: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         13: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         14: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         15: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         16: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         17: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         18: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         19: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         20: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         21: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         22: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         23: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         24: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         25: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         26: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         27: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         28: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                                         29: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/'},
    'derivative_observation.piece.piece_id': {0: 'CRIM_Mass_0009_3', 1: 'CRIM_Mass_0009_3', 2: 'CRIM_Mass_0009_5',
                                              3: 'CRIM_Mass_0009_3', 4: 'CRIM_Mass_0017_4', 5: 'CRIM_Mass_0017_4',
                                              6: 'CRIM_Mass_0017_4', 7: 'CRIM_Mass_0017_5', 8: 'CRIM_Mass_0015_2',
                                              9: 'CRIM_Mass_0015_2', 10: 'CRIM_Mass_0015_2', 11: 'CRIM_Mass_0015_2',
                                              12: 'CRIM_Mass_0015_2', 13: 'CRIM_Mass_0015_2', 14: 'CRIM_Mass_0015_2',
                                              15: 'CRIM_Mass_0015_2', 16: 'CRIM_Mass_0015_2', 17: 'CRIM_Mass_0015_2',
                                              18: 'CRIM_Mass_0015_2', 19: 'CRIM_Mass_0015_2', 20: 'CRIM_Mass_0015_2',
                                              21: 'CRIM_Mass_0015_2', 22: 'CRIM_Mass_0015_2', 23: 'CRIM_Mass_0015_2',
                                              24: 'CRIM_Mass_0015_2', 25: 'CRIM_Mass_0015_2', 26: 'CRIM_Mass_0015_2',
                                              27: 'CRIM_Mass_0015_2', 28: 'CRIM_Mass_0015_2', 29: 'CRIM_Mass_0015_2'},
    'derivative_observation.piece.full_title': {0: 'Missa Tota pulchra es: Credo', 1: 'Missa Tota pulchra es: Credo',
                                                2: 'Missa Tota pulchra es: Agnus Dei',
                                                3: 'Missa Tota pulchra es: Credo', 4: 'Missa Baisez moy: Sanctus',
                                                5: 'Missa Baisez moy: Sanctus', 6: 'Missa Baisez moy: Sanctus',
                                                7: 'Missa Baisez moy: Agnus Dei', 8: 'Missa Benedicta es: Gloria',
                                                9: 'Missa Benedicta es: Gloria', 10: 'Missa Benedicta es: Gloria',
                                                11: 'Missa Benedicta es: Gloria', 12: 'Missa Benedicta es: Gloria',
                                                13: 'Missa Benedicta es: Gloria', 14: 'Missa Benedicta es: Gloria',
                                                15: 'Missa Benedicta es: Gloria', 16: 'Missa Benedicta es: Gloria',
                                                17: 'Missa Benedicta es: Gloria', 18: 'Missa Benedicta es: Gloria',
                                                19: 'Missa Benedicta es: Gloria', 20: 'Missa Benedicta es: Gloria',
                                                21: 'Missa Benedicta es: Gloria', 22: 'Missa Benedicta es: Gloria',
                                                23: 'Missa Benedicta es: Gloria', 24: 'Missa Benedicta es: Gloria',
                                                25: 'Missa Benedicta es: Gloria', 26: 'Missa Benedicta es: Gloria',
                                                27: 'Missa Benedicta es: Gloria', 28: 'Missa Benedicta es: Gloria',
                                                29: 'Missa Benedicta es: Gloria'},
    'derivative_observation.ema': {0: '1-6/1,1,1+3,1+3,3,3/@1-4,@1-3,@1-3+@1-4,@1-3+@1-3,@1-3,@1',
                                   1: '5-8/1,1+4,1+4,4/@3,@1-4+@4,@1+@1-3,@1',
                                   2: '9-12/3-4,2-4,2,2/@4+@1-4,@4+@1-4+@1-3,@1-3,@1',
                                   3: '5-10/1,1+4,1+4,1+4,1+4,4/@3,@1-4+@4,@1-4.5+@1-3,@1-4.5+@1-4,@1+@1-3,@1',
                                   4: '1-41/5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5/@1,@1,@1,@1-3,@1,@1,@all,@1-4,@1-3,@1-4.5,@1,@1-4,@1-3,@1-4.5,@1-3,@all,@all,@1-3,@1,@1,@1-3,@1,@1,@all,@1-4,@1-3,@1-4.5,@1,@1-4,@1-3,@1-4.5,@1-3,@all,@all,@1,@1,@1,@1-3,@1,@1,@1',
                                   5: '1-41/5,5,5,5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5,4-5/@1,@1,@1,@1-3,@1+@1,@1+@1,@1+@all,@1-3+@1-4,@1+@1-3,@1+@1-4.5,@all+@1,@1-4+@1-4,@1-3+@1-3,@1-4.5+@1-4.5,@1+@1-3,@1-4+@all,@1-3+@all,@1-4.5+@1-3,@1-3+@1,@all+@1,@all+@1-3,@1-3+@1,@1+@1,@1+@all,@1-3+@1-4,@1+@1-3,@1+@1-4.5,@all+@1,@1-4+@1-4,@1-3+@1-3,@1-4.5+@1-4.5,@1+@1-3,@1-4+@all,@1-3+@all,@1-4.5+@1,@1-3+@1,@all+@1,@all+@1-3,@1+@1,@1+@1,@1+@1',
                                   6: '1-10/1-2,1-2,1-2,1-2,1-2,1-2,1-2,1,1,1/@all+@1-4,@all+@1-3,@all+@1,@1-4+@all,@1-3+@1-3,@1+@1-3,@all+@1,@1-3,@1-3,@1',
                                   7: '42-47/2,2,2,1-2,1,1/@1,@1-3,@1-4.5,@1+@1,@1-3,@1',
                                   8: '2-12/1,1,1,1,1,1+4,1+4,4,4,4,4/@1,@1,@1,@1,@1,@1+@1,@1+@1,@1,@1,@1-3,@1',
                                   9: '7-8/2-3,2-3/@3-4.5+@2-4,@1+@1',
                                   10: '3-14/1-2,1-2,1-2,1-2,1-2+4-5,4-5,4-5,4-5,4-6,6,6,6/@1+@1-3,@1+@1-4,@1+@1-4,@1+@1-4.5,@1+@1+@1+@1-3,@1+@1-4,@1+@1-4,@1+@1-4.5,@1+@1+@1-3,@1-4,@1-4.5,@1',
                                   11: '2-12,18-19/1,1,1,1,1,1,1,1,1,1,1,1,1/@1,@1,@1,@1,@1,@1,@1-4.5,@1-4.5,@1,@1,@1,@1,@1',
                                   12: '11-12/2-3,3/@1-3+@2-4,@1',
                                   13: '13-19/1,1,1,1,1,1,1/@1,@1-3,@1-3,@1-4,@1-3,@1,@1',
                                   14: '13-22/1+5,1+5,1+5,1+5,1+4-6,4+6,4+6,4+6,4+6,4/@1+@1-4,@1-3+@1-4.5,@1-3+@1-4,@1-4+@1-4,@1-3+@1+@1+@2-4,@1-3+@1-4.5,@1-3+@1-4,@1-4+@1-4,@1-3+@1,@1',
                                   15: '21-23,25-28/1+5,1-2+5,1-2+5,3-4+6,3-4+6,3-4+6,3/@3+@3,@1-4+@2-3+@1-4,@1-3+@1-3+@1-3,@3+@1-3+@1-3,@1-3+@1-4+@1-4,@1-3+@1-3+@1-3,@1',
                                   16: '29-35/5,5-6,4-6,4-6,4-6,4+6,6/@3,@1-3+@3,@3+@1-4+@1-3,@1-4+@1+@1-4,@1-3+@1+@1,@1-3+@1,@1',
                                   17: '33-38/3,3-4,3-5,1+5,1,2/@3-4.5,@1-2+@3-4.5,@1-4+@1-2+@2-4.5,@4+@1,@1-2,@2-4',
                                   18: '37-42/3,3-4,3-4,3-4,3-4,3-4/@4,@1-3+@2-4,@1-4.5+@1-3,@1-4+@1-4,@1-3+@1-4.5,@1+@1-3',
                                   19: '41-44/1+5,1-2+5-6,1-2+5-6,2/@3+@3-4,@1-3+@4+@1-3+@3,@1+@1-3+@1+@1-3,@1',
                                   20: '49-53/1,1,1,1,1/@1-4,@1-3,@1-4,@1-4.5,@1-3',
                                   21: '49-53/1-2,1-2,1-2,1,1/@1-4+@3-4,@1-3+@1-3,@1-4+@1-4.5,@1-4.5,@1-3',
                                   22: '70-77/1-3,1-3,1-3,1-6,1-6,4-6,4-6,4-6/@1+@1-3+@1-3,@1-4+@1-3+@1-3,@1-4+@1-4+@1-4,@1-3+@1-4.5+@1-3+@3+@all+@all,@1+@1+@1+@1-3+@1+@1,@1-4+@1-4+@1-4,@1-4+@1-3+@1-3,@1+@1+@1',
                                   23: '110-117/2+6,2+5-6,2+4-6,1-2+4+6,1+3-4,1+3,1+3,3/@4+@2-4,@1-4+@2-4+@1-3,@1-3+@2-4+@1-3+@1-3,@3+@1+@1-4+@1,@1-4+@1-4+@1-3,@1-3+@1-4,@1+@1,@1',
                                   24: '115-129/4,4-5,2+4-5,1-2+4-5,1-2+4-5,1-2,2-3,3+6,2-3+6,2-4+6,1-2+4,1-4,1-4,1+3,1+3/@4,@1-4.5+@3,@3-4+@1-4+@1-4,@1-3+@1-4.5+@1-4+@1-4,@1-4+@1-4+@1+@1,@1-3+@1-4,@1+@2-4,@1-4+@2-4,@2-3+@1@4+@1-4.5,@1-4+@1-3+@1-4+@1-3,@2-3+@1-4+@1-4.5,@1-4+@1-3+@1-3+@1-3,@1-4+@1+@1-4+@1,@1-4+@1-4,@1+@1-1.5@2.5-3',
                                   25: '129-132/2,2-3,2-3,2-3/@4,@1-4+@2-4.5,@1-4.5+@1-4.5,@1+@1-3',
                                   26: '130-134/6,6,6,6,6/@1,@1,@1,@1,@1',
                                   27: '135-138/2-3,1-3+6,1-3+6,1+6/@4+@1-4,@2-4+@1-4+@1-3+@3,@1-3+@1+@1+@1-4,@1+@1',
                                   28: '137-140/5,1+4-5,1+4-5,1+5/@3,@3+@1-4+@1-4,@1-4+@1-3+@1-4,@1+@1-3',
                                   29: '136-139,144-146/6,5-6,5-6,5,6,3+6,3/@3,@3+@1-4,@1-4+@1,@1,@2-4,@2-4+@1-3,@1-3'}}
# a subset of observations from http://crimproject.org/data/observations/
OBSERVATIONS_DICT_EXAMPLE = {
    'Unnamed: 0': {60: 60, 61: 61, 62: 62, 63: 63, 64: 64, 65: 65, 66: 66, 67: 67, 68: 68, 69: 69, 70: 70, 71: 71,
                   72: 72, 73: 73, 74: 74, 75: 75, 76: 76, 77: 77, 78: 78, 79: 79, 80: 80, 81: 81, 82: 82, 83: 83,
                   84: 84, 85: 85, 86: 86, 87: 87, 88: 88, 89: 89},
    'url': {60: 'http://crimproject.org/data/observations/61/', 61: 'http://crimproject.org/data/observations/62/',
            62: 'http://crimproject.org/data/observations/63/', 63: 'http://crimproject.org/data/observations/64/',
            64: 'http://crimproject.org/data/observations/65/', 65: 'http://crimproject.org/data/observations/66/',
            66: 'http://crimproject.org/data/observations/67/', 67: 'http://crimproject.org/data/observations/68/',
            68: 'http://crimproject.org/data/observations/69/', 69: 'http://crimproject.org/data/observations/70/',
            70: 'http://crimproject.org/data/observations/71/', 71: 'http://crimproject.org/data/observations/72/',
            72: 'http://crimproject.org/data/observations/73/', 73: 'http://crimproject.org/data/observations/74/',
            74: 'http://crimproject.org/data/observations/75/', 75: 'http://crimproject.org/data/observations/76/',
            76: 'http://crimproject.org/data/observations/77/', 77: 'http://crimproject.org/data/observations/78/',
            78: 'http://crimproject.org/data/observations/79/', 79: 'http://crimproject.org/data/observations/80/',
            80: 'http://crimproject.org/data/observations/81/', 81: 'http://crimproject.org/data/observations/82/',
            82: 'http://crimproject.org/data/observations/83/', 83: 'http://crimproject.org/data/observations/84/',
            84: 'http://crimproject.org/data/observations/85/', 85: 'http://crimproject.org/data/observations/86/',
            86: 'http://crimproject.org/data/observations/87/', 87: 'http://crimproject.org/data/observations/88/',
            88: 'http://crimproject.org/data/observations/89/', 89: 'http://crimproject.org/data/observations/90/'},
    'id': {60: 61, 61: 62, 62: 63, 63: 64, 64: 65, 65: 66, 66: 67, 67: 68, 68: 69, 69: 70, 70: 71, 71: 72, 72: 73,
           73: 74, 74: 75, 75: 76, 76: 77, 77: 78, 78: 79, 79: 80, 80: 81, 81: 82, 82: 83, 83: 84, 84: 85, 85: 86,
           86: 87, 87: 88, 88: 89, 89: 90}, 'ema': {60: '86-89/2,1-2+4,1-2+4,4/@3,@1-4+@1-3+@3,@1-3+@1+@1-3,@1',
                                                    61: '148-150/1-2,1-2+5,1+5/@3+@2-4,@1-3+@1-2+@2-4,@1+@1-3',
                                                    62: '73-79/5,3+5,3+5-6,3+5-6,3+5-6,3+6,6/@3,@3+@1-3,@1-3+@1+@1-4,@1-3+@1-4+@1-3,@1-3+@1-3+@3,@1+@1-3,@1',
                                                    63: '149-152/5,2+5,2+5-6,5-6/@2-4,@2-4+@1-4,@1-3+@1-3+@2-4,@1+@1',
                                                    64: '152-155/2-3,2-3,2-3,2-3/@3-4.5+@4,@1-4+@1-4,@1-4+@1-4,@1+@1',
                                                    65: '129-132/2,2-3,2-3,2-3/@4,@1-4+@2-4.5,@1-4.5+@1-4.5,@1+@1-3',
                                                    66: '40-41/4+6,4+6/@2-4.5+@3-4.5,@1+@1-2',
                                                    67: '153-154/2+5-6,2+5-6/@4+@3-4.5+@2-4.5,@1-3+@1-2+@1',
                                                    68: '87-88/1,1/@1-4,@1-3', 69: '58-60/1,1,1/@2-4,@1-3,@1',
                                                    70: '88-91/3,1-3,1-4,1+4/@3,@3+@1-4+@1-3,@1-3+@1-3+@1+@1-4,@1+@1-3',
                                                    71: '57-65/3,1+3-4,1-5,1-5,1+3-6,1-6,2+4-6,4-6,4/@4,@2-4+@1-3+@4,@1-3+@4+@1+@1-3+@1-4,@1@4+@1-3+@2-4+@1-3+@1-3,@1-3+@1-3+@1+@3+@2-4,@1+@2-4.5+@1+@3+@1-3+@1-3,@1+@1-3+@1-3+@2-4,@1-3+@1+@1,@1',
                                                    72: '93-98/1,1-3+5-6,1-3+5-6,1-6,1-2+4-6,1-2+4-6/@4,@1-4+@4+@4+@4+@4,@1-3+@1-4.5+@1-3+@1-3+@1-3,@1-3+@1-4+@1+@4+@1@4+@1@4,@1-3+@1-4.5+@1-3+@1-3+@1-3,@1+@1+@1+@1+@1',
                                                    73: '64-68/1,1-3+5-6,1-6,3-6,3-6/@1-4.5,@1-4+@2-4+@2-4+@1-4+@2-4,@1+@1+@1-3+@1-4.5+@1-3+@1-3,@2-4+@1-4+@1-4+@1-4,@1+@1+@1+@1',
                                                    74: '37-46/2,1-2,1-2,1-2,1-3,1-3,1+3,3,3,3/@3,@1+@1-3,@1-3+@1-3,@1-3+@1-3,@1-3+@1-4+@1,@1-4.5+@1+@1-3,@1-3+@1-3,@1-4,@1-3,@1',
                                                    75: '81-88/2,1-3,1-3,1-4,1-4,1-4,1+3-4,4/@1,@1+@1-3+@3,@1-4+@1-3+@1-3,@1-3+@1-4.5+@1-3+@3,@1-4.5+@1@3.5-4+@1-3+@1-3,@1-3+@1+@1-4+@1-3,@1+@1+@1-4.5,@1-3',
                                                    76: '39-44/1+5,1+5,1+3+5,3+5,3+5,3/@1-3+@1-3,@1-3+@1-3,@1+@1+@3,@1-3+@1-3,@1-3+@1-3,@1',
                                                    77: '82-86/1+6,1+6,1+4+6,4-5,4-5/@1+@1-4,@1-4+@1-3,@1+@3+@1,@1-3+@1-3,@1-3+@1-3',
                                                    78: '40-41/4+6,4+6/@2-4.5+@3-4.5,@1+@1-3',
                                                    79: '84-85/2+5-6,2+5-6/@2-4.5+@1-4+@4,@1-2+@1+@1-3',
                                                    80: '40-41/4+6,4+6/@2-4.5+@3-4.5,@1+@1-3',
                                                    81: '86-88/2-3,2+4,2+4/@4+@1-4,@1-3+@2-4.5,@1+@1-3',
                                                    82: '1-10/1,1,1,1,1+3,1+3,3,3,3,3/@1,@1,@1,@1,@1+@1,@1+@1,@1,@1,@1,@1',
                                                    83: '1-10/1,1,1,1,1+3,1+3,3,3,3,3/@1,@1,@1,@1,@1+@1,@1+@1,@1,@1,@1,@1',
                                                    84: '27-38/1,1+4,1+4,1+3-4,1+3-4+6,3+6,2-3+6,2-3+5-6,2+5,2+5,2+5,5/@3,@1-4.5+@3,@1-4.5+@1-4,@1-4.5+@3+@1-3,@1+@1-4.5+@1+@3,@1-4.5+@1-4,@3+@1-4.5+@1-3,@1-4.5+@1+@3+@1,@1-4.5+@1-4,@1-4.5+@1-3,@1+@1,@1',
                                                    85: '20-34/3,3+5,3+5,2-3+5,2-3+5-6,2+6,2+6,2-3+6,1+3,1+3,1+3-4,1+3-4+6,4+6,4+6,4/@4,@1-4.5+@3,@1-4.5+@1-4.5,@3+@1-4+@1-3,@1-4.5+@1+@1+@3,@1-4.5+@1-4.5,@1-4+@1-3,@1+@2-3+@1,@1-4+@1-4,@1-4+@1-4,@1-4+@1-3+@2-3,@1-3+@1+@1-4+@1-4,@1-4+@1-4.5,@1-3+@1-3,@1',
                                                    86: '27-29/1,1,1/@3,@1-4.5,@1-2',
                                                    87: '32-34/2,1-2,1/@2-3,@1-3+@1-2.5,@1-3',
                                                    88: '68-70/1+6,1+6,1+6/@2-4+@2-4,@1-4+@1-3,@1+@1',
                                                    89: '40-49/2+5,2+4-6,2+4-6,4+6,1+2+4+6,1-2,1-2,1+6,1+6,1+6/@1-4+@1-4,@1-4.5+@3-4.5+@1-3+@3-4,@1+@1-4+@1+@1-4,@1-4+@1,@1-4+@2-4+@1-3+@1,@1-4.5+@1-3,@1-4+@1,@1-4+@1-4,@1-4+@1-3,@1+@1'},
    'musical_type': {60: 'Periodic entry', 61: 'Periodic entry', 62: 'Imitative duo', 63: 'Periodic entry', 64: 'Fuga',
                     65: 'Fuga', 66: 'Fuga', 67: 'Periodic entry', 68: 'Soggetto', 69: 'Soggetto', 70: 'Periodic entry',
                     71: 'Periodic entry', 72: 'Homorhythm', 73: 'Fuga, Non-imitative duo', 74: 'Fuga', 75: 'Fuga',
                     76: 'Non-imitative duo', 77: 'Non-imitative duo', 78: 'Fuga', 79: 'Fuga', 80: 'Fuga', 81: 'Fuga',
                     82: 'Fuga', 83: 'Fuga', 84: 'Non-imitative duo', 85: 'Non-imitative duo', 86: 'Soggetto',
                     87: 'Fuga', 88: 'Contrapuntal duo', 89: 'Non-imitative duo'},
    'mt_cf': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
              69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
              78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
              87: False, 88: False, 89: False},
    'mt_cf_voices': {60: np.nan, 61: np.nan, 62: np.nan, 63: np.nan, 64: np.nan, 65: np.nan, 66: np.nan, 67: np.nan,
                     68: np.nan,
                     69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: np.nan, 74: np.nan, 75: np.nan, 76: np.nan,
                     77: np.nan,
                     78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan, 82: np.nan, 83: np.nan, 84: np.nan, 85: np.nan,
                     86: np.nan,
                     87: np.nan, 88: np.nan, 89: np.nan},
    'mt_cf_dur': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                  69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                  78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                  87: False, 88: False, 89: False},
    'mt_cf_mel': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                  69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                  78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                  87: False, 88: False, 89: False},
    'mt_sog': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: True,
               69: True, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
               78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: True,
               87: False, 88: False, 89: False},
    'mt_sog_voices': {60: np.nan, 61: np.nan, 62: np.nan, 63: np.nan, 64: np.nan, 65: np.nan, 66: np.nan, 67: np.nan,
                      68: '[Discantus]', 69: 'Discantus', 70: np.nan, 71: np.nan, 72: np.nan, 73: np.nan, 74: np.nan,
                      75: np.nan, 76: np.nan, 77: np.nan, 78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan, 82: np.nan,
                      83: np.nan,
                      84: np.nan, 85: np.nan, 86: '[Discantus]', 87: np.nan, 88: np.nan, 89: np.nan},
    'mt_sog_dur': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: True,
                   69: True, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                   78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: True,
                   87: False, 88: False, 89: False},
    'mt_sog_mel': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: True,
                   69: True, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                   78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: True,
                   87: False, 88: False, 89: False},
    'mt_sog_ostinato': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False,
                        68: False, 69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False,
                        76: False, 77: False, 78: False, 79: False, 80: False, 81: False, 82: False, 83: False,
                        84: False, 85: False, 86: False, 87: False, 88: False, 89: False},
    'mt_sog_periodic': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False,
                        68: False, 69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False,
                        76: False, 77: False, 78: False, 79: False, 80: False, 81: False, 82: False, 83: False,
                        84: False, 85: False, 86: False, 87: False, 88: False, 89: False},
    'mt_csog': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                87: False, 88: False, 89: False},
    'mt_csog_voices': {60: np.nan, 61: np.nan, 62: np.nan, 63: np.nan, 64: np.nan, 65: np.nan, 66: np.nan, 67: np.nan,
                       68: np.nan, 69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: np.nan, 74: np.nan, 75: np.nan,
                       76: np.nan, 77: np.nan, 78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan, 82: np.nan, 83: np.nan,
                       84: np.nan, 85: np.nan, 86: np.nan, 87: np.nan, 88: np.nan, 89: np.nan},
    'mt_csog_dur': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                    69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                    78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                    87: False, 88: False, 89: False},
    'mt_csog_mel': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                    69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                    78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                    87: False, 88: False, 89: False},
    'mt_cd': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
              69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
              78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
              87: False, 88: True, 89: False},
    'mt_cd_voices': {60: np.nan, 61: np.nan, 62: np.nan, 63: np.nan, 64: np.nan, 65: np.nan, 66: np.nan, 67: np.nan,
                     68: np.nan,
                     69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: np.nan, 74: np.nan, 75: np.nan, 76: np.nan,
                     77: np.nan,
                     78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan, 82: np.nan, 83: np.nan, 84: np.nan, 85: np.nan,
                     86: np.nan,
                     87: np.nan, 88: '[Discantus]\n[Bassus]', 89: np.nan},
    'mt_fg': {60: False, 61: False, 62: False, 63: False, 64: True, 65: True, 66: True, 67: False, 68: False, 69: False,
              70: False, 71: False, 72: False, 73: True, 74: True, 75: True, 76: False, 77: False, 78: True, 79: True,
              80: True, 81: True, 82: True, 83: True, 84: False, 85: False, 86: False, 87: True, 88: False, 89: False},
    'mt_fg_voices': {60: np.nan, 61: np.nan, 62: np.nan, 63: np.nan, 64: 'Contratenor [1]\r\nContratenor [2]',
                     65: 'Contratenor [1]\r\nContratenor [2]', 66: '[QuintaVox]\n[Bassus]', 67: np.nan, 68: np.nan,
                     69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: 'Discantus\r\nTenor',
                     74: '[Contratenor]\n[Discantus]\n[Tenor]',
                     75: 'Contratenor [1]\r\nDiscantus\r\nContratenor [2]\r\nTenor', 76: np.nan, 77: np.nan,
                     78: '[QuintaVox]\n[Bassus]', 79: 'Bassus [1]\r\nContratenor\r\nBassus [2]',
                     80: '[QuintaVox]\n[Bassus]', 81: 'Contratenor [2]\r\nContratenor [1]\r\nTenor',
                     82: '[Discantus]\n[Tenor]', 83: '[Discantus]\r\n[Contratenor 2]', 84: np.nan, 85: np.nan,
                     86: np.nan,
                     87: '[Contratenor 1]\r\n[Discantus]', 88: np.nan, 89: np.nan},
    'mt_fg_int': {60: np.nan, 61: np.nan, 62: np.nan, 63: np.nan, 64: '1+', 65: '1+', 66: '5-', 67: np.nan, 68: np.nan,
                  69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: '8-', 74: '4+8-', 75: '4+5-4-', 76: np.nan,
                  77: np.nan,
                  78: '5-', 79: '12+12-', 80: '5-', 81: '2+5-', 82: '8-', 83: '8-', 84: np.nan, 85: np.nan, 86: np.nan,
                  87: '5+', 88: np.nan, 89: np.nan},
    'mt_fg_tint': {60: np.nan, 61: np.nan, 62: np.nan, 63: np.nan, 64: 'M1', 65: 'S1', 66: 'M1', 67: np.nan, 68: np.nan,
                   69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: 'B2', 74: 'S1/6', 75: 'S2/1/4', 76: np.nan,
                   77: np.nan,
                   78: 'M1', 79: 'M1/2', 80: 'M1', 81: 'M3/2', 82: 'B4', 83: 'B4', 84: np.nan, 85: np.nan, 86: np.nan,
                   87: 'S2', 88: np.nan, 89: np.nan},
    'mt_fg_periodic': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False,
                       68: False, 69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False,
                       76: False, 77: False, 78: False, 79: False, 80: False, 81: False, 82: False, 83: False,
                       84: False, 85: False, 86: False, 87: False, 88: False, 89: False},
    'mt_fg_strict': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: True, 67: False, 68: False,
                     69: False, 70: False, 71: False, 72: False, 73: True, 74: True, 75: False, 76: False, 77: False,
                     78: True, 79: True, 80: True, 81: True, 82: True, 83: True, 84: False, 85: False, 86: False,
                     87: True, 88: False, 89: False},
    'mt_fg_flexed': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                     69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: True, 76: False, 77: False,
                     78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                     87: False, 88: False, 89: False},
    'mt_fg_sequential': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False,
                         68: False, 69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False,
                         76: False, 77: False, 78: False, 79: False, 80: False, 81: False, 82: False, 83: False,
                         84: False, 85: False, 86: False, 87: False, 88: False, 89: False},
    'mt_fg_inverted': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False,
                       68: False, 69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False,
                       76: False, 77: False, 78: False, 79: False, 80: False, 81: False, 82: False, 83: False,
                       84: False, 85: False, 86: False, 87: False, 88: False, 89: False},
    'mt_fg_retrograde': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False,
                         68: False, 69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False,
                         76: False, 77: False, 78: False, 79: False, 80: False, 81: False, 82: False, 83: False,
                         84: False, 85: False, 86: False, 87: False, 88: False, 89: False},
    'mt_pe': {60: True, 61: True, 62: False, 63: True, 64: False, 65: False, 66: False, 67: True, 68: False, 69: False,
              70: True, 71: True, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False, 78: False,
              79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False, 87: False,
              88: False, 89: False},
    'mt_pe_voices': {60: '[Contratenor]\n[Discantus]\n[QuintaVox]', 61: 'Contratenor [1]\r\nDiscantus\r\nBassus [1]',
                     62: np.nan, 63: 'Bassus [1]\r\nContratenor [1]\r\nBassus [2]', 64: np.nan, 65: np.nan, 66: np.nan,
                     67: 'Bassus [2]\r\nBassus [1]\r\nContratenor', 68: np.nan, 69: np.nan,
                     70: '[Tenor]\n[Contratenor]\n[Discantus]\n[QuintaVox]',
                     71: 'Contratenor [2]\r\nDiscantus\r\nTenor \r\nBassus [1]\r\nContratenor [1]\r\nContratenor [2]\r\nDiscantus\r\nBassus [2]\r\nBassus [1]\r\nContratenor [1]\r\nTenor \r\nBassus [2]',
                     72: np.nan, 73: np.nan, 74: np.nan, 75: np.nan, 76: np.nan, 77: np.nan, 78: np.nan, 79: np.nan,
                     80: np.nan,
                     81: np.nan, 82: np.nan, 83: np.nan, 84: np.nan, 85: np.nan, 86: np.nan, 87: np.nan, 88: np.nan,
                     89: np.nan},
    'mt_pe_int': {60: '7+4-', 61: '7+11-', 62: np.nan, 63: '8+8-', 64: np.nan, 65: np.nan, 66: np.nan, 67: '1+8+',
                  68: np.nan, 69: np.nan, 70: '2+7+4-', 71: '5+8-4-5+3+5+15-5+7+4-8-', 72: np.nan, 73: np.nan,
                  74: np.nan,
                  75: np.nan, 76: np.nan, 77: np.nan, 78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan, 82: np.nan,
                  83: np.nan,
                  84: np.nan, 85: np.nan, 86: np.nan, 87: np.nan, 88: np.nan, 89: np.nan},
    'mt_pe_tint': {60: 'S1/1', 61: 'S1/1', 62: np.nan, 63: 'S2/2', 64: np.nan, 65: np.nan, 66: np.nan, 67: 'M1/1',
                   68: np.nan, 69: np.nan, 70: 'S1', 71: 'S1/1/1/1/1/1/1/1/1/1/1', 72: np.nan, 73: np.nan, 74: np.nan,
                   75: np.nan, 76: np.nan, 77: np.nan, 78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan, 82: np.nan,
                   83: np.nan,
                   84: np.nan, 85: np.nan, 86: np.nan, 87: np.nan, 88: np.nan, 89: np.nan},
    'mt_pe_strict': {60: True, 61: True, 62: False, 63: True, 64: False, 65: False, 66: False, 67: True, 68: False,
                     69: False, 70: True, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                     78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                     87: False, 88: False, 89: False},
    'mt_pe_flexed': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                     69: False, 70: False, 71: True, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                     78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                     87: False, 88: False, 89: False},
    'mt_pe_flt': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                  69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                  78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                  87: False, 88: False, 89: False},
    'mt_pe_sequential': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False,
                         68: False, 69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False,
                         76: False, 77: False, 78: False, 79: False, 80: False, 81: False, 82: False, 83: False,
                         84: False, 85: False, 86: False, 87: False, 88: False, 89: False},
    'mt_pe_added': {60: False, 61: False, 62: False, 63: True, 64: False, 65: False, 66: False, 67: False, 68: False,
                    69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                    78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                    87: False, 88: False, 89: False},
    'mt_pe_invertible': {60: True, 61: True, 62: False, 63: True, 64: False, 65: False, 66: False, 67: False, 68: False,
                         69: False, 70: True, 71: True, 72: False, 73: False, 74: False, 75: False, 76: False,
                         77: False, 78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False,
                         85: False, 86: False, 87: False, 88: False, 89: False},
    'mt_id': {60: False, 61: False, 62: True, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
              69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
              78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
              87: False, 88: False, 89: False},
    'mt_id_voices': {60: np.nan, 61: np.nan, 62: '[SextaVox]\n[Tenor]\n[Bassus]\n[SextaVox]\n[Tenor]\n[Bassus]',
                     63: np.nan, 64: np.nan, 65: np.nan, 66: np.nan, 67: np.nan, 68: np.nan, 69: np.nan, 70: np.nan,
                     71: np.nan,
                     72: np.nan, 73: np.nan, 74: np.nan, 75: np.nan, 76: np.nan, 77: np.nan, 78: np.nan, 79: np.nan,
                     80: np.nan,
                     81: np.nan, 82: np.nan, 83: np.nan, 84: np.nan, 85: np.nan, 86: np.nan, 87: np.nan, 88: np.nan,
                     89: np.nan},
    'mt_id_int': {60: np.nan, 61: np.nan, 62: '8+4-5-9+5-', 63: np.nan, 64: np.nan, 65: np.nan, 66: np.nan, 67: np.nan,
                  68: np.nan, 69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: np.nan, 74: np.nan, 75: np.nan,
                  76: np.nan,
                  77: np.nan, 78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan, 82: np.nan, 83: np.nan, 84: np.nan,
                  85: np.nan,
                  86: np.nan, 87: np.nan, 88: np.nan, 89: np.nan},
    'mt_id_tint': {60: np.nan, 61: np.nan, 62: 'S2/1/2/1/2', 63: np.nan, 64: np.nan, 65: np.nan, 66: np.nan, 67: np.nan,
                   68: np.nan, 69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: np.nan, 74: np.nan, 75: np.nan,
                   76: np.nan,
                   77: np.nan, 78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan, 82: np.nan, 83: np.nan, 84: np.nan,
                   85: np.nan,
                   86: np.nan, 87: np.nan, 88: np.nan, 89: np.nan},
    'mt_id_strict': {60: False, 61: False, 62: True, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                     69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                     78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                     87: False, 88: False, 89: False},
    'mt_id_flexed': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                     69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                     78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                     87: False, 88: False, 89: False},
    'mt_id_flt': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                  69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                  78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                  87: False, 88: False, 89: False},
    'mt_id_invertible': {60: False, 61: False, 62: True, 63: False, 64: False, 65: False, 66: False, 67: False,
                         68: False, 69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False,
                         76: False, 77: False, 78: False, 79: False, 80: False, 81: False, 82: False, 83: False,
                         84: False, 85: False, 86: False, 87: False, 88: False, 89: False},
    'mt_nid': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
               69: False, 70: False, 71: False, 72: False, 73: True, 74: False, 75: False, 76: True, 77: True,
               78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: True, 85: True, 86: False,
               87: False, 88: False, 89: True},
    'mt_nid_voices': {60: np.nan, 61: np.nan, 62: np.nan, 63: np.nan, 64: np.nan, 65: np.nan, 66: np.nan, 67: np.nan,
                      68: np.nan,
                      69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: 'Bassus [1]\r\nBassus [2]', 74: np.nan,
                      75: np.nan,
                      76: '[Discantus]\r\n[SextaVox]\r\n[Tenor]\r\n[SextaVox]',
                      77: 'Discantus\r\nBassus [2]\r\nTenor \r\nBassus [1]', 78: np.nan, 79: np.nan, 80: np.nan,
                      81: np.nan,
                      82: np.nan, 83: np.nan,
                      84: '[Discantus]\n[QuintaVox]\n[Tenor]\n[Bassus]\n[Contratenor]\n[SextaVox]',
                      85: '[Contratenor 2]\r\n[Bassus 1]\r\n[Contratenor 1]\r\n[Bassus 2]\r\n[Contratenor 2]\r\n[Discantus]\r\n[Tenor]\r\n[Bassus 2]',
                      86: np.nan, 87: np.nan, 88: np.nan,
                      89: '[Contratenor 1]\r\n[Bassus 1]\r\n[Tenor] \r\n[Bassus 2]\r\n[Discantus]\r\n[Contratenor 1]'},
    'mt_nid_int': {60: np.nan, 61: np.nan, 62: np.nan, 63: np.nan, 64: np.nan, 65: np.nan, 66: np.nan, 67: np.nan,
                   68: np.nan,
                   69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: '1+', 74: np.nan, 75: np.nan, 76: '8-', 77: '8-',
                   78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan, 82: np.nan, 83: np.nan, 84: '8-1+', 85: '1+4+4-',
                   86: np.nan, 87: np.nan, 88: np.nan, 89: '1+8+'},
    'mt_nid_tint': {60: np.nan, 61: np.nan, 62: np.nan, 63: np.nan, 64: np.nan, 65: np.nan, 66: np.nan, 67: np.nan,
                    68: np.nan,
                    69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: 'B2', 74: np.nan, 75: np.nan, 76: 'S4',
                    77: 'S5',
                    78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan, 82: np.nan, 83: np.nan, 84: 'B3/3', 85: 'B3/4/3',
                    86: np.nan, 87: np.nan, 88: np.nan, 89: 'S3/5'},
    'mt_nid_strict': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                      69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                      78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: True, 85: False, 86: False,
                      87: False, 88: False, 89: False},
    'mt_nid_flexed': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                      69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: True,
                      78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: True, 86: False,
                      87: False, 88: False, 89: False},
    'mt_nid_flt': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                   69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                   78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                   87: False, 88: False, 89: False},
    'mt_nid_sequential': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False,
                          68: False, 69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False,
                          76: False, 77: False, 78: False, 79: False, 80: False, 81: False, 82: False, 83: False,
                          84: False, 85: False, 86: False, 87: False, 88: False, 89: False},
    'mt_nid_invertible': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False,
                          68: False, 69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False,
                          76: False, 77: False, 78: False, 79: False, 80: False, 81: False, 82: False, 83: False,
                          84: False, 85: True, 86: False, 87: False, 88: False, 89: False},
    'mt_hr': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
              69: False, 70: False, 71: False, 72: True, 73: False, 74: False, 75: False, 76: False, 77: False,
              78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
              87: False, 88: False, 89: False},
    'mt_hr_voices': {60: np.nan, 61: np.nan, 62: np.nan, 63: np.nan, 64: np.nan, 65: np.nan, 66: np.nan, 67: np.nan,
                     68: np.nan,
                     69: np.nan, 70: np.nan, 71: np.nan,
                     72: '[Discantus]\r\n[Contratenor]\r\n[Tenor]\r\n[QuintaVox]\r\n[SextaVox]\r\n[Bassus]', 73: np.nan,
                     74: np.nan, 75: np.nan, 76: np.nan, 77: np.nan, 78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan,
                     82: np.nan,
                     83: np.nan, 84: np.nan, 85: np.nan, 86: np.nan, 87: np.nan, 88: np.nan, 89: np.nan},
    'mt_hr_simple': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                     69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                     78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                     87: False, 88: False, 89: False},
    'mt_hr_staggered': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False,
                        68: False, 69: False, 70: False, 71: False, 72: True, 73: False, 74: False, 75: False,
                        76: False, 77: False, 78: False, 79: False, 80: False, 81: False, 82: False, 83: False,
                        84: False, 85: False, 86: False, 87: False, 88: False, 89: False},
    'mt_hr_sequential': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False,
                         68: False, 69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False,
                         76: False, 77: False, 78: False, 79: False, 80: False, 81: False, 82: False, 83: False,
                         84: False, 85: False, 86: False, 87: False, 88: False, 89: False},
    'mt_hr_fauxbourdon': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False,
                          68: False, 69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False,
                          76: False, 77: False, 78: False, 79: False, 80: False, 81: False, 82: False, 83: False,
                          84: False, 85: False, 86: False, 87: False, 88: False, 89: False},
    'mt_cad': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
               69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
               78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
               87: False, 88: False, 89: False},
    'mt_cad_cantizans': {60: np.nan, 61: np.nan, 62: np.nan, 63: np.nan, 64: np.nan, 65: np.nan, 66: np.nan, 67: np.nan,
                         68: np.nan, 69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: np.nan, 74: np.nan, 75: np.nan,
                         76: np.nan, 77: np.nan, 78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan, 82: np.nan, 83: np.nan,
                         84: np.nan, 85: np.nan, 86: np.nan, 87: np.nan, 88: np.nan, 89: np.nan},
    'mt_cad_tenorizans': {60: np.nan, 61: np.nan, 62: np.nan, 63: np.nan, 64: np.nan, 65: np.nan, 66: np.nan,
                          67: np.nan,
                          68: np.nan, 69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: np.nan, 74: np.nan,
                          75: np.nan,
                          76: np.nan, 77: np.nan, 78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan, 82: np.nan,
                          83: np.nan,
                          84: np.nan, 85: np.nan, 86: np.nan, 87: np.nan, 88: np.nan, 89: np.nan},
    'mt_cad_type': {60: np.nan, 61: np.nan, 62: np.nan, 63: np.nan, 64: np.nan, 65: np.nan, 66: np.nan, 67: np.nan,
                    68: np.nan,
                    69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: np.nan, 74: np.nan, 75: np.nan, 76: np.nan,
                    77: np.nan,
                    78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan, 82: np.nan, 83: np.nan, 84: np.nan, 85: np.nan,
                    86: np.nan,
                    87: np.nan, 88: np.nan, 89: np.nan},
    'mt_cad_tone': {60: np.nan, 61: np.nan, 62: np.nan, 63: np.nan, 64: np.nan, 65: np.nan, 66: np.nan, 67: np.nan,
                    68: np.nan,
                    69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: np.nan, 74: np.nan, 75: np.nan, 76: np.nan,
                    77: np.nan,
                    78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan, 82: np.nan, 83: np.nan, 84: np.nan, 85: np.nan,
                    86: np.nan,
                    87: np.nan, 88: np.nan, 89: np.nan},
    'mt_cad_dtv': {60: np.nan, 61: np.nan, 62: np.nan, 63: np.nan, 64: np.nan, 65: np.nan, 66: np.nan, 67: np.nan,
                   68: np.nan,
                   69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: np.nan, 74: np.nan, 75: np.nan, 76: np.nan,
                   77: np.nan,
                   78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan, 82: np.nan, 83: np.nan, 84: np.nan, 85: np.nan,
                   86: np.nan,
                   87: np.nan, 88: np.nan, 89: np.nan},
    'mt_cad_dti': {60: np.nan, 61: np.nan, 62: np.nan, 63: np.nan, 64: np.nan, 65: np.nan, 66: np.nan, 67: np.nan,
                   68: np.nan,
                   69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: np.nan, 74: np.nan, 75: np.nan, 76: np.nan,
                   77: np.nan,
                   78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan, 82: np.nan, 83: np.nan, 84: np.nan, 85: np.nan,
                   86: np.nan,
                   87: np.nan, 88: np.nan, 89: np.nan},
    'mt_int': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
               69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
               78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
               87: False, 88: False, 89: False},
    'mt_int_voices': {60: np.nan, 61: np.nan, 62: np.nan, 63: np.nan, 64: np.nan, 65: np.nan, 66: np.nan, 67: np.nan,
                      68: np.nan,
                      69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: np.nan, 74: np.nan, 75: np.nan, 76: np.nan,
                      77: np.nan,
                      78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan, 82: np.nan, 83: np.nan, 84: np.nan, 85: np.nan,
                      86: np.nan,
                      87: np.nan, 88: np.nan, 89: np.nan},
    'mt_int_p6': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                  69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                  78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                  87: False, 88: False, 89: False},
    'mt_int_p3': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                  69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                  78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                  87: False, 88: False, 89: False},
    'mt_int_c35': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                   69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                   78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                   87: False, 88: False, 89: False},
    'mt_int_c83': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                   69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                   78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                   87: False, 88: False, 89: False},
    'mt_int_c65': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                   69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                   78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                   87: False, 88: False, 89: False},
    'mt_fp': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
              69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
              78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
              87: False, 88: False, 89: False},
    'mt_fp_ir': {60: False, 61: False, 62: False, 63: False, 64: False, 65: False, 66: False, 67: False, 68: False,
                 69: False, 70: False, 71: False, 72: False, 73: False, 74: False, 75: False, 76: False, 77: False,
                 78: False, 79: False, 80: False, 81: False, 82: False, 83: False, 84: False, 85: False, 86: False,
                 87: False, 88: False, 89: False},
    'mt_fp_range': {60: np.nan, 61: np.nan, 62: np.nan, 63: np.nan, 64: np.nan, 65: np.nan, 66: np.nan, 67: np.nan,
                    68: np.nan,
                    69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: np.nan, 74: np.nan, 75: np.nan, 76: np.nan,
                    77: np.nan,
                    78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan, 82: np.nan, 83: np.nan, 84: np.nan, 85: np.nan,
                    86: np.nan,
                    87: np.nan, 88: np.nan, 89: np.nan},
    'mt_fp_comment': {60: np.nan, 61: np.nan, 62: np.nan, 63: np.nan, 64: np.nan, 65: np.nan, 66: np.nan, 67: np.nan,
                      68: np.nan,
                      69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: np.nan, 74: np.nan, 75: np.nan, 76: np.nan,
                      77: np.nan,
                      78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan, 82: np.nan, 83: np.nan, 84: np.nan, 85: np.nan,
                      86: np.nan,
                      87: np.nan, 88: np.nan, 89: np.nan},
    'remarks': {60: np.nan, 61: np.nan, 62: np.nan, 63: 'Added entry in B1 mes.150-151', 64: np.nan, 65: np.nan,
                66: np.nan,
                67: np.nan, 68: np.nan, 69: np.nan, 70: np.nan, 71: np.nan, 72: np.nan, 73: np.nan, 74: np.nan,
                75: np.nan,
                76: 'In second NIM, tenor is 8- but S is 1+', 77: 'NOT FLEXED\r\nIn second NIM, T is 8- but B1 is 1+',
                78: np.nan, 79: np.nan, 80: np.nan, 81: np.nan, 82: np.nan, 83: np.nan, 84: np.nan, 85: np.nan,
                86: np.nan,
                87: np.nan,
                88: 'Sogetto in the bass is repeated, creating a module with CS in the contratenor, but the contrapuntal duo DB is not repeated.',
                89: 'The lower voice of the NIM is also used as fuga starting in m. 43.'},
    'created': {60: '2017-08-03T19:24:17-04:00', 61: '2017-08-03T19:24:17-04:00', 62: '2017-07-01T00:00:25-04:00',
                63: '2017-07-01T00:00:25-04:00', 64: '2017-07-01T01:00:45-04:00', 65: '2017-07-01T01:00:45-04:00',
                66: '2017-07-01T01:09:01-04:00', 67: '2017-07-01T01:09:01-04:00', 68: '2017-07-01T01:15:44-04:00',
                69: '2017-07-01T01:15:44-04:00', 70: '2017-07-01T01:33:05-04:00', 71: '2017-07-01T01:33:05-04:00',
                72: '2017-07-01T01:53:03-04:00', 73: '2017-07-01T01:53:03-04:00', 74: '2017-07-01T17:18:11-04:00',
                75: '2017-07-01T17:18:11-04:00', 76: '2017-08-03T19:32:22-04:00', 77: '2017-08-03T19:32:22-04:00',
                78: '2017-08-03T19:32:22-04:00', 79: '2017-08-03T19:32:22-04:00', 80: '2017-08-03T19:32:22-04:00',
                81: '2017-08-03T19:32:22-04:00', 82: '2017-07-01T17:39:50-04:00', 83: '2017-07-01T17:39:50-04:00',
                84: '2017-08-03T19:35:31-04:00', 85: '2017-08-03T19:35:31-04:00', 86: '2017-08-03T19:36:08-04:00',
                87: '2017-08-03T19:36:08-04:00', 88: '2017-08-03T19:36:56-04:00', 89: '2017-08-03T19:36:56-04:00'},
    'updated': {60: '2020-08-30T13:42:17.663686-04:00', 61: '2020-08-30T13:42:23.239562-04:00',
                62: '2020-08-30T13:43:58.057422-04:00', 63: '2020-08-30T13:44:03.844552-04:00',
                64: '2020-07-20T14:59:12.118037-04:00', 65: '2020-07-20T15:00:46.230447-04:00',
                66: '2019-06-26T17:55:17.201000-04:00', 67: '2020-07-20T15:02:54.966656-04:00',
                68: '2019-06-26T17:55:17.218000-04:00', 69: '2019-06-26T17:55:17.206000-04:00',
                70: '2019-06-26T17:55:17.212000-04:00', 71: '2020-07-20T15:07:31.018547-04:00',
                72: '2019-06-26T17:55:17.209000-04:00', 73: '2020-07-20T15:26:27.443573-04:00',
                74: '2019-06-26T17:55:17.221000-04:00', 75: '2020-07-21T14:00:59.184254-04:00',
                76: '2020-08-30T14:14:42.065815-04:00', 77: '2020-07-21T14:01:39.151905-04:00',
                78: '2019-06-26T17:55:17.233000-04:00', 79: '2020-07-21T14:07:01.802545-04:00',
                80: '2019-06-26T17:55:34.741000-04:00', 81: '2020-07-21T14:07:35.377971-04:00',
                82: '2019-06-26T17:55:17.251000-04:00', 83: '2020-07-20T11:45:44.284453-04:00',
                84: '2019-06-26T17:55:17.242000-04:00', 85: '2020-08-30T14:29:32.869040-04:00',
                86: '2019-06-26T17:55:17.246000-04:00', 87: '2020-07-20T11:49:52.764137-04:00',
                88: '2019-06-26T17:55:17.254000-04:00', 89: '2020-08-30T14:39:08.143450-04:00'},
    'curated': {60: True, 61: True, 62: True, 63: True, 64: True, 65: True, 66: True, 67: True, 68: True, 69: True,
                70: True, 71: True, 72: True, 73: True, 74: True, 75: True, 76: True, 77: True, 78: True, 79: True,
                80: True, 81: True, 82: True, 83: True, 84: True, 85: True, 86: True, 87: True, 88: True, 89: True},
    'observer.url': {60: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     61: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     62: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     63: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     64: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     65: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     66: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     67: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     68: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     69: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     70: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     71: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     72: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     73: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     74: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     75: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     76: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     77: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     78: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     79: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     80: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     81: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     82: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     83: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     84: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     85: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     86: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     87: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     88: 'http://crimproject.org/data/people/CRIM_Person_1016/',
                     89: 'http://crimproject.org/data/people/CRIM_Person_1016/'},
    'observer.name': {60: 'Alexis Risler', 61: 'Alexis Risler', 62: 'Alexis Risler', 63: 'Alexis Risler',
                      64: 'Alexis Risler', 65: 'Alexis Risler', 66: 'Alexis Risler', 67: 'Alexis Risler',
                      68: 'Alexis Risler', 69: 'Alexis Risler', 70: 'Alexis Risler', 71: 'Alexis Risler',
                      72: 'Alexis Risler', 73: 'Alexis Risler', 74: 'Alexis Risler', 75: 'Alexis Risler',
                      76: 'Alexis Risler', 77: 'Alexis Risler', 78: 'Alexis Risler', 79: 'Alexis Risler',
                      80: 'Alexis Risler', 81: 'Alexis Risler', 82: 'Alexis Risler', 83: 'Alexis Risler',
                      84: 'Alexis Risler', 85: 'Alexis Risler', 86: 'Alexis Risler', 87: 'Alexis Risler',
                      88: 'Alexis Risler', 89: 'Alexis Risler'},
    'piece.url': {60: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                  61: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                  62: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                  63: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                  64: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                  65: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                  66: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                  67: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                  68: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                  69: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                  70: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                  71: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                  72: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                  73: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                  74: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                  75: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                  76: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                  77: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                  78: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                  79: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                  80: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                  81: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_2/',
                  82: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                  83: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_1/',
                  84: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                  85: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_1/',
                  86: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                  87: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_1/',
                  88: 'http://crimproject.org/data/pieces/CRIM_Model_0017/',
                  89: 'http://crimproject.org/data/pieces/CRIM_Mass_0015_1/'},
    'piece.piece_id': {60: 'CRIM_Model_0017', 61: 'CRIM_Mass_0015_2', 62: 'CRIM_Model_0017', 63: 'CRIM_Mass_0015_2',
                       64: 'CRIM_Mass_0015_2', 65: 'CRIM_Mass_0015_2', 66: 'CRIM_Model_0017', 67: 'CRIM_Mass_0015_2',
                       68: 'CRIM_Model_0017', 69: 'CRIM_Mass_0015_2', 70: 'CRIM_Model_0017', 71: 'CRIM_Mass_0015_2',
                       72: 'CRIM_Model_0017', 73: 'CRIM_Mass_0015_2', 74: 'CRIM_Model_0017', 75: 'CRIM_Mass_0015_2',
                       76: 'CRIM_Model_0017', 77: 'CRIM_Mass_0015_2', 78: 'CRIM_Model_0017', 79: 'CRIM_Mass_0015_2',
                       80: 'CRIM_Model_0017', 81: 'CRIM_Mass_0015_2', 82: 'CRIM_Model_0017', 83: 'CRIM_Mass_0015_1',
                       84: 'CRIM_Model_0017', 85: 'CRIM_Mass_0015_1', 86: 'CRIM_Model_0017', 87: 'CRIM_Mass_0015_1',
                       88: 'CRIM_Model_0017', 89: 'CRIM_Mass_0015_1'},
    'piece.full_title': {60: 'Benedicta es', 61: 'Missa Benedicta es: Gloria', 62: 'Benedicta es',
                         63: 'Missa Benedicta es: Gloria', 64: 'Missa Benedicta es: Gloria',
                         65: 'Missa Benedicta es: Gloria', 66: 'Benedicta es', 67: 'Missa Benedicta es: Gloria',
                         68: 'Benedicta es', 69: 'Missa Benedicta es: Gloria', 70: 'Benedicta es',
                         71: 'Missa Benedicta es: Gloria', 72: 'Benedicta es', 73: 'Missa Benedicta es: Gloria',
                         74: 'Benedicta es', 75: 'Missa Benedicta es: Gloria', 76: 'Benedicta es',
                         77: 'Missa Benedicta es: Gloria', 78: 'Benedicta es', 79: 'Missa Benedicta es: Gloria',
                         80: 'Benedicta es', 81: 'Missa Benedicta es: Gloria', 82: 'Benedicta es',
                         83: 'Missa Benedicta es: Kyrie', 84: 'Benedicta es', 85: 'Missa Benedicta es: Kyrie',
                         86: 'Benedicta es', 87: 'Missa Benedicta es: Kyrie', 88: 'Benedicta es',
                         89: 'Missa Benedicta es: Kyrie'},
    'piece.mass': {60: np.nan, 61: 'CRIM_Mass_0015', 62: np.nan, 63: 'CRIM_Mass_0015', 64: 'CRIM_Mass_0015',
                   65: 'CRIM_Mass_0015', 66: np.nan, 67: 'CRIM_Mass_0015', 68: np.nan, 69: 'CRIM_Mass_0015', 70: np.nan,
                   71: 'CRIM_Mass_0015', 72: np.nan, 73: 'CRIM_Mass_0015', 74: np.nan, 75: 'CRIM_Mass_0015', 76: np.nan,
                   77: 'CRIM_Mass_0015', 78: np.nan, 79: 'CRIM_Mass_0015', 80: np.nan, 81: 'CRIM_Mass_0015', 82: np.nan,
                   83: 'CRIM_Mass_0015', 84: np.nan, 85: 'CRIM_Mass_0015', 86: np.nan, 87: 'CRIM_Mass_0015', 88: np.nan,
                   89: 'CRIM_Mass_0015'}}
