# Generated by Django 5.0.6 on 2024-08-28 09:41

import django.db.models.deletion
from django.db import migrations, models


def copy_through(apps, schema_editor):
    Portfolio = apps.get_model("wbportfolio", "Portfolio")
    PortfolioBankAccountThroughModel = apps.get_model("wbportfolio", "PortfolioBankAccountThroughModel")

    # We loop over portfolios and their bank accounts with distinct, because we add unique constraints later
    for portfolio in Portfolio.objects.filter(bank_accounts__isnull=False).distinct():
        for bank_account in portfolio.bank_accounts.all().distinct():
            PortfolioBankAccountThroughModel.objects.create(portfolio=portfolio, bank_account=bank_account)


class Migration(migrations.Migration):
    dependencies = [
        ("directory", "0009_remove_entry_external_identfier_and_more"),
        ("wbportfolio", "0065_alter_portfolio_managers_claim_as_shares_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="PortfolioBankAccountThroughModel",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "portfolio_bank_account_type",
                    models.CharField(
                        choices=[("CASH", "Cash"), ("SECURITIES", "Securities")], default="CASH", max_length=255
                    ),
                ),
                (
                    "bank_account",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="portfolio_through",
                        to="directory.bankingcontact",
                    ),
                ),
                (
                    "portfolio",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="bank_account_through",
                        to="wbportfolio.portfolio",
                    ),
                ),
            ],
            options={
                "verbose_name": "Portfolio Bank Account",
                "verbose_name_plural": "Portfolio Bank Accounts",
            },
        ),
        migrations.RunPython(copy_through),
        migrations.RemoveField(
            model_name="portfolio",
            name="bank_accounts",
        ),
        migrations.AddField(
            model_name="portfolio",
            name="bank_accounts",
            field=models.ManyToManyField(
                blank=True,
                related_name="wbportfolio_portfolios",
                through="wbportfolio.PortfolioBankAccountThroughModel",
                to="directory.bankingcontact",
            ),
        ),
        migrations.AddConstraint(
            model_name="portfoliobankaccountthroughmodel",
            constraint=models.UniqueConstraint(
                fields=("portfolio", "bank_account"), name="unique_portfolio_bank_account"
            ),
        ),
        migrations.AddConstraint(
            model_name="portfoliobankaccountthroughmodel",
            constraint=models.UniqueConstraint(
                condition=models.Q(("portfolio_bank_account_type", "SECURITIES")),
                fields=("portfolio",),
                name="unique_portfolio_bank_account_type",
            ),
        ),
        migrations.AddField(
            model_name="portfolio",
            name="only_weighting",
            field=models.BooleanField(
                default=False,
                help_text="Indicates that this portfolio is only utilizing weights and disregards shares, e.g. a model portfolio",
            ),
        ),
        migrations.AlterField(
            model_name="portfolioportfoliothroughmodel",
            name="type",
            field=models.CharField(
                choices=[
                    ("PRIMARY", "Primary"),
                    ("MODEL", "Model"),
                    ("BENCHMARK", "Benchmark"),
                    ("INDEX", "Index"),
                    ("CUSTODIAN", "Custodian"),
                ],
                default="PRIMARY",
                verbose_name="Type",
            ),
        ),
    ]
