# Generated by Django 5.0.13 on 2025-03-21 12:30

import django.db.models.expressions
from decimal import Decimal
from django.db import migrations, models

def migrate_default_values(apps, schema_editor):
    Transaction = apps.get_model("wbportfolio", "Transaction")
    Trade = apps.get_model("wbportfolio", "Trade")
    Expiry = apps.get_model("wbportfolio", "Expiry")
    DividendTransaction = apps.get_model("wbportfolio", "DividendTransaction")
    Transaction.objects.filter(book_date__isnull=True).update(book_date=models.F("transaction_date"))
    Transaction.objects.filter(value_date__isnull=True).update(value_date=models.F("transaction_date"))
    Trade.objects.filter(price_gross__isnull=True).update(price_gross=models.F("price"))
    Expiry.objects.filter(price_gross__isnull=True).update(price_gross=models.F("price"))
    DividendTransaction.objects.filter(price_gross__isnull=True).update(price_gross=models.F("price"))
    Transaction.objects.filter(total_value_gross__isnull=True).update(total_value_gross=models.F("total_value"))


class Migration(migrations.Migration):

    dependencies = [
        ('wbportfolio', '0075_portfolio_initial_position_date_and_more'),
    ]

    operations = [
        migrations.RunPython(migrate_default_values),
        migrations.AlterField(
            model_name='transaction',
            name='book_date',
            field=models.DateField(help_text='The date that this transaction was booked.',
                                   verbose_name='Trade Date'),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='transaction',
            name='value_date',
            field=models.DateField(help_text='The date that this transaction was valuated.',
                                   verbose_name='Value Date'),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='dividendtransaction',
            name='price',
            field=models.DecimalField(decimal_places=4, default=Decimal('0.0'), help_text='The price per share.', max_digits=16, verbose_name='Price'),
        ),
        migrations.AlterField(
            model_name='dividendtransaction',
            name='price_gross',
            field=models.DecimalField(decimal_places=4, default=Decimal('0.0'), help_text='The gross price per share.', max_digits=16, verbose_name='Gross Price'),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='dividendtransaction',
            name='shares',
            field=models.DecimalField(decimal_places=4, default=Decimal('0.0'), help_text='The number of shares that were traded.', max_digits=15, verbose_name='Shares'),
        ),
        migrations.AlterField(
            model_name='expiry',
            name='price',
            field=models.DecimalField(decimal_places=4, default=Decimal('0.0'), help_text='The price per share.', max_digits=16, verbose_name='Price'),
        ),
        migrations.AlterField(
            model_name='expiry',
            name='price_gross',
            field=models.DecimalField(decimal_places=4, default=Decimal('0.0'), help_text='The gross price per share.', max_digits=16, verbose_name='Gross Price'),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='expiry',
            name='shares',
            field=models.DecimalField(decimal_places=4, default=Decimal('0.0'), help_text='The number of shares that were traded.', max_digits=15, verbose_name='Shares'),
        ),
        migrations.AlterField(
            model_name='trade',
            name='price',
            field=models.DecimalField(decimal_places=4, default=Decimal('0.0'), help_text='The price per share.', max_digits=16, verbose_name='Price'),
        ),
        migrations.AlterField(
            model_name='trade',
            name='price_gross',
            field=models.DecimalField(decimal_places=4, default=Decimal('0.0'), help_text='The gross price per share.', max_digits=16, verbose_name='Gross Price'),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='trade',
            name='shares',
            field=models.DecimalField(decimal_places=4, default=Decimal('0.0'), help_text='The number of shares that were traded.', max_digits=15, verbose_name='Shares'),
        ),

        migrations.AlterField(
            model_name='transaction',
            name='total_value',
            field=models.DecimalField(decimal_places=4, default=Decimal('0.0'), max_digits=20, verbose_name='Total Value'),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='transaction',
            name='total_value_gross',
            field=models.DecimalField(decimal_places=4, default=Decimal('0.0'), max_digits=20, verbose_name='Total Value Gross'),
            preserve_default=False,
        ),
        migrations.RemoveField(
            model_name='transaction',
            name='total_value_fx_portfolio',
        ),
        migrations.RemoveField(
            model_name='transaction',
            name='total_value_gross_fx_portfolio',
        ),
        migrations.AddField(
            model_name='transaction',
            name='total_value_fx_portfolio',
            field=models.GeneratedField(db_persist=True, expression=django.db.models.expressions.CombinedExpression(
                models.F('currency_fx_rate'), '*', models.F('total_value')),
                                        output_field=models.DecimalField(decimal_places=4, max_digits=20)),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='transaction',
            name='total_value_gross_fx_portfolio',
            field=models.GeneratedField(db_persist=True, expression=django.db.models.expressions.CombinedExpression(models.F('currency_fx_rate'), '*', models.F('total_value_gross')), output_field=models.DecimalField(decimal_places=4, max_digits=20)),
            preserve_default=False,
        ),

    ]
