# Generated by Django 5.0.14 on 2025-07-17 14:53

import django.db.models.deletion
import django_fsm
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('currency', '0001_initial'),
        ('io', '0008_importsource_resource_kwargs'),
        ('wbfdm', '0031_exchange_apply_round_lot_size_and_more'),
        ('directory', '0013_alter_clientmanagerrelationship_options'),
        ('wbportfolio', '0081_alter_trade_drift_factor'),
    ]

    operations = [
        migrations.RenameModel(
            old_name='TradeProposal',
            new_name='OrderProposal',
        ),
        migrations.AlterField(
            model_name='orderproposal',
            name='creator',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT,
                                    related_name='order_proposals', to='directory.person', verbose_name='Owner'),
        ),
        migrations.AlterField(
            model_name='orderproposal',
            name='portfolio',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='order_proposals',
                                    to='wbportfolio.portfolio', verbose_name='Portfolio'),
        ),
        migrations.AlterField(
            model_name='orderproposal',
            name='rebalancing_model',
            field=models.ForeignKey(blank=True, help_text='Rebalancing Model that generates the target portfolio',
                                    null=True, on_delete=django.db.models.deletion.SET_NULL,
                                    related_name='order_proposals', to='wbportfolio.rebalancingmodel',
                                    verbose_name='Rebalancing Model'),
        ),
        migrations.AlterModelOptions(
            name='orderproposal',
            options={'verbose_name': 'Order Proposal', 'verbose_name_plural': 'Order Proposals'},
        ),
        migrations.RemoveConstraint(
            model_name='orderproposal',
            name='unique_trade_proposal',
        ),
        migrations.RemoveConstraint(
            model_name='trade',
            name='unique_manual_trade',
        ),
        migrations.RenameField(
            model_name='rebalancer',
            old_name='approve_trade_proposal_automatically',
            new_name='approve_order_proposal_automatically',
        ),
        migrations.RenameField(
            model_name='trade',
            old_name='trade_proposal',
            new_name='order_proposal',
        ),
        migrations.AlterField(
            model_name='portfolio',
            name='is_manageable',
            field=models.BooleanField(default=False,
                                      help_text='True if the portfolio can be manually modified (e.g. Order Proposal be submitted or total weight recomputed)'),
        ),
        migrations.AddConstraint(
            model_name='orderproposal',
            constraint=models.UniqueConstraint(fields=('portfolio', 'trade_date'), name='unique_order_proposal'),
        ),
        migrations.AddConstraint(
            model_name='trade',
            constraint=models.UniqueConstraint(condition=models.Q(('order_proposal__isnull', False)),
                                               fields=('portfolio', 'transaction_date', 'underlying_instrument'),
                                               name='unique_manual_trade'),
        ),
        migrations.AlterField(
            model_name='rebalancer',
            name='approve_order_proposal_automatically',
            field=models.BooleanField(default=False, verbose_name='Apply Order Proposal Automatically'),
        ),
        migrations.AlterField(
            model_name='trade',
            name='order_proposal',
            field=models.ForeignKey(blank=True, help_text='The Order Proposal this trade is coming from', null=True,
                                    on_delete=django.db.models.deletion.CASCADE, related_name='trades',
                                    to='wbportfolio.orderproposal'),
        ),
    ]
