# Generated by qodo Gen

import pytest

from lfx.schema.table import Column, FormatterType


class TestColumn:
    # Creating a Column instance without display_name sets it to the name
    def test_create_column_without_display_name(self):
        column = Column(name="test_column")
        assert column.display_name == "test_column"

    # Creating a Column instance with valid formatter values
    def test_create_column_with_valid_formatter(self):
        column = Column(display_name="Test Column", name="test_column", formatter="date")
        assert column.formatter == FormatterType.date

    # Formatter is set based on provided formatter value
    def test_formatter_set_based_on_value(self):
        column = Column(display_name="Test Column", name="test_column", formatter="int")
        assert column.formatter == FormatterType.number

    # Default values for sortable and filterable are set to True
    def test_default_sortable_filterable(self):
        column = Column(display_name="Test Column", name="test_column")
        assert column.sortable is True
        assert column.filterable is True

    # Ensure formatter field is correctly set when provided a FormatterType
    def test_formatter_explicitly_set_to_enum(self):
        column = Column(display_name="Date Column", name="date_column", formatter=FormatterType.date)
        assert column.formatter == FormatterType.date

    # Invalid formatter raises ValueError
    def test_invalid_formatter_raises_value_error(self):
        with pytest.raises(ValueError, match="'invalid' is not a valid FormatterType"):
            Column(display_name="Invalid Column", name="invalid_column", formatter="invalid")

    # Formatter is None when not provided
    def test_formatter_none_when_not_provided(self):
        column = Column(display_name="Test Column", name="test_column")
        assert column.formatter is None

    # Description and default can be set
    def test_description_and_default(self):
        column = Column(
            display_name="Test Column", name="test_column", description="A test column", default="default_value"
        )
        assert column.description == "A test column"
        assert column.default == "default_value"

    def test_create_with_type_instead_of_formatter(self):
        column = Column(display_name="Test Column", name="test_column", type="date")
        assert column.formatter == FormatterType.date
