"""
This type stub file was generated by pyright.
"""

from pydantic import AnyUrl
from functools import cached_property
from typing import Any, Literal
from datetime import datetime
from models.base import TaranisBaseModel
from models.types import (
    AttributeType,
    BOT_TYPES,
    COLLECTOR_TYPES,
    CONNECTOR_TYPES,
    ItemType,
    PRESENTER_TYPES,
    PUBLISHER_TYPES,
    TLPLevel,
    WORKER_CATEGORY,
    WORKER_TYPES,
)

class Job(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _pretty_name = ...
    id: str | None = ...
    name: str
    trigger: str | None = ...
    kwargs: str | None = ...
    next_run_time: str | None = ...

class TaskResult(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _pretty_name = ...
    id: str | None = ...
    result: Any | None = ...
    status: str | None = ...
    last_change: datetime | None = ...
    last_success: datetime | None = ...
    def __eq__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...

class Address(TaranisBaseModel):
    city: str = ...
    country: str = ...
    street: str = ...
    zip: str = ...

class Organization(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _search_fields = ...
    id: int | None = ...
    name: str = ...
    description: str | None = ...
    address: Address = ...

class Permission(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    id: str | None = ...
    name: str
    description: str = ...

class ACL(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _search_fields = ...
    _pretty_name = ...
    id: int | None = ...
    name: str = ...
    description: str | None = ...
    item_type: ItemType | None = ...
    item_id: str | None = ...
    roles: list[int] = ...
    read_only: bool = ...
    enabled: bool = ...

class ParameterValue(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    id: int | None = ...
    parameter: str = ...
    value: str | None = ...

class Worker(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _search_fields = ...
    _pretty_name = ...
    id: str | None = ...
    name: str
    description: str | None = ...
    type: WORKER_TYPES
    category: WORKER_CATEGORY
    parameters: dict[str, str] = ...

class Role(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _search_fields = ...
    _pretty_name = ...
    id: int | None = ...
    name: str = ...
    description: str | None = ...
    permissions: list[str] = ...
    tlp_level: TLPLevel | None = ...

class User(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _search_fields = ...
    id: int | None = ...
    name: str
    organization: dict | int
    permissions: list[str] | None = ...
    profile: dict | None = ...
    roles: list[int] | list[dict] = ...
    username: str = ...
    password: str | None = ...

class TaranisConfig(TaranisBaseModel):
    default_collector_proxy: AnyUrl | Literal[""] = ...
    default_collector_interval: str = ...
    default_tlp_level: TLPLevel = ...
    default_story_conflict_retention: str = ...
    default_news_item_conflict_retention: str = ...

class Settings(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _pretty_name = ...
    _cache_timeout = ...
    id: int = ...
    settings: TaranisConfig = ...

class WordListEntry(TaranisBaseModel):
    value: str
    category: str | None = ...
    description: str | None = ...

class WordList(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _pretty_name = ...
    _search_fields = ...
    id: int | None = ...
    name: str
    description: str | None = ...
    usage: list[str] = ...
    link: str = ...
    entries: list[WordListEntry] | None = ...

class OSINTSource(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _pretty_name = ...
    id: str | None = ...
    name: str
    description: str = ...
    type: COLLECTOR_TYPES | None = ...
    parameters: dict[str, str] | None = ...
    icon: str | None = ...
    enabled: bool | None = ...
    status: TaskResult | None = ...
    @cached_property
    def search_field(self) -> str: ...

class OSINTSourceGroup(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _pretty_name = ...
    _search_fields = ...
    id: str | None = ...
    name: str
    description: str = ...
    default: bool = ...
    osint_sources: list[str] = ...
    word_lists: list[int] = ...

class ProductParameterValue(TaranisBaseModel):
    TEMPLATE_PATH: str | None = ...

class ProductType(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _pretty_name = ...
    _search_fields = ...
    id: int | None = ...
    title: str
    description: str = ...
    type: PRESENTER_TYPES
    parameters: ProductParameterValue = ...
    report_types: list[int] = ...
    status: TaskResult | None = ...

class PublisherPreset(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _pretty_name = ...
    _search_fields = ...
    id: str | None = ...
    name: str
    type: PUBLISHER_TYPES
    description: str | None = ...
    parameters: dict[str, str] | None = ...
    status: TaskResult | None = ...

class ReportItemAttribute(TaranisBaseModel):
    id: int | None = ...
    attribute: dict[str, str] | None = ...
    attribute_id: int | None = ...
    attribute_group_id: int | None = ...
    title: str | None = ...
    description: str | None = ...
    index: int | None = ...
    required: bool | None = ...
    type: str | None = ...

class ReportItemAttributeGroup(TaranisBaseModel):
    id: int | None = ...
    title: str | None = ...
    description: str | None = ...
    index: int | None = ...
    attribute_group_items: list[ReportItemAttribute] = ...

class ReportItemType(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _pretty_name = ...
    _search_fields = ...
    id: int | None = ...
    title: str
    description: str = ...
    attribute_groups: list[ReportItemAttributeGroup] | None = ...

class Template(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _pretty_name = ...
    id: str
    content: str | None = ...
    validation_status: dict | None = ...

class AttributeEnum(TaranisBaseModel):
    id: int | None = ...
    index: int | None = ...
    value: str | None = ...
    description: str | None = ...
    imported: bool | None = ...
    attribute_id: int | None = ...

class Attribute(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _pretty_name = ...
    _search_fields = ...
    id: int | None = ...
    name: str
    description: str = ...
    type: AttributeType
    default_value: str = ...
    attribute_enums: list[AttributeEnum] = ...

class Bot(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _pretty_name = ...
    _search_fields = ...
    id: str | None = ...
    name: str
    description: str = ...
    type: BOT_TYPES
    index: int | None = ...
    parameters: dict[str, str] | None = ...
    status: TaskResult | None = ...

class Connector(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _pretty_name = ...
    _search_fields = ...
    id: str | None = ...
    name: str
    description: str = ...
    type: CONNECTOR_TYPES | None = ...
    index: int | None = ...
    parameters: dict[str, str] | None = ...
    icon: str | None = ...
    status: TaskResult | None = ...

class WorkerParameterValue(TaranisBaseModel):
    name: str
    label: str | None = ...
    parent: Literal["parameters"] = ...
    type: str | None = ...
    rules: list[str] = ...

class WorkerParameter(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _pretty_name = ...
    id: str
    parameters: list[WorkerParameterValue]
