"""
This type stub file was generated by pyright.
"""

from datetime import datetime
from pydantic import field_validator
from typing import Literal
from functools import cached_property
from models.base import TaranisBaseModel

class NewsItem(TaranisBaseModel):
    _core_endpoint = ...
    osint_source_id: str
    hash: str | None = ...
    title: str | None = ...
    author: str | None = ...
    review: str | None = ...
    content: str | None = ...
    web_url: str | None = ...
    source: str | None = ...
    published: datetime | None = ...
    collected: datetime | None = ...
    attributes: list[str | dict] | None = ...
    language: str | None = ...
    @field_validator("language", mode="before")
    def normalize_language_code(cls, v):  # -> str | None:
        ...

class StoryTag(TaranisBaseModel):
    name: str
    size: int
    type: str | None = ...

class Story(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _pretty_name = ...
    _cache_timeout = ...
    id: str | None = ...
    title: str | None = ...
    description: str | None = ...
    created: datetime | None = ...
    updated: datetime | None = ...
    last_change: str | None = ...
    news_items: list[NewsItem] | None = ...
    links: list[str] | None = ...
    important: bool | None = ...
    read: bool | None = ...
    likes: int | None = ...
    dislikes: int | None = ...
    user_vote: Literal["like", "dislike", "", None] = ...
    summary: str | None = ...
    relevance: int | None = ...
    comments: str | None = ...
    in_reports_count: int | None = ...
    tags: list[dict] | None = ...
    attributes: list[dict] | None = ...
    @cached_property
    def search_field(self) -> str: ...

class AssessSource(TaranisBaseModel):
    id: str | None = ...
    icon: str | None = ...
    name: str
    type: str | None = ...

class FilterLists(TaranisBaseModel):
    _core_endpoint = ...
    _model_name = ...
    _pretty_name = ...
    tags: list[str] = ...
    sources: list[AssessSource] = ...
    groups: list[dict] = ...

class StoryUpdatePayload(TaranisBaseModel):
    vote: Literal["like", "dislike", ""] | None = ...
    important: bool | None = ...
    read: bool | None = ...
    title: str | None = ...
    description: str | None = ...
    comments: str | None = ...
    summary: str | None = ...
    tags: list[dict] | None = ...
    attributes: list[dict] | None = ...

class BulkAction(TaranisBaseModel):
    story_ids: list[str] = ...
    payload: StoryUpdatePayload | None = ...
