# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetEventOrchestrationIntegrationResult',
    'AwaitableGetEventOrchestrationIntegrationResult',
    'get_event_orchestration_integration',
    'get_event_orchestration_integration_output',
]

@pulumi.output_type
class GetEventOrchestrationIntegrationResult:
    """
    A collection of values returned by getEventOrchestrationIntegration.
    """
    def __init__(__self__, event_orchestration=None, id=None, label=None, parameters=None):
        if event_orchestration and not isinstance(event_orchestration, str):
            raise TypeError("Expected argument 'event_orchestration' to be a str")
        pulumi.set(__self__, "event_orchestration", event_orchestration)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if parameters and not isinstance(parameters, list):
            raise TypeError("Expected argument 'parameters' to be a list")
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="eventOrchestration")
    def event_orchestration(self) -> str:
        return pulumi.get(self, "event_orchestration")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GetEventOrchestrationIntegrationParameterResult']:
        return pulumi.get(self, "parameters")


class AwaitableGetEventOrchestrationIntegrationResult(GetEventOrchestrationIntegrationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEventOrchestrationIntegrationResult(
            event_orchestration=self.event_orchestration,
            id=self.id,
            label=self.label,
            parameters=self.parameters)


def get_event_orchestration_integration(event_orchestration: Optional[str] = None,
                                        id: Optional[str] = None,
                                        label: Optional[str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEventOrchestrationIntegrationResult:
    """
    Use this data source to get information about a specific [Integration](https://developer.pagerduty.com/api-reference/1c6607db389a8-get-an-integration-for-an-event-orchestration) for an Event Orchestration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_pagerduty as pagerduty

    event_orchestration = pagerduty.EventOrchestration("event_orchestration", name="Test Event Orchestration")
    integration = pagerduty.get_event_orchestration_integration_output(event_orchestration=event_orchestration.id,
        label="Test Event Orchestration Default Integration")
    ```


    :param str event_orchestration: ID of the Event Orchestration to which this Integration belongs.
    :param str id: ID of the Integration associated with the Event Orchestration. Specify either `id` or `label`. If both are specified `id` takes precedence.
    :param str label: Name/description of the Integration associated with the Event Orchestration. Specify either `id` or `label`. If both are specified `id` takes precedence. The value of `label` is not unique. Potentially there might be multiple Integrations with the same `label` value associated with the Event Orchestration and retrieving data by `label` attribute will result in an error during the planning step.
    """
    __args__ = dict()
    __args__['eventOrchestration'] = event_orchestration
    __args__['id'] = id
    __args__['label'] = label
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('pagerduty:index/getEventOrchestrationIntegration:getEventOrchestrationIntegration', __args__, opts=opts, typ=GetEventOrchestrationIntegrationResult).value

    return AwaitableGetEventOrchestrationIntegrationResult(
        event_orchestration=pulumi.get(__ret__, 'event_orchestration'),
        id=pulumi.get(__ret__, 'id'),
        label=pulumi.get(__ret__, 'label'),
        parameters=pulumi.get(__ret__, 'parameters'))
def get_event_orchestration_integration_output(event_orchestration: Optional[pulumi.Input[str]] = None,
                                               id: Optional[pulumi.Input[Optional[str]]] = None,
                                               label: Optional[pulumi.Input[Optional[str]]] = None,
                                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEventOrchestrationIntegrationResult]:
    """
    Use this data source to get information about a specific [Integration](https://developer.pagerduty.com/api-reference/1c6607db389a8-get-an-integration-for-an-event-orchestration) for an Event Orchestration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_pagerduty as pagerduty

    event_orchestration = pagerduty.EventOrchestration("event_orchestration", name="Test Event Orchestration")
    integration = pagerduty.get_event_orchestration_integration_output(event_orchestration=event_orchestration.id,
        label="Test Event Orchestration Default Integration")
    ```


    :param str event_orchestration: ID of the Event Orchestration to which this Integration belongs.
    :param str id: ID of the Integration associated with the Event Orchestration. Specify either `id` or `label`. If both are specified `id` takes precedence.
    :param str label: Name/description of the Integration associated with the Event Orchestration. Specify either `id` or `label`. If both are specified `id` takes precedence. The value of `label` is not unique. Potentially there might be multiple Integrations with the same `label` value associated with the Event Orchestration and retrieving data by `label` attribute will result in an error during the planning step.
    """
    __args__ = dict()
    __args__['eventOrchestration'] = event_orchestration
    __args__['id'] = id
    __args__['label'] = label
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('pagerduty:index/getEventOrchestrationIntegration:getEventOrchestrationIntegration', __args__, opts=opts, typ=GetEventOrchestrationIntegrationResult)
    return __ret__.apply(lambda __response__: GetEventOrchestrationIntegrationResult(
        event_orchestration=pulumi.get(__response__, 'event_orchestration'),
        id=pulumi.get(__response__, 'id'),
        label=pulumi.get(__response__, 'label'),
        parameters=pulumi.get(__response__, 'parameters')))
