# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetStandardsResourceScoresResult',
    'AwaitableGetStandardsResourceScoresResult',
    'get_standards_resource_scores',
    'get_standards_resource_scores_output',
]

@pulumi.output_type
class GetStandardsResourceScoresResult:
    """
    A collection of values returned by getStandardsResourceScores.
    """
    def __init__(__self__, id=None, resource_type=None, score=None, standards=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if score and not isinstance(score, dict):
            raise TypeError("Expected argument 'score' to be a dict")
        pulumi.set(__self__, "score", score)
        if standards and not isinstance(standards, list):
            raise TypeError("Expected argument 'standards' to be a list")
        pulumi.set(__self__, "standards", standards)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A unique identifier for the standard.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Specifies the type of resource to which the standard applies.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def score(self) -> 'outputs.GetStandardsResourceScoresScoreResult':
        """
        Summary of the scores for standards associated with this resource.
        """
        return pulumi.get(self, "score")

    @property
    @pulumi.getter
    def standards(self) -> Sequence['outputs.GetStandardsResourceScoresStandardResult']:
        """
        The list of standards evaluated against.
        """
        return pulumi.get(self, "standards")


class AwaitableGetStandardsResourceScoresResult(GetStandardsResourceScoresResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStandardsResourceScoresResult(
            id=self.id,
            resource_type=self.resource_type,
            score=self.score,
            standards=self.standards)


def get_standards_resource_scores(id: Optional[str] = None,
                                  resource_type: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStandardsResourceScoresResult:
    """
    Use this data source to get information about the [scores for the standards of a
    resource][1].

    ## Example Usage

    ```python
    import pulumi
    import pulumi_pagerduty as pagerduty

    example = pagerduty.get_service(name="My Service")
    scores = pagerduty.get_standards_resource_scores(resource_type="technical_services",
        id=example.id)
    ```


    :param str id: Identifier of said resource.
    :param str resource_type: Type of the object the standards are associated to. Allowed values are `technical_services`.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['resourceType'] = resource_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('pagerduty:index/getStandardsResourceScores:getStandardsResourceScores', __args__, opts=opts, typ=GetStandardsResourceScoresResult).value

    return AwaitableGetStandardsResourceScoresResult(
        id=pulumi.get(__ret__, 'id'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        score=pulumi.get(__ret__, 'score'),
        standards=pulumi.get(__ret__, 'standards'))
def get_standards_resource_scores_output(id: Optional[pulumi.Input[str]] = None,
                                         resource_type: Optional[pulumi.Input[str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStandardsResourceScoresResult]:
    """
    Use this data source to get information about the [scores for the standards of a
    resource][1].

    ## Example Usage

    ```python
    import pulumi
    import pulumi_pagerduty as pagerduty

    example = pagerduty.get_service(name="My Service")
    scores = pagerduty.get_standards_resource_scores(resource_type="technical_services",
        id=example.id)
    ```


    :param str id: Identifier of said resource.
    :param str resource_type: Type of the object the standards are associated to. Allowed values are `technical_services`.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['resourceType'] = resource_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('pagerduty:index/getStandardsResourceScores:getStandardsResourceScores', __args__, opts=opts, typ=GetStandardsResourceScoresResult)
    return __ret__.apply(lambda __response__: GetStandardsResourceScoresResult(
        id=pulumi.get(__response__, 'id'),
        resource_type=pulumi.get(__response__, 'resource_type'),
        score=pulumi.get(__response__, 'score'),
        standards=pulumi.get(__response__, 'standards')))
