# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetTeamsResult',
    'AwaitableGetTeamsResult',
    'get_teams',
    'get_teams_output',
]

@pulumi.output_type
class GetTeamsResult:
    """
    A collection of values returned by getTeams.
    """
    def __init__(__self__, id=None, query=None, teams=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if query and not isinstance(query, str):
            raise TypeError("Expected argument 'query' to be a str")
        pulumi.set(__self__, "query", query)
        if teams and not isinstance(teams, list):
            raise TypeError("Expected argument 'teams' to be a list")
        pulumi.set(__self__, "teams", teams)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def query(self) -> Optional[str]:
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def teams(self) -> Sequence['outputs.GetTeamsTeamResult']:
        """
        The teams found.
        """
        return pulumi.get(self, "teams")


class AwaitableGetTeamsResult(GetTeamsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTeamsResult(
            id=self.id,
            query=self.query,
            teams=self.teams)


def get_teams(query: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTeamsResult:
    """
    Use this data source to [list teams](https://developer.pagerduty.com/api-reference/0138639504311-list-teams) in your PagerDuty account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_pagerduty as pagerduty

    all_teams = pagerduty.get_teams()
    # Fetch only teams whose name matches "devops"
    devops = pagerduty.get_teams(query="devops")
    ```


    :param str query: Filters the result, showing only the records whose name matches the query.
    """
    __args__ = dict()
    __args__['query'] = query
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('pagerduty:index/getTeams:getTeams', __args__, opts=opts, typ=GetTeamsResult).value

    return AwaitableGetTeamsResult(
        id=pulumi.get(__ret__, 'id'),
        query=pulumi.get(__ret__, 'query'),
        teams=pulumi.get(__ret__, 'teams'))
def get_teams_output(query: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTeamsResult]:
    """
    Use this data source to [list teams](https://developer.pagerduty.com/api-reference/0138639504311-list-teams) in your PagerDuty account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_pagerduty as pagerduty

    all_teams = pagerduty.get_teams()
    # Fetch only teams whose name matches "devops"
    devops = pagerduty.get_teams(query="devops")
    ```


    :param str query: Filters the result, showing only the records whose name matches the query.
    """
    __args__ = dict()
    __args__['query'] = query
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('pagerduty:index/getTeams:getTeams', __args__, opts=opts, typ=GetTeamsResult)
    return __ret__.apply(lambda __response__: GetTeamsResult(
        id=pulumi.get(__response__, 'id'),
        query=pulumi.get(__response__, 'query'),
        teams=pulumi.get(__response__, 'teams')))
