# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['IncidentCustomFieldArgs', 'IncidentCustomField']

@pulumi.input_type
class IncidentCustomFieldArgs:
    def __init__(__self__, *,
                 data_type: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 field_type: pulumi.Input[str],
                 default_value: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a IncidentCustomField resource.
        :param pulumi.Input[str] data_type: The data type of the field. Must be one of `string`, `integer`, `float`, `boolean`, `datetime`, or `url`.
        :param pulumi.Input[str] display_name: The display name of the field.
        :param pulumi.Input[str] field_type: The field type of the field. Must be one of `single_value`, `single_value_fixed`, `multi_value`, or `multi_value_fixed`.
        :param pulumi.Input[str] default_value: The default value to set when new incidents are created. Always specified as a string.
        :param pulumi.Input[str] description: The description of the field.
        :param pulumi.Input[str] name: The name of the field.
        """
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "field_type", field_type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> pulumi.Input[str]:
        """
        The data type of the field. Must be one of `string`, `integer`, `float`, `boolean`, `datetime`, or `url`.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The display name of the field.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="fieldType")
    def field_type(self) -> pulumi.Input[str]:
        """
        The field type of the field. Must be one of `single_value`, `single_value_fixed`, `multi_value`, or `multi_value_fixed`.
        """
        return pulumi.get(self, "field_type")

    @field_type.setter
    def field_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "field_type", value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[str]]:
        """
        The default value to set when new incidents are created. Always specified as a string.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the field.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the field.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _IncidentCustomFieldState:
    def __init__(__self__, *,
                 data_type: Optional[pulumi.Input[str]] = None,
                 default_value: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 field_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering IncidentCustomField resources.
        :param pulumi.Input[str] data_type: The data type of the field. Must be one of `string`, `integer`, `float`, `boolean`, `datetime`, or `url`.
        :param pulumi.Input[str] default_value: The default value to set when new incidents are created. Always specified as a string.
        :param pulumi.Input[str] description: The description of the field.
        :param pulumi.Input[str] display_name: The display name of the field.
        :param pulumi.Input[str] field_type: The field type of the field. Must be one of `single_value`, `single_value_fixed`, `multi_value`, or `multi_value_fixed`.
        :param pulumi.Input[str] name: The name of the field.
        """
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if field_type is not None:
            pulumi.set(__self__, "field_type", field_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[str]]:
        """
        The data type of the field. Must be one of `string`, `integer`, `float`, `boolean`, `datetime`, or `url`.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[str]]:
        """
        The default value to set when new incidents are created. Always specified as a string.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the field.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the field.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="fieldType")
    def field_type(self) -> Optional[pulumi.Input[str]]:
        """
        The field type of the field. Must be one of `single_value`, `single_value_fixed`, `multi_value`, or `multi_value_fixed`.
        """
        return pulumi.get(self, "field_type")

    @field_type.setter
    def field_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the field.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


class IncidentCustomField(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_type: Optional[pulumi.Input[str]] = None,
                 default_value: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 field_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        An [Incident Custom Field](https://support.pagerduty.com/docs/custom-fields-on-incidents) defines a field which can be set on incidents in the target account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        cs_impact = pagerduty.IncidentCustomField("cs_impact",
            name="impact",
            display_name="Customer Impact",
            data_type="string",
            field_type="single_value")
        sre_environment = pagerduty.IncidentCustomField("sre_environment",
            name="environment",
            display_name="Environment",
            data_type="string",
            field_type="single_value_fixed")
        false_alarm = pagerduty.IncidentCustomField("false_alarm",
            name="false_alarm",
            display_name="False Alarm",
            data_type="boolean",
            field_type="single_value",
            default_value="false")
        ```

        ## Import

        Fields can be imported using the `id`, e.g.

        ```sh
        $ pulumi import pagerduty:index/incidentCustomField:IncidentCustomField sre_environment PLBP09X
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] data_type: The data type of the field. Must be one of `string`, `integer`, `float`, `boolean`, `datetime`, or `url`.
        :param pulumi.Input[str] default_value: The default value to set when new incidents are created. Always specified as a string.
        :param pulumi.Input[str] description: The description of the field.
        :param pulumi.Input[str] display_name: The display name of the field.
        :param pulumi.Input[str] field_type: The field type of the field. Must be one of `single_value`, `single_value_fixed`, `multi_value`, or `multi_value_fixed`.
        :param pulumi.Input[str] name: The name of the field.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IncidentCustomFieldArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An [Incident Custom Field](https://support.pagerduty.com/docs/custom-fields-on-incidents) defines a field which can be set on incidents in the target account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        cs_impact = pagerduty.IncidentCustomField("cs_impact",
            name="impact",
            display_name="Customer Impact",
            data_type="string",
            field_type="single_value")
        sre_environment = pagerduty.IncidentCustomField("sre_environment",
            name="environment",
            display_name="Environment",
            data_type="string",
            field_type="single_value_fixed")
        false_alarm = pagerduty.IncidentCustomField("false_alarm",
            name="false_alarm",
            display_name="False Alarm",
            data_type="boolean",
            field_type="single_value",
            default_value="false")
        ```

        ## Import

        Fields can be imported using the `id`, e.g.

        ```sh
        $ pulumi import pagerduty:index/incidentCustomField:IncidentCustomField sre_environment PLBP09X
        ```

        :param str resource_name: The name of the resource.
        :param IncidentCustomFieldArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IncidentCustomFieldArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_type: Optional[pulumi.Input[str]] = None,
                 default_value: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 field_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IncidentCustomFieldArgs.__new__(IncidentCustomFieldArgs)

            if data_type is None and not opts.urn:
                raise TypeError("Missing required property 'data_type'")
            __props__.__dict__["data_type"] = data_type
            __props__.__dict__["default_value"] = default_value
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if field_type is None and not opts.urn:
                raise TypeError("Missing required property 'field_type'")
            __props__.__dict__["field_type"] = field_type
            __props__.__dict__["name"] = name
        super(IncidentCustomField, __self__).__init__(
            'pagerduty:index/incidentCustomField:IncidentCustomField',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_type: Optional[pulumi.Input[str]] = None,
            default_value: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            field_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None) -> 'IncidentCustomField':
        """
        Get an existing IncidentCustomField resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] data_type: The data type of the field. Must be one of `string`, `integer`, `float`, `boolean`, `datetime`, or `url`.
        :param pulumi.Input[str] default_value: The default value to set when new incidents are created. Always specified as a string.
        :param pulumi.Input[str] description: The description of the field.
        :param pulumi.Input[str] display_name: The display name of the field.
        :param pulumi.Input[str] field_type: The field type of the field. Must be one of `single_value`, `single_value_fixed`, `multi_value`, or `multi_value_fixed`.
        :param pulumi.Input[str] name: The name of the field.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IncidentCustomFieldState.__new__(_IncidentCustomFieldState)

        __props__.__dict__["data_type"] = data_type
        __props__.__dict__["default_value"] = default_value
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["field_type"] = field_type
        __props__.__dict__["name"] = name
        return IncidentCustomField(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> pulumi.Output[str]:
        """
        The data type of the field. Must be one of `string`, `integer`, `float`, `boolean`, `datetime`, or `url`.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> pulumi.Output[Optional[str]]:
        """
        The default value to set when new incidents are created. Always specified as a string.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the field.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The display name of the field.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fieldType")
    def field_type(self) -> pulumi.Output[str]:
        """
        The field type of the field. Must be one of `single_value`, `single_value_fixed`, `multi_value`, or `multi_value_fixed`.
        """
        return pulumi.get(self, "field_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the field.
        """
        return pulumi.get(self, "name")

