# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['IncidentTypeArgs', 'IncidentType']

@pulumi.input_type
class IncidentTypeArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 parent_type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a IncidentType resource.
        :param pulumi.Input[str] display_name: The display name of the Incident Type. Usage of the prefixes PD, PagerDuty, or the suffixes Default, or (Default) is prohibited.
        :param pulumi.Input[str] parent_type: The parent type of the Incident Type. Either name or id of the parent type can be used.
        :param pulumi.Input[str] description: A succinct description of the Incident Type.
        :param pulumi.Input[bool] enabled: State of this Incident Type object. Defaults to true if not provided.
        :param pulumi.Input[str] name: The name of the Incident Type. Usage of the suffix `_default` is prohibited. This cannot be changed once the incident type has been created.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "parent_type", parent_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The display name of the Incident Type. Usage of the prefixes PD, PagerDuty, or the suffixes Default, or (Default) is prohibited.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> pulumi.Input[str]:
        """
        The parent type of the Incident Type. Either name or id of the parent type can be used.
        """
        return pulumi.get(self, "parent_type")

    @parent_type.setter
    def parent_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "parent_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A succinct description of the Incident Type.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        State of this Incident Type object. Defaults to true if not provided.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Incident Type. Usage of the suffix `_default` is prohibited. This cannot be changed once the incident type has been created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _IncidentTypeState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_type: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering IncidentType resources.
        :param pulumi.Input[str] description: A succinct description of the Incident Type.
        :param pulumi.Input[str] display_name: The display name of the Incident Type. Usage of the prefixes PD, PagerDuty, or the suffixes Default, or (Default) is prohibited.
        :param pulumi.Input[bool] enabled: State of this Incident Type object. Defaults to true if not provided.
        :param pulumi.Input[str] name: The name of the Incident Type. Usage of the suffix `_default` is prohibited. This cannot be changed once the incident type has been created.
        :param pulumi.Input[str] parent_type: The parent type of the Incident Type. Either name or id of the parent type can be used.
        :param pulumi.Input[str] type: A string that determines the schema of the object.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_type is not None:
            pulumi.set(__self__, "parent_type", parent_type)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A succinct description of the Incident Type.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the Incident Type. Usage of the prefixes PD, PagerDuty, or the suffixes Default, or (Default) is prohibited.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        State of this Incident Type object. Defaults to true if not provided.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Incident Type. Usage of the suffix `_default` is prohibited. This cannot be changed once the incident type has been created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> Optional[pulumi.Input[str]]:
        """
        The parent type of the Incident Type. Either name or id of the parent type can be used.
        """
        return pulumi.get(self, "parent_type")

    @parent_type.setter
    def parent_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_type", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        A string that determines the schema of the object.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class IncidentType(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        base = pagerduty.get_incident_type(display_name="Base Incident")
        example = pagerduty.IncidentType("example",
            name="backoffice",
            display_name="Backoffice Incident",
            parent_type=base.id,
            description="Internal incidents not facing customer")
        ```

        ## Import

        Services can be imported using the `id`, e.g.

        ```sh
        $ pulumi import pagerduty:index/incidentType:IncidentType main P12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A succinct description of the Incident Type.
        :param pulumi.Input[str] display_name: The display name of the Incident Type. Usage of the prefixes PD, PagerDuty, or the suffixes Default, or (Default) is prohibited.
        :param pulumi.Input[bool] enabled: State of this Incident Type object. Defaults to true if not provided.
        :param pulumi.Input[str] name: The name of the Incident Type. Usage of the suffix `_default` is prohibited. This cannot be changed once the incident type has been created.
        :param pulumi.Input[str] parent_type: The parent type of the Incident Type. Either name or id of the parent type can be used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IncidentTypeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        base = pagerduty.get_incident_type(display_name="Base Incident")
        example = pagerduty.IncidentType("example",
            name="backoffice",
            display_name="Backoffice Incident",
            parent_type=base.id,
            description="Internal incidents not facing customer")
        ```

        ## Import

        Services can be imported using the `id`, e.g.

        ```sh
        $ pulumi import pagerduty:index/incidentType:IncidentType main P12345
        ```

        :param str resource_name: The name of the resource.
        :param IncidentTypeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IncidentTypeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IncidentTypeArgs.__new__(IncidentTypeArgs)

            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["name"] = name
            if parent_type is None and not opts.urn:
                raise TypeError("Missing required property 'parent_type'")
            __props__.__dict__["parent_type"] = parent_type
            __props__.__dict__["type"] = None
        super(IncidentType, __self__).__init__(
            'pagerduty:index/incidentType:IncidentType',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parent_type: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'IncidentType':
        """
        Get an existing IncidentType resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A succinct description of the Incident Type.
        :param pulumi.Input[str] display_name: The display name of the Incident Type. Usage of the prefixes PD, PagerDuty, or the suffixes Default, or (Default) is prohibited.
        :param pulumi.Input[bool] enabled: State of this Incident Type object. Defaults to true if not provided.
        :param pulumi.Input[str] name: The name of the Incident Type. Usage of the suffix `_default` is prohibited. This cannot be changed once the incident type has been created.
        :param pulumi.Input[str] parent_type: The parent type of the Incident Type. Either name or id of the parent type can be used.
        :param pulumi.Input[str] type: A string that determines the schema of the object.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IncidentTypeState.__new__(_IncidentTypeState)

        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_type"] = parent_type
        __props__.__dict__["type"] = type
        return IncidentType(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A succinct description of the Incident Type.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The display name of the Incident Type. Usage of the prefixes PD, PagerDuty, or the suffixes Default, or (Default) is prohibited.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        State of this Incident Type object. Defaults to true if not provided.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Incident Type. Usage of the suffix `_default` is prohibited. This cannot be changed once the incident type has been created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> pulumi.Output[str]:
        """
        The parent type of the Incident Type. Either name or id of the parent type can be used.
        """
        return pulumi.get(self, "parent_type")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        A string that determines the schema of the object.
        """
        return pulumi.get(self, "type")

