"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
require("@aws-cdk/assert/jest");
const cf = require("@aws-cdk/aws-cloudfront");
const origins = require("@aws-cdk/aws-cloudfront-origins");
const cdk = require("@aws-cdk/core");
const extensions = require("../extensions");
test('minimal usage', () => {
    // GIVEN
    const app = new cdk.App();
    const stack = new cdk.Stack(app, 'demo-stack');
    // WHEN
    // create the cloudfront distribution with extension(s)
    const ext = new extensions.AccessOriginByGeolocation(stack, 'AccessOriginByGeolocation', {
        countryTable: {
            US: 'mock-api.com',
            CN: 'mock-api.com.cn',
        },
    });
    const policy = new cf.OriginRequestPolicy(stack, 'OrigReqPolicy', {
        headerBehavior: cf.OriginRequestHeaderBehavior.allowList('cloudfront-viewer-country'),
    });
    // create the cloudfront distribution with extension(s)
    const dist = new cf.Distribution(stack, 'dist', {
        defaultBehavior: {
            origin: new origins.HttpOrigin('aws.amazon.com'),
            edgeLambdas: [ext],
            originRequestPolicy: {
                originRequestPolicyId: policy.originRequestPolicyId,
            },
        },
    });
    new cdk.CfnOutput(stack, 'distributionDomainName', {
        value: dist.distributionDomainName,
    });
    // THEN
    expect(assert_1.SynthUtils.synthesize(stack).template).toMatchSnapshot();
    expect(stack).toHaveResourceLike('AWS::CloudFront::Distribution', {
        DistributionConfig: {
            DefaultCacheBehavior: {
                LambdaFunctionAssociations: [
                    {
                        EventType: 'origin-request',
                        IncludeBody: false,
                        LambdaFunctionARN: {
                            Ref: 'AccessOriginByGeolocationFuncCurrentVersion7A439649fbcf2af2133e08383d90b15f8124ab6b',
                        },
                    },
                ],
                ViewerProtocolPolicy: 'allow-all',
            },
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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