"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
require("@aws-cdk/assert/jest");
const cf = require("@aws-cdk/aws-cloudfront");
const origins = require("@aws-cdk/aws-cloudfront-origins");
const cdk = require("@aws-cdk/core");
const extensions = require("../extensions");
test('minimal usage', () => {
    // GIVEN
    const app = new cdk.App();
    const stack = new cdk.Stack(app, 'demo-stack');
    // WHEN
    // create the cloudfront distribution with extension(s)
    const ext = new extensions.RedirectByGeolocation(stack, 'RedirectByGeolocation', {
        countryTable: {
            US: 'mock-api.com',
            CN: 'mock-api.com.cn',
        },
    });
    const policy = new cf.OriginRequestPolicy(stack, 'OrigReqPolicy', {
        headerBehavior: cf.OriginRequestHeaderBehavior.allowList('cloudfront-viewer-country'),
    });
    // create the cloudfront distribution with extension(s)
    const dist = new cf.Distribution(stack, 'dist', {
        defaultBehavior: {
            origin: new origins.HttpOrigin('aws.amazon.com'),
            edgeLambdas: [ext],
            originRequestPolicy: {
                originRequestPolicyId: policy.originRequestPolicyId,
            },
        },
    });
    new cdk.CfnOutput(stack, 'distributionDomainName', {
        value: dist.distributionDomainName,
    });
    // THEN
    expect(assert_1.SynthUtils.synthesize(stack).template).toMatchSnapshot();
    expect(stack).toHaveResourceLike('AWS::CloudFront::Distribution', {
        DistributionConfig: {
            DefaultCacheBehavior: {
                LambdaFunctionAssociations: [
                    {
                        EventType: 'origin-request',
                        LambdaFunctionARN: {
                            Ref: 'RedirectByGeolocationFuncCurrentVersion56E461BDe2155fac6b3da1cf83a734ead5cc3a8c',
                        },
                    },
                ],
                ViewerProtocolPolicy: 'allow-all',
            },
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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