"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalDataIngestion = exports.OAuth2AuthorizationCodeGrant = exports.SimpleLambdaEdge = exports.RedirectByGeolocation = exports.AccessOriginByGeolocation = exports.CustomErrorPage = exports.DefaultDirIndex = exports.ConvertQueryString = exports.NormalizeQueryString = exports.MultipleOriginIpRetry = exports.SecurtyHeaders = exports.AntiHotlinking = exports.HTTP302FromOrigin = exports.ModifyResponseHeader = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cf = require("@aws-cdk/aws-cloudfront");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const aws_lambda_nodejs_1 = require("@aws-cdk/aws-lambda-nodejs");
const cdk = require("@aws-cdk/core");
const _1 = require("./");
const custom_1 = require("./custom");
/**
 * The directory for all extensions lambda assets
 */
const EXTENSION_ASSETS_PATH = path.join(__dirname, '../lambda-assets/extensions');
;
/**
 * The modify response header extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/modify-response-header
 * @stability stable
 */
class ModifyResponseHeader extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/modify-response-header',
            semanticVersion: '1.0.0',
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.ModifyResponseHeaderFunctionARN').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
    }
}
exports.ModifyResponseHeader = ModifyResponseHeader;
_a = JSII_RTTI_SYMBOL_1;
ModifyResponseHeader[_a] = { fqn: "cdk-cloudfront-plus.ModifyResponseHeader", version: "0.3.25" };
// export class HTTP302FromOrigin extends ServerlessApp implements IExtensions {
//   readonly functionArn: string;
//   readonly functionVersion: lambda.Version;
//   readonly eventType: cf.LambdaEdgeEventType;
//   readonly lambdaFunction: lambda.Version;
//   constructor(scope: cdk.Construct, id: string) {
//     super(scope, id, {
//       applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/http302-from-origin',
//       semanticVersion: '1.0.2',
//     });
//     const stack = cdk.Stack.of(scope);
//     this.functionArn = this.resource.getAtt('Outputs.Http302Function').toString();
//     this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
//     this.lambdaFunction = this.functionVersion;
//     this.eventType = cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
//   }
// };
/**
 * The HTTP[302] from origin extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/http302-from-origin
 * @stability stable
 */
class HTTP302FromOrigin extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'HTTP302FromOriginFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-http302-from-origin/index.ts`,
            runtime: lambda.Runtime.NODEJS_14_X,
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_RESPONSE,
            solutionId: 'SO8103',
            templateDescription: 'Cloudfront extension with AWS CDK - HTTP 302 from Origin',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.HTTP302FromOrigin = HTTP302FromOrigin;
_b = JSII_RTTI_SYMBOL_1;
HTTP302FromOrigin[_b] = { fqn: "cdk-cloudfront-plus.HTTP302FromOrigin", version: "0.3.25" };
;
/**
 * The Anti-Hotlinking extension.
 *
 * @see https://console.aws.amazon.com/lambda/home#/create/app?applicationId=arn:aws:serverlessrepo:us-east-1:418289889111:applications/anti-hotlinking
 * @stability stable
 */
class AntiHotlinking extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/anti-hotlinking',
            semanticVersion: '1.2.5',
            parameters: {
                RefererList: props.referer.join(','),
            },
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.AntiHotlinking').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.VIEWER_REQUEST;
    }
}
exports.AntiHotlinking = AntiHotlinking;
_c = JSII_RTTI_SYMBOL_1;
AntiHotlinking[_c] = { fqn: "cdk-cloudfront-plus.AntiHotlinking", version: "0.3.25" };
/**
 * Security Headers extension.
 *
 * @see https://aws.amazon.com/tw/blogs/networking-and-content-delivery/adding-http-security-headers-using-lambdaedge-and-amazon-cloudfront/
 * @stability stable
 */
class SecurtyHeaders extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/add-security-headers',
            semanticVersion: '1.0.0',
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.AddSecurityHeaderFunction').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.ORIGIN_RESPONSE;
    }
}
exports.SecurtyHeaders = SecurtyHeaders;
_d = JSII_RTTI_SYMBOL_1;
SecurtyHeaders[_d] = { fqn: "cdk-cloudfront-plus.SecurtyHeaders", version: "0.3.25" };
/**
 * Multiple Origin IP Retry extension.
 *
 * @see https://github.com/awslabs/aws-cloudfront-extensions/tree/main/edge/nodejs/multiple-origin-IP-retry
 * @stability stable
 */
class MultipleOriginIpRetry extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/multiple-origin-IP-retry',
            semanticVersion: '1.0.1',
            parameters: {
                OriginIPList: props.originIp.join(';'),
                OriginProtocol: props.originProtocol,
            },
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.MultipleOriginIPRetry').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.ORIGIN_REQUEST;
    }
}
exports.MultipleOriginIpRetry = MultipleOriginIpRetry;
_e = JSII_RTTI_SYMBOL_1;
MultipleOriginIpRetry[_e] = { fqn: "cdk-cloudfront-plus.MultipleOriginIpRetry", version: "0.3.25" };
/**
 * Normalize Query String extension.
 *
 * @see https://github.com/awslabs/aws-cloudfront-extensions/tree/main/edge/nodejs/normalize-query-string
 * @stability stable
 */
class NormalizeQueryString extends _1.ServerlessApp {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            applicationId: 'arn:aws:serverlessrepo:us-east-1:418289889111:applications/normalize-query-string',
            semanticVersion: '1.0.1',
        });
        const stack = cdk.Stack.of(scope);
        this.functionArn = this.resource.getAtt('Outputs.NormalizeQueryStringFunction').toString();
        this.functionVersion = bumpFunctionVersion(stack, id, this.functionArn);
        this.eventType = cf.LambdaEdgeEventType.VIEWER_REQUEST;
    }
}
exports.NormalizeQueryString = NormalizeQueryString;
_f = JSII_RTTI_SYMBOL_1;
NormalizeQueryString[_f] = { fqn: "cdk-cloudfront-plus.NormalizeQueryString", version: "0.3.25" };
/**
 * Generate a lambda function version from the given function ARN
 * @param scope
 * @param id
 * @param functionArn The lambda function ARN
 * @returns lambda.Version
 */
function bumpFunctionVersion(scope, id, functionArn) {
    return new lambda.Version(scope, `LambdaVersion${id}`, {
        lambda: lambda.Function.fromFunctionArn(scope, `FuncArn${id}`, functionArn),
    });
}
/**
 * Convert a query string to key-value pairs and add them into header.
 *
 * @see https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-examples.html#lambda-examples-header-based-on-query-string
 * @stability stable
 */
class ConvertQueryString extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'ConvertQueryStringFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-convert-query-string/index.ts`,
            handler: 'lambdaHandler',
            runtime: lambda.Runtime.NODEJS_14_X,
            bundling: {
                define: {
                    NEEDED_KEYS: JSON.stringify(props.args),
                },
            },
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: 'SO8113',
            templateDescription: 'Cloudfront extension with AWS CDK - Convert Query String.',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.ConvertQueryString = ConvertQueryString;
_g = JSII_RTTI_SYMBOL_1;
ConvertQueryString[_g] = { fqn: "cdk-cloudfront-plus.ConvertQueryString", version: "0.3.25" };
/**
 * Default Directory Indexes in Amazon S3-backed Amazon CloudFront Origins.
 *
 * use case - see https://aws.amazon.com/tw/blogs/compute/implementing-default-directory-indexes-in-amazon-s3-backed-amazon-cloudfront-origins-using-lambdaedge/
 *
 * @stability stable
 */
class DefaultDirIndex extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'DefaultDirIndexFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-default-dir-index/index.ts`,
            runtime: lambda.Runtime.NODEJS_14_X,
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: 'SO8134',
            templateDescription: 'Cloudfront extension with AWS CDK - Default Directory Index for Amazon S3 Origin.',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.DefaultDirIndex = DefaultDirIndex;
_h = JSII_RTTI_SYMBOL_1;
DefaultDirIndex[_h] = { fqn: "cdk-cloudfront-plus.DefaultDirIndex", version: "0.3.25" };
;
/**
 * Display customized error pages, or mask 4XX error pages, based on where the error originated.
 *
 * use case - see https://aws.amazon.com/blogs/networking-and-content-delivery/customize-403-error-pages-from-amazon-cloudfront-origin-with-lambdaedge/
 *
 * @stability stable
 */
class CustomErrorPage extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'CustomErrorPageFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-custom-error-page/index.ts`,
            runtime: lambda.Runtime.NODEJS_14_X,
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_RESPONSE,
            solutionId: 'SO8136',
            templateDescription: 'Cloudfront extension with AWS CDK - Custom Error Page',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.CustomErrorPage = CustomErrorPage;
_j = JSII_RTTI_SYMBOL_1;
CustomErrorPage[_j] = { fqn: "cdk-cloudfront-plus.CustomErrorPage", version: "0.3.25" };
;
/**
 * (SO8118)Access Origin by Geolocation.
 *
 * @stability stable
 */
class AccessOriginByGeolocation extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'AccessOriginByGeolocationFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-access-origin-by-geolocation/index.ts`,
            runtime: lambda.Runtime.NODEJS_14_X,
            bundling: {
                define: {
                    'process.env.COUNTRY_CODE_TABLE': JSON.stringify(props.countryTable),
                },
            },
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: 'S08118',
            templateDescription: 'Cloudfront extension with AWS CDK - Access Origin by Geolocation',
        });
    }
}
exports.AccessOriginByGeolocation = AccessOriginByGeolocation;
_k = JSII_RTTI_SYMBOL_1;
AccessOriginByGeolocation[_k] = { fqn: "cdk-cloudfront-plus.AccessOriginByGeolocation", version: "0.3.25" };
;
/**
 * Forward request to the nearest PoP as per geolocation.
 *
 * @stability stable
 */
class RedirectByGeolocation extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'RedirectByGeolocationFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-redirect-by-geolocation/index.ts`,
            runtime: lambda.Runtime.NODEJS_14_X,
            bundling: {
                define: {
                    'process.env.COUNTRY_CODE_TABLE': JSON.stringify(props.countryTable),
                },
            },
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.ORIGIN_REQUEST,
            solutionId: 'SO8135',
            templateDescription: 'Cloudfront extension with AWS CDK - Redirect by Geolocation',
        });
    }
}
exports.RedirectByGeolocation = RedirectByGeolocation;
_l = JSII_RTTI_SYMBOL_1;
RedirectByGeolocation[_l] = { fqn: "cdk-cloudfront-plus.RedirectByGeolocation", version: "0.3.25" };
/**
 * Simple content generation.
 *
 * @see https://github.com/awslabs/aws-cloudfront-extensions/tree/main/edge/nodejs/simple-lambda-edge
 * @stability stable
 */
class SimpleLambdaEdge extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'SimpleLambdaEdgeFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/simple-lambda-edge/index.ts`,
            runtime: lambda.Runtime.NODEJS_14_X,
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.VIEWER_REQUEST,
            solutionId: '',
            templateDescription: 'Cloudfront extension with AWS CDK - Simple Lambda Edge.',
        });
    }
}
exports.SimpleLambdaEdge = SimpleLambdaEdge;
_m = JSII_RTTI_SYMBOL_1;
SimpleLambdaEdge[_m] = { fqn: "cdk-cloudfront-plus.SimpleLambdaEdge", version: "0.3.25" };
;
/**
 * OAuth2 Authentication - Authorization Code Grant.
 *
 * @stability stable
 */
class OAuth2AuthorizationCodeGrant extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'OAuth2AuthorizationCodeGrantFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-authentication-by-oauth2/index.ts`,
            runtime: lambda.Runtime.NODEJS_14_X,
            bundling: {
                define: {
                    'process.env.CLIENT_ID': JSON.stringify(props.clientId),
                    'process.env.CLIENT_SECRET': JSON.stringify(props.clientSecret),
                    'process.env.CLIENT_DOMAIN': JSON.stringify(props.clientDomain),
                    'process.env.CLIENT_PUBLIC_KEY': JSON.stringify(props.clientPublicKey),
                    'process.env.CALLBACK_PATH': JSON.stringify(props.callbackPath),
                    'process.env.JWT_ARGORITHM': JSON.stringify(props.jwtArgorithm),
                    'process.env.AUTHORIZE_URL': JSON.stringify(props.authorizeUrl),
                    'process.env.AUTHORIZE_PARAMS': JSON.stringify(props.authorizeParams),
                    'process.env.DEBUG_ENABLE': JSON.stringify(props.debugEnable),
                },
            },
        });
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.VIEWER_REQUEST,
            solutionId: 'SO8131',
            templateDescription: 'Cloudfront extension with AWS CDK - OAuth2 Authentication - Authorization Code Grant.',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.OAuth2AuthorizationCodeGrant = OAuth2AuthorizationCodeGrant;
_o = JSII_RTTI_SYMBOL_1;
OAuth2AuthorizationCodeGrant[_o] = { fqn: "cdk-cloudfront-plus.OAuth2AuthorizationCodeGrant", version: "0.3.25" };
;
;
/**
 * Ingest data to Kinesis Firehose by nearest cloudfront edge.
 *
 * @see https://aws.amazon.com/blogs/networking-and-content-delivery/global-data-ingestion-with-amazon-cloudfront-and-lambdaedge/
 * @stability stable
 */
class GlobalDataIngestion extends custom_1.Custom {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _q;
        const func = new aws_lambda_nodejs_1.NodejsFunction(scope, 'GlobalDataIngestionFunc', {
            entry: `${EXTENSION_ASSETS_PATH}/cf-global-data-ingestion/index.ts`,
            runtime: lambda.Runtime.NODEJS_14_X,
            bundling: {
                define: {
                    'process.env.DELIVERY_STREAM_NAME': JSON.stringify(props.firehoseStreamName),
                },
            },
        });
        (_q = func.role) === null || _q === void 0 ? void 0 : _q.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonKinesisFirehoseFullAccess'));
        super(scope, id, {
            func,
            eventType: cf.LambdaEdgeEventType.VIEWER_REQUEST,
            includeBody: true,
            solutionId: 'SO8133',
            templateDescription: 'Cloudfront extension with AWS CDK - Global Data Ingestion',
        });
        this.lambdaFunction = this.functionVersion;
    }
}
exports.GlobalDataIngestion = GlobalDataIngestion;
_p = JSII_RTTI_SYMBOL_1;
GlobalDataIngestion[_p] = { fqn: "cdk-cloudfront-plus.GlobalDataIngestion", version: "0.3.25" };
//# sourceMappingURL=data:application/json;base64,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