"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCdkJavaApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const __1 = require("..");
const awscdk_deps_java_1 = require("./awscdk-deps-java");
const cdk_config_1 = require("./cdk-config");
const cdk_tasks_1 = require("./cdk-tasks");
const java_1 = require("../java");
/**
 * AWS CDK app in Java.
 *
 * @pjid awscdk-app-java
 */
class AwsCdkJavaApp extends java_1.JavaProject {
    constructor(options) {
        const mainClassComponents = options.mainClass.split(".");
        const mainPackage = mainClassComponents.slice(0, -1);
        const mainClassName = mainClassComponents[mainClassComponents.length - 1];
        super({
            ...options,
            sample: false,
            sampleJavaPackage: mainPackage.join("."),
        });
        this.mainClass = options.mainClass;
        this.mainPackage = mainPackage.join(".");
        this.mainClassName = mainClassName;
        this.cdkDeps = new awscdk_deps_java_1.AwsCdkDepsJava(this, {
            dependencyType: __1.DependencyType.RUNTIME,
            ...options,
        });
        this.cdkTasks = new cdk_tasks_1.CdkTasks(this);
        this.postCompileTask.spawn(this.cdkTasks.synth);
        this.cdkConfig = new cdk_config_1.CdkConfig(this, {
            app: `mvn exec:java --quiet -Dexec.mainClass=${this.mainClass}`,
            ...options,
        });
        if (options.sample ?? true) {
            this.addSample();
        }
    }
    /**
     * Adds an AWS CDK module dependencies
     *
     * @param modules The list of modules to depend on (e.g. "software.amazon.awscdk/aws-lambda", "software.amazon.awscdk/aws-iam", etc)
     * @deprecated In CDK 2.x all modules are available by default. Alpha modules should be added using the standard 'deps'
     */
    addCdkDependency(...modules) {
        for (const m of modules) {
            this.cdkDeps.addV1Dependencies(m);
        }
    }
    addSample() {
        const pkg = this.mainPackage.split(".");
        const javaFile = `${this.mainClassName}.java`;
        new __1.SampleDir(this, (0, path_1.join)("src", "main", "java", ...pkg), {
            files: {
                [javaFile]: [
                    `package ${pkg.join(".")};`,
                    "",
                    this.cdkDeps.cdkMajorVersion == 1
                        ? "import software.amazon.awscdk.core.App;"
                        : "import software.amazon.awscdk.App;",
                    this.cdkDeps.cdkMajorVersion == 1
                        ? "import software.amazon.awscdk.core.Stack;"
                        : "import software.amazon.awscdk.Stack;",
                    "",
                    `public class ${this.mainClassName} {`,
                    "  public static void main(final String[] args) {",
                    "    App app = new App();",
                    `    new Stack(app, "${this.name}");`,
                    "    app.synth();",
                    "  }",
                    "}",
                ].join("\n"),
            },
        });
    }
}
exports.AwsCdkJavaApp = AwsCdkJavaApp;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkJavaApp[_a] = { fqn: "projen.awscdk.AwsCdkJavaApp", version: "0.98.4" };
//# sourceMappingURL=data:application/json;base64,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