"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApprovalLevel = exports.CdkConfig = exports.CdkFeatureFlags = exports.CdkFeatureFlagsV2 = exports.CdkFeatureFlagsV1 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fast_json_patch_1 = require("fast-json-patch");
const component_1 = require("../component");
const json_1 = require("../json");
const util_1 = require("../util");
const internal_1 = require("./internal");
/**
 * CDK V1 feature flags configuration.
 * @deprecated CDK V1 is EOS. Upgrade to CDK V2.
 */
class CdkFeatureFlagsV1 {
    constructor(flags) {
        this.flags = flags;
    }
}
exports.CdkFeatureFlagsV1 = CdkFeatureFlagsV1;
_a = JSII_RTTI_SYMBOL_1;
CdkFeatureFlagsV1[_a] = { fqn: "projen.awscdk.CdkFeatureFlagsV1", version: "0.98.4" };
/**
 * Disable all feature flags.
 */
CdkFeatureFlagsV1.NONE = new CdkFeatureFlagsV1({});
/**
 * Enable all CDK V1 feature flags.
 */
CdkFeatureFlagsV1.ALL = new CdkFeatureFlagsV1(internal_1.FEATURE_FLAGS_V1);
/**
 * CDK V2 feature flags configuration.
 */
class CdkFeatureFlagsV2 {
    /**
     * Attempt to load the feature flags from the `aws-cdk-lib/recommended-feature-flags.json` in a locally available npm package.
     * This file is typically only present in AWS CDK TypeScript projects, but can yield more accurate results.
     *
     * Falls back to all known feature flags if not found.
     */
    static fromLocalAwsCdkLib() {
        try {
            const featureFlags = (0, util_1.tryReadFileSync)(require.resolve("aws-cdk-lib/recommended-feature-flags.json", {
                paths: [process.cwd()],
            })) || "{}";
            return new CdkFeatureFlagsV2(JSON.parse(featureFlags));
        }
        catch {
            return CdkFeatureFlags.V2.ALL;
        }
    }
    constructor(flags) {
        this.flags = flags;
    }
}
exports.CdkFeatureFlagsV2 = CdkFeatureFlagsV2;
_b = JSII_RTTI_SYMBOL_1;
CdkFeatureFlagsV2[_b] = { fqn: "projen.awscdk.CdkFeatureFlagsV2", version: "0.98.4" };
/**
 * Disable all feature flags.
 */
CdkFeatureFlagsV2.NONE = new CdkFeatureFlagsV2({});
/**
 * Enable all CDK V2 feature flags known to projen.
 * These might not include feature flags, if your version of projen isn't up-to-date.
 *
 * Make sure to double-check any changes to feature flags in `cdk.json` before deploying.
 * Unexpected changes may cause breaking changes in your CDK app.
 * You can overwrite any feature flag by passing it into the context field.
 */
CdkFeatureFlagsV2.ALL = new CdkFeatureFlagsV2(internal_1.FEATURE_FLAGS_V2);
/**
 * CDK feature flags configuration.
 */
class CdkFeatureFlags {
    constructor(flags) {
        this.flags = flags;
    }
}
exports.CdkFeatureFlags = CdkFeatureFlags;
_c = JSII_RTTI_SYMBOL_1;
CdkFeatureFlags[_c] = { fqn: "projen.awscdk.CdkFeatureFlags", version: "0.98.4" };
/**
 * CDK V1 feature flags configuration.
 * @deprecated CDK V1 is EOS. Upgrade to CDK V2.
 */
CdkFeatureFlags.V1 = CdkFeatureFlagsV1;
/**
 * CDK V2 feature flags configuration.
 */
CdkFeatureFlags.V2 = CdkFeatureFlagsV2;
/**
 * Represents cdk.json file.
 */
class CdkConfig extends component_1.Component {
    constructor(project, options) {
        super(project);
        this.cdkout = options.cdkout ?? "cdk.out";
        this._include = options.watchIncludes ?? [];
        this._exclude = options.watchExcludes ?? [];
        const flags = options.featureFlags?.flags ?? {};
        this._context = {
            ...flags,
            // Customer context should take precedence over the default feature flags
            ...(options.context ?? {}),
        };
        this.json = new json_1.JsonFile(project, "cdk.json", {
            omitEmpty: true,
            obj: {
                app: options.app,
                context: this._context,
                requireApproval: options.requireApproval,
                output: this.cdkout,
                build: options.buildCommand,
                watch: {
                    include: () => this._include,
                    exclude: () => this._exclude,
                },
            },
        });
        project.gitignore.exclude(`/${this.cdkout}/`);
        project.gitignore.exclude(".cdk.staging/");
    }
    /**
     * Add includes to `cdk.json`.
     * @param patterns The includes to add.
     */
    addIncludes(...patterns) {
        this._include.push(...patterns);
    }
    /**
     * Add excludes to `cdk.json`.
     * @param patterns The excludes to add.
     */
    addExcludes(...patterns) {
        this._exclude.push(...patterns);
    }
    /**
     * List of glob patterns to be included by CDK.
     */
    get include() {
        return [...this._include];
    }
    /**
     * List of glob patterns to be excluded by CDK.
     */
    get exclude() {
        return [...this._exclude];
    }
    /**
     * The context to write to cdk.json.
     */
    get context() {
        return (0, fast_json_patch_1.deepClone)(this._context);
    }
}
exports.CdkConfig = CdkConfig;
_d = JSII_RTTI_SYMBOL_1;
CdkConfig[_d] = { fqn: "projen.awscdk.CdkConfig", version: "0.98.4" };
/**
 * Which approval is required when deploying CDK apps.
 */
var ApprovalLevel;
(function (ApprovalLevel) {
    /**
     * Approval is never required
     */
    ApprovalLevel["NEVER"] = "never";
    /**
     * Requires approval on any IAM or security-group-related change
     */
    ApprovalLevel["ANY_CHANGE"] = "any-change";
    /**
     * Requires approval when IAM statements or traffic rules are added; removals don't require approval
     */
    ApprovalLevel["BROADENING"] = "broadening";
})(ApprovalLevel || (exports.ApprovalLevel = ApprovalLevel = {}));
//# sourceMappingURL=data:application/json;base64,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