"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TYPESCRIPT_LAMBDA_EXTENSION_EXT = exports.TYPESCRIPT_EDGE_LAMBDA_EXT = exports.TYPESCRIPT_LAMBDA_EXT = exports.FEATURE_FLAGS_V2 = exports.FEATURE_FLAGS_V1 = void 0;
exports.convertToPosixPath = convertToPosixPath;
const path_1 = require("path");
const feature_flags_v2_const_1 = require("./private/feature-flags-v2.const");
/**
 * Feature flags as of v1.130.0
 */
exports.FEATURE_FLAGS_V1 = {
    "aws-cdk:enableDiffNoFail": true,
    "@aws-cdk/aws-apigateway:usagePlanKeyOrderInsensitiveId": true,
    "@aws-cdk/core:enableStackNameDuplicates": true,
    "@aws-cdk/core:stackRelativeExports": true,
    "@aws-cdk/aws-ecr-assets:dockerIgnoreSupport": true,
    "@aws-cdk/aws-secretsmanager:parseOwnedSecretName": true,
    "@aws-cdk/aws-kms:defaultKeyPolicies": true,
    "@aws-cdk/aws-s3:grantWriteWithoutAcl": true,
    "@aws-cdk/aws-ecs-patterns:removeDefaultDesiredCount": true,
    "@aws-cdk/aws-rds:lowercaseDbIdentifier": true,
    "@aws-cdk/aws-efs:defaultEncryptionAtRest": true,
    "@aws-cdk/aws-lambda:recognizeVersionProps": true,
    "@aws-cdk/aws-cloudfront:defaultSecurityPolicyTLSv1.2_2021": true,
};
/**
 * Feature flags for V2
 */
exports.FEATURE_FLAGS_V2 = feature_flags_v2_const_1.default;
/**
 * Suffix for AWS Lambda handlers.
 */
exports.TYPESCRIPT_LAMBDA_EXT = ".lambda.ts";
/**
 * Suffix for AWS Edge Lambda handlers.
 */
exports.TYPESCRIPT_EDGE_LAMBDA_EXT = ".edge-lambda.ts";
/**
 * Suffix for AWS Lambda Extensions.
 */
exports.TYPESCRIPT_LAMBDA_EXTENSION_EXT = ".lambda-extension.ts";
/**
 * Converts the given path string to posix if it wasn't already.
 */
function convertToPosixPath(p) {
    return p.split(path_1.sep).join(path_1.posix.sep);
}
//# sourceMappingURL=data:application/json;base64,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