"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructLibraryCdktf = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const semver = require("semver");
const cdk_1 = require("../cdk");
/**
 * CDKTF construct library project
 *
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the CDK for Terraform (CDKTF), with a friendly workflow and
 * automatic publishing to the construct catalog.
 *
 * @pjid cdktf-construct
 */
class ConstructLibraryCdktf extends cdk_1.ConstructLibrary {
    constructor(options) {
        super(options);
        if (!options.cdktfVersion) {
            throw new Error("Required field cdktfVersion is not specified.");
        }
        function getDefaultConstructVersion() {
            const semverCDKTFVersion = semver.coerce(options.cdktfVersion);
            if (semverCDKTFVersion && semver.lte(semverCDKTFVersion, "0.5.0")) {
                return "^3.0.0";
            }
            return "^10.3.0";
        }
        const ver = options.cdktfVersion;
        const constructVersion = options.constructsVersion ?? getDefaultConstructVersion();
        this.addPeerDeps(`constructs@${constructVersion}`, `cdktf@${ver}`);
        this.addKeywords("cdktf");
    }
}
exports.ConstructLibraryCdktf = ConstructLibraryCdktf;
_a = JSII_RTTI_SYMBOL_1;
ConstructLibraryCdktf[_a] = { fqn: "projen.cdktf.ConstructLibraryCdktf", version: "0.98.4" };
//# sourceMappingURL=data:application/json;base64,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