"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mergify = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const util_1 = require("../util");
const yaml_1 = require("../yaml");
class Mergify extends component_1.Component {
    constructor(github, options = {}) {
        super(github.project);
        this.rules = new Array();
        this.queues = new Array();
        for (const rule of options.rules ?? []) {
            this.addRule(rule);
        }
        for (const queue of options.queues ?? []) {
            this.addQueue(queue);
        }
    }
    createYamlFile() {
        if (this.yamlFile == null) {
            this.yamlFile = new yaml_1.YamlFile(this.project, ".mergify.yml", {
                obj: {
                    queue_rules: () => this.queues.map((q) => (0, util_1.snakeCaseKeys)(q, false)),
                    pull_request_rules: this.rules,
                    merge_queue: {
                        max_parallel_checks: 1,
                    },
                },
                // Mergify needs to read the file from the repository in order to work.
                committed: true,
            });
        }
    }
    addRule(rule) {
        this.rules.push(rule);
        this.createYamlFile();
    }
    addQueue(queue) {
        if (queue.conditions && !queue.queueConditions) {
            queue = {
                ...queue,
                queueConditions: queue.conditions,
                conditions: undefined,
            };
        }
        this.queues.push(queue);
        this.createYamlFile();
    }
}
exports.Mergify = Mergify;
_a = JSII_RTTI_SYMBOL_1;
Mergify[_a] = { fqn: "projen.github.Mergify", version: "0.98.4" };
//# sourceMappingURL=data:application/json;base64,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