"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Stale = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const stale_util_1 = require("./stale-util");
const workflows_model_1 = require("./workflows-model");
const component_1 = require("../component");
const runner_options_1 = require("../runner-options");
/**
 * Warns and then closes issues and PRs that have had no activity for a specified amount of time.
 *
 * The default configuration will:
 *
 *  * Add a "Stale" label to pull requests after 14 days and closed after 2 days
 *  * Add a "Stale" label to issues after 60 days and closed after 7 days
 *  * If a comment is added, the label will be removed and timer is restarted.
 *
 * @see https://github.com/actions/stale
 */
class Stale extends component_1.Component {
    constructor(github, options = {}) {
        super(github.project);
        const stale = github.addWorkflow("stale");
        stale.on({
            schedule: [{ cron: "0 1 * * *" }], // at 1am every day
            workflowDispatch: {},
        });
        const pullRequests = (0, stale_util_1.renderBehavior)(options.pullRequest, {
            stale: 14,
            close: 2,
            type: "pull request",
        });
        const issues = (0, stale_util_1.renderBehavior)(options.issues, {
            stale: 60,
            close: 7,
            type: "issue",
        });
        const renderExemptLabels = (exemptLabels) => {
            if (!exemptLabels || exemptLabels.length === 0) {
                return undefined;
            }
            return exemptLabels.join(",");
        };
        stale.addJobs({
            stale: {
                ...(0, runner_options_1.filteredRunsOnOptions)(options.runsOn, options.runsOnGroup),
                permissions: {
                    issues: workflows_model_1.JobPermission.WRITE,
                    pullRequests: workflows_model_1.JobPermission.WRITE,
                },
                steps: [
                    {
                        uses: "actions/stale@v10",
                        with: {
                            // disable global
                            "days-before-stale": -1,
                            "days-before-close": -1,
                            // pull requests
                            "days-before-pr-stale": pullRequests.daysBeforeStale,
                            "days-before-pr-close": pullRequests.daysBeforeClose,
                            "stale-pr-message": pullRequests.staleMessage,
                            "close-pr-message": pullRequests.closeMessage,
                            "stale-pr-label": pullRequests.staleLabel,
                            "exempt-pr-labels": renderExemptLabels(pullRequests.exemptLabels),
                            // issues
                            "days-before-issue-stale": issues.daysBeforeStale,
                            "days-before-issue-close": issues.daysBeforeClose,
                            "stale-issue-message": issues.staleMessage,
                            "close-issue-message": issues.closeMessage,
                            "stale-issue-label": issues.staleLabel,
                            "exempt-issue-labels": renderExemptLabels(issues.exemptLabels),
                        },
                    },
                ],
            },
        });
    }
}
exports.Stale = Stale;
_a = JSII_RTTI_SYMBOL_1;
Stale[_a] = { fqn: "projen.github.Stale", version: "0.98.4" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RhbGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvZ2l0aHViL3N0YWxlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQ0EsNkNBQThDO0FBQzlDLHVEQUFrRDtBQUNsRCw0Q0FBeUM7QUFDekMsc0RBQThFO0FBMEY5RTs7Ozs7Ozs7OztHQVVHO0FBQ0gsTUFBYSxLQUFNLFNBQVEscUJBQVM7SUFDbEMsWUFBWSxNQUFjLEVBQUUsVUFBd0IsRUFBRTtRQUNwRCxLQUFLLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBRXRCLE1BQU0sS0FBSyxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDMUMsS0FBSyxDQUFDLEVBQUUsQ0FBQztZQUNQLFFBQVEsRUFBRSxDQUFDLEVBQUUsSUFBSSxFQUFFLFdBQVcsRUFBRSxDQUFDLEVBQUUsbUJBQW1CO1lBQ3RELGdCQUFnQixFQUFFLEVBQUU7U0FDckIsQ0FBQyxDQUFDO1FBRUgsTUFBTSxZQUFZLEdBQUcsSUFBQSwyQkFBYyxFQUFDLE9BQU8sQ0FBQyxXQUFXLEVBQUU7WUFDdkQsS0FBSyxFQUFFLEVBQUU7WUFDVCxLQUFLLEVBQUUsQ0FBQztZQUNSLElBQUksRUFBRSxjQUFjO1NBQ3JCLENBQUMsQ0FBQztRQUNILE1BQU0sTUFBTSxHQUFHLElBQUEsMkJBQWMsRUFBQyxPQUFPLENBQUMsTUFBTSxFQUFFO1lBQzVDLEtBQUssRUFBRSxFQUFFO1lBQ1QsS0FBSyxFQUFFLENBQUM7WUFDUixJQUFJLEVBQUUsT0FBTztTQUNkLENBQUMsQ0FBQztRQUVILE1BQU0sa0JBQWtCLEdBQUcsQ0FBQyxZQUF1QixFQUFFLEVBQUU7WUFDckQsSUFBSSxDQUFDLFlBQVksSUFBSSxZQUFZLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRSxDQUFDO2dCQUMvQyxPQUFPLFNBQVMsQ0FBQztZQUNuQixDQUFDO1lBQ0QsT0FBTyxZQUFZLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ2hDLENBQUMsQ0FBQztRQUVGLEtBQUssQ0FBQyxPQUFPLENBQUM7WUFDWixLQUFLLEVBQUU7Z0JBQ0wsR0FBRyxJQUFBLHNDQUFxQixFQUFDLE9BQU8sQ0FBQyxNQUFNLEVBQUUsT0FBTyxDQUFDLFdBQVcsQ0FBQztnQkFDN0QsV0FBVyxFQUFFO29CQUNYLE1BQU0sRUFBRSwrQkFBYSxDQUFDLEtBQUs7b0JBQzNCLFlBQVksRUFBRSwrQkFBYSxDQUFDLEtBQUs7aUJBQ2xDO2dCQUNELEtBQUssRUFBRTtvQkFDTDt3QkFDRSxJQUFJLEVBQUUsbUJBQW1CO3dCQUN6QixJQUFJLEVBQUU7NEJBQ0osaUJBQWlCOzRCQUNqQixtQkFBbUIsRUFBRSxDQUFDLENBQUM7NEJBQ3ZCLG1CQUFtQixFQUFFLENBQUMsQ0FBQzs0QkFFdkIsZ0JBQWdCOzRCQUNoQixzQkFBc0IsRUFBRSxZQUFZLENBQUMsZUFBZTs0QkFDcEQsc0JBQXNCLEVBQUUsWUFBWSxDQUFDLGVBQWU7NEJBQ3BELGtCQUFrQixFQUFFLFlBQVksQ0FBQyxZQUFZOzRCQUM3QyxrQkFBa0IsRUFBRSxZQUFZLENBQUMsWUFBWTs0QkFDN0MsZ0JBQWdCLEVBQUUsWUFBWSxDQUFDLFVBQVU7NEJBQ3pDLGtCQUFrQixFQUFFLGtCQUFrQixDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUM7NEJBRWpFLFNBQVM7NEJBQ1QseUJBQXlCLEVBQUUsTUFBTSxDQUFDLGVBQWU7NEJBQ2pELHlCQUF5QixFQUFFLE1BQU0sQ0FBQyxlQUFlOzRCQUNqRCxxQkFBcUIsRUFBRSxNQUFNLENBQUMsWUFBWTs0QkFDMUMscUJBQXFCLEVBQUUsTUFBTSxDQUFDLFlBQVk7NEJBQzFDLG1CQUFtQixFQUFFLE1BQU0sQ0FBQyxVQUFVOzRCQUN0QyxxQkFBcUIsRUFBRSxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDO3lCQUMvRDtxQkFDRjtpQkFDRjthQUNGO1NBQ0YsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUEvREgsc0JBZ0VDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgR2l0SHViIH0gZnJvbSBcIi4vZ2l0aHViXCI7XG5pbXBvcnQgeyByZW5kZXJCZWhhdmlvciB9IGZyb20gXCIuL3N0YWxlLXV0aWxcIjtcbmltcG9ydCB7IEpvYlBlcm1pc3Npb24gfSBmcm9tIFwiLi93b3JrZmxvd3MtbW9kZWxcIjtcbmltcG9ydCB7IENvbXBvbmVudCB9IGZyb20gXCIuLi9jb21wb25lbnRcIjtcbmltcG9ydCB7IEdyb3VwUnVubmVyT3B0aW9ucywgZmlsdGVyZWRSdW5zT25PcHRpb25zIH0gZnJvbSBcIi4uL3J1bm5lci1vcHRpb25zXCI7XG5cbi8qKlxuICogT3B0aW9ucyBmb3IgYFN0YWxlYC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTdGFsZU9wdGlvbnMge1xuICAvKipcbiAgICogSG93IHRvIGhhbmRsZSBzdGFsZSBwdWxsIHJlcXVlc3RzLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIEJ5IGRlZmF1bHQsIHB1bGwgcmVxdWVzdHMgd2l0aCBubyBhY3Rpdml0eSB3aWxsIGJlIG1hcmtlZCBhc1xuICAgKiBzdGFsZSBhZnRlciAxNCBkYXlzIGFuZCBjbG9zZWQgd2l0aGluIDIgZGF5cyB3aXRoIHJlbGV2YW50IGNvbW1lbnRzLlxuICAgKi9cbiAgcmVhZG9ubHkgcHVsbFJlcXVlc3Q/OiBTdGFsZUJlaGF2aW9yO1xuXG4gIC8qKlxuICAgKiBIb3cgdG8gaGFuZGxlIHN0YWxlIGlzc3Vlcy5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBCeSBkZWZhdWx0LCBzdGFsZSBpc3N1ZXMgd2l0aCBubyBhY3Rpdml0eSB3aWxsIGJlIG1hcmtlZCBhc1xuICAgKiBzdGFsZSBhZnRlciA2MCBkYXlzIGFuZCBjbG9zZWQgd2l0aGluIDcgZGF5cy5cbiAgICovXG4gIHJlYWRvbmx5IGlzc3Vlcz86IFN0YWxlQmVoYXZpb3I7XG5cbiAgLyoqXG4gICAqIEdpdGh1YiBSdW5uZXIgc2VsZWN0aW9uIGxhYmVsc1xuICAgKiBAZGVmYXVsdCBbXCJ1YnVudHUtbGF0ZXN0XCJdXG4gICAqIEBkZXNjcmlwdGlvbiBEZWZpbmVzIGEgdGFyZ2V0IFJ1bm5lciBieSBsYWJlbHNcbiAgICogQHRocm93cyB7RXJyb3J9IGlmIGJvdGggYHJ1bnNPbmAgYW5kIGBydW5zT25Hcm91cGAgYXJlIHNwZWNpZmllZFxuICAgKi9cbiAgcmVhZG9ubHkgcnVuc09uPzogc3RyaW5nW107XG5cbiAgLyoqXG4gICAqIEdpdGh1YiBSdW5uZXIgR3JvdXAgc2VsZWN0aW9uIG9wdGlvbnNcbiAgICogQGRlc2NyaXB0aW9uIERlZmluZXMgYSB0YXJnZXQgUnVubmVyIEdyb3VwIGJ5IG5hbWUgYW5kL29yIGxhYmVsc1xuICAgKiBAdGhyb3dzIHtFcnJvcn0gaWYgYm90aCBgcnVuc09uYCBhbmQgYHJ1bnNPbkdyb3VwYCBhcmUgc3BlY2lmaWVkXG4gICAqL1xuICByZWFkb25seSBydW5zT25Hcm91cD86IEdyb3VwUnVubmVyT3B0aW9ucztcbn1cblxuLyoqXG4gKiBTdGFsZSBiZWhhdmlvci5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTdGFsZUJlaGF2aW9yIHtcbiAgLyoqXG4gICAqIERldGVybWluZXMgaWYgdGhpcyBiZWhhdmlvciBpcyBlbmFibGVkLlxuICAgKlxuICAgKiBTYW1lIGFzIHNldHRpbmcgYGRheXNCZWZvcmVTdGFsZWAgYW5kIGBkYXlzQmVmb3JlQ2xvc2VgIHRvIGAtMWAuXG4gICAqXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IGVuYWJsZWQ/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBIb3cgbWFueSBkYXlzIHVudGlsIHRoZSBpc3N1ZSBvciBwdWxsIHJlcXVlc3QgaXMgbWFya2VkIGFzIFwiU3RhbGVcIi4gU2V0IHRvIC0xIHRvIGRpc2FibGUuXG4gICAqIEBkZWZhdWx0IC1cbiAgICovXG4gIHJlYWRvbmx5IGRheXNCZWZvcmVTdGFsZT86IG51bWJlcjtcblxuICAvKipcbiAgICogRGF5cyB1bnRpbCB0aGUgaXNzdWUvUFIgaXMgY2xvc2VkIGFmdGVyIGl0IGlzIG1hcmtlZCBhcyBcIlN0YWxlXCIuIFNldCB0byAtMSB0byBkaXNhYmxlLlxuICAgKiBAZGVmYXVsdCAtXG4gICAqL1xuICByZWFkb25seSBkYXlzQmVmb3JlQ2xvc2U/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIFRoZSBjb21tZW50IHRvIGFkZCB0byB0aGUgaXNzdWUvUFIgd2hlbiBpdCBiZWNvbWVzIHN0YWxlLlxuICAgKiBAZGVmYXVsdCBcIlRoaXMgcHVsbCByZXF1ZXN0IGlzIG5vdyBtYXJrZWQgYXMgc3RhbGUgYmVjYXVzZSBoYXNuXFwndCBzZWVuIGFjdGl2aXR5IGZvciBhIHdoaWxlLiBBZGQgYSBjb21tZW50IG9yIGl0IHdpbGwgYmUgY2xvc2VkIHNvb24uXCJcbiAgICovXG4gIHJlYWRvbmx5IHN0YWxlTWVzc2FnZT86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIGNvbW1lbnQgdG8gYWRkIHRvIHRoZSBpc3N1ZS9QUiB3aGVuIGl0J3MgY2xvc2VkXG4gICAqXG4gICAqIEBkZWZhdWx0IFwiQ2xvc2luZyB0aGlzIHB1bGwgcmVxdWVzdCBhcyBpdCBoYXNuXFwndCBzZWVuIGFjdGl2aXR5IGZvciBhIHdoaWxlLiBQbGVhc2UgYWRkIGEgY29tbWVudCBAbWVudGlvbmluZyBhIG1haW50YWluZXIgd2hlbiB5b3UgYXJlIHJlYWR5IHRvIGNvbnRpbnVlLlwiXG4gICAqL1xuICByZWFkb25seSBjbG9zZU1lc3NhZ2U/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBsYWJlbCB0byBhcHBseSB0byB0aGUgaXNzdWUvUFIgd2hlbiBpdCBiZWNvbWVzIHN0YWxlLlxuICAgKiBAZGVmYXVsdCBcInN0YWxlXCJcbiAgICovXG4gIHJlYWRvbmx5IHN0YWxlTGFiZWw/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIExhYmVsIHdoaWNoIGV4ZW1wdCBhbiBpc3N1ZS9QUiBmcm9tIGJlY29taW5nIHN0YWxlLiBTZXQgdG8gYFtdYCB0byBkaXNhYmxlLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIFtcImJhY2tsb2dcIl1cbiAgICovXG4gIHJlYWRvbmx5IGV4ZW1wdExhYmVscz86IHN0cmluZ1tdO1xufVxuXG4vKipcbiAqIFdhcm5zIGFuZCB0aGVuIGNsb3NlcyBpc3N1ZXMgYW5kIFBScyB0aGF0IGhhdmUgaGFkIG5vIGFjdGl2aXR5IGZvciBhIHNwZWNpZmllZCBhbW91bnQgb2YgdGltZS5cbiAqXG4gKiBUaGUgZGVmYXVsdCBjb25maWd1cmF0aW9uIHdpbGw6XG4gKlxuICogICogQWRkIGEgXCJTdGFsZVwiIGxhYmVsIHRvIHB1bGwgcmVxdWVzdHMgYWZ0ZXIgMTQgZGF5cyBhbmQgY2xvc2VkIGFmdGVyIDIgZGF5c1xuICogICogQWRkIGEgXCJTdGFsZVwiIGxhYmVsIHRvIGlzc3VlcyBhZnRlciA2MCBkYXlzIGFuZCBjbG9zZWQgYWZ0ZXIgNyBkYXlzXG4gKiAgKiBJZiBhIGNvbW1lbnQgaXMgYWRkZWQsIHRoZSBsYWJlbCB3aWxsIGJlIHJlbW92ZWQgYW5kIHRpbWVyIGlzIHJlc3RhcnRlZC5cbiAqXG4gKiBAc2VlIGh0dHBzOi8vZ2l0aHViLmNvbS9hY3Rpb25zL3N0YWxlXG4gKi9cbmV4cG9ydCBjbGFzcyBTdGFsZSBleHRlbmRzIENvbXBvbmVudCB7XG4gIGNvbnN0cnVjdG9yKGdpdGh1YjogR2l0SHViLCBvcHRpb25zOiBTdGFsZU9wdGlvbnMgPSB7fSkge1xuICAgIHN1cGVyKGdpdGh1Yi5wcm9qZWN0KTtcblxuICAgIGNvbnN0IHN0YWxlID0gZ2l0aHViLmFkZFdvcmtmbG93KFwic3RhbGVcIik7XG4gICAgc3RhbGUub24oe1xuICAgICAgc2NoZWR1bGU6IFt7IGNyb246IFwiMCAxICogKiAqXCIgfV0sIC8vIGF0IDFhbSBldmVyeSBkYXlcbiAgICAgIHdvcmtmbG93RGlzcGF0Y2g6IHt9LFxuICAgIH0pO1xuXG4gICAgY29uc3QgcHVsbFJlcXVlc3RzID0gcmVuZGVyQmVoYXZpb3Iob3B0aW9ucy5wdWxsUmVxdWVzdCwge1xuICAgICAgc3RhbGU6IDE0LFxuICAgICAgY2xvc2U6IDIsXG4gICAgICB0eXBlOiBcInB1bGwgcmVxdWVzdFwiLFxuICAgIH0pO1xuICAgIGNvbnN0IGlzc3VlcyA9IHJlbmRlckJlaGF2aW9yKG9wdGlvbnMuaXNzdWVzLCB7XG4gICAgICBzdGFsZTogNjAsXG4gICAgICBjbG9zZTogNyxcbiAgICAgIHR5cGU6IFwiaXNzdWVcIixcbiAgICB9KTtcblxuICAgIGNvbnN0IHJlbmRlckV4ZW1wdExhYmVscyA9IChleGVtcHRMYWJlbHM/OiBzdHJpbmdbXSkgPT4ge1xuICAgICAgaWYgKCFleGVtcHRMYWJlbHMgfHwgZXhlbXB0TGFiZWxzLmxlbmd0aCA9PT0gMCkge1xuICAgICAgICByZXR1cm4gdW5kZWZpbmVkO1xuICAgICAgfVxuICAgICAgcmV0dXJuIGV4ZW1wdExhYmVscy5qb2luKFwiLFwiKTtcbiAgICB9O1xuXG4gICAgc3RhbGUuYWRkSm9icyh7XG4gICAgICBzdGFsZToge1xuICAgICAgICAuLi5maWx0ZXJlZFJ1bnNPbk9wdGlvbnMob3B0aW9ucy5ydW5zT24sIG9wdGlvbnMucnVuc09uR3JvdXApLFxuICAgICAgICBwZXJtaXNzaW9uczoge1xuICAgICAgICAgIGlzc3VlczogSm9iUGVybWlzc2lvbi5XUklURSxcbiAgICAgICAgICBwdWxsUmVxdWVzdHM6IEpvYlBlcm1pc3Npb24uV1JJVEUsXG4gICAgICAgIH0sXG4gICAgICAgIHN0ZXBzOiBbXG4gICAgICAgICAge1xuICAgICAgICAgICAgdXNlczogXCJhY3Rpb25zL3N0YWxlQHYxMFwiLFxuICAgICAgICAgICAgd2l0aDoge1xuICAgICAgICAgICAgICAvLyBkaXNhYmxlIGdsb2JhbFxuICAgICAgICAgICAgICBcImRheXMtYmVmb3JlLXN0YWxlXCI6IC0xLFxuICAgICAgICAgICAgICBcImRheXMtYmVmb3JlLWNsb3NlXCI6IC0xLFxuXG4gICAgICAgICAgICAgIC8vIHB1bGwgcmVxdWVzdHNcbiAgICAgICAgICAgICAgXCJkYXlzLWJlZm9yZS1wci1zdGFsZVwiOiBwdWxsUmVxdWVzdHMuZGF5c0JlZm9yZVN0YWxlLFxuICAgICAgICAgICAgICBcImRheXMtYmVmb3JlLXByLWNsb3NlXCI6IHB1bGxSZXF1ZXN0cy5kYXlzQmVmb3JlQ2xvc2UsXG4gICAgICAgICAgICAgIFwic3RhbGUtcHItbWVzc2FnZVwiOiBwdWxsUmVxdWVzdHMuc3RhbGVNZXNzYWdlLFxuICAgICAgICAgICAgICBcImNsb3NlLXByLW1lc3NhZ2VcIjogcHVsbFJlcXVlc3RzLmNsb3NlTWVzc2FnZSxcbiAgICAgICAgICAgICAgXCJzdGFsZS1wci1sYWJlbFwiOiBwdWxsUmVxdWVzdHMuc3RhbGVMYWJlbCxcbiAgICAgICAgICAgICAgXCJleGVtcHQtcHItbGFiZWxzXCI6IHJlbmRlckV4ZW1wdExhYmVscyhwdWxsUmVxdWVzdHMuZXhlbXB0TGFiZWxzKSxcblxuICAgICAgICAgICAgICAvLyBpc3N1ZXNcbiAgICAgICAgICAgICAgXCJkYXlzLWJlZm9yZS1pc3N1ZS1zdGFsZVwiOiBpc3N1ZXMuZGF5c0JlZm9yZVN0YWxlLFxuICAgICAgICAgICAgICBcImRheXMtYmVmb3JlLWlzc3VlLWNsb3NlXCI6IGlzc3Vlcy5kYXlzQmVmb3JlQ2xvc2UsXG4gICAgICAgICAgICAgIFwic3RhbGUtaXNzdWUtbWVzc2FnZVwiOiBpc3N1ZXMuc3RhbGVNZXNzYWdlLFxuICAgICAgICAgICAgICBcImNsb3NlLWlzc3VlLW1lc3NhZ2VcIjogaXNzdWVzLmNsb3NlTWVzc2FnZSxcbiAgICAgICAgICAgICAgXCJzdGFsZS1pc3N1ZS1sYWJlbFwiOiBpc3N1ZXMuc3RhbGVMYWJlbCxcbiAgICAgICAgICAgICAgXCJleGVtcHQtaXNzdWUtbGFiZWxzXCI6IHJlbmRlckV4ZW1wdExhYmVscyhpc3N1ZXMuZXhlbXB0TGFiZWxzKSxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgfSxcbiAgICAgICAgXSxcbiAgICAgIH0sXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==