"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskWorkflowJob = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constants_1 = require("./constants");
const workflow_steps_1 = require("./workflow-steps");
const component_1 = require("../component");
const runner_options_1 = require("../runner-options");
const util_1 = require("./private/util");
/**
 * The primary or initial job of a TaskWorkflow.
 *
 * @implements {Job}
 */
class TaskWorkflowJob extends component_1.Component {
    /**
     * @param scope should be part of the project the Task belongs to.
     * @param task the main task that is run as part of this job.
     * @param options options to configure the TaskWorkflowJob.
     */
    constructor(scope, task, options) {
        super(scope, `${new.target.name}#${task.name}`);
        const preCheckoutSteps = options.preCheckoutSteps ?? [];
        const checkoutWith = {};
        if (options.downloadLfs) {
            checkoutWith.lfs = true;
        }
        // 'checkoutWith' can override 'lfs'
        Object.assign(checkoutWith, options.checkoutWith ?? {});
        const preBuildSteps = options.preBuildSteps ?? [];
        const postBuildSteps = options.postBuildSteps ?? [];
        const gitIdentity = options.gitIdentity ?? constants_1.DEFAULT_GITHUB_ACTIONS_USER;
        if (options.artifactsDirectory) {
            (0, util_1.ensureNotHiddenPath)(options.artifactsDirectory, "artifactsDirectory");
            postBuildSteps.push(workflow_steps_1.WorkflowSteps.uploadArtifact({
                // Setting to always will ensure that this step will run even if
                // the previous ones have failed (e.g. coverage report, internal logs, etc)
                if: "always()",
                with: {
                    name: options.artifactsDirectory,
                    path: options.artifactsDirectory,
                },
            }));
        }
        const runsOnInputs = (0, runner_options_1.filteredRunsOnOptions)(options.runsOn, options.runsOnGroup);
        this.runsOn = runsOnInputs?.runsOn;
        this.runsOnGroup = runsOnInputs?.runsOnGroup;
        this.container = options.container;
        this.env = options.env;
        this.permissions = options.permissions;
        this.defaults = options?.jobDefaults;
        this.if = options.condition;
        this.outputs = options.outputs;
        this.environment = options.environment;
        this.steps = [
            ...preCheckoutSteps,
            // check out sources.
            workflow_steps_1.WorkflowSteps.checkout({ with: checkoutWith }),
            // sets git identity so we can push later
            workflow_steps_1.WorkflowSteps.setupGitIdentity({ gitIdentity }),
            ...preBuildSteps,
            // run the main build task
            {
                name: task.name,
                run: this.project.runTaskCommand(task),
            },
            ...postBuildSteps,
        ];
    }
    /**
     * @jsii ignore
     * @internal
     */
    toJSON() {
        return {
            runsOn: this.runsOn,
            runsOnGroup: this.runsOnGroup,
            steps: this.steps,
            environment: this.environment,
            outputs: this.outputs,
            env: this.env,
            defaults: this.defaults,
            timeoutMinutes: this.timeoutMinutes,
            continueOnError: this.continueOnError,
            container: this.container,
            services: this.services,
            tools: this.tools,
            name: this.name,
            needs: this.needs,
            permissions: this.permissions,
            concurrency: this.concurrency,
            if: this.if,
            strategy: this.strategy,
        };
    }
}
exports.TaskWorkflowJob = TaskWorkflowJob;
_a = JSII_RTTI_SYMBOL_1;
TaskWorkflowJob[_a] = { fqn: "projen.github.TaskWorkflowJob", version: "0.98.4" };
//# sourceMappingURL=data:application/json;base64,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