"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitlabConfiguration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const configuration_1 = require("./configuration");
const nested_configuration_1 = require("./nested-configuration");
/**
 * A GitLab CI for the main `.gitlab-ci.yml` file.
 */
class GitlabConfiguration extends configuration_1.CiConfiguration {
    constructor(project, options) {
        super(project, "gitlab-ci", options);
        this.nestedTemplates = {};
    }
    /**
     * Creates and adds nested templates to the includes of the main CI.
     * Additionally adds their stages to the main CI if they are not already present.
     * You can futher customize nested templates through the `nestedTemplates` property.
     * E.g. gitlabConfig.nestedTemplates['templateName']?.addStages('stageName')
     * @param config a record the names and configuraitons of the templates.
     */
    createNestedTemplates(config) {
        for (const [name, options] of Object.entries(config)) {
            if (this.nestedTemplates[name] !== undefined) {
                throw new Error(`${this.name}: GitLab CI already contains template "${name}".`);
            }
            const template = new nested_configuration_1.NestedConfiguration(this.project, this, name, options);
            this.nestedTemplates[template.name] = template;
            this.addIncludes({ local: template.path });
            this.addStages(...template.stages);
        }
    }
}
exports.GitlabConfiguration = GitlabConfiguration;
_a = JSII_RTTI_SYMBOL_1;
GitlabConfiguration[_a] = { fqn: "projen.gitlab.GitlabConfiguration", version: "0.98.4" };
//# sourceMappingURL=data:application/json;base64,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