import { type BiomeConfiguration } from "./biome-config";
import { Component } from "../../component";
import type { NodeProject } from "../../javascript/node-project";
import { JsonFile } from "../../json";
import type { Project } from "../../project";
import type { Task } from "../../task";
export interface BiomeOptions {
    /**
     * Version of Biome to use
     *
     * @default "^2"
     */
    readonly version?: string;
    /**
     * Enable linting with recommended rules.
     *
     * @default true
     */
    readonly linter?: boolean;
    /**
     * Enable code formatter with recommended settings.
     *
     * @default true
     */
    readonly formatter?: boolean;
    /**
     * Enable code assist with recommended actions.
     *
     * @default true
     */
    readonly assist?: boolean;
    /**
     * Should arrays be merged or overwritten when creating Biome configuration
     *
     * By default arrays are merged and duplicate values are removed
     *
     * @default true
     */
    readonly mergeArraysInConfiguration?: boolean;
    /**
     * Automatically ignore all generated files.
     *
     * This prevents Biome from trying to format or lint files that are marked as generated,
     * which would fail since generated files are typically read-only.
     *
     * @default true
     */
    readonly ignoreGeneratedFiles?: boolean;
    /**
     * Full Biome configuration.
     *
     * This configuration dictates the final outcome if value is set.
     * For example, if the linter is disabled at the top-level, it can be enabled with `biomeConfig.linter.enabled`.
     */
    readonly biomeConfig?: BiomeConfiguration;
}
/**
 * Biome component.
 */
export declare class Biome extends Component {
    static of(project: Project): Biome | undefined;
    private readonly biomeConfiguration;
    private readonly _filePatterns;
    private readonly biomeCommand;
    /**
     * Biome task.
     */
    readonly task: Task;
    /**
     * Biome configuration file content
     */
    readonly file: JsonFile;
    constructor(project: NodeProject, options?: BiomeOptions);
    addFilePattern(pattern: string): void;
    private createLocalBiomeTask;
}
