"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const path_1 = require("path");
const eslint_1 = require("./eslint");
const render_options_1 = require("./render-options");
const common_1 = require("../common");
const projenrc_1 = require("../projenrc");
const biome_1 = require("./biome/biome");
/**
 * A projenrc file written in JavaScript
 *
 * This component can be instantiated in any type of project
 * and has no expectations around the project's main language.
 */
class Projenrc extends projenrc_1.ProjenrcFile {
    constructor(project, options = {}) {
        super(project);
        this.filePath = options.filename ?? common_1.DEFAULT_PROJEN_RC_JS_FILENAME;
        // this is the task projen executes when running `projen`
        project.defaultTask?.exec(`node ${this.filePath}`);
        this.generateProjenrc();
    }
    preSynthesize() {
        super.preSynthesize();
        const eslint = eslint_1.Eslint.of(this.project);
        eslint?.addLintPattern(this.filePath);
        eslint?.addIgnorePattern(`!${this.filePath}`);
        eslint?.addOverride({
            files: [this.filePath],
            rules: {
                "@typescript-eslint/no-require-imports": "off",
                "import/no-extraneous-dependencies": "off",
            },
        });
        const biome = biome_1.Biome.of(this.project);
        biome?.addFilePattern(this.filePath);
    }
    generateProjenrc() {
        const rcfile = (0, path_1.resolve)(this.project.outdir, this.filePath);
        if ((0, fs_1.existsSync)(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.initProject;
        if (!bootstrap) {
            return;
        }
        const parts = bootstrap.fqn.split(".");
        const moduleName = parts[0];
        const importName = parts[1];
        const className = parts.slice(1).join(".");
        const { renderedOptions, imports } = (0, render_options_1.renderJavaScriptOptions)({
            comments: bootstrap.comments,
            args: bootstrap.args,
            type: bootstrap.type,
        });
        imports.add(moduleName, importName);
        const lines = new Array();
        lines.push(...imports.asCjsRequire());
        lines.push();
        lines.push(`const project = new ${className}(${renderedOptions});`);
        lines.push();
        lines.push("project.synth();");
        (0, fs_1.mkdirSync)((0, path_1.dirname)(rcfile), { recursive: true });
        (0, fs_1.writeFileSync)(rcfile, lines.join("\n"));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.Projenrc = Projenrc;
_a = JSII_RTTI_SYMBOL_1;
Projenrc[_a] = { fqn: "projen.javascript.Projenrc", version: "0.98.4" };
//# sourceMappingURL=data:application/json;base64,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