"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pytest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const dependencies_1 = require("../dependencies");
class Pytest extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        const version = options.version ?? "7.4.3";
        this.testdir = options.testdir ?? "tests";
        this.testMatch = options.testMatch ?? [];
        project.deps.addDependency(`pytest@${version}`, dependencies_1.DependencyType.TEST);
        project.testTask.exec([
            "pytest",
            ...(options.maxFailures ? [`--maxfail=${options.maxFailures}`] : []),
            ...this.testMatch,
        ]
            .join(" ")
            .trimEnd());
    }
}
exports.Pytest = Pytest;
_a = JSII_RTTI_SYMBOL_1;
Pytest[_a] = { fqn: "projen.python.Pytest", version: "0.98.4" };
//# sourceMappingURL=data:application/json;base64,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