"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Setuptools = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const setuppy_1 = require("./setuppy");
const component_1 = require("../component");
const dependencies_1 = require("../dependencies");
/**
 * Manages packaging through setuptools with a setup.py script.
 */
class Setuptools extends component_1.Component {
    constructor(project, options) {
        super(project);
        this.pythonExec = options.pythonExec ?? "python";
        project.deps.addDependency("wheel@0.36.2", dependencies_1.DependencyType.DEVENV);
        project.deps.addDependency("twine@3.3.0", dependencies_1.DependencyType.DEVENV);
        project.packageTask.exec(`${this.pythonExec} setup.py sdist bdist_wheel`);
        this.publishTestTask = project.addTask("publish:test", {
            description: "Uploads the package against a test PyPI endpoint.",
            exec: "twine upload --repository-url https://test.pypi.org/legacy/ dist/*",
        });
        this.publishTask = project.addTask("publish", {
            description: "Uploads the package against a test PyPI endpoint.",
            exec: "twine upload dist/*",
        });
        const packages = options.packageName ? [options.packageName] : undefined;
        new setuppy_1.SetupPy(project, {
            name: project.name,
            packages: packages,
            authorName: options.authorName,
            authorEmail: options.authorEmail,
            version: options.version,
            description: options.description,
            license: options.license,
            homepage: options.homepage,
            classifiers: options.classifiers,
            ...options.setupConfig,
        });
    }
}
exports.Setuptools = Setuptools;
_a = JSII_RTTI_SYMBOL_1;
Setuptools[_a] = { fqn: "projen.python.Setuptools", version: "0.98.4" };
//# sourceMappingURL=data:application/json;base64,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