export type BumpType = RelativeBumpType | {
    bump: "absolute";
    absolute: string;
};
export type RelativeBumpType = {
    bump: "none";
} | {
    bump: "relative";
    relative: MajorMinorPatch;
};
export type MajorMinorPatch = "major" | "minor" | "patch";
/**
 * Reverse engineer the bump type from two version
 *
 * We have to do this because `commit-and-tag-version` will not just tell
 * us the type of bump it performed, it only prints the new version.
 */
export declare function relativeBumpType(v0: string, v1: string): RelativeBumpType;
/**
 * Bump type to string
 */
export declare function renderBumpType(bumpType: BumpType): string;
/**
 * String to bump type
 */
export declare function parseBumpType(x: string): BumpType;
/**
 * Perform the given bump on the given version, returning the new version
 */
export declare function performBump(baseVersion: string, bumpType: BumpType): string;
export declare function isMajorMinorPatch(v: string): v is MajorMinorPatch;
