"use strict";
// a builtin task that sets the "version" field of the file
// specified in OUTFILE to "0.0.0"
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
const outfile = process.env.OUTFILE;
if (!outfile) {
    throw new Error("OUTFILE is required");
}
if (!(0, fs_1.existsSync)(outfile)) {
    process.exit(0); // nothing to do
}
const content = JSON.parse((0, fs_1.readFileSync)(outfile, "utf8"));
content.version = "0.0.0";
(0, fs_1.writeFileSync)(outfile, JSON.stringify(content, undefined, 2) + "\n");
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVzZXQtdmVyc2lvbi50YXNrLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3JlbGVhc2UvcmVzZXQtdmVyc2lvbi50YXNrLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSwyREFBMkQ7QUFDM0Qsa0NBQWtDOztBQUVsQywyQkFBNkQ7QUFFN0QsTUFBTSxPQUFPLEdBQUcsT0FBTyxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUM7QUFDcEMsSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFDO0lBQ2IsTUFBTSxJQUFJLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0FBQ3pDLENBQUM7QUFFRCxJQUFJLENBQUMsSUFBQSxlQUFVLEVBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztJQUN6QixPQUFPLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsZ0JBQWdCO0FBQ25DLENBQUM7QUFFRCxNQUFNLE9BQU8sR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUEsaUJBQVksRUFBQyxPQUFPLEVBQUUsTUFBTSxDQUFDLENBQUMsQ0FBQztBQUMxRCxPQUFPLENBQUMsT0FBTyxHQUFHLE9BQU8sQ0FBQztBQUMxQixJQUFBLGtCQUFhLEVBQUMsT0FBTyxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxFQUFFLFNBQVMsRUFBRSxDQUFDLENBQUMsR0FBRyxJQUFJLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIGEgYnVpbHRpbiB0YXNrIHRoYXQgc2V0cyB0aGUgXCJ2ZXJzaW9uXCIgZmllbGQgb2YgdGhlIGZpbGVcbi8vIHNwZWNpZmllZCBpbiBPVVRGSUxFIHRvIFwiMC4wLjBcIlxuXG5pbXBvcnQgeyBleGlzdHNTeW5jLCByZWFkRmlsZVN5bmMsIHdyaXRlRmlsZVN5bmMgfSBmcm9tIFwiZnNcIjtcblxuY29uc3Qgb3V0ZmlsZSA9IHByb2Nlc3MuZW52Lk9VVEZJTEU7XG5pZiAoIW91dGZpbGUpIHtcbiAgdGhyb3cgbmV3IEVycm9yKFwiT1VURklMRSBpcyByZXF1aXJlZFwiKTtcbn1cblxuaWYgKCFleGlzdHNTeW5jKG91dGZpbGUpKSB7XG4gIHByb2Nlc3MuZXhpdCgwKTsgLy8gbm90aGluZyB0byBkb1xufVxuXG5jb25zdCBjb250ZW50ID0gSlNPTi5wYXJzZShyZWFkRmlsZVN5bmMob3V0ZmlsZSwgXCJ1dGY4XCIpKTtcbmNvbnRlbnQudmVyc2lvbiA9IFwiMC4wLjBcIjtcbndyaXRlRmlsZVN5bmMob3V0ZmlsZSwgSlNPTi5zdHJpbmdpZnkoY29udGVudCwgdW5kZWZpbmVkLCAyKSArIFwiXFxuXCIpO1xuIl19