"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeLaunchConfig = exports.InternalConsoleOptions = exports.Console = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const json_1 = require("../json");
/**
 * Controls where to launch the debug target
 * Source: https://code.visualstudio.com/docs/editor/debugging#_launchjson-attributes
 */
var Console;
(function (Console) {
    Console["INTERNAL_CONSOLE"] = "internalConsole";
    Console["INTEGRATED_TERMINAL"] = "integratedTerminal";
    Console["EXTERNAL_TERMINAL"] = "externalTerminal";
})(Console || (exports.Console = Console = {}));
/**
 * Controls the visibility of the VSCode Debug Console panel during a debugging session
 * Source: https://code.visualstudio.com/docs/editor/debugging#_launchjson-attributes
 */
var InternalConsoleOptions;
(function (InternalConsoleOptions) {
    InternalConsoleOptions["NEVER_OPEN"] = "neverOpen";
    InternalConsoleOptions["OPEN_ON_FIRST_SESSION_START"] = "openOnFirstSessionStart";
    InternalConsoleOptions["OPEN_ON_SESSION_START"] = "openOnSessionStart";
})(InternalConsoleOptions || (exports.InternalConsoleOptions = InternalConsoleOptions = {}));
/**
 * VSCode launch configuration file (launch.json), useful for enabling in-editor debugger
 */
class VsCodeLaunchConfig extends component_1.Component {
    static renderLaunchConfig(cfg) {
        if (!cfg.env) {
            return cfg;
        }
        return {
            ...cfg,
            env: Object.fromEntries(Object.entries(cfg.env).map(([key, value]) => [
                key,
                value === false ? null : value,
            ])),
        };
    }
    constructor(vscode) {
        super(vscode.project);
        this.content = {
            version: "0.2.0",
            configurations: [],
        };
        this.file = new json_1.JsonFile(vscode.project, ".vscode/launch.json", {
            obj: () => ({
                ...this.content,
                configurations: this.content.configurations.map(VsCodeLaunchConfig.renderLaunchConfig),
            }),
        });
    }
    /**
     * Adds a VsCodeLaunchConfigurationEntry (e.g. a node.js debugger) to `.vscode/launch.json.
     * Each configuration entry has following mandatory fields: type, request and name.
     * See https://code.visualstudio.com/docs/editor/debugging#_launchjson-attributes for details.
     * @param cfg VsCodeLaunchConfigurationEntry
     */
    addConfiguration(cfg) {
        this.content.configurations.push(cfg);
    }
    /**
     * Adds an input variable with type `promptString` to `.vscode/launch.json`.
     *
     * See https://code.visualstudio.com/docs/editor/variables-reference#_input-variables for details.
     * @param cfg VsCodeLaunchPromptStringInputEntry
     */
    addPromptStringInput(cfg) {
        this.addInput({
            ...cfg,
            type: InputCommandType.PROMPT_STRING,
        });
    }
    /**
     * Adds an input variable with type `pickString` to `.vscode/launch.json`.
     *
     * See https://code.visualstudio.com/docs/editor/variables-reference#_input-variables for details.
     * @param cfg VsCodeLaunchPickStringInputEntry
     */
    addPickStringInput(cfg) {
        this.addInput({
            ...cfg,
            type: InputCommandType.PICK_STRING,
        });
    }
    /**
     * Adds an input variable with type `command` to `.vscode/launch.json`.
     *
     * See https://code.visualstudio.com/docs/editor/variables-reference#_input-variables for details.
     * @param cfg VsCodeLaunchCommandInputEntry
     */
    addCommandInput(cfg) {
        this.addInput({
            ...cfg,
            type: InputCommandType.COMMAND,
        });
    }
    addInput(input) {
        var _b;
        (_b = this.content).inputs ?? (_b.inputs = []);
        this.content.inputs.push(input);
    }
}
exports.VsCodeLaunchConfig = VsCodeLaunchConfig;
_a = JSII_RTTI_SYMBOL_1;
VsCodeLaunchConfig[_a] = { fqn: "projen.vscode.VsCodeLaunchConfig", version: "0.98.4" };
var InputCommandType;
(function (InputCommandType) {
    InputCommandType["PROMPT_STRING"] = "promptString";
    InputCommandType["PICK_STRING"] = "pickString";
    InputCommandType["COMMAND"] = "command";
})(InputCommandType || (InputCommandType = {}));
//# sourceMappingURL=data:application/json;base64,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