# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'RemediationRecipeDetectConfiguration',
    'RemediationRecipeNetworkConfiguration',
    'RemediationRecipeScmConfiguration',
    'RemediationRecipeVerifyConfiguration',
    'RemediationRunStage',
    'VulnerabilityAuditApplicationDependency',
    'VulnerabilityAuditConfiguration',
    'VulnerabilityAuditSource',
    'VulnerabilityAuditUsageData',
    'VulnerabilityAuditVulnerability',
    'GetKnowledgebasesFilterResult',
    'GetKnowledgebasesKnowledgeBaseCollectionResult',
    'GetKnowledgebasesKnowledgeBaseCollectionItemResult',
    'GetRemediationRecipeDetectConfigurationResult',
    'GetRemediationRecipeNetworkConfigurationResult',
    'GetRemediationRecipeScmConfigurationResult',
    'GetRemediationRecipeVerifyConfigurationResult',
    'GetRemediationRecipesFilterResult',
    'GetRemediationRecipesRemediationRecipeCollectionResult',
    'GetRemediationRecipesRemediationRecipeCollectionItemResult',
    'GetRemediationRecipesRemediationRecipeCollectionItemDetectConfigurationResult',
    'GetRemediationRecipesRemediationRecipeCollectionItemNetworkConfigurationResult',
    'GetRemediationRecipesRemediationRecipeCollectionItemScmConfigurationResult',
    'GetRemediationRecipesRemediationRecipeCollectionItemVerifyConfigurationResult',
    'GetRemediationRunApplicationDependencyRecommendationsApplicationDependencyRecommendationCollectionResult',
    'GetRemediationRunApplicationDependencyRecommendationsApplicationDependencyRecommendationCollectionItemResult',
    'GetRemediationRunApplicationDependencyRecommendationsFilterResult',
    'GetRemediationRunStageResult',
    'GetRemediationRunStagePipelinePropertyResult',
    'GetRemediationRunStagePullRequestPropertyResult',
    'GetRemediationRunStagesFilterResult',
    'GetRemediationRunStagesRemediationRunStageCollectionResult',
    'GetRemediationRunStagesRemediationRunStageCollectionItemResult',
    'GetRemediationRunStagesRemediationRunStageCollectionItemPipelinePropertyResult',
    'GetRemediationRunStagesRemediationRunStageCollectionItemPullRequestPropertyResult',
    'GetRemediationRunsFilterResult',
    'GetRemediationRunsRemediationRunCollectionResult',
    'GetRemediationRunsRemediationRunCollectionItemResult',
    'GetRemediationRunsRemediationRunCollectionItemStageResult',
    'GetVulnerabilityAuditApplicationDependencyResult',
    'GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionResult',
    'GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemResult',
    'GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemVulnerabilityResult',
    'GetVulnerabilityAuditApplicationDependencyVulnerabilitiesFilterResult',
    'GetVulnerabilityAuditApplicationDependencyVulnerabilityItemResult',
    'GetVulnerabilityAuditApplicationDependencyVulnerabilityItemVulnerabilityResult',
    'GetVulnerabilityAuditConfigurationResult',
    'GetVulnerabilityAuditSourceResult',
    'GetVulnerabilityAuditUsageDataResult',
    'GetVulnerabilityAuditVulnerabilityResult',
    'GetVulnerabilityAuditsFilterResult',
    'GetVulnerabilityAuditsVulnerabilityAuditCollectionResult',
    'GetVulnerabilityAuditsVulnerabilityAuditCollectionItemResult',
    'GetVulnerabilityAuditsVulnerabilityAuditCollectionItemApplicationDependencyResult',
    'GetVulnerabilityAuditsVulnerabilityAuditCollectionItemConfigurationResult',
    'GetVulnerabilityAuditsVulnerabilityAuditCollectionItemSourceResult',
    'GetVulnerabilityAuditsVulnerabilityAuditCollectionItemUsageDataResult',
    'GetVulnerabilityAuditsVulnerabilityAuditCollectionItemVulnerabilityResult',
]

@pulumi.output_type
class RemediationRecipeDetectConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxPermissibleCvssV2score":
            suggest = "max_permissible_cvss_v2score"
        elif key == "maxPermissibleCvssV3score":
            suggest = "max_permissible_cvss_v3score"
        elif key == "maxPermissibleSeverity":
            suggest = "max_permissible_severity"
        elif key == "upgradePolicy":
            suggest = "upgrade_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RemediationRecipeDetectConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RemediationRecipeDetectConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RemediationRecipeDetectConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclusions: Optional[Sequence[_builtins.str]] = None,
                 max_permissible_cvss_v2score: Optional[_builtins.float] = None,
                 max_permissible_cvss_v3score: Optional[_builtins.float] = None,
                 max_permissible_severity: Optional[_builtins.str] = None,
                 upgrade_policy: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] exclusions: (Updatable) The list of dependencies to be ignored by the recommendation algorithm. The dependency pattern is matched against the 'group:artifact:version' or the purl of a dependency. An asterisk (*) at the end in the dependency pattern acts as a wildcard and matches zero or more characters.
        :param _builtins.float max_permissible_cvss_v2score: (Updatable) The maximum Common Vulnerability Scoring System Version 2 (CVSS V2) score. A vulnerability with a CVSS V2 score below this value is not considered for remediation.
        :param _builtins.float max_permissible_cvss_v3score: (Updatable) The maximum Common Vulnerability Scoring System Version 3 (CVSS V3) score. A vulnerability with a CVSS V3 score below this value is not considered for patching.
        :param _builtins.str max_permissible_severity: (Updatable) The maximum ADM Severity. A vulnerability with an severity below this value is not considered for remediation.
        :param _builtins.str upgrade_policy: (Updatable) The upgrade policy for recommendations. The `Nearest` upgrade policy upgrades a dependency to the oldest version that meets both of the following criteria: it is newer than the current version and it is not affected by a vulnerability.
        """
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if max_permissible_cvss_v2score is not None:
            pulumi.set(__self__, "max_permissible_cvss_v2score", max_permissible_cvss_v2score)
        if max_permissible_cvss_v3score is not None:
            pulumi.set(__self__, "max_permissible_cvss_v3score", max_permissible_cvss_v3score)
        if max_permissible_severity is not None:
            pulumi.set(__self__, "max_permissible_severity", max_permissible_severity)
        if upgrade_policy is not None:
            pulumi.set(__self__, "upgrade_policy", upgrade_policy)

    @_builtins.property
    @pulumi.getter
    def exclusions(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) The list of dependencies to be ignored by the recommendation algorithm. The dependency pattern is matched against the 'group:artifact:version' or the purl of a dependency. An asterisk (*) at the end in the dependency pattern acts as a wildcard and matches zero or more characters.
        """
        return pulumi.get(self, "exclusions")

    @_builtins.property
    @pulumi.getter(name="maxPermissibleCvssV2score")
    def max_permissible_cvss_v2score(self) -> Optional[_builtins.float]:
        """
        (Updatable) The maximum Common Vulnerability Scoring System Version 2 (CVSS V2) score. A vulnerability with a CVSS V2 score below this value is not considered for remediation.
        """
        return pulumi.get(self, "max_permissible_cvss_v2score")

    @_builtins.property
    @pulumi.getter(name="maxPermissibleCvssV3score")
    def max_permissible_cvss_v3score(self) -> Optional[_builtins.float]:
        """
        (Updatable) The maximum Common Vulnerability Scoring System Version 3 (CVSS V3) score. A vulnerability with a CVSS V3 score below this value is not considered for patching.
        """
        return pulumi.get(self, "max_permissible_cvss_v3score")

    @_builtins.property
    @pulumi.getter(name="maxPermissibleSeverity")
    def max_permissible_severity(self) -> Optional[_builtins.str]:
        """
        (Updatable) The maximum ADM Severity. A vulnerability with an severity below this value is not considered for remediation.
        """
        return pulumi.get(self, "max_permissible_severity")

    @_builtins.property
    @pulumi.getter(name="upgradePolicy")
    def upgrade_policy(self) -> Optional[_builtins.str]:
        """
        (Updatable) The upgrade policy for recommendations. The `Nearest` upgrade policy upgrades a dependency to the oldest version that meets both of the following criteria: it is newer than the current version and it is not affected by a vulnerability.
        """
        return pulumi.get(self, "upgrade_policy")


@pulumi.output_type
class RemediationRecipeNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "nsgIds":
            suggest = "nsg_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RemediationRecipeNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RemediationRecipeNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RemediationRecipeNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: _builtins.str,
                 nsg_ids: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str subnet_id: (Updatable) The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the subnet.
        :param Sequence[_builtins.str] nsg_ids: (Updatable) The list of Oracle Cloud Identifiers ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) corresponding to Network Security Groups.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        (Updatable) The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the subnet.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) The list of Oracle Cloud Identifiers ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) corresponding to Network Security Groups.
        """
        return pulumi.get(self, "nsg_ids")


@pulumi.output_type
class RemediationRecipeScmConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isAutomergeEnabled":
            suggest = "is_automerge_enabled"
        elif key == "scmType":
            suggest = "scm_type"
        elif key == "buildFileLocation":
            suggest = "build_file_location"
        elif key == "externalScmType":
            suggest = "external_scm_type"
        elif key == "ociCodeRepositoryId":
            suggest = "oci_code_repository_id"
        elif key == "patSecretId":
            suggest = "pat_secret_id"
        elif key == "repositoryUrl":
            suggest = "repository_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RemediationRecipeScmConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RemediationRecipeScmConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RemediationRecipeScmConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: _builtins.str,
                 is_automerge_enabled: _builtins.bool,
                 scm_type: _builtins.str,
                 build_file_location: Optional[_builtins.str] = None,
                 external_scm_type: Optional[_builtins.str] = None,
                 oci_code_repository_id: Optional[_builtins.str] = None,
                 pat_secret_id: Optional[_builtins.str] = None,
                 repository_url: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str branch: (Updatable) The branch used by ADM to patch vulnerabilities.
        :param _builtins.bool is_automerge_enabled: (Updatable) If true, the Pull Request (PR) will be merged after the verify stage completes successfully     If false, the PR with the proposed changes must be reviewed and manually merged.
        :param _builtins.str scm_type: (Updatable) The type of Source Code Management.
        :param _builtins.str build_file_location: (Updatable) The location of the build file relative to the root of the repository. Only Maven build files (POM) are currently supported. If this property is not specified, ADM will use the build file located at the root of the repository.
        :param _builtins.str external_scm_type: (Updatable) The type of External Source Code Management.
        :param _builtins.str oci_code_repository_id: (Updatable) The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Oracle Cloud Infrastructure DevOps repository.
        :param _builtins.str pat_secret_id: (Updatable) The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Private Access Token (PAT) Secret. The secret provides the credentials necessary to authenticate against the SCM.
        :param _builtins.str repository_url: (Updatable) The repository URL for the SCM. For Non-Enterprise GitHub the expected format is https://github.com/[owner]/[repoName] For Enterprise GitHub the expected format is http(s)://[hostname]/api/v3/repos/[owner]/[repoName] For GitLab the expected format is https://gitlab.com/[groupName]/[repoName]
        :param _builtins.str username: (Updatable) The username for the SCM (to perform operations such as cloning or pushing via HTTP).
        """
        pulumi.set(__self__, "branch", branch)
        pulumi.set(__self__, "is_automerge_enabled", is_automerge_enabled)
        pulumi.set(__self__, "scm_type", scm_type)
        if build_file_location is not None:
            pulumi.set(__self__, "build_file_location", build_file_location)
        if external_scm_type is not None:
            pulumi.set(__self__, "external_scm_type", external_scm_type)
        if oci_code_repository_id is not None:
            pulumi.set(__self__, "oci_code_repository_id", oci_code_repository_id)
        if pat_secret_id is not None:
            pulumi.set(__self__, "pat_secret_id", pat_secret_id)
        if repository_url is not None:
            pulumi.set(__self__, "repository_url", repository_url)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> _builtins.str:
        """
        (Updatable) The branch used by ADM to patch vulnerabilities.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="isAutomergeEnabled")
    def is_automerge_enabled(self) -> _builtins.bool:
        """
        (Updatable) If true, the Pull Request (PR) will be merged after the verify stage completes successfully     If false, the PR with the proposed changes must be reviewed and manually merged.
        """
        return pulumi.get(self, "is_automerge_enabled")

    @_builtins.property
    @pulumi.getter(name="scmType")
    def scm_type(self) -> _builtins.str:
        """
        (Updatable) The type of Source Code Management.
        """
        return pulumi.get(self, "scm_type")

    @_builtins.property
    @pulumi.getter(name="buildFileLocation")
    def build_file_location(self) -> Optional[_builtins.str]:
        """
        (Updatable) The location of the build file relative to the root of the repository. Only Maven build files (POM) are currently supported. If this property is not specified, ADM will use the build file located at the root of the repository.
        """
        return pulumi.get(self, "build_file_location")

    @_builtins.property
    @pulumi.getter(name="externalScmType")
    def external_scm_type(self) -> Optional[_builtins.str]:
        """
        (Updatable) The type of External Source Code Management.
        """
        return pulumi.get(self, "external_scm_type")

    @_builtins.property
    @pulumi.getter(name="ociCodeRepositoryId")
    def oci_code_repository_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Oracle Cloud Infrastructure DevOps repository.
        """
        return pulumi.get(self, "oci_code_repository_id")

    @_builtins.property
    @pulumi.getter(name="patSecretId")
    def pat_secret_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Private Access Token (PAT) Secret. The secret provides the credentials necessary to authenticate against the SCM.
        """
        return pulumi.get(self, "pat_secret_id")

    @_builtins.property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> Optional[_builtins.str]:
        """
        (Updatable) The repository URL for the SCM. For Non-Enterprise GitHub the expected format is https://github.com/[owner]/[repoName] For Enterprise GitHub the expected format is http(s)://[hostname]/api/v3/repos/[owner]/[repoName] For GitLab the expected format is https://gitlab.com/[groupName]/[repoName]
        """
        return pulumi.get(self, "repository_url")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        (Updatable) The username for the SCM (to perform operations such as cloning or pushing via HTTP).
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class RemediationRecipeVerifyConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildServiceType":
            suggest = "build_service_type"
        elif key == "additionalParameters":
            suggest = "additional_parameters"
        elif key == "jenkinsUrl":
            suggest = "jenkins_url"
        elif key == "jobName":
            suggest = "job_name"
        elif key == "patSecretId":
            suggest = "pat_secret_id"
        elif key == "pipelineId":
            suggest = "pipeline_id"
        elif key == "repositoryUrl":
            suggest = "repository_url"
        elif key == "triggerSecretId":
            suggest = "trigger_secret_id"
        elif key == "workflowName":
            suggest = "workflow_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RemediationRecipeVerifyConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RemediationRecipeVerifyConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RemediationRecipeVerifyConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 build_service_type: _builtins.str,
                 additional_parameters: Optional[Mapping[str, _builtins.str]] = None,
                 jenkins_url: Optional[_builtins.str] = None,
                 job_name: Optional[_builtins.str] = None,
                 pat_secret_id: Optional[_builtins.str] = None,
                 pipeline_id: Optional[_builtins.str] = None,
                 repository_url: Optional[_builtins.str] = None,
                 trigger_secret_id: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None,
                 workflow_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str build_service_type: (Updatable) The type of Build Service.
        :param Mapping[str, _builtins.str] additional_parameters: (Updatable) Additional key-value pairs passed as parameters to the build service when running an experiment.
        :param _builtins.str jenkins_url: (Updatable) The URL that locates the Jenkins pipeline.
        :param _builtins.str job_name: (Updatable) The name of the Jenkins pipeline job that identifies the build pipeline.
        :param _builtins.str pat_secret_id: (Updatable) The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Private Access Token (PAT) Secret. The PAT provides the credentials to access the Jenkins Pipeline.
        :param _builtins.str pipeline_id: (Updatable) The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the user's DevOps Build Pipeline.
        :param _builtins.str repository_url: (Updatable) The location of the repository where the GitHub Actions is defined. For Non-Enterprise GitHub the expected format is https://github.com/[owner]/[repoName] For Enterprise GitHub the expected format is http(s)://[hostname]/api/v3/repos/[owner]/[repoName]
        :param _builtins.str trigger_secret_id: (Updatable) The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the trigger Secret. The Secret provides access to the trigger for a GitLab pipeline.
        :param _builtins.str username: (Updatable) The username that will be used to authenticate with Jenkins.
        :param _builtins.str workflow_name: (Updatable) The name of the GitHub Actions workflow that defines the build pipeline.
        """
        pulumi.set(__self__, "build_service_type", build_service_type)
        if additional_parameters is not None:
            pulumi.set(__self__, "additional_parameters", additional_parameters)
        if jenkins_url is not None:
            pulumi.set(__self__, "jenkins_url", jenkins_url)
        if job_name is not None:
            pulumi.set(__self__, "job_name", job_name)
        if pat_secret_id is not None:
            pulumi.set(__self__, "pat_secret_id", pat_secret_id)
        if pipeline_id is not None:
            pulumi.set(__self__, "pipeline_id", pipeline_id)
        if repository_url is not None:
            pulumi.set(__self__, "repository_url", repository_url)
        if trigger_secret_id is not None:
            pulumi.set(__self__, "trigger_secret_id", trigger_secret_id)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if workflow_name is not None:
            pulumi.set(__self__, "workflow_name", workflow_name)

    @_builtins.property
    @pulumi.getter(name="buildServiceType")
    def build_service_type(self) -> _builtins.str:
        """
        (Updatable) The type of Build Service.
        """
        return pulumi.get(self, "build_service_type")

    @_builtins.property
    @pulumi.getter(name="additionalParameters")
    def additional_parameters(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Updatable) Additional key-value pairs passed as parameters to the build service when running an experiment.
        """
        return pulumi.get(self, "additional_parameters")

    @_builtins.property
    @pulumi.getter(name="jenkinsUrl")
    def jenkins_url(self) -> Optional[_builtins.str]:
        """
        (Updatable) The URL that locates the Jenkins pipeline.
        """
        return pulumi.get(self, "jenkins_url")

    @_builtins.property
    @pulumi.getter(name="jobName")
    def job_name(self) -> Optional[_builtins.str]:
        """
        (Updatable) The name of the Jenkins pipeline job that identifies the build pipeline.
        """
        return pulumi.get(self, "job_name")

    @_builtins.property
    @pulumi.getter(name="patSecretId")
    def pat_secret_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Private Access Token (PAT) Secret. The PAT provides the credentials to access the Jenkins Pipeline.
        """
        return pulumi.get(self, "pat_secret_id")

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the user's DevOps Build Pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @_builtins.property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> Optional[_builtins.str]:
        """
        (Updatable) The location of the repository where the GitHub Actions is defined. For Non-Enterprise GitHub the expected format is https://github.com/[owner]/[repoName] For Enterprise GitHub the expected format is http(s)://[hostname]/api/v3/repos/[owner]/[repoName]
        """
        return pulumi.get(self, "repository_url")

    @_builtins.property
    @pulumi.getter(name="triggerSecretId")
    def trigger_secret_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the trigger Secret. The Secret provides access to the trigger for a GitLab pipeline.
        """
        return pulumi.get(self, "trigger_secret_id")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        (Updatable) The username that will be used to authenticate with Jenkins.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="workflowName")
    def workflow_name(self) -> Optional[_builtins.str]:
        """
        (Updatable) The name of the GitHub Actions workflow that defines the build pipeline.
        """
        return pulumi.get(self, "workflow_name")


@pulumi.output_type
class RemediationRunStage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeCreated":
            suggest = "time_created"
        elif key == "timeFinished":
            suggest = "time_finished"
        elif key == "timeStarted":
            suggest = "time_started"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RemediationRunStage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RemediationRunStage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RemediationRunStage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 summary: Optional[_builtins.str] = None,
                 time_created: Optional[_builtins.str] = None,
                 time_finished: Optional[_builtins.str] = None,
                 time_started: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str summary: Information about the current step within the given stage.
        :param _builtins.str time_created: The creation date and time of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param _builtins.str time_finished: The date and time of the finish of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param _builtins.str time_started: The date and time of the start of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param _builtins.str type: The type of stage.
        """
        if summary is not None:
            pulumi.set(__self__, "summary", summary)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_finished is not None:
            pulumi.set(__self__, "time_finished", time_finished)
        if time_started is not None:
            pulumi.set(__self__, "time_started", time_started)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def summary(self) -> Optional[_builtins.str]:
        """
        Information about the current step within the given stage.
        """
        return pulumi.get(self, "summary")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[_builtins.str]:
        """
        The creation date and time of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> Optional[_builtins.str]:
        """
        The date and time of the finish of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_finished")

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[_builtins.str]:
        """
        The date and time of the start of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_started")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of stage.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class VulnerabilityAuditApplicationDependency(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeId":
            suggest = "node_id"
        elif key == "applicationDependencyNodeIds":
            suggest = "application_dependency_node_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityAuditApplicationDependency. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityAuditApplicationDependency.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityAuditApplicationDependency.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_id: _builtins.str,
                 application_dependency_node_ids: Optional[Sequence[_builtins.str]] = None,
                 gav: Optional[_builtins.str] = None,
                 purl: Optional[_builtins.str] = None):
        """
        :param _builtins.str node_id: Unique identifier of an application dependency, for example nodeId1. The nodeId can be generated by assigning a unique id to each application dependency in the tree of application dependencies. Every node, even those who share the same GAV, should have a different nodeId. The preferred way of constructing a nodeId is to assign incremental integers during a breadth first or depth first search. A nodeId can be reused only it refers to the same subtree of application dependencies. (This is not equivalent to referring to the same GAV, that is, a GAV can have multiple transitive dependencies.)
        :param Sequence[_builtins.str] application_dependency_node_ids: List of application dependencies on which this application dependency depends, each identified by its nodeId.
        :param _builtins.str gav: Group Artifact Version (GAV) identifier (Group:Artifact:Version). Example: org.graalvm.nativeimage:svm:21.1.0. "N/A" for non-maven artifacts.
        :param _builtins.str purl: Package URL identifier, e.g. pkg:maven/org.graalvm.nativeimage/svm@21.1.0
        """
        pulumi.set(__self__, "node_id", node_id)
        if application_dependency_node_ids is not None:
            pulumi.set(__self__, "application_dependency_node_ids", application_dependency_node_ids)
        if gav is not None:
            pulumi.set(__self__, "gav", gav)
        if purl is not None:
            pulumi.set(__self__, "purl", purl)

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> _builtins.str:
        """
        Unique identifier of an application dependency, for example nodeId1. The nodeId can be generated by assigning a unique id to each application dependency in the tree of application dependencies. Every node, even those who share the same GAV, should have a different nodeId. The preferred way of constructing a nodeId is to assign incremental integers during a breadth first or depth first search. A nodeId can be reused only it refers to the same subtree of application dependencies. (This is not equivalent to referring to the same GAV, that is, a GAV can have multiple transitive dependencies.)
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter(name="applicationDependencyNodeIds")
    def application_dependency_node_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of application dependencies on which this application dependency depends, each identified by its nodeId.
        """
        return pulumi.get(self, "application_dependency_node_ids")

    @_builtins.property
    @pulumi.getter
    def gav(self) -> Optional[_builtins.str]:
        """
        Group Artifact Version (GAV) identifier (Group:Artifact:Version). Example: org.graalvm.nativeimage:svm:21.1.0. "N/A" for non-maven artifacts.
        """
        return pulumi.get(self, "gav")

    @_builtins.property
    @pulumi.getter
    def purl(self) -> Optional[_builtins.str]:
        """
        Package URL identifier, e.g. pkg:maven/org.graalvm.nativeimage/svm@21.1.0
        """
        return pulumi.get(self, "purl")


@pulumi.output_type
class VulnerabilityAuditConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxPermissibleCvssV2score":
            suggest = "max_permissible_cvss_v2score"
        elif key == "maxPermissibleCvssV3score":
            suggest = "max_permissible_cvss_v3score"
        elif key == "maxPermissibleSeverity":
            suggest = "max_permissible_severity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityAuditConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityAuditConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityAuditConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclusions: Optional[Sequence[_builtins.str]] = None,
                 max_permissible_cvss_v2score: Optional[_builtins.float] = None,
                 max_permissible_cvss_v3score: Optional[_builtins.float] = None,
                 max_permissible_severity: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] exclusions: A vulnerable application dependency is ignored if its name matches any of the items in `exclusions`. An asterisk (*) in the dependency pattern acts as a wildcard and matches zero or more characters.
        :param _builtins.float max_permissible_cvss_v2score: A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        :param _builtins.float max_permissible_cvss_v3score: A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        :param _builtins.str max_permissible_severity: A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleSeverity.
        """
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if max_permissible_cvss_v2score is not None:
            pulumi.set(__self__, "max_permissible_cvss_v2score", max_permissible_cvss_v2score)
        if max_permissible_cvss_v3score is not None:
            pulumi.set(__self__, "max_permissible_cvss_v3score", max_permissible_cvss_v3score)
        if max_permissible_severity is not None:
            pulumi.set(__self__, "max_permissible_severity", max_permissible_severity)

    @_builtins.property
    @pulumi.getter
    def exclusions(self) -> Optional[Sequence[_builtins.str]]:
        """
        A vulnerable application dependency is ignored if its name matches any of the items in `exclusions`. An asterisk (*) in the dependency pattern acts as a wildcard and matches zero or more characters.
        """
        return pulumi.get(self, "exclusions")

    @_builtins.property
    @pulumi.getter(name="maxPermissibleCvssV2score")
    def max_permissible_cvss_v2score(self) -> Optional[_builtins.float]:
        """
        A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        """
        return pulumi.get(self, "max_permissible_cvss_v2score")

    @_builtins.property
    @pulumi.getter(name="maxPermissibleCvssV3score")
    def max_permissible_cvss_v3score(self) -> Optional[_builtins.float]:
        """
        A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        """
        return pulumi.get(self, "max_permissible_cvss_v3score")

    @_builtins.property
    @pulumi.getter(name="maxPermissibleSeverity")
    def max_permissible_severity(self) -> Optional[_builtins.str]:
        """
        A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleSeverity.
        """
        return pulumi.get(self, "max_permissible_severity")


@pulumi.output_type
class VulnerabilityAuditSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ociResourceId":
            suggest = "oci_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityAuditSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityAuditSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityAuditSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 oci_resource_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Source type of the vulnerability audit.
        :param _builtins.str description: Description of the external resource source.
        :param _builtins.str oci_resource_id: The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Oracle Cloud Infrastructure resource that triggered the vulnerability audit.
        """
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if oci_resource_id is not None:
            pulumi.set(__self__, "oci_resource_id", oci_resource_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Source type of the vulnerability audit.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of the external resource source.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="ociResourceId")
    def oci_resource_id(self) -> Optional[_builtins.str]:
        """
        The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Oracle Cloud Infrastructure resource that triggered the vulnerability audit.
        """
        return pulumi.get(self, "oci_resource_id")


@pulumi.output_type
class VulnerabilityAuditUsageData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityAuditUsageData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityAuditUsageData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityAuditUsageData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: _builtins.str,
                 namespace: _builtins.str,
                 object: _builtins.str,
                 source_type: _builtins.str):
        """
        :param _builtins.str bucket: The Object Storage bucket to read the usage data from.
        :param _builtins.str namespace: The Object Storage namespace to read the usage data from.
        :param _builtins.str object: The Object Storage object name to read the usage data from.
        :param _builtins.str source_type: The destination type. Use `objectStorageTuple` when specifying the namespace, bucket name, and object name. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "source_type", source_type)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The Object Storage bucket to read the usage data from.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The Object Storage namespace to read the usage data from.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> _builtins.str:
        """
        The Object Storage object name to read the usage data from.
        """
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        The destination type. Use `objectStorageTuple` when specifying the namespace, bucket name, and object name. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class VulnerabilityAuditVulnerability(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cvssV2score":
            suggest = "cvss_v2score"
        elif key == "cvssV3score":
            suggest = "cvss_v3score"
        elif key == "isFalsePositive":
            suggest = "is_false_positive"
        elif key == "isIgnored":
            suggest = "is_ignored"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityAuditVulnerability. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityAuditVulnerability.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityAuditVulnerability.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cvss_v2score: Optional[_builtins.float] = None,
                 cvss_v3score: Optional[_builtins.float] = None,
                 id: Optional[_builtins.str] = None,
                 is_false_positive: Optional[_builtins.bool] = None,
                 is_ignored: Optional[_builtins.bool] = None,
                 severity: Optional[_builtins.str] = None,
                 source: Optional[_builtins.str] = None):
        """
        :param _builtins.float cvss_v2score: Common Vulnerability Scoring System (CVSS) Version 2, calculated from the metrics provided in the CVSS vector provided from the vulnerability source. This field is deprecated and will be removed in the future. The cvssV2Score can be obtained from the metrics field of the listVulnerabilities endpoint.
        :param _builtins.float cvss_v3score: Common Vulnerability Scoring System (CVSS) Version 3, calculated from the metrics provided in the CVSS vector provided from the vulnerability source. This field is deprecated and will be removed in the future. The cvssV3Score can be obtained from the metrics field of the listVulnerabilities endpoint.
        :param _builtins.str id: Unique vulnerability identifier, e.g. CVE-1999-0067.
        :param _builtins.bool is_false_positive: Indicates if the vulnerability is a false positive according to the usage data. If no usage data was provided or the service cannot infer usage of the vulnerable code then this property is `null`.
        :param _builtins.bool is_ignored: Indicates if the vulnerability was ignored according to the audit configuration.
        :param _builtins.str severity: ADM qualitative severity score. Can be either NONE, LOW, MEDIUM, HIGH or CRITICAL.
        :param _builtins.str source: vulnerability audit source.
        """
        if cvss_v2score is not None:
            pulumi.set(__self__, "cvss_v2score", cvss_v2score)
        if cvss_v3score is not None:
            pulumi.set(__self__, "cvss_v3score", cvss_v3score)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_false_positive is not None:
            pulumi.set(__self__, "is_false_positive", is_false_positive)
        if is_ignored is not None:
            pulumi.set(__self__, "is_ignored", is_ignored)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter(name="cvssV2score")
    def cvss_v2score(self) -> Optional[_builtins.float]:
        """
        Common Vulnerability Scoring System (CVSS) Version 2, calculated from the metrics provided in the CVSS vector provided from the vulnerability source. This field is deprecated and will be removed in the future. The cvssV2Score can be obtained from the metrics field of the listVulnerabilities endpoint.
        """
        return pulumi.get(self, "cvss_v2score")

    @_builtins.property
    @pulumi.getter(name="cvssV3score")
    def cvss_v3score(self) -> Optional[_builtins.float]:
        """
        Common Vulnerability Scoring System (CVSS) Version 3, calculated from the metrics provided in the CVSS vector provided from the vulnerability source. This field is deprecated and will be removed in the future. The cvssV3Score can be obtained from the metrics field of the listVulnerabilities endpoint.
        """
        return pulumi.get(self, "cvss_v3score")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Unique vulnerability identifier, e.g. CVE-1999-0067.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isFalsePositive")
    def is_false_positive(self) -> Optional[_builtins.bool]:
        """
        Indicates if the vulnerability is a false positive according to the usage data. If no usage data was provided or the service cannot infer usage of the vulnerable code then this property is `null`.
        """
        return pulumi.get(self, "is_false_positive")

    @_builtins.property
    @pulumi.getter(name="isIgnored")
    def is_ignored(self) -> Optional[_builtins.bool]:
        """
        Indicates if the vulnerability was ignored according to the audit configuration.
        """
        return pulumi.get(self, "is_ignored")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[_builtins.str]:
        """
        ADM qualitative severity score. Can be either NONE, LOW, MEDIUM, HIGH or CRITICAL.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[_builtins.str]:
        """
        vulnerability audit source.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class GetKnowledgebasesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetKnowledgebasesKnowledgeBaseCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetKnowledgebasesKnowledgeBaseCollectionItemResult']):
        """
        :param Sequence['GetKnowledgebasesKnowledgeBaseCollectionItemArgs'] items: List of knowledge base summaries.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetKnowledgebasesKnowledgeBaseCollectionItemResult']:
        """
        List of knowledge base summaries.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetKnowledgebasesKnowledgeBaseCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: A filter to return only resources that belong to the specified compartment identifier. Required only if the id query param is not specified.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: A filter to return only resources that match the specified identifier. Required only if the compartmentId query parameter is not specified.
        :param _builtins.str state: A filter to return only Knowledge Bases that match the specified lifecycleState.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The creation date and time of the knowledge base (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param _builtins.str time_updated: The date and time the knowledge base was last updated (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        A filter to return only resources that belong to the specified compartment identifier. Required only if the id query param is not specified.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        A filter to return only resources that match the specified identifier. Required only if the compartmentId query parameter is not specified.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only Knowledge Bases that match the specified lifecycleState.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The creation date and time of the knowledge base (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the knowledge base was last updated (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetRemediationRecipeDetectConfigurationResult(dict):
    def __init__(__self__, *,
                 exclusions: Sequence[_builtins.str],
                 max_permissible_cvss_v2score: _builtins.float,
                 max_permissible_cvss_v3score: _builtins.float,
                 max_permissible_severity: _builtins.str,
                 upgrade_policy: _builtins.str):
        """
        :param Sequence[_builtins.str] exclusions: The list of dependencies to be ignored by the recommendation algorithm. The dependency pattern is matched against the 'group:artifact:version' or the purl of a dependency. An asterisk (*) at the end in the dependency pattern acts as a wildcard and matches zero or more characters.
        :param _builtins.float max_permissible_cvss_v2score: The maximum Common Vulnerability Scoring System Version 2 (CVSS V2) score. A vulnerability with a CVSS V2 score below this value is not considered for remediation.
        :param _builtins.float max_permissible_cvss_v3score: The maximum Common Vulnerability Scoring System Version 3 (CVSS V3) score. A vulnerability with a CVSS V3 score below this value is not considered for patching.
        :param _builtins.str max_permissible_severity: The maximum ADM Severity. A vulnerability with an severity below this value is not considered for remediation.
        :param _builtins.str upgrade_policy: The upgrade policy for recommendations. The `Nearest` upgrade policy upgrades a dependency to the oldest version that meets both of the following criteria: it is newer than the current version and it is not affected by a vulnerability.
        """
        pulumi.set(__self__, "exclusions", exclusions)
        pulumi.set(__self__, "max_permissible_cvss_v2score", max_permissible_cvss_v2score)
        pulumi.set(__self__, "max_permissible_cvss_v3score", max_permissible_cvss_v3score)
        pulumi.set(__self__, "max_permissible_severity", max_permissible_severity)
        pulumi.set(__self__, "upgrade_policy", upgrade_policy)

    @_builtins.property
    @pulumi.getter
    def exclusions(self) -> Sequence[_builtins.str]:
        """
        The list of dependencies to be ignored by the recommendation algorithm. The dependency pattern is matched against the 'group:artifact:version' or the purl of a dependency. An asterisk (*) at the end in the dependency pattern acts as a wildcard and matches zero or more characters.
        """
        return pulumi.get(self, "exclusions")

    @_builtins.property
    @pulumi.getter(name="maxPermissibleCvssV2score")
    def max_permissible_cvss_v2score(self) -> _builtins.float:
        """
        The maximum Common Vulnerability Scoring System Version 2 (CVSS V2) score. A vulnerability with a CVSS V2 score below this value is not considered for remediation.
        """
        return pulumi.get(self, "max_permissible_cvss_v2score")

    @_builtins.property
    @pulumi.getter(name="maxPermissibleCvssV3score")
    def max_permissible_cvss_v3score(self) -> _builtins.float:
        """
        The maximum Common Vulnerability Scoring System Version 3 (CVSS V3) score. A vulnerability with a CVSS V3 score below this value is not considered for patching.
        """
        return pulumi.get(self, "max_permissible_cvss_v3score")

    @_builtins.property
    @pulumi.getter(name="maxPermissibleSeverity")
    def max_permissible_severity(self) -> _builtins.str:
        """
        The maximum ADM Severity. A vulnerability with an severity below this value is not considered for remediation.
        """
        return pulumi.get(self, "max_permissible_severity")

    @_builtins.property
    @pulumi.getter(name="upgradePolicy")
    def upgrade_policy(self) -> _builtins.str:
        """
        The upgrade policy for recommendations. The `Nearest` upgrade policy upgrades a dependency to the oldest version that meets both of the following criteria: it is newer than the current version and it is not affected by a vulnerability.
        """
        return pulumi.get(self, "upgrade_policy")


@pulumi.output_type
class GetRemediationRecipeNetworkConfigurationResult(dict):
    def __init__(__self__, *,
                 nsg_ids: Sequence[_builtins.str],
                 subnet_id: _builtins.str):
        """
        :param Sequence[_builtins.str] nsg_ids: The list of Oracle Cloud Identifiers ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) corresponding to Network Security Groups.
        :param _builtins.str subnet_id: The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the subnet.
        """
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[_builtins.str]:
        """
        The list of Oracle Cloud Identifiers ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) corresponding to Network Security Groups.
        """
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the subnet.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetRemediationRecipeScmConfigurationResult(dict):
    def __init__(__self__, *,
                 branch: _builtins.str,
                 build_file_location: _builtins.str,
                 external_scm_type: _builtins.str,
                 is_automerge_enabled: _builtins.bool,
                 oci_code_repository_id: _builtins.str,
                 pat_secret_id: _builtins.str,
                 repository_url: _builtins.str,
                 scm_type: _builtins.str,
                 username: _builtins.str):
        """
        :param _builtins.str branch: The branch used by ADM to patch vulnerabilities.
        :param _builtins.str build_file_location: The location of the build file relative to the root of the repository. Only Maven build files (POM) are currently supported. If this property is not specified, ADM will use the build file located at the root of the repository.
        :param _builtins.str external_scm_type: The type of External Source Code Management.
        :param _builtins.bool is_automerge_enabled: If true, the Pull Request (PR) will be merged after the verify stage completes successfully     If false, the PR with the proposed changes must be reviewed and manually merged.
        :param _builtins.str oci_code_repository_id: The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Oracle Cloud Infrastructure DevOps repository.
        :param _builtins.str pat_secret_id: The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Private Access Token (PAT) Secret. The PAT provides the credentials to access the Jenkins Pipeline.
        :param _builtins.str repository_url: The location of the repository where the GitHub Actions is defined. For Non-Enterprise GitHub the expected format is https://github.com/[owner]/[repoName] For Enterprise GitHub the expected format is http(s)://[hostname]/api/v3/repos/[owner]/[repoName]
        :param _builtins.str scm_type: The type of Source Code Management.
        :param _builtins.str username: The username that will be used to authenticate with Jenkins.
        """
        pulumi.set(__self__, "branch", branch)
        pulumi.set(__self__, "build_file_location", build_file_location)
        pulumi.set(__self__, "external_scm_type", external_scm_type)
        pulumi.set(__self__, "is_automerge_enabled", is_automerge_enabled)
        pulumi.set(__self__, "oci_code_repository_id", oci_code_repository_id)
        pulumi.set(__self__, "pat_secret_id", pat_secret_id)
        pulumi.set(__self__, "repository_url", repository_url)
        pulumi.set(__self__, "scm_type", scm_type)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> _builtins.str:
        """
        The branch used by ADM to patch vulnerabilities.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="buildFileLocation")
    def build_file_location(self) -> _builtins.str:
        """
        The location of the build file relative to the root of the repository. Only Maven build files (POM) are currently supported. If this property is not specified, ADM will use the build file located at the root of the repository.
        """
        return pulumi.get(self, "build_file_location")

    @_builtins.property
    @pulumi.getter(name="externalScmType")
    def external_scm_type(self) -> _builtins.str:
        """
        The type of External Source Code Management.
        """
        return pulumi.get(self, "external_scm_type")

    @_builtins.property
    @pulumi.getter(name="isAutomergeEnabled")
    def is_automerge_enabled(self) -> _builtins.bool:
        """
        If true, the Pull Request (PR) will be merged after the verify stage completes successfully     If false, the PR with the proposed changes must be reviewed and manually merged.
        """
        return pulumi.get(self, "is_automerge_enabled")

    @_builtins.property
    @pulumi.getter(name="ociCodeRepositoryId")
    def oci_code_repository_id(self) -> _builtins.str:
        """
        The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Oracle Cloud Infrastructure DevOps repository.
        """
        return pulumi.get(self, "oci_code_repository_id")

    @_builtins.property
    @pulumi.getter(name="patSecretId")
    def pat_secret_id(self) -> _builtins.str:
        """
        The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Private Access Token (PAT) Secret. The PAT provides the credentials to access the Jenkins Pipeline.
        """
        return pulumi.get(self, "pat_secret_id")

    @_builtins.property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> _builtins.str:
        """
        The location of the repository where the GitHub Actions is defined. For Non-Enterprise GitHub the expected format is https://github.com/[owner]/[repoName] For Enterprise GitHub the expected format is http(s)://[hostname]/api/v3/repos/[owner]/[repoName]
        """
        return pulumi.get(self, "repository_url")

    @_builtins.property
    @pulumi.getter(name="scmType")
    def scm_type(self) -> _builtins.str:
        """
        The type of Source Code Management.
        """
        return pulumi.get(self, "scm_type")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username that will be used to authenticate with Jenkins.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetRemediationRecipeVerifyConfigurationResult(dict):
    def __init__(__self__, *,
                 additional_parameters: Mapping[str, _builtins.str],
                 build_service_type: _builtins.str,
                 jenkins_url: _builtins.str,
                 job_name: _builtins.str,
                 pat_secret_id: _builtins.str,
                 pipeline_id: _builtins.str,
                 repository_url: _builtins.str,
                 trigger_secret_id: _builtins.str,
                 username: _builtins.str,
                 workflow_name: _builtins.str):
        """
        :param Mapping[str, _builtins.str] additional_parameters: Additional key-value pairs passed as parameters to the build service when running an experiment.
        :param _builtins.str build_service_type: The type of Build Service.
        :param _builtins.str jenkins_url: The URL that locates the Jenkins pipeline.
        :param _builtins.str job_name: The name of the Jenkins pipeline job that identifies the build pipeline.
        :param _builtins.str pat_secret_id: The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Private Access Token (PAT) Secret. The PAT provides the credentials to access the Jenkins Pipeline.
        :param _builtins.str pipeline_id: The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the user's DevOps Build Pipeline.
        :param _builtins.str repository_url: The location of the repository where the GitHub Actions is defined. For Non-Enterprise GitHub the expected format is https://github.com/[owner]/[repoName] For Enterprise GitHub the expected format is http(s)://[hostname]/api/v3/repos/[owner]/[repoName]
        :param _builtins.str trigger_secret_id: The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the trigger Secret. The Secret provides access to the trigger for a GitLab pipeline.
        :param _builtins.str username: The username that will be used to authenticate with Jenkins.
        :param _builtins.str workflow_name: The name of the GitHub Actions workflow that defines the build pipeline.
        """
        pulumi.set(__self__, "additional_parameters", additional_parameters)
        pulumi.set(__self__, "build_service_type", build_service_type)
        pulumi.set(__self__, "jenkins_url", jenkins_url)
        pulumi.set(__self__, "job_name", job_name)
        pulumi.set(__self__, "pat_secret_id", pat_secret_id)
        pulumi.set(__self__, "pipeline_id", pipeline_id)
        pulumi.set(__self__, "repository_url", repository_url)
        pulumi.set(__self__, "trigger_secret_id", trigger_secret_id)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "workflow_name", workflow_name)

    @_builtins.property
    @pulumi.getter(name="additionalParameters")
    def additional_parameters(self) -> Mapping[str, _builtins.str]:
        """
        Additional key-value pairs passed as parameters to the build service when running an experiment.
        """
        return pulumi.get(self, "additional_parameters")

    @_builtins.property
    @pulumi.getter(name="buildServiceType")
    def build_service_type(self) -> _builtins.str:
        """
        The type of Build Service.
        """
        return pulumi.get(self, "build_service_type")

    @_builtins.property
    @pulumi.getter(name="jenkinsUrl")
    def jenkins_url(self) -> _builtins.str:
        """
        The URL that locates the Jenkins pipeline.
        """
        return pulumi.get(self, "jenkins_url")

    @_builtins.property
    @pulumi.getter(name="jobName")
    def job_name(self) -> _builtins.str:
        """
        The name of the Jenkins pipeline job that identifies the build pipeline.
        """
        return pulumi.get(self, "job_name")

    @_builtins.property
    @pulumi.getter(name="patSecretId")
    def pat_secret_id(self) -> _builtins.str:
        """
        The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Private Access Token (PAT) Secret. The PAT provides the credentials to access the Jenkins Pipeline.
        """
        return pulumi.get(self, "pat_secret_id")

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> _builtins.str:
        """
        The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the user's DevOps Build Pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @_builtins.property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> _builtins.str:
        """
        The location of the repository where the GitHub Actions is defined. For Non-Enterprise GitHub the expected format is https://github.com/[owner]/[repoName] For Enterprise GitHub the expected format is http(s)://[hostname]/api/v3/repos/[owner]/[repoName]
        """
        return pulumi.get(self, "repository_url")

    @_builtins.property
    @pulumi.getter(name="triggerSecretId")
    def trigger_secret_id(self) -> _builtins.str:
        """
        The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the trigger Secret. The Secret provides access to the trigger for a GitLab pipeline.
        """
        return pulumi.get(self, "trigger_secret_id")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username that will be used to authenticate with Jenkins.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="workflowName")
    def workflow_name(self) -> _builtins.str:
        """
        The name of the GitHub Actions workflow that defines the build pipeline.
        """
        return pulumi.get(self, "workflow_name")


@pulumi.output_type
class GetRemediationRecipesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRemediationRecipesRemediationRecipeCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRemediationRecipesRemediationRecipeCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRemediationRecipesRemediationRecipeCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRemediationRecipesRemediationRecipeCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 detect_configurations: Sequence['outputs.GetRemediationRecipesRemediationRecipeCollectionItemDetectConfigurationResult'],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_run_triggered_on_kb_change: _builtins.bool,
                 knowledge_base_id: _builtins.str,
                 network_configurations: Sequence['outputs.GetRemediationRecipesRemediationRecipeCollectionItemNetworkConfigurationResult'],
                 scm_configurations: Sequence['outputs.GetRemediationRecipesRemediationRecipeCollectionItemScmConfigurationResult'],
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 verify_configurations: Sequence['outputs.GetRemediationRecipesRemediationRecipeCollectionItemVerifyConfigurationResult']):
        """
        :param _builtins.str compartment_id: A filter to return only resources that belong to the specified compartment identifier. Required only if the id query param is not specified.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param Sequence['GetRemediationRecipesRemediationRecipeCollectionItemDetectConfigurationArgs'] detect_configurations: A configuration to define the constraints when detecting vulnerable dependencies and recommending remediations.
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: A filter to return only resources that match the specified identifier. Required only if the compartmentId query parameter is not specified.
        :param _builtins.bool is_run_triggered_on_kb_change: Boolean indicating if a run should be automatically triggered once the Knowledge Base contents are updated.
        :param _builtins.str knowledge_base_id: The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
        :param Sequence['GetRemediationRecipesRemediationRecipeCollectionItemNetworkConfigurationArgs'] network_configurations: A network configuration defines the required network characteristics for the remediation run of the recipe to access the source repository and/or verify build services.
        :param Sequence['GetRemediationRecipesRemediationRecipeCollectionItemScmConfigurationArgs'] scm_configurations: A configuration for the Source Code Management tool/platform used by a remediation recipe.
        :param _builtins.str state: A filter to return only Remediation Recipes that match the specified lifecycleState.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The creation date and time of the Remediation Recipe (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param _builtins.str time_updated: The date and time the Remediation Recipe was last updated (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param Sequence['GetRemediationRecipesRemediationRecipeCollectionItemVerifyConfigurationArgs'] verify_configurations: The Verify stage configuration specifies a build service to run a pipeline for the recommended code changes. The build pipeline will be initiated to ensure that there is no breaking change after the dependency versions have been updated in source to avoid vulnerabilities.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "detect_configurations", detect_configurations)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_run_triggered_on_kb_change", is_run_triggered_on_kb_change)
        pulumi.set(__self__, "knowledge_base_id", knowledge_base_id)
        pulumi.set(__self__, "network_configurations", network_configurations)
        pulumi.set(__self__, "scm_configurations", scm_configurations)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "verify_configurations", verify_configurations)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        A filter to return only resources that belong to the specified compartment identifier. Required only if the id query param is not specified.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="detectConfigurations")
    def detect_configurations(self) -> Sequence['outputs.GetRemediationRecipesRemediationRecipeCollectionItemDetectConfigurationResult']:
        """
        A configuration to define the constraints when detecting vulnerable dependencies and recommending remediations.
        """
        return pulumi.get(self, "detect_configurations")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        A filter to return only resources that match the specified identifier. Required only if the compartmentId query parameter is not specified.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isRunTriggeredOnKbChange")
    def is_run_triggered_on_kb_change(self) -> _builtins.bool:
        """
        Boolean indicating if a run should be automatically triggered once the Knowledge Base contents are updated.
        """
        return pulumi.get(self, "is_run_triggered_on_kb_change")

    @_builtins.property
    @pulumi.getter(name="knowledgeBaseId")
    def knowledge_base_id(self) -> _builtins.str:
        """
        The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the knowledge base.
        """
        return pulumi.get(self, "knowledge_base_id")

    @_builtins.property
    @pulumi.getter(name="networkConfigurations")
    def network_configurations(self) -> Sequence['outputs.GetRemediationRecipesRemediationRecipeCollectionItemNetworkConfigurationResult']:
        """
        A network configuration defines the required network characteristics for the remediation run of the recipe to access the source repository and/or verify build services.
        """
        return pulumi.get(self, "network_configurations")

    @_builtins.property
    @pulumi.getter(name="scmConfigurations")
    def scm_configurations(self) -> Sequence['outputs.GetRemediationRecipesRemediationRecipeCollectionItemScmConfigurationResult']:
        """
        A configuration for the Source Code Management tool/platform used by a remediation recipe.
        """
        return pulumi.get(self, "scm_configurations")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only Remediation Recipes that match the specified lifecycleState.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The creation date and time of the Remediation Recipe (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the Remediation Recipe was last updated (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="verifyConfigurations")
    def verify_configurations(self) -> Sequence['outputs.GetRemediationRecipesRemediationRecipeCollectionItemVerifyConfigurationResult']:
        """
        The Verify stage configuration specifies a build service to run a pipeline for the recommended code changes. The build pipeline will be initiated to ensure that there is no breaking change after the dependency versions have been updated in source to avoid vulnerabilities.
        """
        return pulumi.get(self, "verify_configurations")


@pulumi.output_type
class GetRemediationRecipesRemediationRecipeCollectionItemDetectConfigurationResult(dict):
    def __init__(__self__, *,
                 exclusions: Sequence[_builtins.str],
                 max_permissible_cvss_v2score: _builtins.float,
                 max_permissible_cvss_v3score: _builtins.float,
                 max_permissible_severity: _builtins.str,
                 upgrade_policy: _builtins.str):
        """
        :param Sequence[_builtins.str] exclusions: The list of dependencies to be ignored by the recommendation algorithm. The dependency pattern is matched against the 'group:artifact:version' or the purl of a dependency. An asterisk (*) at the end in the dependency pattern acts as a wildcard and matches zero or more characters.
        :param _builtins.float max_permissible_cvss_v2score: The maximum Common Vulnerability Scoring System Version 2 (CVSS V2) score. A vulnerability with a CVSS V2 score below this value is not considered for remediation.
        :param _builtins.float max_permissible_cvss_v3score: The maximum Common Vulnerability Scoring System Version 3 (CVSS V3) score. A vulnerability with a CVSS V3 score below this value is not considered for patching.
        :param _builtins.str max_permissible_severity: The maximum ADM Severity. A vulnerability with an severity below this value is not considered for remediation.
        :param _builtins.str upgrade_policy: The upgrade policy for recommendations. The `Nearest` upgrade policy upgrades a dependency to the oldest version that meets both of the following criteria: it is newer than the current version and it is not affected by a vulnerability.
        """
        pulumi.set(__self__, "exclusions", exclusions)
        pulumi.set(__self__, "max_permissible_cvss_v2score", max_permissible_cvss_v2score)
        pulumi.set(__self__, "max_permissible_cvss_v3score", max_permissible_cvss_v3score)
        pulumi.set(__self__, "max_permissible_severity", max_permissible_severity)
        pulumi.set(__self__, "upgrade_policy", upgrade_policy)

    @_builtins.property
    @pulumi.getter
    def exclusions(self) -> Sequence[_builtins.str]:
        """
        The list of dependencies to be ignored by the recommendation algorithm. The dependency pattern is matched against the 'group:artifact:version' or the purl of a dependency. An asterisk (*) at the end in the dependency pattern acts as a wildcard and matches zero or more characters.
        """
        return pulumi.get(self, "exclusions")

    @_builtins.property
    @pulumi.getter(name="maxPermissibleCvssV2score")
    def max_permissible_cvss_v2score(self) -> _builtins.float:
        """
        The maximum Common Vulnerability Scoring System Version 2 (CVSS V2) score. A vulnerability with a CVSS V2 score below this value is not considered for remediation.
        """
        return pulumi.get(self, "max_permissible_cvss_v2score")

    @_builtins.property
    @pulumi.getter(name="maxPermissibleCvssV3score")
    def max_permissible_cvss_v3score(self) -> _builtins.float:
        """
        The maximum Common Vulnerability Scoring System Version 3 (CVSS V3) score. A vulnerability with a CVSS V3 score below this value is not considered for patching.
        """
        return pulumi.get(self, "max_permissible_cvss_v3score")

    @_builtins.property
    @pulumi.getter(name="maxPermissibleSeverity")
    def max_permissible_severity(self) -> _builtins.str:
        """
        The maximum ADM Severity. A vulnerability with an severity below this value is not considered for remediation.
        """
        return pulumi.get(self, "max_permissible_severity")

    @_builtins.property
    @pulumi.getter(name="upgradePolicy")
    def upgrade_policy(self) -> _builtins.str:
        """
        The upgrade policy for recommendations. The `Nearest` upgrade policy upgrades a dependency to the oldest version that meets both of the following criteria: it is newer than the current version and it is not affected by a vulnerability.
        """
        return pulumi.get(self, "upgrade_policy")


@pulumi.output_type
class GetRemediationRecipesRemediationRecipeCollectionItemNetworkConfigurationResult(dict):
    def __init__(__self__, *,
                 nsg_ids: Sequence[_builtins.str],
                 subnet_id: _builtins.str):
        """
        :param Sequence[_builtins.str] nsg_ids: The list of Oracle Cloud Identifiers ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) corresponding to Network Security Groups.
        :param _builtins.str subnet_id: The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the subnet.
        """
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[_builtins.str]:
        """
        The list of Oracle Cloud Identifiers ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) corresponding to Network Security Groups.
        """
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the subnet.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetRemediationRecipesRemediationRecipeCollectionItemScmConfigurationResult(dict):
    def __init__(__self__, *,
                 branch: _builtins.str,
                 build_file_location: _builtins.str,
                 external_scm_type: _builtins.str,
                 is_automerge_enabled: _builtins.bool,
                 oci_code_repository_id: _builtins.str,
                 pat_secret_id: _builtins.str,
                 repository_url: _builtins.str,
                 scm_type: _builtins.str,
                 username: _builtins.str):
        """
        :param _builtins.str branch: The branch used by ADM to patch vulnerabilities.
        :param _builtins.str build_file_location: The location of the build file relative to the root of the repository. Only Maven build files (POM) are currently supported. If this property is not specified, ADM will use the build file located at the root of the repository.
        :param _builtins.str external_scm_type: The type of External Source Code Management.
        :param _builtins.bool is_automerge_enabled: If true, the Pull Request (PR) will be merged after the verify stage completes successfully     If false, the PR with the proposed changes must be reviewed and manually merged.
        :param _builtins.str oci_code_repository_id: The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Oracle Cloud Infrastructure DevOps repository.
        :param _builtins.str pat_secret_id: The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Private Access Token (PAT) Secret. The PAT provides the credentials to access the Jenkins Pipeline.
        :param _builtins.str repository_url: The location of the repository where the GitHub Actions is defined. For Non-Enterprise GitHub the expected format is https://github.com/[owner]/[repoName] For Enterprise GitHub the expected format is http(s)://[hostname]/api/v3/repos/[owner]/[repoName]
        :param _builtins.str scm_type: The type of Source Code Management.
        :param _builtins.str username: The username that will be used to authenticate with Jenkins.
        """
        pulumi.set(__self__, "branch", branch)
        pulumi.set(__self__, "build_file_location", build_file_location)
        pulumi.set(__self__, "external_scm_type", external_scm_type)
        pulumi.set(__self__, "is_automerge_enabled", is_automerge_enabled)
        pulumi.set(__self__, "oci_code_repository_id", oci_code_repository_id)
        pulumi.set(__self__, "pat_secret_id", pat_secret_id)
        pulumi.set(__self__, "repository_url", repository_url)
        pulumi.set(__self__, "scm_type", scm_type)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> _builtins.str:
        """
        The branch used by ADM to patch vulnerabilities.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="buildFileLocation")
    def build_file_location(self) -> _builtins.str:
        """
        The location of the build file relative to the root of the repository. Only Maven build files (POM) are currently supported. If this property is not specified, ADM will use the build file located at the root of the repository.
        """
        return pulumi.get(self, "build_file_location")

    @_builtins.property
    @pulumi.getter(name="externalScmType")
    def external_scm_type(self) -> _builtins.str:
        """
        The type of External Source Code Management.
        """
        return pulumi.get(self, "external_scm_type")

    @_builtins.property
    @pulumi.getter(name="isAutomergeEnabled")
    def is_automerge_enabled(self) -> _builtins.bool:
        """
        If true, the Pull Request (PR) will be merged after the verify stage completes successfully     If false, the PR with the proposed changes must be reviewed and manually merged.
        """
        return pulumi.get(self, "is_automerge_enabled")

    @_builtins.property
    @pulumi.getter(name="ociCodeRepositoryId")
    def oci_code_repository_id(self) -> _builtins.str:
        """
        The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Oracle Cloud Infrastructure DevOps repository.
        """
        return pulumi.get(self, "oci_code_repository_id")

    @_builtins.property
    @pulumi.getter(name="patSecretId")
    def pat_secret_id(self) -> _builtins.str:
        """
        The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Private Access Token (PAT) Secret. The PAT provides the credentials to access the Jenkins Pipeline.
        """
        return pulumi.get(self, "pat_secret_id")

    @_builtins.property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> _builtins.str:
        """
        The location of the repository where the GitHub Actions is defined. For Non-Enterprise GitHub the expected format is https://github.com/[owner]/[repoName] For Enterprise GitHub the expected format is http(s)://[hostname]/api/v3/repos/[owner]/[repoName]
        """
        return pulumi.get(self, "repository_url")

    @_builtins.property
    @pulumi.getter(name="scmType")
    def scm_type(self) -> _builtins.str:
        """
        The type of Source Code Management.
        """
        return pulumi.get(self, "scm_type")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username that will be used to authenticate with Jenkins.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetRemediationRecipesRemediationRecipeCollectionItemVerifyConfigurationResult(dict):
    def __init__(__self__, *,
                 additional_parameters: Mapping[str, _builtins.str],
                 build_service_type: _builtins.str,
                 jenkins_url: _builtins.str,
                 job_name: _builtins.str,
                 pat_secret_id: _builtins.str,
                 pipeline_id: _builtins.str,
                 repository_url: _builtins.str,
                 trigger_secret_id: _builtins.str,
                 username: _builtins.str,
                 workflow_name: _builtins.str):
        """
        :param Mapping[str, _builtins.str] additional_parameters: Additional key-value pairs passed as parameters to the build service when running an experiment.
        :param _builtins.str build_service_type: The type of Build Service.
        :param _builtins.str jenkins_url: The URL that locates the Jenkins pipeline.
        :param _builtins.str job_name: The name of the Jenkins pipeline job that identifies the build pipeline.
        :param _builtins.str pat_secret_id: The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Private Access Token (PAT) Secret. The PAT provides the credentials to access the Jenkins Pipeline.
        :param _builtins.str pipeline_id: The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the user's DevOps Build Pipeline.
        :param _builtins.str repository_url: The location of the repository where the GitHub Actions is defined. For Non-Enterprise GitHub the expected format is https://github.com/[owner]/[repoName] For Enterprise GitHub the expected format is http(s)://[hostname]/api/v3/repos/[owner]/[repoName]
        :param _builtins.str trigger_secret_id: The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the trigger Secret. The Secret provides access to the trigger for a GitLab pipeline.
        :param _builtins.str username: The username that will be used to authenticate with Jenkins.
        :param _builtins.str workflow_name: The name of the GitHub Actions workflow that defines the build pipeline.
        """
        pulumi.set(__self__, "additional_parameters", additional_parameters)
        pulumi.set(__self__, "build_service_type", build_service_type)
        pulumi.set(__self__, "jenkins_url", jenkins_url)
        pulumi.set(__self__, "job_name", job_name)
        pulumi.set(__self__, "pat_secret_id", pat_secret_id)
        pulumi.set(__self__, "pipeline_id", pipeline_id)
        pulumi.set(__self__, "repository_url", repository_url)
        pulumi.set(__self__, "trigger_secret_id", trigger_secret_id)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "workflow_name", workflow_name)

    @_builtins.property
    @pulumi.getter(name="additionalParameters")
    def additional_parameters(self) -> Mapping[str, _builtins.str]:
        """
        Additional key-value pairs passed as parameters to the build service when running an experiment.
        """
        return pulumi.get(self, "additional_parameters")

    @_builtins.property
    @pulumi.getter(name="buildServiceType")
    def build_service_type(self) -> _builtins.str:
        """
        The type of Build Service.
        """
        return pulumi.get(self, "build_service_type")

    @_builtins.property
    @pulumi.getter(name="jenkinsUrl")
    def jenkins_url(self) -> _builtins.str:
        """
        The URL that locates the Jenkins pipeline.
        """
        return pulumi.get(self, "jenkins_url")

    @_builtins.property
    @pulumi.getter(name="jobName")
    def job_name(self) -> _builtins.str:
        """
        The name of the Jenkins pipeline job that identifies the build pipeline.
        """
        return pulumi.get(self, "job_name")

    @_builtins.property
    @pulumi.getter(name="patSecretId")
    def pat_secret_id(self) -> _builtins.str:
        """
        The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Private Access Token (PAT) Secret. The PAT provides the credentials to access the Jenkins Pipeline.
        """
        return pulumi.get(self, "pat_secret_id")

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> _builtins.str:
        """
        The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the user's DevOps Build Pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @_builtins.property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> _builtins.str:
        """
        The location of the repository where the GitHub Actions is defined. For Non-Enterprise GitHub the expected format is https://github.com/[owner]/[repoName] For Enterprise GitHub the expected format is http(s)://[hostname]/api/v3/repos/[owner]/[repoName]
        """
        return pulumi.get(self, "repository_url")

    @_builtins.property
    @pulumi.getter(name="triggerSecretId")
    def trigger_secret_id(self) -> _builtins.str:
        """
        The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the trigger Secret. The Secret provides access to the trigger for a GitLab pipeline.
        """
        return pulumi.get(self, "trigger_secret_id")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username that will be used to authenticate with Jenkins.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="workflowName")
    def workflow_name(self) -> _builtins.str:
        """
        The name of the GitHub Actions workflow that defines the build pipeline.
        """
        return pulumi.get(self, "workflow_name")


@pulumi.output_type
class GetRemediationRunApplicationDependencyRecommendationsApplicationDependencyRecommendationCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRemediationRunApplicationDependencyRecommendationsApplicationDependencyRecommendationCollectionItemResult']):
        """
        :param Sequence['GetRemediationRunApplicationDependencyRecommendationsApplicationDependencyRecommendationCollectionItemArgs'] items: List of application recommendation summaries.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRemediationRunApplicationDependencyRecommendationsApplicationDependencyRecommendationCollectionItemResult']:
        """
        List of application recommendation summaries.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRemediationRunApplicationDependencyRecommendationsApplicationDependencyRecommendationCollectionItemResult(dict):
    def __init__(__self__, *,
                 application_dependency_node_ids: Sequence[_builtins.str],
                 gav: _builtins.str,
                 node_id: _builtins.str,
                 purl: _builtins.str,
                 recommended_gav: _builtins.str,
                 recommended_purl: _builtins.str):
        """
        :param Sequence[_builtins.str] application_dependency_node_ids: List of (application dependencies) node identifiers from which this node depends.
        :param _builtins.str gav: A filter to return only resources that match the entire GAV (Group Artifact Version) identifier given.
        :param _builtins.str node_id: Unique node identifier of an application dependency with an associated Recommendation, e.g. nodeId1.
        :param _builtins.str purl: A filter to return only resources that match the entire purl given.
        :param _builtins.str recommended_gav: Recommended application dependency in "group:artifact:version" (GAV) format, e.g. org.graalvm.nativeimage:svm:21.2.0.
        :param _builtins.str recommended_purl: Recommended application dependency in purl format, e.g. pkg:maven/org.graalvm.nativeimage/svm@21.2.0
        """
        pulumi.set(__self__, "application_dependency_node_ids", application_dependency_node_ids)
        pulumi.set(__self__, "gav", gav)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "purl", purl)
        pulumi.set(__self__, "recommended_gav", recommended_gav)
        pulumi.set(__self__, "recommended_purl", recommended_purl)

    @_builtins.property
    @pulumi.getter(name="applicationDependencyNodeIds")
    def application_dependency_node_ids(self) -> Sequence[_builtins.str]:
        """
        List of (application dependencies) node identifiers from which this node depends.
        """
        return pulumi.get(self, "application_dependency_node_ids")

    @_builtins.property
    @pulumi.getter
    def gav(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire GAV (Group Artifact Version) identifier given.
        """
        return pulumi.get(self, "gav")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> _builtins.str:
        """
        Unique node identifier of an application dependency with an associated Recommendation, e.g. nodeId1.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter
    def purl(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire purl given.
        """
        return pulumi.get(self, "purl")

    @_builtins.property
    @pulumi.getter(name="recommendedGav")
    def recommended_gav(self) -> _builtins.str:
        """
        Recommended application dependency in "group:artifact:version" (GAV) format, e.g. org.graalvm.nativeimage:svm:21.2.0.
        """
        return pulumi.get(self, "recommended_gav")

    @_builtins.property
    @pulumi.getter(name="recommendedPurl")
    def recommended_purl(self) -> _builtins.str:
        """
        Recommended application dependency in purl format, e.g. pkg:maven/org.graalvm.nativeimage/svm@21.2.0
        """
        return pulumi.get(self, "recommended_purl")


@pulumi.output_type
class GetRemediationRunApplicationDependencyRecommendationsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRemediationRunStageResult(dict):
    def __init__(__self__, *,
                 summary: _builtins.str,
                 time_created: _builtins.str,
                 time_finished: _builtins.str,
                 time_started: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str summary: Information about the current step within the given stage.
        :param _builtins.str time_created: The creation date and time of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param _builtins.str time_finished: The date and time of the finish of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param _builtins.str time_started: The date and time of the start of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param _builtins.str type: The type of stage.
        """
        pulumi.set(__self__, "summary", summary)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_finished", time_finished)
        pulumi.set(__self__, "time_started", time_started)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def summary(self) -> _builtins.str:
        """
        Information about the current step within the given stage.
        """
        return pulumi.get(self, "summary")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The creation date and time of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> _builtins.str:
        """
        The date and time of the finish of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_finished")

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> _builtins.str:
        """
        The date and time of the start of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_started")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of stage.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRemediationRunStagePipelinePropertyResult(dict):
    def __init__(__self__, *,
                 pipeline_identifier: _builtins.str,
                 pipeline_url: _builtins.str):
        """
        :param _builtins.str pipeline_identifier: Unique identifier for the pipeline or action created in the Verify stage.
        :param _builtins.str pipeline_url: The web link to the pipeline from the Verify stage.
        """
        pulumi.set(__self__, "pipeline_identifier", pipeline_identifier)
        pulumi.set(__self__, "pipeline_url", pipeline_url)

    @_builtins.property
    @pulumi.getter(name="pipelineIdentifier")
    def pipeline_identifier(self) -> _builtins.str:
        """
        Unique identifier for the pipeline or action created in the Verify stage.
        """
        return pulumi.get(self, "pipeline_identifier")

    @_builtins.property
    @pulumi.getter(name="pipelineUrl")
    def pipeline_url(self) -> _builtins.str:
        """
        The web link to the pipeline from the Verify stage.
        """
        return pulumi.get(self, "pipeline_url")


@pulumi.output_type
class GetRemediationRunStagePullRequestPropertyResult(dict):
    def __init__(__self__, *,
                 pull_request_identifier: _builtins.str,
                 pull_request_url: _builtins.str):
        """
        :param _builtins.str pull_request_identifier: Unique identifier for the pull or merge request created in the recommend stage.
        :param _builtins.str pull_request_url: The web link to the pull or merge request created in the recommend stage.
        """
        pulumi.set(__self__, "pull_request_identifier", pull_request_identifier)
        pulumi.set(__self__, "pull_request_url", pull_request_url)

    @_builtins.property
    @pulumi.getter(name="pullRequestIdentifier")
    def pull_request_identifier(self) -> _builtins.str:
        """
        Unique identifier for the pull or merge request created in the recommend stage.
        """
        return pulumi.get(self, "pull_request_identifier")

    @_builtins.property
    @pulumi.getter(name="pullRequestUrl")
    def pull_request_url(self) -> _builtins.str:
        """
        The web link to the pull or merge request created in the recommend stage.
        """
        return pulumi.get(self, "pull_request_url")


@pulumi.output_type
class GetRemediationRunStagesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRemediationRunStagesRemediationRunStageCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRemediationRunStagesRemediationRunStageCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRemediationRunStagesRemediationRunStageCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRemediationRunStagesRemediationRunStageCollectionItemResult(dict):
    def __init__(__self__, *,
                 audit_id: _builtins.str,
                 next_stage_type: _builtins.str,
                 pipeline_properties: Sequence['outputs.GetRemediationRunStagesRemediationRunStageCollectionItemPipelinePropertyResult'],
                 previous_stage_type: _builtins.str,
                 pull_request_properties: Sequence['outputs.GetRemediationRunStagesRemediationRunStageCollectionItemPullRequestPropertyResult'],
                 recommended_updates_count: _builtins.int,
                 remediation_run_id: _builtins.str,
                 status: _builtins.str,
                 summary: _builtins.str,
                 time_created: _builtins.str,
                 time_finished: _builtins.str,
                 time_started: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str audit_id: The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the vulnerability audit.
        :param _builtins.str next_stage_type: The next type of stage in the remediation run.
        :param Sequence['GetRemediationRunStagesRemediationRunStageCollectionItemPipelinePropertyArgs'] pipeline_properties: Pipeline properties which result from the run of the verify stage.
        :param _builtins.str previous_stage_type: The previous type of stage in the remediation run.
        :param Sequence['GetRemediationRunStagesRemediationRunStageCollectionItemPullRequestPropertyArgs'] pull_request_properties: Pull request properties from recommend stage of the remediation run.
        :param _builtins.int recommended_updates_count: Count of recommended application dependencies to update.
        :param _builtins.str remediation_run_id: Unique Remediation Run identifier path parameter.
        :param _builtins.str status: A filter to return only Stages that match the specified status.
        :param _builtins.str summary: Information about the current step within the stage.
        :param _builtins.str time_created: The creation date and time of the remediation run stage (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param _builtins.str time_finished: The date and time of the finish of the remediation run stage (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param _builtins.str time_started: The date and time of the start of the remediation run stage (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param _builtins.str type: A filter to return only Stages that match the specified type.
        """
        pulumi.set(__self__, "audit_id", audit_id)
        pulumi.set(__self__, "next_stage_type", next_stage_type)
        pulumi.set(__self__, "pipeline_properties", pipeline_properties)
        pulumi.set(__self__, "previous_stage_type", previous_stage_type)
        pulumi.set(__self__, "pull_request_properties", pull_request_properties)
        pulumi.set(__self__, "recommended_updates_count", recommended_updates_count)
        pulumi.set(__self__, "remediation_run_id", remediation_run_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "summary", summary)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_finished", time_finished)
        pulumi.set(__self__, "time_started", time_started)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="auditId")
    def audit_id(self) -> _builtins.str:
        """
        The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the vulnerability audit.
        """
        return pulumi.get(self, "audit_id")

    @_builtins.property
    @pulumi.getter(name="nextStageType")
    def next_stage_type(self) -> _builtins.str:
        """
        The next type of stage in the remediation run.
        """
        return pulumi.get(self, "next_stage_type")

    @_builtins.property
    @pulumi.getter(name="pipelineProperties")
    def pipeline_properties(self) -> Sequence['outputs.GetRemediationRunStagesRemediationRunStageCollectionItemPipelinePropertyResult']:
        """
        Pipeline properties which result from the run of the verify stage.
        """
        return pulumi.get(self, "pipeline_properties")

    @_builtins.property
    @pulumi.getter(name="previousStageType")
    def previous_stage_type(self) -> _builtins.str:
        """
        The previous type of stage in the remediation run.
        """
        return pulumi.get(self, "previous_stage_type")

    @_builtins.property
    @pulumi.getter(name="pullRequestProperties")
    def pull_request_properties(self) -> Sequence['outputs.GetRemediationRunStagesRemediationRunStageCollectionItemPullRequestPropertyResult']:
        """
        Pull request properties from recommend stage of the remediation run.
        """
        return pulumi.get(self, "pull_request_properties")

    @_builtins.property
    @pulumi.getter(name="recommendedUpdatesCount")
    def recommended_updates_count(self) -> _builtins.int:
        """
        Count of recommended application dependencies to update.
        """
        return pulumi.get(self, "recommended_updates_count")

    @_builtins.property
    @pulumi.getter(name="remediationRunId")
    def remediation_run_id(self) -> _builtins.str:
        """
        Unique Remediation Run identifier path parameter.
        """
        return pulumi.get(self, "remediation_run_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        A filter to return only Stages that match the specified status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def summary(self) -> _builtins.str:
        """
        Information about the current step within the stage.
        """
        return pulumi.get(self, "summary")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The creation date and time of the remediation run stage (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> _builtins.str:
        """
        The date and time of the finish of the remediation run stage (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_finished")

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> _builtins.str:
        """
        The date and time of the start of the remediation run stage (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_started")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        A filter to return only Stages that match the specified type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRemediationRunStagesRemediationRunStageCollectionItemPipelinePropertyResult(dict):
    def __init__(__self__, *,
                 pipeline_identifier: _builtins.str,
                 pipeline_url: _builtins.str):
        """
        :param _builtins.str pipeline_identifier: Unique identifier for the pipeline or action created in the Verify stage.
        :param _builtins.str pipeline_url: The web link to the pipeline from the Verify stage.
        """
        pulumi.set(__self__, "pipeline_identifier", pipeline_identifier)
        pulumi.set(__self__, "pipeline_url", pipeline_url)

    @_builtins.property
    @pulumi.getter(name="pipelineIdentifier")
    def pipeline_identifier(self) -> _builtins.str:
        """
        Unique identifier for the pipeline or action created in the Verify stage.
        """
        return pulumi.get(self, "pipeline_identifier")

    @_builtins.property
    @pulumi.getter(name="pipelineUrl")
    def pipeline_url(self) -> _builtins.str:
        """
        The web link to the pipeline from the Verify stage.
        """
        return pulumi.get(self, "pipeline_url")


@pulumi.output_type
class GetRemediationRunStagesRemediationRunStageCollectionItemPullRequestPropertyResult(dict):
    def __init__(__self__, *,
                 pull_request_identifier: _builtins.str,
                 pull_request_url: _builtins.str):
        """
        :param _builtins.str pull_request_identifier: Unique identifier for the pull or merge request created in the recommend stage.
        :param _builtins.str pull_request_url: The web link to the pull or merge request created in the recommend stage.
        """
        pulumi.set(__self__, "pull_request_identifier", pull_request_identifier)
        pulumi.set(__self__, "pull_request_url", pull_request_url)

    @_builtins.property
    @pulumi.getter(name="pullRequestIdentifier")
    def pull_request_identifier(self) -> _builtins.str:
        """
        Unique identifier for the pull or merge request created in the recommend stage.
        """
        return pulumi.get(self, "pull_request_identifier")

    @_builtins.property
    @pulumi.getter(name="pullRequestUrl")
    def pull_request_url(self) -> _builtins.str:
        """
        The web link to the pull or merge request created in the recommend stage.
        """
        return pulumi.get(self, "pull_request_url")


@pulumi.output_type
class GetRemediationRunsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRemediationRunsRemediationRunCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRemediationRunsRemediationRunCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRemediationRunsRemediationRunCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRemediationRunsRemediationRunCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 current_stage_type: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 remediation_recipe_id: _builtins.str,
                 remediation_run_source: _builtins.str,
                 stages: Sequence['outputs.GetRemediationRunsRemediationRunCollectionItemStageResult'],
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_finished: _builtins.str,
                 time_started: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: A filter to return only resources that belong to the specified compartment identifier. Required only if the id query param is not specified.
        :param _builtins.str current_stage_type: The type of the current stage of the remediation run.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: A filter to return only resources that match the specified identifier. Required only if the compartmentId query parameter is not specified.
        :param _builtins.str remediation_recipe_id: A filter to return only resources that match the specified Remediation Recipe identifier.
        :param _builtins.str remediation_run_source: The source that triggered the Remediation Recipe.
        :param Sequence['GetRemediationRunsRemediationRunCollectionItemStageArgs'] stages: The list of remediation run stage summaries.
        :param _builtins.str state: A filter to return only Remediation Runs that match the specified lifecycleState.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The creation date and time of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param _builtins.str time_finished: The date and time of the finish of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param _builtins.str time_started: The date and time of the start of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param _builtins.str time_updated: The date and time the remediation run was last updated (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "current_stage_type", current_stage_type)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "remediation_recipe_id", remediation_recipe_id)
        pulumi.set(__self__, "remediation_run_source", remediation_run_source)
        pulumi.set(__self__, "stages", stages)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_finished", time_finished)
        pulumi.set(__self__, "time_started", time_started)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        A filter to return only resources that belong to the specified compartment identifier. Required only if the id query param is not specified.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="currentStageType")
    def current_stage_type(self) -> _builtins.str:
        """
        The type of the current stage of the remediation run.
        """
        return pulumi.get(self, "current_stage_type")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        A filter to return only resources that match the specified identifier. Required only if the compartmentId query parameter is not specified.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="remediationRecipeId")
    def remediation_recipe_id(self) -> _builtins.str:
        """
        A filter to return only resources that match the specified Remediation Recipe identifier.
        """
        return pulumi.get(self, "remediation_recipe_id")

    @_builtins.property
    @pulumi.getter(name="remediationRunSource")
    def remediation_run_source(self) -> _builtins.str:
        """
        The source that triggered the Remediation Recipe.
        """
        return pulumi.get(self, "remediation_run_source")

    @_builtins.property
    @pulumi.getter
    def stages(self) -> Sequence['outputs.GetRemediationRunsRemediationRunCollectionItemStageResult']:
        """
        The list of remediation run stage summaries.
        """
        return pulumi.get(self, "stages")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only Remediation Runs that match the specified lifecycleState.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The creation date and time of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> _builtins.str:
        """
        The date and time of the finish of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_finished")

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> _builtins.str:
        """
        The date and time of the start of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_started")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the remediation run was last updated (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetRemediationRunsRemediationRunCollectionItemStageResult(dict):
    def __init__(__self__, *,
                 summary: _builtins.str,
                 time_created: _builtins.str,
                 time_finished: _builtins.str,
                 time_started: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str summary: Information about the current step within the given stage.
        :param _builtins.str time_created: The creation date and time of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param _builtins.str time_finished: The date and time of the finish of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param _builtins.str time_started: The date and time of the start of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param _builtins.str type: The type of stage.
        """
        pulumi.set(__self__, "summary", summary)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_finished", time_finished)
        pulumi.set(__self__, "time_started", time_started)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def summary(self) -> _builtins.str:
        """
        Information about the current step within the given stage.
        """
        return pulumi.get(self, "summary")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The creation date and time of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> _builtins.str:
        """
        The date and time of the finish of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_finished")

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> _builtins.str:
        """
        The date and time of the start of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_started")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of stage.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetVulnerabilityAuditApplicationDependencyResult(dict):
    def __init__(__self__, *,
                 application_dependency_node_ids: Sequence[_builtins.str],
                 gav: _builtins.str,
                 node_id: _builtins.str,
                 purl: _builtins.str):
        pulumi.set(__self__, "application_dependency_node_ids", application_dependency_node_ids)
        pulumi.set(__self__, "gav", gav)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "purl", purl)

    @_builtins.property
    @pulumi.getter(name="applicationDependencyNodeIds")
    def application_dependency_node_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "application_dependency_node_ids")

    @_builtins.property
    @pulumi.getter
    def gav(self) -> _builtins.str:
        return pulumi.get(self, "gav")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> _builtins.str:
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter
    def purl(self) -> _builtins.str:
        return pulumi.get(self, "purl")


@pulumi.output_type
class GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemResult']):
        """
        :param Sequence['GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemArgs'] items: List of vulnerability audit summaries.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemResult']:
        """
        List of vulnerability audit summaries.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemResult(dict):
    def __init__(__self__, *,
                 application_dependency_node_ids: Sequence[_builtins.str],
                 gav: _builtins.str,
                 is_found_in_knowledge_base: _builtins.bool,
                 node_id: _builtins.str,
                 purl: _builtins.str,
                 vulnerabilities: Sequence['outputs.GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemVulnerabilityResult'],
                 warnings: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] application_dependency_node_ids: List of application dependencies on which this application dependency depends, each identified by its nodeId.
        :param _builtins.str gav: A filter to return only resources that match the entire GAV (Group Artifact Version) identifier given.
        :param _builtins.bool is_found_in_knowledge_base: Indicates if the artifact is found in the knowledge base, this field is deprecated and will be removed in the future.
        :param _builtins.str node_id: Unique identifier of an application dependency, for example nodeId1.
        :param _builtins.str purl: A filter to return only resources that match the entire purl given.
        :param Sequence['GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemVulnerabilityArgs'] vulnerabilities: List of vulnerabilities for the application dependency.
        :param Sequence[_builtins.str] warnings: Potential issues in the artifact identifiers (purls) provided by the user, that the user is alerted about. ADM supports the following warnings:
               * MISSING_VERSION: Missing version
               * INCORRECT_FORMAT_VERSION: Version can not be parsed according to the ecosystem
               * UNKNOWN_ECOSYSTEM: The purl's ecosystem is unknown to ADM
               * INCORRECT_FORMAT_EPOCH: Epoch qualifier can not be parsed according to the ecosystem
               * MISSING_DISTRO: The distro qualifier is required for the ecosystem, but was not provided in the purl
               * UNKNOWN_DISTRO: ADM does not have data for the provided distro value for the given ecosystem
               * MISSING_ARCH: The arch qualifier is required for the ecosystem and distro, but was not provided in the purl
               * UNKNOWN_ARCH: ADM does not have data for the provided arch value for the given ecosystem and distro
               * EPOCH_VALUE_MISMATCH: Epoch value in qualifier is not the same as the epoch value in version
               * INVALID_PURL: The provided PURL could not be parsed
        """
        pulumi.set(__self__, "application_dependency_node_ids", application_dependency_node_ids)
        pulumi.set(__self__, "gav", gav)
        pulumi.set(__self__, "is_found_in_knowledge_base", is_found_in_knowledge_base)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "purl", purl)
        pulumi.set(__self__, "vulnerabilities", vulnerabilities)
        pulumi.set(__self__, "warnings", warnings)

    @_builtins.property
    @pulumi.getter(name="applicationDependencyNodeIds")
    def application_dependency_node_ids(self) -> Sequence[_builtins.str]:
        """
        List of application dependencies on which this application dependency depends, each identified by its nodeId.
        """
        return pulumi.get(self, "application_dependency_node_ids")

    @_builtins.property
    @pulumi.getter
    def gav(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire GAV (Group Artifact Version) identifier given.
        """
        return pulumi.get(self, "gav")

    @_builtins.property
    @pulumi.getter(name="isFoundInKnowledgeBase")
    def is_found_in_knowledge_base(self) -> _builtins.bool:
        """
        Indicates if the artifact is found in the knowledge base, this field is deprecated and will be removed in the future.
        """
        return pulumi.get(self, "is_found_in_knowledge_base")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> _builtins.str:
        """
        Unique identifier of an application dependency, for example nodeId1.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter
    def purl(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire purl given.
        """
        return pulumi.get(self, "purl")

    @_builtins.property
    @pulumi.getter
    def vulnerabilities(self) -> Sequence['outputs.GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemVulnerabilityResult']:
        """
        List of vulnerabilities for the application dependency.
        """
        return pulumi.get(self, "vulnerabilities")

    @_builtins.property
    @pulumi.getter
    def warnings(self) -> Sequence[_builtins.str]:
        """
        Potential issues in the artifact identifiers (purls) provided by the user, that the user is alerted about. ADM supports the following warnings:
        * MISSING_VERSION: Missing version
        * INCORRECT_FORMAT_VERSION: Version can not be parsed according to the ecosystem
        * UNKNOWN_ECOSYSTEM: The purl's ecosystem is unknown to ADM
        * INCORRECT_FORMAT_EPOCH: Epoch qualifier can not be parsed according to the ecosystem
        * MISSING_DISTRO: The distro qualifier is required for the ecosystem, but was not provided in the purl
        * UNKNOWN_DISTRO: ADM does not have data for the provided distro value for the given ecosystem
        * MISSING_ARCH: The arch qualifier is required for the ecosystem and distro, but was not provided in the purl
        * UNKNOWN_ARCH: ADM does not have data for the provided arch value for the given ecosystem and distro
        * EPOCH_VALUE_MISMATCH: Epoch value in qualifier is not the same as the epoch value in version
        * INVALID_PURL: The provided PURL could not be parsed
        """
        return pulumi.get(self, "warnings")


@pulumi.output_type
class GetVulnerabilityAuditApplicationDependencyVulnerabilitiesApplicationDependencyVulnerabilityCollectionItemVulnerabilityResult(dict):
    def __init__(__self__, *,
                 cvss_v2score: _builtins.float,
                 cvss_v3score: _builtins.float,
                 id: _builtins.str,
                 is_false_positive: _builtins.bool,
                 is_ignored: _builtins.bool,
                 severity: _builtins.str,
                 source: _builtins.str):
        """
        :param _builtins.float cvss_v2score: Common Vulnerability Scoring System (CVSS) Version 2, calculated from the metrics provided in the CVSS vector provided from the vulnerability source. This field is deprecated and will be removed in the future. The cvssV2Score can be obtained from the metrics field of the listVulnerabilities endpoint.
        :param _builtins.float cvss_v3score: Common Vulnerability Scoring System (CVSS) Version 3, calculated from the metrics provided in the CVSS vector provided from the vulnerability source. This field is deprecated and will be removed in the future. The cvssV3Score can be obtained from the metrics field of the listVulnerabilities endpoint.
        :param _builtins.str id: Unique vulnerability identifier, e.g. CVE-1999-0067.
        :param _builtins.bool is_false_positive: Indicates if the vulnerability is a false positive according to the usage data. If no usage data was provided or the service cannot infer usage of the vulnerable code then this property is `null`.
        :param _builtins.bool is_ignored: Indicates if the vulnerability was ignored according to the audit configuration.
        :param _builtins.str severity: ADM qualitative severity score. Can be either NONE, LOW, MEDIUM, HIGH or CRITICAL.
        :param _builtins.str source: Source that published the vulnerability
        """
        pulumi.set(__self__, "cvss_v2score", cvss_v2score)
        pulumi.set(__self__, "cvss_v3score", cvss_v3score)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_false_positive", is_false_positive)
        pulumi.set(__self__, "is_ignored", is_ignored)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter(name="cvssV2score")
    def cvss_v2score(self) -> _builtins.float:
        """
        Common Vulnerability Scoring System (CVSS) Version 2, calculated from the metrics provided in the CVSS vector provided from the vulnerability source. This field is deprecated and will be removed in the future. The cvssV2Score can be obtained from the metrics field of the listVulnerabilities endpoint.
        """
        return pulumi.get(self, "cvss_v2score")

    @_builtins.property
    @pulumi.getter(name="cvssV3score")
    def cvss_v3score(self) -> _builtins.float:
        """
        Common Vulnerability Scoring System (CVSS) Version 3, calculated from the metrics provided in the CVSS vector provided from the vulnerability source. This field is deprecated and will be removed in the future. The cvssV3Score can be obtained from the metrics field of the listVulnerabilities endpoint.
        """
        return pulumi.get(self, "cvss_v3score")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique vulnerability identifier, e.g. CVE-1999-0067.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isFalsePositive")
    def is_false_positive(self) -> _builtins.bool:
        """
        Indicates if the vulnerability is a false positive according to the usage data. If no usage data was provided or the service cannot infer usage of the vulnerable code then this property is `null`.
        """
        return pulumi.get(self, "is_false_positive")

    @_builtins.property
    @pulumi.getter(name="isIgnored")
    def is_ignored(self) -> _builtins.bool:
        """
        Indicates if the vulnerability was ignored according to the audit configuration.
        """
        return pulumi.get(self, "is_ignored")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> _builtins.str:
        """
        ADM qualitative severity score. Can be either NONE, LOW, MEDIUM, HIGH or CRITICAL.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        Source that published the vulnerability
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class GetVulnerabilityAuditApplicationDependencyVulnerabilitiesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetVulnerabilityAuditApplicationDependencyVulnerabilityItemResult(dict):
    def __init__(__self__, *,
                 application_dependency_node_ids: Sequence[_builtins.str],
                 gav: _builtins.str,
                 is_found_in_knowledge_base: _builtins.bool,
                 node_id: _builtins.str,
                 purl: _builtins.str,
                 vulnerabilities: Sequence['outputs.GetVulnerabilityAuditApplicationDependencyVulnerabilityItemVulnerabilityResult']):
        """
        :param Sequence[_builtins.str] application_dependency_node_ids: List of Application Dependencies on which this Application Dependency depends, each identified by its nodeId.
        :param _builtins.str gav: A filter to return only resources that match the entire GAV (Group Artifact Version) identifier given.
        :param _builtins.bool is_found_in_knowledge_base: Indicates if the artifact is found in the knowledge base.
        :param _builtins.str node_id: Unique identifier of an Application Dependency, for example nodeId1.
        :param Sequence['GetVulnerabilityAuditApplicationDependencyVulnerabilityItemVulnerabilityArgs'] vulnerabilities: List of vulnerabilities for the Application Dependency.
        """
        pulumi.set(__self__, "application_dependency_node_ids", application_dependency_node_ids)
        pulumi.set(__self__, "gav", gav)
        pulumi.set(__self__, "is_found_in_knowledge_base", is_found_in_knowledge_base)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "purl", purl)
        pulumi.set(__self__, "vulnerabilities", vulnerabilities)

    @_builtins.property
    @pulumi.getter(name="applicationDependencyNodeIds")
    def application_dependency_node_ids(self) -> Sequence[_builtins.str]:
        """
        List of Application Dependencies on which this Application Dependency depends, each identified by its nodeId.
        """
        return pulumi.get(self, "application_dependency_node_ids")

    @_builtins.property
    @pulumi.getter
    def gav(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire GAV (Group Artifact Version) identifier given.
        """
        return pulumi.get(self, "gav")

    @_builtins.property
    @pulumi.getter(name="isFoundInKnowledgeBase")
    def is_found_in_knowledge_base(self) -> _builtins.bool:
        """
        Indicates if the artifact is found in the knowledge base.
        """
        return pulumi.get(self, "is_found_in_knowledge_base")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> _builtins.str:
        """
        Unique identifier of an Application Dependency, for example nodeId1.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter
    def purl(self) -> _builtins.str:
        return pulumi.get(self, "purl")

    @_builtins.property
    @pulumi.getter
    def vulnerabilities(self) -> Sequence['outputs.GetVulnerabilityAuditApplicationDependencyVulnerabilityItemVulnerabilityResult']:
        """
        List of vulnerabilities for the Application Dependency.
        """
        return pulumi.get(self, "vulnerabilities")


@pulumi.output_type
class GetVulnerabilityAuditApplicationDependencyVulnerabilityItemVulnerabilityResult(dict):
    def __init__(__self__, *,
                 cvss_v2score: _builtins.float,
                 cvss_v3score: _builtins.float,
                 id: _builtins.str,
                 is_false_positive: _builtins.bool,
                 is_ignored: _builtins.bool,
                 severity: _builtins.str,
                 source: _builtins.str):
        """
        :param _builtins.float cvss_v2score: Common Vulnerability Scoring System (CVSS) Version 2.
        :param _builtins.float cvss_v3score: Common Vulnerability Scoring System (CVSS) Version 3.
        :param _builtins.str id: Unique vulnerability identifier, e.g. CVE-1999-0067.
        :param _builtins.bool is_ignored: Indicates if the vulnerability was ignored according to the audit configuration.
        """
        pulumi.set(__self__, "cvss_v2score", cvss_v2score)
        pulumi.set(__self__, "cvss_v3score", cvss_v3score)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_false_positive", is_false_positive)
        pulumi.set(__self__, "is_ignored", is_ignored)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter(name="cvssV2score")
    def cvss_v2score(self) -> _builtins.float:
        """
        Common Vulnerability Scoring System (CVSS) Version 2.
        """
        return pulumi.get(self, "cvss_v2score")

    @_builtins.property
    @pulumi.getter(name="cvssV3score")
    def cvss_v3score(self) -> _builtins.float:
        """
        Common Vulnerability Scoring System (CVSS) Version 3.
        """
        return pulumi.get(self, "cvss_v3score")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique vulnerability identifier, e.g. CVE-1999-0067.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isFalsePositive")
    def is_false_positive(self) -> _builtins.bool:
        return pulumi.get(self, "is_false_positive")

    @_builtins.property
    @pulumi.getter(name="isIgnored")
    def is_ignored(self) -> _builtins.bool:
        """
        Indicates if the vulnerability was ignored according to the audit configuration.
        """
        return pulumi.get(self, "is_ignored")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> _builtins.str:
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        return pulumi.get(self, "source")


@pulumi.output_type
class GetVulnerabilityAuditConfigurationResult(dict):
    def __init__(__self__, *,
                 exclusions: Sequence[_builtins.str],
                 max_permissible_cvss_v2score: _builtins.float,
                 max_permissible_cvss_v3score: _builtins.float,
                 max_permissible_severity: _builtins.str):
        """
        :param Sequence[_builtins.str] exclusions: A vulnerable application dependency is ignored if its name matches any of the items in `exclusions`. An asterisk (*) in the dependency pattern acts as a wildcard and matches zero or more characters.
        :param _builtins.float max_permissible_cvss_v2score: A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        :param _builtins.float max_permissible_cvss_v3score: A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        :param _builtins.str max_permissible_severity: A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleSeverity.
        """
        pulumi.set(__self__, "exclusions", exclusions)
        pulumi.set(__self__, "max_permissible_cvss_v2score", max_permissible_cvss_v2score)
        pulumi.set(__self__, "max_permissible_cvss_v3score", max_permissible_cvss_v3score)
        pulumi.set(__self__, "max_permissible_severity", max_permissible_severity)

    @_builtins.property
    @pulumi.getter
    def exclusions(self) -> Sequence[_builtins.str]:
        """
        A vulnerable application dependency is ignored if its name matches any of the items in `exclusions`. An asterisk (*) in the dependency pattern acts as a wildcard and matches zero or more characters.
        """
        return pulumi.get(self, "exclusions")

    @_builtins.property
    @pulumi.getter(name="maxPermissibleCvssV2score")
    def max_permissible_cvss_v2score(self) -> _builtins.float:
        """
        A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        """
        return pulumi.get(self, "max_permissible_cvss_v2score")

    @_builtins.property
    @pulumi.getter(name="maxPermissibleCvssV3score")
    def max_permissible_cvss_v3score(self) -> _builtins.float:
        """
        A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        """
        return pulumi.get(self, "max_permissible_cvss_v3score")

    @_builtins.property
    @pulumi.getter(name="maxPermissibleSeverity")
    def max_permissible_severity(self) -> _builtins.str:
        """
        A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleSeverity.
        """
        return pulumi.get(self, "max_permissible_severity")


@pulumi.output_type
class GetVulnerabilityAuditSourceResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 oci_resource_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str description: Description of the external resource source.
        :param _builtins.str oci_resource_id: The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Oracle Cloud Infrastructure resource that triggered the vulnerability audit.
        :param _builtins.str type: Source type of the vulnerability audit.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "oci_resource_id", oci_resource_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the external resource source.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="ociResourceId")
    def oci_resource_id(self) -> _builtins.str:
        """
        The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Oracle Cloud Infrastructure resource that triggered the vulnerability audit.
        """
        return pulumi.get(self, "oci_resource_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Source type of the vulnerability audit.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetVulnerabilityAuditUsageDataResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 namespace: _builtins.str,
                 object: _builtins.str,
                 source_type: _builtins.str):
        """
        :param _builtins.str bucket: The Object Storage bucket to read the usage data from.
        :param _builtins.str namespace: The Object Storage namespace to read the usage data from.
        :param _builtins.str object: The Object Storage object name to read the usage data from.
        :param _builtins.str source_type: The destination type. Use `objectStorageTuple` when specifying the namespace, bucket name, and object name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "source_type", source_type)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The Object Storage bucket to read the usage data from.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The Object Storage namespace to read the usage data from.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> _builtins.str:
        """
        The Object Storage object name to read the usage data from.
        """
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        The destination type. Use `objectStorageTuple` when specifying the namespace, bucket name, and object name.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetVulnerabilityAuditVulnerabilityResult(dict):
    def __init__(__self__, *,
                 cvss_v2score: _builtins.float,
                 cvss_v3score: _builtins.float,
                 id: _builtins.str,
                 is_false_positive: _builtins.bool,
                 is_ignored: _builtins.bool,
                 severity: _builtins.str,
                 source: _builtins.str):
        """
        :param _builtins.float cvss_v2score: Common Vulnerability Scoring System (CVSS) Version 2, calculated from the metrics provided in the CVSS vector provided from the vulnerability source. This field is deprecated and will be removed in the future. The cvssV2Score can be obtained from the metrics field of the listVulnerabilities endpoint.
        :param _builtins.float cvss_v3score: Common Vulnerability Scoring System (CVSS) Version 3, calculated from the metrics provided in the CVSS vector provided from the vulnerability source. This field is deprecated and will be removed in the future. The cvssV3Score can be obtained from the metrics field of the listVulnerabilities endpoint.
        :param _builtins.str id: Unique vulnerability identifier, e.g. CVE-1999-0067.
        :param _builtins.bool is_false_positive: Indicates if the vulnerability is a false positive according to the usage data. If no usage data was provided or the service cannot infer usage of the vulnerable code then this property is `null`.
        :param _builtins.bool is_ignored: Indicates if the vulnerability was ignored according to the audit configuration.
        :param _builtins.str severity: ADM qualitative severity score. Can be either NONE, LOW, MEDIUM, HIGH or CRITICAL.
        :param _builtins.str source: Source that published the vulnerability
        """
        pulumi.set(__self__, "cvss_v2score", cvss_v2score)
        pulumi.set(__self__, "cvss_v3score", cvss_v3score)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_false_positive", is_false_positive)
        pulumi.set(__self__, "is_ignored", is_ignored)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter(name="cvssV2score")
    def cvss_v2score(self) -> _builtins.float:
        """
        Common Vulnerability Scoring System (CVSS) Version 2, calculated from the metrics provided in the CVSS vector provided from the vulnerability source. This field is deprecated and will be removed in the future. The cvssV2Score can be obtained from the metrics field of the listVulnerabilities endpoint.
        """
        return pulumi.get(self, "cvss_v2score")

    @_builtins.property
    @pulumi.getter(name="cvssV3score")
    def cvss_v3score(self) -> _builtins.float:
        """
        Common Vulnerability Scoring System (CVSS) Version 3, calculated from the metrics provided in the CVSS vector provided from the vulnerability source. This field is deprecated and will be removed in the future. The cvssV3Score can be obtained from the metrics field of the listVulnerabilities endpoint.
        """
        return pulumi.get(self, "cvss_v3score")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique vulnerability identifier, e.g. CVE-1999-0067.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isFalsePositive")
    def is_false_positive(self) -> _builtins.bool:
        """
        Indicates if the vulnerability is a false positive according to the usage data. If no usage data was provided or the service cannot infer usage of the vulnerable code then this property is `null`.
        """
        return pulumi.get(self, "is_false_positive")

    @_builtins.property
    @pulumi.getter(name="isIgnored")
    def is_ignored(self) -> _builtins.bool:
        """
        Indicates if the vulnerability was ignored according to the audit configuration.
        """
        return pulumi.get(self, "is_ignored")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> _builtins.str:
        """
        ADM qualitative severity score. Can be either NONE, LOW, MEDIUM, HIGH or CRITICAL.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        Source that published the vulnerability
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class GetVulnerabilityAuditsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetVulnerabilityAuditsVulnerabilityAuditCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetVulnerabilityAuditsVulnerabilityAuditCollectionItemResult(dict):
    def __init__(__self__, *,
                 application_dependencies: Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemApplicationDependencyResult'],
                 build_type: _builtins.str,
                 compartment_id: _builtins.str,
                 configurations: Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemConfigurationResult'],
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_success: _builtins.bool,
                 knowledge_base_id: _builtins.str,
                 lifecycle_details: _builtins.str,
                 max_observed_cvss_v2score: _builtins.float,
                 max_observed_cvss_v2score_with_ignored: _builtins.float,
                 max_observed_cvss_v3score: _builtins.float,
                 max_observed_cvss_v3score_with_ignored: _builtins.float,
                 max_observed_severity: _builtins.str,
                 max_observed_severity_with_ignored: _builtins.str,
                 sources: Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemSourceResult'],
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 usage_datas: Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemUsageDataResult'],
                 vulnerabilities: Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemVulnerabilityResult'],
                 vulnerable_artifacts_count: _builtins.int,
                 vulnerable_artifacts_count_with_ignored: _builtins.int):
        """
        :param _builtins.str build_type: The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET when the list of application dependencies is not Maven-related or is a mix of Maven and other ecosystems. This option is soon to be deprecated.
        :param _builtins.str compartment_id: A filter to return only resources that belong to the specified compartment identifier. Required only if the id query param is not specified.
        :param Sequence['GetVulnerabilityAuditsVulnerabilityAuditCollectionItemConfigurationArgs'] configurations: Configuration for a vulnerability audit. A vulnerable application dependency is ignored if its name does match any of the items in `exclusions`, or all of the associated Vulnerabilies have a CVSS v2 score below `maxPermissibleCvssV2Score` and a CVSS v3 score below `maxPermissibleCvssV3Score`. type: object
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: A filter to return only resources that match the specified identifier. Required only if the compartmentId query parameter is not specified.
        :param _builtins.bool is_success: A filter to return only successful or failed Vulnerability Audits.
        :param _builtins.str knowledge_base_id: A filter to return only Vulnerability Audits that were created against the specified knowledge base.
        :param _builtins.str lifecycle_details: Details on the lifecycle state.
        :param _builtins.float max_observed_cvss_v2score: Maximum Common Vulnerability Scoring System Version 2 score observed for non-ignored vulnerable application dependencies.
        :param _builtins.float max_observed_cvss_v2score_with_ignored: Maximum Common Vulnerability Scoring System Version 2 score observed for vulnerable application dependencies including ignored ones.
        :param _builtins.float max_observed_cvss_v3score: Maximum Common Vulnerability Scoring System Version 3 score observed for non-ignored vulnerable application dependencies.
        :param _builtins.float max_observed_cvss_v3score_with_ignored: Maximum Common Vulnerability Scoring System Version 3 score observed for vulnerable application dependencies including ignored ones.
        :param _builtins.str max_observed_severity: Maximum ADM Severity observed for non-ignored vulnerable application dependencies.
        :param _builtins.str max_observed_severity_with_ignored: Maximum ADM Severity observed for vulnerable application dependencies including ignored ones.
        :param Sequence['GetVulnerabilityAuditsVulnerabilityAuditCollectionItemSourceArgs'] sources: Source that published the vulnerability
        :param _builtins.str state: A filter to return only Vulnerability Audits that match the specified lifecycleState.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The creation date and time of the vulnerability audit (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param _builtins.str time_updated: The update date and time of the vulnerability audit (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param Sequence['GetVulnerabilityAuditsVulnerabilityAuditCollectionItemUsageDataArgs'] usage_datas: The source details of the usage data in object storage. The usage data file uploaded to object storage must be a gzip archive of the JSON usage data returned from the GraalVM native-image-inspect tool after a native-image build. Set `sourceType` to `objectStorageTuple` and use [UsageDataViaObjectStorageTupleDetails](https://docs.cloud.oracle.com/iaas/api/#/en/adm/latest/requests/UsageDataViaObjectStorageTupleDetails) when specifying the namespace, bucket name, and object name.
        :param Sequence['GetVulnerabilityAuditsVulnerabilityAuditCollectionItemVulnerabilityArgs'] vulnerabilities: List of vulnerabilities found in the vulnerability audit. If a vulnerability affects multiple dependencies, the metadata returned here consists of audit-wide aggregates.
        :param _builtins.int vulnerable_artifacts_count: Count of non-ignored vulnerable application dependencies.
        :param _builtins.int vulnerable_artifacts_count_with_ignored: Count of all vulnerable application dependencies.
        """
        pulumi.set(__self__, "application_dependencies", application_dependencies)
        pulumi.set(__self__, "build_type", build_type)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "configurations", configurations)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_success", is_success)
        pulumi.set(__self__, "knowledge_base_id", knowledge_base_id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "max_observed_cvss_v2score", max_observed_cvss_v2score)
        pulumi.set(__self__, "max_observed_cvss_v2score_with_ignored", max_observed_cvss_v2score_with_ignored)
        pulumi.set(__self__, "max_observed_cvss_v3score", max_observed_cvss_v3score)
        pulumi.set(__self__, "max_observed_cvss_v3score_with_ignored", max_observed_cvss_v3score_with_ignored)
        pulumi.set(__self__, "max_observed_severity", max_observed_severity)
        pulumi.set(__self__, "max_observed_severity_with_ignored", max_observed_severity_with_ignored)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "usage_datas", usage_datas)
        pulumi.set(__self__, "vulnerabilities", vulnerabilities)
        pulumi.set(__self__, "vulnerable_artifacts_count", vulnerable_artifacts_count)
        pulumi.set(__self__, "vulnerable_artifacts_count_with_ignored", vulnerable_artifacts_count_with_ignored)

    @_builtins.property
    @pulumi.getter(name="applicationDependencies")
    def application_dependencies(self) -> Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemApplicationDependencyResult']:
        return pulumi.get(self, "application_dependencies")

    @_builtins.property
    @pulumi.getter(name="buildType")
    def build_type(self) -> _builtins.str:
        """
        The type of the build tool is restricted to only two values MAVEN or UNSET. Use UNSET when the list of application dependencies is not Maven-related or is a mix of Maven and other ecosystems. This option is soon to be deprecated.
        """
        return pulumi.get(self, "build_type")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        A filter to return only resources that belong to the specified compartment identifier. Required only if the id query param is not specified.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemConfigurationResult']:
        """
        Configuration for a vulnerability audit. A vulnerable application dependency is ignored if its name does match any of the items in `exclusions`, or all of the associated Vulnerabilies have a CVSS v2 score below `maxPermissibleCvssV2Score` and a CVSS v3 score below `maxPermissibleCvssV3Score`. type: object
        """
        return pulumi.get(self, "configurations")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        A filter to return only resources that match the specified identifier. Required only if the compartmentId query parameter is not specified.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isSuccess")
    def is_success(self) -> _builtins.bool:
        """
        A filter to return only successful or failed Vulnerability Audits.
        """
        return pulumi.get(self, "is_success")

    @_builtins.property
    @pulumi.getter(name="knowledgeBaseId")
    def knowledge_base_id(self) -> _builtins.str:
        """
        A filter to return only Vulnerability Audits that were created against the specified knowledge base.
        """
        return pulumi.get(self, "knowledge_base_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Details on the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="maxObservedCvssV2score")
    def max_observed_cvss_v2score(self) -> _builtins.float:
        """
        Maximum Common Vulnerability Scoring System Version 2 score observed for non-ignored vulnerable application dependencies.
        """
        return pulumi.get(self, "max_observed_cvss_v2score")

    @_builtins.property
    @pulumi.getter(name="maxObservedCvssV2scoreWithIgnored")
    def max_observed_cvss_v2score_with_ignored(self) -> _builtins.float:
        """
        Maximum Common Vulnerability Scoring System Version 2 score observed for vulnerable application dependencies including ignored ones.
        """
        return pulumi.get(self, "max_observed_cvss_v2score_with_ignored")

    @_builtins.property
    @pulumi.getter(name="maxObservedCvssV3score")
    def max_observed_cvss_v3score(self) -> _builtins.float:
        """
        Maximum Common Vulnerability Scoring System Version 3 score observed for non-ignored vulnerable application dependencies.
        """
        return pulumi.get(self, "max_observed_cvss_v3score")

    @_builtins.property
    @pulumi.getter(name="maxObservedCvssV3scoreWithIgnored")
    def max_observed_cvss_v3score_with_ignored(self) -> _builtins.float:
        """
        Maximum Common Vulnerability Scoring System Version 3 score observed for vulnerable application dependencies including ignored ones.
        """
        return pulumi.get(self, "max_observed_cvss_v3score_with_ignored")

    @_builtins.property
    @pulumi.getter(name="maxObservedSeverity")
    def max_observed_severity(self) -> _builtins.str:
        """
        Maximum ADM Severity observed for non-ignored vulnerable application dependencies.
        """
        return pulumi.get(self, "max_observed_severity")

    @_builtins.property
    @pulumi.getter(name="maxObservedSeverityWithIgnored")
    def max_observed_severity_with_ignored(self) -> _builtins.str:
        """
        Maximum ADM Severity observed for vulnerable application dependencies including ignored ones.
        """
        return pulumi.get(self, "max_observed_severity_with_ignored")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemSourceResult']:
        """
        Source that published the vulnerability
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only Vulnerability Audits that match the specified lifecycleState.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The creation date and time of the vulnerability audit (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The update date and time of the vulnerability audit (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="usageDatas")
    def usage_datas(self) -> Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemUsageDataResult']:
        """
        The source details of the usage data in object storage. The usage data file uploaded to object storage must be a gzip archive of the JSON usage data returned from the GraalVM native-image-inspect tool after a native-image build. Set `sourceType` to `objectStorageTuple` and use [UsageDataViaObjectStorageTupleDetails](https://docs.cloud.oracle.com/iaas/api/#/en/adm/latest/requests/UsageDataViaObjectStorageTupleDetails) when specifying the namespace, bucket name, and object name.
        """
        return pulumi.get(self, "usage_datas")

    @_builtins.property
    @pulumi.getter
    def vulnerabilities(self) -> Sequence['outputs.GetVulnerabilityAuditsVulnerabilityAuditCollectionItemVulnerabilityResult']:
        """
        List of vulnerabilities found in the vulnerability audit. If a vulnerability affects multiple dependencies, the metadata returned here consists of audit-wide aggregates.
        """
        return pulumi.get(self, "vulnerabilities")

    @_builtins.property
    @pulumi.getter(name="vulnerableArtifactsCount")
    def vulnerable_artifacts_count(self) -> _builtins.int:
        """
        Count of non-ignored vulnerable application dependencies.
        """
        return pulumi.get(self, "vulnerable_artifacts_count")

    @_builtins.property
    @pulumi.getter(name="vulnerableArtifactsCountWithIgnored")
    def vulnerable_artifacts_count_with_ignored(self) -> _builtins.int:
        """
        Count of all vulnerable application dependencies.
        """
        return pulumi.get(self, "vulnerable_artifacts_count_with_ignored")


@pulumi.output_type
class GetVulnerabilityAuditsVulnerabilityAuditCollectionItemApplicationDependencyResult(dict):
    def __init__(__self__, *,
                 application_dependency_node_ids: Sequence[_builtins.str],
                 gav: _builtins.str,
                 node_id: _builtins.str,
                 purl: _builtins.str):
        pulumi.set(__self__, "application_dependency_node_ids", application_dependency_node_ids)
        pulumi.set(__self__, "gav", gav)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "purl", purl)

    @_builtins.property
    @pulumi.getter(name="applicationDependencyNodeIds")
    def application_dependency_node_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "application_dependency_node_ids")

    @_builtins.property
    @pulumi.getter
    def gav(self) -> _builtins.str:
        return pulumi.get(self, "gav")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> _builtins.str:
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter
    def purl(self) -> _builtins.str:
        return pulumi.get(self, "purl")


@pulumi.output_type
class GetVulnerabilityAuditsVulnerabilityAuditCollectionItemConfigurationResult(dict):
    def __init__(__self__, *,
                 exclusions: Sequence[_builtins.str],
                 max_permissible_cvss_v2score: _builtins.float,
                 max_permissible_cvss_v3score: _builtins.float,
                 max_permissible_severity: _builtins.str):
        """
        :param Sequence[_builtins.str] exclusions: A vulnerable application dependency is ignored if its name matches any of the items in `exclusions`. An asterisk (*) in the dependency pattern acts as a wildcard and matches zero or more characters.
        :param _builtins.float max_permissible_cvss_v2score: A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        :param _builtins.float max_permissible_cvss_v3score: A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        :param _builtins.str max_permissible_severity: A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleSeverity.
        """
        pulumi.set(__self__, "exclusions", exclusions)
        pulumi.set(__self__, "max_permissible_cvss_v2score", max_permissible_cvss_v2score)
        pulumi.set(__self__, "max_permissible_cvss_v3score", max_permissible_cvss_v3score)
        pulumi.set(__self__, "max_permissible_severity", max_permissible_severity)

    @_builtins.property
    @pulumi.getter
    def exclusions(self) -> Sequence[_builtins.str]:
        """
        A vulnerable application dependency is ignored if its name matches any of the items in `exclusions`. An asterisk (*) in the dependency pattern acts as a wildcard and matches zero or more characters.
        """
        return pulumi.get(self, "exclusions")

    @_builtins.property
    @pulumi.getter(name="maxPermissibleCvssV2score")
    def max_permissible_cvss_v2score(self) -> _builtins.float:
        """
        A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        """
        return pulumi.get(self, "max_permissible_cvss_v2score")

    @_builtins.property
    @pulumi.getter(name="maxPermissibleCvssV3score")
    def max_permissible_cvss_v3score(self) -> _builtins.float:
        """
        A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleCvssV2Score and below maxPermissibleCvssV3Score.
        """
        return pulumi.get(self, "max_permissible_cvss_v3score")

    @_builtins.property
    @pulumi.getter(name="maxPermissibleSeverity")
    def max_permissible_severity(self) -> _builtins.str:
        """
        A vulnerable application dependency is ignored if the score of its associated Vulnerability is below maxPermissibleSeverity.
        """
        return pulumi.get(self, "max_permissible_severity")


@pulumi.output_type
class GetVulnerabilityAuditsVulnerabilityAuditCollectionItemSourceResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 oci_resource_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str description: Description of the external resource source.
        :param _builtins.str oci_resource_id: The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Oracle Cloud Infrastructure resource that triggered the vulnerability audit.
        :param _builtins.str type: Source type of the vulnerability audit.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "oci_resource_id", oci_resource_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the external resource source.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="ociResourceId")
    def oci_resource_id(self) -> _builtins.str:
        """
        The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Oracle Cloud Infrastructure resource that triggered the vulnerability audit.
        """
        return pulumi.get(self, "oci_resource_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Source type of the vulnerability audit.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetVulnerabilityAuditsVulnerabilityAuditCollectionItemUsageDataResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 namespace: _builtins.str,
                 object: _builtins.str,
                 source_type: _builtins.str):
        """
        :param _builtins.str bucket: The Object Storage bucket to read the usage data from.
        :param _builtins.str namespace: The Object Storage namespace to read the usage data from.
        :param _builtins.str object: The Object Storage object name to read the usage data from.
        :param _builtins.str source_type: The destination type. Use `objectStorageTuple` when specifying the namespace, bucket name, and object name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "source_type", source_type)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The Object Storage bucket to read the usage data from.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The Object Storage namespace to read the usage data from.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> _builtins.str:
        """
        The Object Storage object name to read the usage data from.
        """
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        The destination type. Use `objectStorageTuple` when specifying the namespace, bucket name, and object name.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetVulnerabilityAuditsVulnerabilityAuditCollectionItemVulnerabilityResult(dict):
    def __init__(__self__, *,
                 cvss_v2score: _builtins.float,
                 cvss_v3score: _builtins.float,
                 id: _builtins.str,
                 is_false_positive: _builtins.bool,
                 is_ignored: _builtins.bool,
                 severity: _builtins.str,
                 source: _builtins.str):
        """
        :param _builtins.float cvss_v2score: Common Vulnerability Scoring System (CVSS) Version 2, calculated from the metrics provided in the CVSS vector provided from the vulnerability source. This field is deprecated and will be removed in the future. The cvssV2Score can be obtained from the metrics field of the listVulnerabilities endpoint.
        :param _builtins.float cvss_v3score: Common Vulnerability Scoring System (CVSS) Version 3, calculated from the metrics provided in the CVSS vector provided from the vulnerability source. This field is deprecated and will be removed in the future. The cvssV3Score can be obtained from the metrics field of the listVulnerabilities endpoint.
        :param _builtins.str id: A filter to return only resources that match the specified identifier. Required only if the compartmentId query parameter is not specified.
        :param _builtins.bool is_false_positive: Indicates if the vulnerability is a false positive according to the usage data. If no usage data was provided or the service cannot infer usage of the vulnerable code then this property is `null`.
        :param _builtins.bool is_ignored: Indicates if the vulnerability was ignored according to the audit configuration.
        :param _builtins.str severity: ADM qualitative severity score. Can be either NONE, LOW, MEDIUM, HIGH or CRITICAL.
        :param _builtins.str source: Source that published the vulnerability
        """
        pulumi.set(__self__, "cvss_v2score", cvss_v2score)
        pulumi.set(__self__, "cvss_v3score", cvss_v3score)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_false_positive", is_false_positive)
        pulumi.set(__self__, "is_ignored", is_ignored)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter(name="cvssV2score")
    def cvss_v2score(self) -> _builtins.float:
        """
        Common Vulnerability Scoring System (CVSS) Version 2, calculated from the metrics provided in the CVSS vector provided from the vulnerability source. This field is deprecated and will be removed in the future. The cvssV2Score can be obtained from the metrics field of the listVulnerabilities endpoint.
        """
        return pulumi.get(self, "cvss_v2score")

    @_builtins.property
    @pulumi.getter(name="cvssV3score")
    def cvss_v3score(self) -> _builtins.float:
        """
        Common Vulnerability Scoring System (CVSS) Version 3, calculated from the metrics provided in the CVSS vector provided from the vulnerability source. This field is deprecated and will be removed in the future. The cvssV3Score can be obtained from the metrics field of the listVulnerabilities endpoint.
        """
        return pulumi.get(self, "cvss_v3score")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        A filter to return only resources that match the specified identifier. Required only if the compartmentId query parameter is not specified.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isFalsePositive")
    def is_false_positive(self) -> _builtins.bool:
        """
        Indicates if the vulnerability is a false positive according to the usage data. If no usage data was provided or the service cannot infer usage of the vulnerable code then this property is `null`.
        """
        return pulumi.get(self, "is_false_positive")

    @_builtins.property
    @pulumi.getter(name="isIgnored")
    def is_ignored(self) -> _builtins.bool:
        """
        Indicates if the vulnerability was ignored according to the audit configuration.
        """
        return pulumi.get(self, "is_ignored")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> _builtins.str:
        """
        ADM qualitative severity score. Can be either NONE, LOW, MEDIUM, HIGH or CRITICAL.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        Source that published the vulnerability
        """
        return pulumi.get(self, "source")


