# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetStreamGroupsResult',
    'AwaitableGetStreamGroupsResult',
    'get_stream_groups',
    'get_stream_groups_output',
]

@pulumi.output_type
class GetStreamGroupsResult:
    """
    A collection of values returned by getStreamGroups.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, stream_group_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if stream_group_collections and not isinstance(stream_group_collections, list):
            raise TypeError("Expected argument 'stream_group_collections' to be a list")
        pulumi.set(__self__, "stream_group_collections", stream_group_collections)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of compartment
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A human-friendly name for the streamGroup.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetStreamGroupsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the streamGroup.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="streamGroupCollections")
    def stream_group_collections(self) -> Sequence['outputs.GetStreamGroupsStreamGroupCollectionResult']:
        """
        The list of stream_group_collection.
        """
        return pulumi.get(self, "stream_group_collections")


class AwaitableGetStreamGroupsResult(GetStreamGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamGroupsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            stream_group_collections=self.stream_group_collections)


def get_stream_groups(compartment_id: Optional[_builtins.str] = None,
                      display_name: Optional[_builtins.str] = None,
                      filters: Optional[Sequence[Union['GetStreamGroupsFilterArgs', 'GetStreamGroupsFilterArgsDict']]] = None,
                      id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamGroupsResult:
    """
    This data source provides the list of Stream Groups in Oracle Cloud Infrastructure Ai Vision service.

    Gets a list of the streamGroups in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream_groups = oci.AiVision.get_stream_groups(compartment_id=compartment_id,
        display_name=stream_group_display_name,
        id=stream_group_id)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str id: The filter to find the device with the given identifier.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:AiVision/getStreamGroups:getStreamGroups', __args__, opts=opts, typ=GetStreamGroupsResult).value

    return AwaitableGetStreamGroupsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        stream_group_collections=pulumi.get(__ret__, 'stream_group_collections'))
def get_stream_groups_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetStreamGroupsFilterArgs', 'GetStreamGroupsFilterArgsDict']]]]] = None,
                             id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStreamGroupsResult]:
    """
    This data source provides the list of Stream Groups in Oracle Cloud Infrastructure Ai Vision service.

    Gets a list of the streamGroups in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream_groups = oci.AiVision.get_stream_groups(compartment_id=compartment_id,
        display_name=stream_group_display_name,
        id=stream_group_id)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str id: The filter to find the device with the given identifier.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:AiVision/getStreamGroups:getStreamGroups', __args__, opts=opts, typ=GetStreamGroupsResult)
    return __ret__.apply(lambda __response__: GetStreamGroupsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        stream_group_collections=pulumi.get(__response__, 'stream_group_collections')))
