# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AnalyticsInstanceCapacity',
    'AnalyticsInstanceNetworkEndpointDetails',
    'AnalyticsInstanceNetworkEndpointDetailsWhitelistedVcn',
    'AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZone',
    'AnalyticsInstancePrivateAccessChannelPrivateSourceScanHost',
    'GetAnalyticsInstanceCapacityResult',
    'GetAnalyticsInstanceNetworkEndpointDetailResult',
    'GetAnalyticsInstanceNetworkEndpointDetailWhitelistedVcnResult',
    'GetAnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneResult',
    'GetAnalyticsInstancePrivateAccessChannelPrivateSourceScanHostResult',
    'GetAnalyticsInstancesAnalyticsInstanceResult',
    'GetAnalyticsInstancesAnalyticsInstanceCapacityResult',
    'GetAnalyticsInstancesAnalyticsInstanceNetworkEndpointDetailResult',
    'GetAnalyticsInstancesAnalyticsInstanceNetworkEndpointDetailWhitelistedVcnResult',
    'GetAnalyticsInstancesFilterResult',
]

@pulumi.output_type
class AnalyticsInstanceCapacity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityType":
            suggest = "capacity_type"
        elif key == "capacityValue":
            suggest = "capacity_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyticsInstanceCapacity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyticsInstanceCapacity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyticsInstanceCapacity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_type: _builtins.str,
                 capacity_value: _builtins.int):
        """
        :param _builtins.str capacity_type: The capacity model to use. Accepted values are: OLPU_COUNT, USER_COUNT
        :param _builtins.int capacity_value: (Updatable) The capacity value selected, either the number of OCPUs (OLPU_COUNT) or the number of users (USER_COUNT). This parameter affects the number of OCPUs, amount of memory, and other resources allocated to the instance.
        """
        pulumi.set(__self__, "capacity_type", capacity_type)
        pulumi.set(__self__, "capacity_value", capacity_value)

    @_builtins.property
    @pulumi.getter(name="capacityType")
    def capacity_type(self) -> _builtins.str:
        """
        The capacity model to use. Accepted values are: OLPU_COUNT, USER_COUNT
        """
        return pulumi.get(self, "capacity_type")

    @_builtins.property
    @pulumi.getter(name="capacityValue")
    def capacity_value(self) -> _builtins.int:
        """
        (Updatable) The capacity value selected, either the number of OCPUs (OLPU_COUNT) or the number of users (USER_COUNT). This parameter affects the number of OCPUs, amount of memory, and other resources allocated to the instance.
        """
        return pulumi.get(self, "capacity_value")


@pulumi.output_type
class AnalyticsInstanceNetworkEndpointDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkEndpointType":
            suggest = "network_endpoint_type"
        elif key == "networkSecurityGroupIds":
            suggest = "network_security_group_ids"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "vcnId":
            suggest = "vcn_id"
        elif key == "whitelistedIps":
            suggest = "whitelisted_ips"
        elif key == "whitelistedServices":
            suggest = "whitelisted_services"
        elif key == "whitelistedVcns":
            suggest = "whitelisted_vcns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyticsInstanceNetworkEndpointDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyticsInstanceNetworkEndpointDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyticsInstanceNetworkEndpointDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_endpoint_type: _builtins.str,
                 network_security_group_ids: Optional[Sequence[_builtins.str]] = None,
                 subnet_id: Optional[_builtins.str] = None,
                 vcn_id: Optional[_builtins.str] = None,
                 whitelisted_ips: Optional[Sequence[_builtins.str]] = None,
                 whitelisted_services: Optional[Sequence[_builtins.str]] = None,
                 whitelisted_vcns: Optional[Sequence['outputs.AnalyticsInstanceNetworkEndpointDetailsWhitelistedVcn']] = None):
        """
        :param _builtins.str network_endpoint_type: The type of network endpoint.
        :param Sequence[_builtins.str] network_security_group_ids: Network Security Group OCIDs for an Analytics instance.
        :param _builtins.str subnet_id: The subnet OCID for the private endpoint.
        :param _builtins.str vcn_id: The VCN OCID for the private endpoint.
        :param Sequence[_builtins.str] whitelisted_ips: Source IP addresses or IP address ranges in ingress rules.
        :param Sequence[_builtins.str] whitelisted_services: Oracle Cloud Services that are allowed to access this Analytics instance.
        :param Sequence['AnalyticsInstanceNetworkEndpointDetailsWhitelistedVcnArgs'] whitelisted_vcns: Virtual Cloud Networks allowed to access this network endpoint.
        """
        pulumi.set(__self__, "network_endpoint_type", network_endpoint_type)
        if network_security_group_ids is not None:
            pulumi.set(__self__, "network_security_group_ids", network_security_group_ids)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vcn_id is not None:
            pulumi.set(__self__, "vcn_id", vcn_id)
        if whitelisted_ips is not None:
            pulumi.set(__self__, "whitelisted_ips", whitelisted_ips)
        if whitelisted_services is not None:
            pulumi.set(__self__, "whitelisted_services", whitelisted_services)
        if whitelisted_vcns is not None:
            pulumi.set(__self__, "whitelisted_vcns", whitelisted_vcns)

    @_builtins.property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> _builtins.str:
        """
        The type of network endpoint.
        """
        return pulumi.get(self, "network_endpoint_type")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Network Security Group OCIDs for an Analytics instance.
        """
        return pulumi.get(self, "network_security_group_ids")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        The subnet OCID for the private endpoint.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[_builtins.str]:
        """
        The VCN OCID for the private endpoint.
        """
        return pulumi.get(self, "vcn_id")

    @_builtins.property
    @pulumi.getter(name="whitelistedIps")
    def whitelisted_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        Source IP addresses or IP address ranges in ingress rules.
        """
        return pulumi.get(self, "whitelisted_ips")

    @_builtins.property
    @pulumi.getter(name="whitelistedServices")
    def whitelisted_services(self) -> Optional[Sequence[_builtins.str]]:
        """
        Oracle Cloud Services that are allowed to access this Analytics instance.
        """
        return pulumi.get(self, "whitelisted_services")

    @_builtins.property
    @pulumi.getter(name="whitelistedVcns")
    def whitelisted_vcns(self) -> Optional[Sequence['outputs.AnalyticsInstanceNetworkEndpointDetailsWhitelistedVcn']]:
        """
        Virtual Cloud Networks allowed to access this network endpoint.
        """
        return pulumi.get(self, "whitelisted_vcns")


@pulumi.output_type
class AnalyticsInstanceNetworkEndpointDetailsWhitelistedVcn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "whitelistedIps":
            suggest = "whitelisted_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyticsInstanceNetworkEndpointDetailsWhitelistedVcn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyticsInstanceNetworkEndpointDetailsWhitelistedVcn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyticsInstanceNetworkEndpointDetailsWhitelistedVcn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 whitelisted_ips: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str id: The Virtual Cloud Network OCID.
        :param Sequence[_builtins.str] whitelisted_ips: Source IP addresses or IP address ranges in ingress rules.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if whitelisted_ips is not None:
            pulumi.set(__self__, "whitelisted_ips", whitelisted_ips)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="whitelistedIps")
    def whitelisted_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        Source IP addresses or IP address ranges in ingress rules.
        """
        return pulumi.get(self, "whitelisted_ips")


@pulumi.output_type
class AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZone(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsZone":
            suggest = "dns_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZone. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZone.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZone.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_zone: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str dns_zone: (Updatable) Private Source DNS Zone. Ex: example-vcn.oraclevcn.com, corp.example.com.
        :param _builtins.str description: (Updatable) Description of private source dns zone.
        """
        pulumi.set(__self__, "dns_zone", dns_zone)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="dnsZone")
    def dns_zone(self) -> _builtins.str:
        """
        (Updatable) Private Source DNS Zone. Ex: example-vcn.oraclevcn.com, corp.example.com.
        """
        return pulumi.get(self, "dns_zone")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        (Updatable) Description of private source dns zone.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class AnalyticsInstancePrivateAccessChannelPrivateSourceScanHost(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scanHostname":
            suggest = "scan_hostname"
        elif key == "scanPort":
            suggest = "scan_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyticsInstancePrivateAccessChannelPrivateSourceScanHost. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyticsInstancePrivateAccessChannelPrivateSourceScanHost.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyticsInstancePrivateAccessChannelPrivateSourceScanHost.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scan_hostname: _builtins.str,
                 scan_port: _builtins.int,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str scan_hostname: (Updatable) Private Source Scan hostname. Ex: db01-scan.corp.example.com, prd-db01-scan.mycompany.com.
        :param _builtins.int scan_port: (Updatable) Private Source Scan host port. This is the source port where SCAN protocol will get connected (e.g. 1521).
        :param _builtins.str description: (Updatable) Description of private source scan host zone.
        """
        pulumi.set(__self__, "scan_hostname", scan_hostname)
        pulumi.set(__self__, "scan_port", scan_port)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="scanHostname")
    def scan_hostname(self) -> _builtins.str:
        """
        (Updatable) Private Source Scan hostname. Ex: db01-scan.corp.example.com, prd-db01-scan.mycompany.com.
        """
        return pulumi.get(self, "scan_hostname")

    @_builtins.property
    @pulumi.getter(name="scanPort")
    def scan_port(self) -> _builtins.int:
        """
        (Updatable) Private Source Scan host port. This is the source port where SCAN protocol will get connected (e.g. 1521).
        """
        return pulumi.get(self, "scan_port")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        (Updatable) Description of private source scan host zone.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GetAnalyticsInstanceCapacityResult(dict):
    def __init__(__self__, *,
                 capacity_type: _builtins.str,
                 capacity_value: _builtins.int):
        """
        :param _builtins.str capacity_type: The capacity model to use. Accepted values are: OLPU_COUNT, USER_COUNT
        :param _builtins.int capacity_value: The capacity value selected, either the number of OCPUs (OLPU_COUNT) or the number of users (USER_COUNT). This parameter affects the number of OCPUs, amount of memory, and other resources allocated to the instance.
        """
        pulumi.set(__self__, "capacity_type", capacity_type)
        pulumi.set(__self__, "capacity_value", capacity_value)

    @_builtins.property
    @pulumi.getter(name="capacityType")
    def capacity_type(self) -> _builtins.str:
        """
        The capacity model to use. Accepted values are: OLPU_COUNT, USER_COUNT
        """
        return pulumi.get(self, "capacity_type")

    @_builtins.property
    @pulumi.getter(name="capacityValue")
    def capacity_value(self) -> _builtins.int:
        """
        The capacity value selected, either the number of OCPUs (OLPU_COUNT) or the number of users (USER_COUNT). This parameter affects the number of OCPUs, amount of memory, and other resources allocated to the instance.
        """
        return pulumi.get(self, "capacity_value")


@pulumi.output_type
class GetAnalyticsInstanceNetworkEndpointDetailResult(dict):
    def __init__(__self__, *,
                 network_endpoint_type: _builtins.str,
                 network_security_group_ids: Sequence[_builtins.str],
                 subnet_id: _builtins.str,
                 vcn_id: _builtins.str,
                 whitelisted_ips: Sequence[_builtins.str],
                 whitelisted_services: Sequence[_builtins.str],
                 whitelisted_vcns: Sequence['outputs.GetAnalyticsInstanceNetworkEndpointDetailWhitelistedVcnResult']):
        """
        :param _builtins.str network_endpoint_type: The type of network endpoint.
        :param Sequence[_builtins.str] network_security_group_ids: Network Security Group OCIDs for an Analytics instance.
        :param _builtins.str subnet_id: OCID of the customer subnet connected to private access channel.
        :param _builtins.str vcn_id: OCID of the customer VCN peered with private access channel.
        :param Sequence[_builtins.str] whitelisted_ips: Source IP addresses or IP address ranges in ingress rules.
        :param Sequence[_builtins.str] whitelisted_services: Oracle Cloud Services that are allowed to access this Analytics instance.
        :param Sequence['GetAnalyticsInstanceNetworkEndpointDetailWhitelistedVcnArgs'] whitelisted_vcns: Virtual Cloud Networks allowed to access this network endpoint.
        """
        pulumi.set(__self__, "network_endpoint_type", network_endpoint_type)
        pulumi.set(__self__, "network_security_group_ids", network_security_group_ids)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vcn_id", vcn_id)
        pulumi.set(__self__, "whitelisted_ips", whitelisted_ips)
        pulumi.set(__self__, "whitelisted_services", whitelisted_services)
        pulumi.set(__self__, "whitelisted_vcns", whitelisted_vcns)

    @_builtins.property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> _builtins.str:
        """
        The type of network endpoint.
        """
        return pulumi.get(self, "network_endpoint_type")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Sequence[_builtins.str]:
        """
        Network Security Group OCIDs for an Analytics instance.
        """
        return pulumi.get(self, "network_security_group_ids")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        OCID of the customer subnet connected to private access channel.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> _builtins.str:
        """
        OCID of the customer VCN peered with private access channel.
        """
        return pulumi.get(self, "vcn_id")

    @_builtins.property
    @pulumi.getter(name="whitelistedIps")
    def whitelisted_ips(self) -> Sequence[_builtins.str]:
        """
        Source IP addresses or IP address ranges in ingress rules.
        """
        return pulumi.get(self, "whitelisted_ips")

    @_builtins.property
    @pulumi.getter(name="whitelistedServices")
    def whitelisted_services(self) -> Sequence[_builtins.str]:
        """
        Oracle Cloud Services that are allowed to access this Analytics instance.
        """
        return pulumi.get(self, "whitelisted_services")

    @_builtins.property
    @pulumi.getter(name="whitelistedVcns")
    def whitelisted_vcns(self) -> Sequence['outputs.GetAnalyticsInstanceNetworkEndpointDetailWhitelistedVcnResult']:
        """
        Virtual Cloud Networks allowed to access this network endpoint.
        """
        return pulumi.get(self, "whitelisted_vcns")


@pulumi.output_type
class GetAnalyticsInstanceNetworkEndpointDetailWhitelistedVcnResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 whitelisted_ips: Sequence[_builtins.str]):
        """
        :param _builtins.str id: The Virtual Cloud Network OCID.
        :param Sequence[_builtins.str] whitelisted_ips: Source IP addresses or IP address ranges in ingress rules.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "whitelisted_ips", whitelisted_ips)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="whitelistedIps")
    def whitelisted_ips(self) -> Sequence[_builtins.str]:
        """
        Source IP addresses or IP address ranges in ingress rules.
        """
        return pulumi.get(self, "whitelisted_ips")


@pulumi.output_type
class GetAnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 dns_zone: _builtins.str):
        """
        :param _builtins.str description: Description of private source scan host zone.
        :param _builtins.str dns_zone: Private Source DNS Zone. Ex: example-vcn.oraclevcn.com, corp.example.com.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dns_zone", dns_zone)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of private source scan host zone.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dnsZone")
    def dns_zone(self) -> _builtins.str:
        """
        Private Source DNS Zone. Ex: example-vcn.oraclevcn.com, corp.example.com.
        """
        return pulumi.get(self, "dns_zone")


@pulumi.output_type
class GetAnalyticsInstancePrivateAccessChannelPrivateSourceScanHostResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 scan_hostname: _builtins.str,
                 scan_port: _builtins.int):
        """
        :param _builtins.str description: Description of private source scan host zone.
        :param _builtins.str scan_hostname: Private Source Scan hostname. Ex: db01-scan.corp.example.com, prd-db01-scan.mycompany.com.
        :param _builtins.int scan_port: Private Source Scan host port. This is the source port where SCAN protocol will get connected (e.g. 1521).
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "scan_hostname", scan_hostname)
        pulumi.set(__self__, "scan_port", scan_port)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of private source scan host zone.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="scanHostname")
    def scan_hostname(self) -> _builtins.str:
        """
        Private Source Scan hostname. Ex: db01-scan.corp.example.com, prd-db01-scan.mycompany.com.
        """
        return pulumi.get(self, "scan_hostname")

    @_builtins.property
    @pulumi.getter(name="scanPort")
    def scan_port(self) -> _builtins.int:
        """
        Private Source Scan host port. This is the source port where SCAN protocol will get connected (e.g. 1521).
        """
        return pulumi.get(self, "scan_port")


@pulumi.output_type
class GetAnalyticsInstancesAnalyticsInstanceResult(dict):
    def __init__(__self__, *,
                 admin_user: _builtins.str,
                 capacities: Sequence['outputs.GetAnalyticsInstancesAnalyticsInstanceCapacityResult'],
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 domain_id: _builtins.str,
                 email_notification: _builtins.str,
                 feature_bundle: _builtins.str,
                 feature_set: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 idcs_access_token: _builtins.str,
                 kms_key_id: _builtins.str,
                 license_type: _builtins.str,
                 name: _builtins.str,
                 network_endpoint_details: Sequence['outputs.GetAnalyticsInstancesAnalyticsInstanceNetworkEndpointDetailResult'],
                 service_url: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 update_channel: _builtins.str):
        """
        :param Sequence['GetAnalyticsInstancesAnalyticsInstanceCapacityArgs'] capacities: Service instance capacity metadata (e.g.: OLPU count, number of users, ...etc...).
        :param _builtins.str compartment_id: The OCID of the compartment.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str description: Description of the vanity url.
        :param _builtins.str domain_id: Identity domain OCID.
        :param _builtins.str email_notification: Email address receiving notifications.
        :param _builtins.str feature_bundle: The feature set of an Analytics instance.
        :param _builtins.str feature_set: A filter to only return resources matching the feature set. Values are case-insensitive.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: The Virtual Cloud Network OCID.
        :param _builtins.str kms_key_id: OCID of the Oracle Cloud Infrastructure Vault Key encrypting the customer data stored in this Analytics instance. A null value indicates Oracle managed default encryption.
        :param _builtins.str license_type: The license used for the service.
        :param _builtins.str name: A filter to return only resources that match the given name exactly.
        :param Sequence['GetAnalyticsInstancesAnalyticsInstanceNetworkEndpointDetailArgs'] network_endpoint_details: Base representation of a network endpoint.
        :param _builtins.str service_url: URL of the Analytics service.
        :param _builtins.str state: A filter to only return resources matching the lifecycle state. The state value is case-insensitive.
        :param Mapping[str, _builtins.str] system_tags: System tags for this resource. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.key": "value"}`
        :param _builtins.str time_created: The date and time the instance was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        :param _builtins.str time_updated: The date and time the instance was last updated (in the format defined by RFC3339). This timestamp represents updates made through this API. External events do not influence it.
        :param _builtins.str update_channel: Analytics instance update channel.
        """
        pulumi.set(__self__, "admin_user", admin_user)
        pulumi.set(__self__, "capacities", capacities)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "domain_id", domain_id)
        pulumi.set(__self__, "email_notification", email_notification)
        pulumi.set(__self__, "feature_bundle", feature_bundle)
        pulumi.set(__self__, "feature_set", feature_set)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "idcs_access_token", idcs_access_token)
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "license_type", license_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_endpoint_details", network_endpoint_details)
        pulumi.set(__self__, "service_url", service_url)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "update_channel", update_channel)

    @_builtins.property
    @pulumi.getter(name="adminUser")
    def admin_user(self) -> _builtins.str:
        return pulumi.get(self, "admin_user")

    @_builtins.property
    @pulumi.getter
    def capacities(self) -> Sequence['outputs.GetAnalyticsInstancesAnalyticsInstanceCapacityResult']:
        """
        Service instance capacity metadata (e.g.: OLPU count, number of users, ...etc...).
        """
        return pulumi.get(self, "capacities")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the vanity url.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> _builtins.str:
        """
        Identity domain OCID.
        """
        return pulumi.get(self, "domain_id")

    @_builtins.property
    @pulumi.getter(name="emailNotification")
    def email_notification(self) -> _builtins.str:
        """
        Email address receiving notifications.
        """
        return pulumi.get(self, "email_notification")

    @_builtins.property
    @pulumi.getter(name="featureBundle")
    def feature_bundle(self) -> _builtins.str:
        """
        The feature set of an Analytics instance.
        """
        return pulumi.get(self, "feature_bundle")

    @_builtins.property
    @pulumi.getter(name="featureSet")
    def feature_set(self) -> _builtins.str:
        """
        A filter to only return resources matching the feature set. Values are case-insensitive.
        """
        return pulumi.get(self, "feature_set")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="idcsAccessToken")
    def idcs_access_token(self) -> _builtins.str:
        return pulumi.get(self, "idcs_access_token")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> _builtins.str:
        """
        OCID of the Oracle Cloud Infrastructure Vault Key encrypting the customer data stored in this Analytics instance. A null value indicates Oracle managed default encryption.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> _builtins.str:
        """
        The license used for the service.
        """
        return pulumi.get(self, "license_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A filter to return only resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkEndpointDetails")
    def network_endpoint_details(self) -> Sequence['outputs.GetAnalyticsInstancesAnalyticsInstanceNetworkEndpointDetailResult']:
        """
        Base representation of a network endpoint.
        """
        return pulumi.get(self, "network_endpoint_details")

    @_builtins.property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> _builtins.str:
        """
        URL of the Analytics service.
        """
        return pulumi.get(self, "service_url")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to only return resources matching the lifecycle state. The state value is case-insensitive.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.key": "value"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the instance was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the instance was last updated (in the format defined by RFC3339). This timestamp represents updates made through this API. External events do not influence it.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="updateChannel")
    def update_channel(self) -> _builtins.str:
        """
        Analytics instance update channel.
        """
        return pulumi.get(self, "update_channel")


@pulumi.output_type
class GetAnalyticsInstancesAnalyticsInstanceCapacityResult(dict):
    def __init__(__self__, *,
                 capacity_type: _builtins.str,
                 capacity_value: _builtins.int):
        """
        :param _builtins.str capacity_type: A filter to only return resources matching the capacity type enum. Values are case-insensitive.
        :param _builtins.int capacity_value: The capacity value selected, either the number of OCPUs (OLPU_COUNT) or the number of users (USER_COUNT). This parameter affects the number of OCPUs, amount of memory, and other resources allocated to the instance.
        """
        pulumi.set(__self__, "capacity_type", capacity_type)
        pulumi.set(__self__, "capacity_value", capacity_value)

    @_builtins.property
    @pulumi.getter(name="capacityType")
    def capacity_type(self) -> _builtins.str:
        """
        A filter to only return resources matching the capacity type enum. Values are case-insensitive.
        """
        return pulumi.get(self, "capacity_type")

    @_builtins.property
    @pulumi.getter(name="capacityValue")
    def capacity_value(self) -> _builtins.int:
        """
        The capacity value selected, either the number of OCPUs (OLPU_COUNT) or the number of users (USER_COUNT). This parameter affects the number of OCPUs, amount of memory, and other resources allocated to the instance.
        """
        return pulumi.get(self, "capacity_value")


@pulumi.output_type
class GetAnalyticsInstancesAnalyticsInstanceNetworkEndpointDetailResult(dict):
    def __init__(__self__, *,
                 network_endpoint_type: _builtins.str,
                 network_security_group_ids: Sequence[_builtins.str],
                 subnet_id: _builtins.str,
                 vcn_id: _builtins.str,
                 whitelisted_ips: Sequence[_builtins.str],
                 whitelisted_services: Sequence[_builtins.str],
                 whitelisted_vcns: Sequence['outputs.GetAnalyticsInstancesAnalyticsInstanceNetworkEndpointDetailWhitelistedVcnResult']):
        """
        :param _builtins.str network_endpoint_type: The type of network endpoint.
        :param Sequence[_builtins.str] network_security_group_ids: Network Security Group OCIDs for an Analytics instance.
        :param _builtins.str subnet_id: OCID of the customer subnet connected to private access channel.
        :param _builtins.str vcn_id: OCID of the customer VCN peered with private access channel.
        :param Sequence[_builtins.str] whitelisted_ips: Source IP addresses or IP address ranges in ingress rules.
        :param Sequence[_builtins.str] whitelisted_services: Oracle Cloud Services that are allowed to access this Analytics instance.
        :param Sequence['GetAnalyticsInstancesAnalyticsInstanceNetworkEndpointDetailWhitelistedVcnArgs'] whitelisted_vcns: Virtual Cloud Networks allowed to access this network endpoint.
        """
        pulumi.set(__self__, "network_endpoint_type", network_endpoint_type)
        pulumi.set(__self__, "network_security_group_ids", network_security_group_ids)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vcn_id", vcn_id)
        pulumi.set(__self__, "whitelisted_ips", whitelisted_ips)
        pulumi.set(__self__, "whitelisted_services", whitelisted_services)
        pulumi.set(__self__, "whitelisted_vcns", whitelisted_vcns)

    @_builtins.property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> _builtins.str:
        """
        The type of network endpoint.
        """
        return pulumi.get(self, "network_endpoint_type")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Sequence[_builtins.str]:
        """
        Network Security Group OCIDs for an Analytics instance.
        """
        return pulumi.get(self, "network_security_group_ids")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        OCID of the customer subnet connected to private access channel.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> _builtins.str:
        """
        OCID of the customer VCN peered with private access channel.
        """
        return pulumi.get(self, "vcn_id")

    @_builtins.property
    @pulumi.getter(name="whitelistedIps")
    def whitelisted_ips(self) -> Sequence[_builtins.str]:
        """
        Source IP addresses or IP address ranges in ingress rules.
        """
        return pulumi.get(self, "whitelisted_ips")

    @_builtins.property
    @pulumi.getter(name="whitelistedServices")
    def whitelisted_services(self) -> Sequence[_builtins.str]:
        """
        Oracle Cloud Services that are allowed to access this Analytics instance.
        """
        return pulumi.get(self, "whitelisted_services")

    @_builtins.property
    @pulumi.getter(name="whitelistedVcns")
    def whitelisted_vcns(self) -> Sequence['outputs.GetAnalyticsInstancesAnalyticsInstanceNetworkEndpointDetailWhitelistedVcnResult']:
        """
        Virtual Cloud Networks allowed to access this network endpoint.
        """
        return pulumi.get(self, "whitelisted_vcns")


@pulumi.output_type
class GetAnalyticsInstancesAnalyticsInstanceNetworkEndpointDetailWhitelistedVcnResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 whitelisted_ips: Sequence[_builtins.str]):
        """
        :param _builtins.str id: The Virtual Cloud Network OCID.
        :param Sequence[_builtins.str] whitelisted_ips: Source IP addresses or IP address ranges in ingress rules.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "whitelisted_ips", whitelisted_ips)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="whitelistedIps")
    def whitelisted_ips(self) -> Sequence[_builtins.str]:
        """
        Source IP addresses or IP address ranges in ingress rules.
        """
        return pulumi.get(self, "whitelisted_ips")


@pulumi.output_type
class GetAnalyticsInstancesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A filter to return only resources that match the given name exactly.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A filter to return only resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


