# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetScheduledQueryResult',
    'AwaitableGetScheduledQueryResult',
    'get_scheduled_query',
    'get_scheduled_query_output',
]

@pulumi.output_type
class GetScheduledQueryResult:
    """
    A collection of values returned by getScheduledQuery.
    """
    def __init__(__self__, apm_domain_id=None, defined_tags=None, freeform_tags=None, id=None, opc_dry_run=None, scheduled_query_description=None, scheduled_query_id=None, scheduled_query_instances=None, scheduled_query_maximum_runtime_in_seconds=None, scheduled_query_name=None, scheduled_query_next_run_in_ms=None, scheduled_query_processing_configurations=None, scheduled_query_processing_sub_type=None, scheduled_query_processing_type=None, scheduled_query_retention_criteria=None, scheduled_query_retention_period_in_ms=None, scheduled_query_schedule=None, scheduled_query_text=None, state=None, system_tags=None):
        if apm_domain_id and not isinstance(apm_domain_id, str):
            raise TypeError("Expected argument 'apm_domain_id' to be a str")
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if opc_dry_run and not isinstance(opc_dry_run, str):
            raise TypeError("Expected argument 'opc_dry_run' to be a str")
        pulumi.set(__self__, "opc_dry_run", opc_dry_run)
        if scheduled_query_description and not isinstance(scheduled_query_description, str):
            raise TypeError("Expected argument 'scheduled_query_description' to be a str")
        pulumi.set(__self__, "scheduled_query_description", scheduled_query_description)
        if scheduled_query_id and not isinstance(scheduled_query_id, str):
            raise TypeError("Expected argument 'scheduled_query_id' to be a str")
        pulumi.set(__self__, "scheduled_query_id", scheduled_query_id)
        if scheduled_query_instances and not isinstance(scheduled_query_instances, str):
            raise TypeError("Expected argument 'scheduled_query_instances' to be a str")
        pulumi.set(__self__, "scheduled_query_instances", scheduled_query_instances)
        if scheduled_query_maximum_runtime_in_seconds and not isinstance(scheduled_query_maximum_runtime_in_seconds, str):
            raise TypeError("Expected argument 'scheduled_query_maximum_runtime_in_seconds' to be a str")
        pulumi.set(__self__, "scheduled_query_maximum_runtime_in_seconds", scheduled_query_maximum_runtime_in_seconds)
        if scheduled_query_name and not isinstance(scheduled_query_name, str):
            raise TypeError("Expected argument 'scheduled_query_name' to be a str")
        pulumi.set(__self__, "scheduled_query_name", scheduled_query_name)
        if scheduled_query_next_run_in_ms and not isinstance(scheduled_query_next_run_in_ms, str):
            raise TypeError("Expected argument 'scheduled_query_next_run_in_ms' to be a str")
        pulumi.set(__self__, "scheduled_query_next_run_in_ms", scheduled_query_next_run_in_ms)
        if scheduled_query_processing_configurations and not isinstance(scheduled_query_processing_configurations, list):
            raise TypeError("Expected argument 'scheduled_query_processing_configurations' to be a list")
        pulumi.set(__self__, "scheduled_query_processing_configurations", scheduled_query_processing_configurations)
        if scheduled_query_processing_sub_type and not isinstance(scheduled_query_processing_sub_type, str):
            raise TypeError("Expected argument 'scheduled_query_processing_sub_type' to be a str")
        pulumi.set(__self__, "scheduled_query_processing_sub_type", scheduled_query_processing_sub_type)
        if scheduled_query_processing_type and not isinstance(scheduled_query_processing_type, str):
            raise TypeError("Expected argument 'scheduled_query_processing_type' to be a str")
        pulumi.set(__self__, "scheduled_query_processing_type", scheduled_query_processing_type)
        if scheduled_query_retention_criteria and not isinstance(scheduled_query_retention_criteria, str):
            raise TypeError("Expected argument 'scheduled_query_retention_criteria' to be a str")
        pulumi.set(__self__, "scheduled_query_retention_criteria", scheduled_query_retention_criteria)
        if scheduled_query_retention_period_in_ms and not isinstance(scheduled_query_retention_period_in_ms, str):
            raise TypeError("Expected argument 'scheduled_query_retention_period_in_ms' to be a str")
        pulumi.set(__self__, "scheduled_query_retention_period_in_ms", scheduled_query_retention_period_in_ms)
        if scheduled_query_schedule and not isinstance(scheduled_query_schedule, str):
            raise TypeError("Expected argument 'scheduled_query_schedule' to be a str")
        pulumi.set(__self__, "scheduled_query_schedule", scheduled_query_schedule)
        if scheduled_query_text and not isinstance(scheduled_query_text, str):
            raise TypeError("Expected argument 'scheduled_query_text' to be a str")
        pulumi.set(__self__, "scheduled_query_text", scheduled_query_text)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)

    @_builtins.property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> _builtins.str:
        return pulumi.get(self, "apm_domain_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the scheduled query . An OCID is generated when the scheduled query is created.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> _builtins.str:
        return pulumi.get(self, "opc_dry_run")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryDescription")
    def scheduled_query_description(self) -> _builtins.str:
        """
        Description for the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_description")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryId")
    def scheduled_query_id(self) -> _builtins.str:
        return pulumi.get(self, "scheduled_query_id")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryInstances")
    def scheduled_query_instances(self) -> _builtins.str:
        """
        Scheduled query instances.
        """
        return pulumi.get(self, "scheduled_query_instances")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryMaximumRuntimeInSeconds")
    def scheduled_query_maximum_runtime_in_seconds(self) -> _builtins.str:
        """
        Maximum runtime for the scheduled query in seconds.
        """
        return pulumi.get(self, "scheduled_query_maximum_runtime_in_seconds")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryName")
    def scheduled_query_name(self) -> _builtins.str:
        """
        Name of the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_name")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryNextRunInMs")
    def scheduled_query_next_run_in_ms(self) -> _builtins.str:
        """
        Next run for the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_next_run_in_ms")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryProcessingConfigurations")
    def scheduled_query_processing_configurations(self) -> Sequence['outputs.GetScheduledQueryScheduledQueryProcessingConfigurationResult']:
        """
        Definition of the scheduled query processing configuration.
        """
        return pulumi.get(self, "scheduled_query_processing_configurations")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryProcessingSubType")
    def scheduled_query_processing_sub_type(self) -> _builtins.str:
        """
        Processing sub type of the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_processing_sub_type")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryProcessingType")
    def scheduled_query_processing_type(self) -> _builtins.str:
        """
        Processing type of the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_processing_type")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryRetentionCriteria")
    def scheduled_query_retention_criteria(self) -> _builtins.str:
        """
        Retention criteria for the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_retention_criteria")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryRetentionPeriodInMs")
    def scheduled_query_retention_period_in_ms(self) -> _builtins.str:
        """
        Retention period for the scheduled query in milliseconds.
        """
        return pulumi.get(self, "scheduled_query_retention_period_in_ms")

    @_builtins.property
    @pulumi.getter(name="scheduledQuerySchedule")
    def scheduled_query_schedule(self) -> _builtins.str:
        """
        Schedule for the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_schedule")

    @_builtins.property
    @pulumi.getter(name="scheduledQueryText")
    def scheduled_query_text(self) -> _builtins.str:
        """
        Scheduled query to be run.
        """
        return pulumi.get(self, "scheduled_query_text")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current lifecycle state of the Scheduled Query.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")


class AwaitableGetScheduledQueryResult(GetScheduledQueryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScheduledQueryResult(
            apm_domain_id=self.apm_domain_id,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            id=self.id,
            opc_dry_run=self.opc_dry_run,
            scheduled_query_description=self.scheduled_query_description,
            scheduled_query_id=self.scheduled_query_id,
            scheduled_query_instances=self.scheduled_query_instances,
            scheduled_query_maximum_runtime_in_seconds=self.scheduled_query_maximum_runtime_in_seconds,
            scheduled_query_name=self.scheduled_query_name,
            scheduled_query_next_run_in_ms=self.scheduled_query_next_run_in_ms,
            scheduled_query_processing_configurations=self.scheduled_query_processing_configurations,
            scheduled_query_processing_sub_type=self.scheduled_query_processing_sub_type,
            scheduled_query_processing_type=self.scheduled_query_processing_type,
            scheduled_query_retention_criteria=self.scheduled_query_retention_criteria,
            scheduled_query_retention_period_in_ms=self.scheduled_query_retention_period_in_ms,
            scheduled_query_schedule=self.scheduled_query_schedule,
            scheduled_query_text=self.scheduled_query_text,
            state=self.state,
            system_tags=self.system_tags)


def get_scheduled_query(apm_domain_id: Optional[_builtins.str] = None,
                        scheduled_query_id: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScheduledQueryResult:
    """
    This data source provides details about a specific Scheduled Query resource in Oracle Cloud Infrastructure Apm Traces service.

    Retrieve a scheduled query in the APM Domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduled_query = oci.ApmTraces.get_scheduled_query(apm_domain_id=test_apm_domain["id"],
        scheduled_query_id=test_scheduled_query_oci_apm_traces_scheduled_query["id"])
    ```


    :param _builtins.str apm_domain_id: The APM Domain ID for the intended request.
    :param _builtins.str scheduled_query_id: Id of the scheduled query.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['scheduledQueryId'] = scheduled_query_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApmTraces/getScheduledQuery:getScheduledQuery', __args__, opts=opts, typ=GetScheduledQueryResult).value

    return AwaitableGetScheduledQueryResult(
        apm_domain_id=pulumi.get(__ret__, 'apm_domain_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        opc_dry_run=pulumi.get(__ret__, 'opc_dry_run'),
        scheduled_query_description=pulumi.get(__ret__, 'scheduled_query_description'),
        scheduled_query_id=pulumi.get(__ret__, 'scheduled_query_id'),
        scheduled_query_instances=pulumi.get(__ret__, 'scheduled_query_instances'),
        scheduled_query_maximum_runtime_in_seconds=pulumi.get(__ret__, 'scheduled_query_maximum_runtime_in_seconds'),
        scheduled_query_name=pulumi.get(__ret__, 'scheduled_query_name'),
        scheduled_query_next_run_in_ms=pulumi.get(__ret__, 'scheduled_query_next_run_in_ms'),
        scheduled_query_processing_configurations=pulumi.get(__ret__, 'scheduled_query_processing_configurations'),
        scheduled_query_processing_sub_type=pulumi.get(__ret__, 'scheduled_query_processing_sub_type'),
        scheduled_query_processing_type=pulumi.get(__ret__, 'scheduled_query_processing_type'),
        scheduled_query_retention_criteria=pulumi.get(__ret__, 'scheduled_query_retention_criteria'),
        scheduled_query_retention_period_in_ms=pulumi.get(__ret__, 'scheduled_query_retention_period_in_ms'),
        scheduled_query_schedule=pulumi.get(__ret__, 'scheduled_query_schedule'),
        scheduled_query_text=pulumi.get(__ret__, 'scheduled_query_text'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'))
def get_scheduled_query_output(apm_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                               scheduled_query_id: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetScheduledQueryResult]:
    """
    This data source provides details about a specific Scheduled Query resource in Oracle Cloud Infrastructure Apm Traces service.

    Retrieve a scheduled query in the APM Domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduled_query = oci.ApmTraces.get_scheduled_query(apm_domain_id=test_apm_domain["id"],
        scheduled_query_id=test_scheduled_query_oci_apm_traces_scheduled_query["id"])
    ```


    :param _builtins.str apm_domain_id: The APM Domain ID for the intended request.
    :param _builtins.str scheduled_query_id: Id of the scheduled query.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['scheduledQueryId'] = scheduled_query_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ApmTraces/getScheduledQuery:getScheduledQuery', __args__, opts=opts, typ=GetScheduledQueryResult)
    return __ret__.apply(lambda __response__: GetScheduledQueryResult(
        apm_domain_id=pulumi.get(__response__, 'apm_domain_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        opc_dry_run=pulumi.get(__response__, 'opc_dry_run'),
        scheduled_query_description=pulumi.get(__response__, 'scheduled_query_description'),
        scheduled_query_id=pulumi.get(__response__, 'scheduled_query_id'),
        scheduled_query_instances=pulumi.get(__response__, 'scheduled_query_instances'),
        scheduled_query_maximum_runtime_in_seconds=pulumi.get(__response__, 'scheduled_query_maximum_runtime_in_seconds'),
        scheduled_query_name=pulumi.get(__response__, 'scheduled_query_name'),
        scheduled_query_next_run_in_ms=pulumi.get(__response__, 'scheduled_query_next_run_in_ms'),
        scheduled_query_processing_configurations=pulumi.get(__response__, 'scheduled_query_processing_configurations'),
        scheduled_query_processing_sub_type=pulumi.get(__response__, 'scheduled_query_processing_sub_type'),
        scheduled_query_processing_type=pulumi.get(__response__, 'scheduled_query_processing_type'),
        scheduled_query_retention_criteria=pulumi.get(__response__, 'scheduled_query_retention_criteria'),
        scheduled_query_retention_period_in_ms=pulumi.get(__response__, 'scheduled_query_retention_period_in_ms'),
        scheduled_query_schedule=pulumi.get(__response__, 'scheduled_query_schedule'),
        scheduled_query_text=pulumi.get(__response__, 'scheduled_query_text'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags')))
