# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InternalOccmDemandSignalDeliveryArgs', 'InternalOccmDemandSignalDelivery']

@pulumi.input_type
class InternalOccmDemandSignalDeliveryArgs:
    def __init__(__self__, *,
                 accepted_quantity: pulumi.Input[_builtins.str],
                 compartment_id: pulumi.Input[_builtins.str],
                 demand_signal_id: pulumi.Input[_builtins.str],
                 demand_signal_item_id: pulumi.Input[_builtins.str],
                 occ_customer_group_id: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 justification: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a InternalOccmDemandSignalDelivery resource.
        :param pulumi.Input[_builtins.str] accepted_quantity: (Updatable) The quantity of the resource that Oracle Cloud Infrastructure will supply to the customer.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the tenancy from which the demand signal delivery resource is created.
        :param pulumi.Input[_builtins.str] demand_signal_id: The OCID of the demand signal under which this delivery will be grouped.
        :param pulumi.Input[_builtins.str] demand_signal_item_id: The OCID of the demand signal item corresponding to which this delivery is made.
        :param pulumi.Input[_builtins.str] occ_customer_group_id: The OCID of the corresponding customer group to which this demand signal delivery resource belongs to. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] justification: (Updatable) This field could be used by Oracle Cloud Infrastructure to communicate the reason for declining the request.
        :param pulumi.Input[_builtins.str] lifecycle_details: The enum values corresponding to the various states associated with the delivery resource.
        :param pulumi.Input[_builtins.str] notes: (Updatable) This field acts as a notes section for operators.
        """
        pulumi.set(__self__, "accepted_quantity", accepted_quantity)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "demand_signal_id", demand_signal_id)
        pulumi.set(__self__, "demand_signal_item_id", demand_signal_item_id)
        pulumi.set(__self__, "occ_customer_group_id", occ_customer_group_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if justification is not None:
            pulumi.set(__self__, "justification", justification)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)

    @_builtins.property
    @pulumi.getter(name="acceptedQuantity")
    def accepted_quantity(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The quantity of the resource that Oracle Cloud Infrastructure will supply to the customer.
        """
        return pulumi.get(self, "accepted_quantity")

    @accepted_quantity.setter
    def accepted_quantity(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "accepted_quantity", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the tenancy from which the demand signal delivery resource is created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="demandSignalId")
    def demand_signal_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the demand signal under which this delivery will be grouped.
        """
        return pulumi.get(self, "demand_signal_id")

    @demand_signal_id.setter
    def demand_signal_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "demand_signal_id", value)

    @_builtins.property
    @pulumi.getter(name="demandSignalItemId")
    def demand_signal_item_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the demand signal item corresponding to which this delivery is made.
        """
        return pulumi.get(self, "demand_signal_item_id")

    @demand_signal_item_id.setter
    def demand_signal_item_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "demand_signal_item_id", value)

    @_builtins.property
    @pulumi.getter(name="occCustomerGroupId")
    def occ_customer_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the corresponding customer group to which this demand signal delivery resource belongs to. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "occ_customer_group_id")

    @occ_customer_group_id.setter
    def occ_customer_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "occ_customer_group_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def justification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) This field could be used by Oracle Cloud Infrastructure to communicate the reason for declining the request.
        """
        return pulumi.get(self, "justification")

    @justification.setter
    def justification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "justification", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enum values corresponding to the various states associated with the delivery resource.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) This field acts as a notes section for operators.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notes", value)


@pulumi.input_type
class _InternalOccmDemandSignalDeliveryState:
    def __init__(__self__, *,
                 accepted_quantity: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 demand_signal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 demand_signal_item_id: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 justification: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 occ_customer_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_delivered: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InternalOccmDemandSignalDelivery resources.
        :param pulumi.Input[_builtins.str] accepted_quantity: (Updatable) The quantity of the resource that Oracle Cloud Infrastructure will supply to the customer.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the tenancy from which the demand signal delivery resource is created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] demand_signal_id: The OCID of the demand signal under which this delivery will be grouped.
        :param pulumi.Input[_builtins.str] demand_signal_item_id: The OCID of the demand signal item corresponding to which this delivery is made.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] justification: (Updatable) This field could be used by Oracle Cloud Infrastructure to communicate the reason for declining the request.
        :param pulumi.Input[_builtins.str] lifecycle_details: The enum values corresponding to the various states associated with the delivery resource.
        :param pulumi.Input[_builtins.str] notes: (Updatable) This field acts as a notes section for operators.
        :param pulumi.Input[_builtins.str] occ_customer_group_id: The OCID of the corresponding customer group to which this demand signal delivery resource belongs to. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_delivered: The date on which the Oracle Cloud Infrastructure delivered the resource to the customers. The default value for this will be the corresponding demand signal item resource's need by date.
        """
        if accepted_quantity is not None:
            pulumi.set(__self__, "accepted_quantity", accepted_quantity)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if demand_signal_id is not None:
            pulumi.set(__self__, "demand_signal_id", demand_signal_id)
        if demand_signal_item_id is not None:
            pulumi.set(__self__, "demand_signal_item_id", demand_signal_item_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if justification is not None:
            pulumi.set(__self__, "justification", justification)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if occ_customer_group_id is not None:
            pulumi.set(__self__, "occ_customer_group_id", occ_customer_group_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_delivered is not None:
            pulumi.set(__self__, "time_delivered", time_delivered)

    @_builtins.property
    @pulumi.getter(name="acceptedQuantity")
    def accepted_quantity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The quantity of the resource that Oracle Cloud Infrastructure will supply to the customer.
        """
        return pulumi.get(self, "accepted_quantity")

    @accepted_quantity.setter
    def accepted_quantity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "accepted_quantity", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the tenancy from which the demand signal delivery resource is created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="demandSignalId")
    def demand_signal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the demand signal under which this delivery will be grouped.
        """
        return pulumi.get(self, "demand_signal_id")

    @demand_signal_id.setter
    def demand_signal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "demand_signal_id", value)

    @_builtins.property
    @pulumi.getter(name="demandSignalItemId")
    def demand_signal_item_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the demand signal item corresponding to which this delivery is made.
        """
        return pulumi.get(self, "demand_signal_item_id")

    @demand_signal_item_id.setter
    def demand_signal_item_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "demand_signal_item_id", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def justification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) This field could be used by Oracle Cloud Infrastructure to communicate the reason for declining the request.
        """
        return pulumi.get(self, "justification")

    @justification.setter
    def justification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "justification", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enum values corresponding to the various states associated with the delivery resource.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) This field acts as a notes section for operators.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notes", value)

    @_builtins.property
    @pulumi.getter(name="occCustomerGroupId")
    def occ_customer_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the corresponding customer group to which this demand signal delivery resource belongs to. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "occ_customer_group_id")

    @occ_customer_group_id.setter
    def occ_customer_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "occ_customer_group_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeDelivered")
    def time_delivered(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date on which the Oracle Cloud Infrastructure delivered the resource to the customers. The default value for this will be the corresponding demand signal item resource's need by date.
        """
        return pulumi.get(self, "time_delivered")

    @time_delivered.setter
    def time_delivered(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_delivered", value)


@pulumi.type_token("oci:CapacityManagement/internalOccmDemandSignalDelivery:InternalOccmDemandSignalDelivery")
class InternalOccmDemandSignalDelivery(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accepted_quantity: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 demand_signal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 demand_signal_item_id: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 justification: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 occ_customer_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Internal Occm Demand Signal Delivery resource in Oracle Cloud Infrastructure Capacity Management service.

        This is a post API which is used to create a demand signal delivery resource.
        operationId: CreateInternalOccmDemandSignalDelivery
        summary: A post call to create a demand signal delivery.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_internal_occm_demand_signal_delivery = oci.capacitymanagement.InternalOccmDemandSignalDelivery("test_internal_occm_demand_signal_delivery",
            accepted_quantity=internal_occm_demand_signal_delivery_accepted_quantity,
            compartment_id=compartment_id,
            demand_signal_id=test_demand_signal["id"],
            demand_signal_item_id=test_demand_signal_item["id"],
            occ_customer_group_id=test_occ_customer_group["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            justification=internal_occm_demand_signal_delivery_justification,
            notes=internal_occm_demand_signal_delivery_notes)
        ```

        ## Import

        InternalOccmDemandSignalDeliveries can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CapacityManagement/internalOccmDemandSignalDelivery:InternalOccmDemandSignalDelivery test_internal_occm_demand_signal_delivery "internal/occmDemandSignalDeliveries/{occmDemandSignalDeliveryId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accepted_quantity: (Updatable) The quantity of the resource that Oracle Cloud Infrastructure will supply to the customer.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the tenancy from which the demand signal delivery resource is created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] demand_signal_id: The OCID of the demand signal under which this delivery will be grouped.
        :param pulumi.Input[_builtins.str] demand_signal_item_id: The OCID of the demand signal item corresponding to which this delivery is made.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] justification: (Updatable) This field could be used by Oracle Cloud Infrastructure to communicate the reason for declining the request.
        :param pulumi.Input[_builtins.str] lifecycle_details: The enum values corresponding to the various states associated with the delivery resource.
        :param pulumi.Input[_builtins.str] notes: (Updatable) This field acts as a notes section for operators.
        :param pulumi.Input[_builtins.str] occ_customer_group_id: The OCID of the corresponding customer group to which this demand signal delivery resource belongs to. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InternalOccmDemandSignalDeliveryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Internal Occm Demand Signal Delivery resource in Oracle Cloud Infrastructure Capacity Management service.

        This is a post API which is used to create a demand signal delivery resource.
        operationId: CreateInternalOccmDemandSignalDelivery
        summary: A post call to create a demand signal delivery.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_internal_occm_demand_signal_delivery = oci.capacitymanagement.InternalOccmDemandSignalDelivery("test_internal_occm_demand_signal_delivery",
            accepted_quantity=internal_occm_demand_signal_delivery_accepted_quantity,
            compartment_id=compartment_id,
            demand_signal_id=test_demand_signal["id"],
            demand_signal_item_id=test_demand_signal_item["id"],
            occ_customer_group_id=test_occ_customer_group["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            justification=internal_occm_demand_signal_delivery_justification,
            notes=internal_occm_demand_signal_delivery_notes)
        ```

        ## Import

        InternalOccmDemandSignalDeliveries can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CapacityManagement/internalOccmDemandSignalDelivery:InternalOccmDemandSignalDelivery test_internal_occm_demand_signal_delivery "internal/occmDemandSignalDeliveries/{occmDemandSignalDeliveryId}"
        ```

        :param str resource_name: The name of the resource.
        :param InternalOccmDemandSignalDeliveryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InternalOccmDemandSignalDeliveryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accepted_quantity: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 demand_signal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 demand_signal_item_id: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 justification: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 occ_customer_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InternalOccmDemandSignalDeliveryArgs.__new__(InternalOccmDemandSignalDeliveryArgs)

            if accepted_quantity is None and not opts.urn:
                raise TypeError("Missing required property 'accepted_quantity'")
            __props__.__dict__["accepted_quantity"] = accepted_quantity
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if demand_signal_id is None and not opts.urn:
                raise TypeError("Missing required property 'demand_signal_id'")
            __props__.__dict__["demand_signal_id"] = demand_signal_id
            if demand_signal_item_id is None and not opts.urn:
                raise TypeError("Missing required property 'demand_signal_item_id'")
            __props__.__dict__["demand_signal_item_id"] = demand_signal_item_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["justification"] = justification
            __props__.__dict__["lifecycle_details"] = lifecycle_details
            __props__.__dict__["notes"] = notes
            if occ_customer_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'occ_customer_group_id'")
            __props__.__dict__["occ_customer_group_id"] = occ_customer_group_id
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_delivered"] = None
        super(InternalOccmDemandSignalDelivery, __self__).__init__(
            'oci:CapacityManagement/internalOccmDemandSignalDelivery:InternalOccmDemandSignalDelivery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accepted_quantity: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            demand_signal_id: Optional[pulumi.Input[_builtins.str]] = None,
            demand_signal_item_id: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            justification: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            notes: Optional[pulumi.Input[_builtins.str]] = None,
            occ_customer_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_delivered: Optional[pulumi.Input[_builtins.str]] = None) -> 'InternalOccmDemandSignalDelivery':
        """
        Get an existing InternalOccmDemandSignalDelivery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] accepted_quantity: (Updatable) The quantity of the resource that Oracle Cloud Infrastructure will supply to the customer.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the tenancy from which the demand signal delivery resource is created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] demand_signal_id: The OCID of the demand signal under which this delivery will be grouped.
        :param pulumi.Input[_builtins.str] demand_signal_item_id: The OCID of the demand signal item corresponding to which this delivery is made.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] justification: (Updatable) This field could be used by Oracle Cloud Infrastructure to communicate the reason for declining the request.
        :param pulumi.Input[_builtins.str] lifecycle_details: The enum values corresponding to the various states associated with the delivery resource.
        :param pulumi.Input[_builtins.str] notes: (Updatable) This field acts as a notes section for operators.
        :param pulumi.Input[_builtins.str] occ_customer_group_id: The OCID of the corresponding customer group to which this demand signal delivery resource belongs to. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_delivered: The date on which the Oracle Cloud Infrastructure delivered the resource to the customers. The default value for this will be the corresponding demand signal item resource's need by date.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InternalOccmDemandSignalDeliveryState.__new__(_InternalOccmDemandSignalDeliveryState)

        __props__.__dict__["accepted_quantity"] = accepted_quantity
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["demand_signal_id"] = demand_signal_id
        __props__.__dict__["demand_signal_item_id"] = demand_signal_item_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["justification"] = justification
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["notes"] = notes
        __props__.__dict__["occ_customer_group_id"] = occ_customer_group_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_delivered"] = time_delivered
        return InternalOccmDemandSignalDelivery(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acceptedQuantity")
    def accepted_quantity(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The quantity of the resource that Oracle Cloud Infrastructure will supply to the customer.
        """
        return pulumi.get(self, "accepted_quantity")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the tenancy from which the demand signal delivery resource is created.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="demandSignalId")
    def demand_signal_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the demand signal under which this delivery will be grouped.
        """
        return pulumi.get(self, "demand_signal_id")

    @_builtins.property
    @pulumi.getter(name="demandSignalItemId")
    def demand_signal_item_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the demand signal item corresponding to which this delivery is made.
        """
        return pulumi.get(self, "demand_signal_item_id")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def justification(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) This field could be used by Oracle Cloud Infrastructure to communicate the reason for declining the request.
        """
        return pulumi.get(self, "justification")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        The enum values corresponding to the various states associated with the delivery resource.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def notes(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) This field acts as a notes section for operators.
        """
        return pulumi.get(self, "notes")

    @_builtins.property
    @pulumi.getter(name="occCustomerGroupId")
    def occ_customer_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the corresponding customer group to which this demand signal delivery resource belongs to. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "occ_customer_group_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeDelivered")
    def time_delivered(self) -> pulumi.Output[_builtins.str]:
        """
        The date on which the Oracle Cloud Infrastructure delivered the resource to the customers. The default value for this will be the corresponding demand signal item resource's need by date.
        """
        return pulumi.get(self, "time_delivered")

