# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OccCapacityRequestArgs', 'OccCapacityRequest']

@pulumi.input_type
class OccCapacityRequestArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 date_expected_capacity_handover: pulumi.Input[_builtins.str],
                 details: pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestDetailArgs']]],
                 display_name: pulumi.Input[_builtins.str],
                 namespace: pulumi.Input[_builtins.str],
                 occ_availability_catalog_id: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestPatchOperationArgs']]]] = None,
                 request_state: Optional[pulumi.Input[_builtins.str]] = None,
                 request_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OccCapacityRequest resource.
        :param pulumi.Input[_builtins.str] compartment_id: Since all resources are at tenancy level hence this will be the ocid of the tenancy where operation is to be performed.
        :param pulumi.Input[_builtins.str] date_expected_capacity_handover: The date by which the capacity requested by customers before dateFinalCustomerOrder needs to be fulfilled.
        :param pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestDetailArgs']]] details: A list of different resources requested by the user.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) An user-friendly name for the capacity request. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] namespace: The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        :param pulumi.Input[_builtins.str] occ_availability_catalog_id: The OCID of the availability catalog against which capacity request is made.
        :param pulumi.Input[_builtins.str] region: The name of the region for which the capacity request is made.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain (AD) in which the new resource is to be placed. If this is specified then the capacity will be validated and fulfilled within the scope of this AD. Note that this field is NOT required for Capacity request Transfer requests.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: Meaningful text about the capacity request.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed State.
        :param pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestPatchOperationArgs']]] patch_operations: (Updatable)
        :param pulumi.Input[_builtins.str] request_state: (Updatable) The subset of request states available for creating the capacity request.
        :param pulumi.Input[_builtins.str] request_type: Type of Capacity Request(New or Transfer)
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "date_expected_capacity_handover", date_expected_capacity_handover)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "occ_availability_catalog_id", occ_availability_catalog_id)
        pulumi.set(__self__, "region", region)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if patch_operations is not None:
            pulumi.set(__self__, "patch_operations", patch_operations)
        if request_state is not None:
            pulumi.set(__self__, "request_state", request_state)
        if request_type is not None:
            pulumi.set(__self__, "request_type", request_type)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        Since all resources are at tenancy level hence this will be the ocid of the tenancy where operation is to be performed.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="dateExpectedCapacityHandover")
    def date_expected_capacity_handover(self) -> pulumi.Input[_builtins.str]:
        """
        The date by which the capacity requested by customers before dateFinalCustomerOrder needs to be fulfilled.
        """
        return pulumi.get(self, "date_expected_capacity_handover")

    @date_expected_capacity_handover.setter
    def date_expected_capacity_handover(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "date_expected_capacity_handover", value)

    @_builtins.property
    @pulumi.getter
    def details(self) -> pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestDetailArgs']]]:
        """
        A list of different resources requested by the user.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestDetailArgs']]]):
        pulumi.set(self, "details", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) An user-friendly name for the capacity request. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="occAvailabilityCatalogId")
    def occ_availability_catalog_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the availability catalog against which capacity request is made.
        """
        return pulumi.get(self, "occ_availability_catalog_id")

    @occ_availability_catalog_id.setter
    def occ_availability_catalog_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "occ_availability_catalog_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the region for which the capacity request is made.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability domain (AD) in which the new resource is to be placed. If this is specified then the capacity will be validated and fulfilled within the scope of this AD. Note that this field is NOT required for Capacity request Transfer requests.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Meaningful text about the capacity request.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed State.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestPatchOperationArgs']]]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "patch_operations")

    @patch_operations.setter
    def patch_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestPatchOperationArgs']]]]):
        pulumi.set(self, "patch_operations", value)

    @_builtins.property
    @pulumi.getter(name="requestState")
    def request_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The subset of request states available for creating the capacity request.
        """
        return pulumi.get(self, "request_state")

    @request_state.setter
    def request_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_state", value)

    @_builtins.property
    @pulumi.getter(name="requestType")
    def request_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of Capacity Request(New or Transfer)


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "request_type")

    @request_type.setter
    def request_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_type", value)


@pulumi.input_type
class _OccCapacityRequestState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 date_expected_capacity_handover: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestDetailArgs']]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 occ_availability_catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 occ_customer_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestPatchOperationArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_state: Optional[pulumi.Input[_builtins.str]] = None,
                 request_type: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OccCapacityRequest resources.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain (AD) in which the new resource is to be placed. If this is specified then the capacity will be validated and fulfilled within the scope of this AD. Note that this field is NOT required for Capacity request Transfer requests.
        :param pulumi.Input[_builtins.str] compartment_id: Since all resources are at tenancy level hence this will be the ocid of the tenancy where operation is to be performed.
        :param pulumi.Input[_builtins.str] date_expected_capacity_handover: The date by which the capacity requested by customers before dateFinalCustomerOrder needs to be fulfilled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: Meaningful text about the capacity request.
        :param pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestDetailArgs']]] details: A list of different resources requested by the user.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) An user-friendly name for the capacity request. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed State.
        :param pulumi.Input[_builtins.str] namespace: The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        :param pulumi.Input[_builtins.str] occ_availability_catalog_id: The OCID of the availability catalog against which capacity request is made.
        :param pulumi.Input[_builtins.str] occ_customer_group_id: The OCID of the customer group to which this customer belongs to.
        :param pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestPatchOperationArgs']]] patch_operations: (Updatable)
        :param pulumi.Input[_builtins.str] region: The name of the region for which the capacity request is made.
        :param pulumi.Input[_builtins.str] request_state: (Updatable) The subset of request states available for creating the capacity request.
        :param pulumi.Input[_builtins.str] request_type: Type of Capacity Request(New or Transfer)
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time when the capacity request was created.
        :param pulumi.Input[_builtins.str] time_updated: The time when the capacity request was updated.
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if date_expected_capacity_handover is not None:
            pulumi.set(__self__, "date_expected_capacity_handover", date_expected_capacity_handover)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if occ_availability_catalog_id is not None:
            pulumi.set(__self__, "occ_availability_catalog_id", occ_availability_catalog_id)
        if occ_customer_group_id is not None:
            pulumi.set(__self__, "occ_customer_group_id", occ_customer_group_id)
        if patch_operations is not None:
            pulumi.set(__self__, "patch_operations", patch_operations)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if request_state is not None:
            pulumi.set(__self__, "request_state", request_state)
        if request_type is not None:
            pulumi.set(__self__, "request_type", request_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability domain (AD) in which the new resource is to be placed. If this is specified then the capacity will be validated and fulfilled within the scope of this AD. Note that this field is NOT required for Capacity request Transfer requests.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Since all resources are at tenancy level hence this will be the ocid of the tenancy where operation is to be performed.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="dateExpectedCapacityHandover")
    def date_expected_capacity_handover(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date by which the capacity requested by customers before dateFinalCustomerOrder needs to be fulfilled.
        """
        return pulumi.get(self, "date_expected_capacity_handover")

    @date_expected_capacity_handover.setter
    def date_expected_capacity_handover(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_expected_capacity_handover", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Meaningful text about the capacity request.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestDetailArgs']]]]:
        """
        A list of different resources requested by the user.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestDetailArgs']]]]):
        pulumi.set(self, "details", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An user-friendly name for the capacity request. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed State.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="occAvailabilityCatalogId")
    def occ_availability_catalog_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the availability catalog against which capacity request is made.
        """
        return pulumi.get(self, "occ_availability_catalog_id")

    @occ_availability_catalog_id.setter
    def occ_availability_catalog_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "occ_availability_catalog_id", value)

    @_builtins.property
    @pulumi.getter(name="occCustomerGroupId")
    def occ_customer_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the customer group to which this customer belongs to.
        """
        return pulumi.get(self, "occ_customer_group_id")

    @occ_customer_group_id.setter
    def occ_customer_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "occ_customer_group_id", value)

    @_builtins.property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestPatchOperationArgs']]]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "patch_operations")

    @patch_operations.setter
    def patch_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OccCapacityRequestPatchOperationArgs']]]]):
        pulumi.set(self, "patch_operations", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the region for which the capacity request is made.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="requestState")
    def request_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The subset of request states available for creating the capacity request.
        """
        return pulumi.get(self, "request_state")

    @request_state.setter
    def request_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_state", value)

    @_builtins.property
    @pulumi.getter(name="requestType")
    def request_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of Capacity Request(New or Transfer)


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "request_type")

    @request_type.setter
    def request_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_type", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the capacity request was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the capacity request was updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:CapacityManagement/occCapacityRequest:OccCapacityRequest")
class OccCapacityRequest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 date_expected_capacity_handover: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OccCapacityRequestDetailArgs', 'OccCapacityRequestDetailArgsDict']]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 occ_availability_catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OccCapacityRequestPatchOperationArgs', 'OccCapacityRequestPatchOperationArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_state: Optional[pulumi.Input[_builtins.str]] = None,
                 request_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Occ Capacity Request resource in Oracle Cloud Infrastructure Capacity Management service.

        Create Capacity Request.
          Updates the OccCapacityRequest by evaluating a sequence of instructions.

        ## Example Usage

        ## Import

        OccCapacityRequests can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CapacityManagement/occCapacityRequest:OccCapacityRequest test_occ_capacity_request "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain (AD) in which the new resource is to be placed. If this is specified then the capacity will be validated and fulfilled within the scope of this AD. Note that this field is NOT required for Capacity request Transfer requests.
        :param pulumi.Input[_builtins.str] compartment_id: Since all resources are at tenancy level hence this will be the ocid of the tenancy where operation is to be performed.
        :param pulumi.Input[_builtins.str] date_expected_capacity_handover: The date by which the capacity requested by customers before dateFinalCustomerOrder needs to be fulfilled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: Meaningful text about the capacity request.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OccCapacityRequestDetailArgs', 'OccCapacityRequestDetailArgsDict']]]] details: A list of different resources requested by the user.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) An user-friendly name for the capacity request. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed State.
        :param pulumi.Input[_builtins.str] namespace: The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        :param pulumi.Input[_builtins.str] occ_availability_catalog_id: The OCID of the availability catalog against which capacity request is made.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OccCapacityRequestPatchOperationArgs', 'OccCapacityRequestPatchOperationArgsDict']]]] patch_operations: (Updatable)
        :param pulumi.Input[_builtins.str] region: The name of the region for which the capacity request is made.
        :param pulumi.Input[_builtins.str] request_state: (Updatable) The subset of request states available for creating the capacity request.
        :param pulumi.Input[_builtins.str] request_type: Type of Capacity Request(New or Transfer)
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OccCapacityRequestArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Occ Capacity Request resource in Oracle Cloud Infrastructure Capacity Management service.

        Create Capacity Request.
          Updates the OccCapacityRequest by evaluating a sequence of instructions.

        ## Example Usage

        ## Import

        OccCapacityRequests can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CapacityManagement/occCapacityRequest:OccCapacityRequest test_occ_capacity_request "id"
        ```

        :param str resource_name: The name of the resource.
        :param OccCapacityRequestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OccCapacityRequestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 date_expected_capacity_handover: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OccCapacityRequestDetailArgs', 'OccCapacityRequestDetailArgsDict']]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 occ_availability_catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OccCapacityRequestPatchOperationArgs', 'OccCapacityRequestPatchOperationArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_state: Optional[pulumi.Input[_builtins.str]] = None,
                 request_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OccCapacityRequestArgs.__new__(OccCapacityRequestArgs)

            __props__.__dict__["availability_domain"] = availability_domain
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if date_expected_capacity_handover is None and not opts.urn:
                raise TypeError("Missing required property 'date_expected_capacity_handover'")
            __props__.__dict__["date_expected_capacity_handover"] = date_expected_capacity_handover
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if details is None and not opts.urn:
                raise TypeError("Missing required property 'details'")
            __props__.__dict__["details"] = details
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["lifecycle_details"] = lifecycle_details
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            if occ_availability_catalog_id is None and not opts.urn:
                raise TypeError("Missing required property 'occ_availability_catalog_id'")
            __props__.__dict__["occ_availability_catalog_id"] = occ_availability_catalog_id
            __props__.__dict__["patch_operations"] = patch_operations
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["request_state"] = request_state
            __props__.__dict__["request_type"] = request_type
            __props__.__dict__["occ_customer_group_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(OccCapacityRequest, __self__).__init__(
            'oci:CapacityManagement/occCapacityRequest:OccCapacityRequest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            date_expected_capacity_handover: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OccCapacityRequestDetailArgs', 'OccCapacityRequestDetailArgsDict']]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            occ_availability_catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
            occ_customer_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OccCapacityRequestPatchOperationArgs', 'OccCapacityRequestPatchOperationArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            request_state: Optional[pulumi.Input[_builtins.str]] = None,
            request_type: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'OccCapacityRequest':
        """
        Get an existing OccCapacityRequest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain (AD) in which the new resource is to be placed. If this is specified then the capacity will be validated and fulfilled within the scope of this AD. Note that this field is NOT required for Capacity request Transfer requests.
        :param pulumi.Input[_builtins.str] compartment_id: Since all resources are at tenancy level hence this will be the ocid of the tenancy where operation is to be performed.
        :param pulumi.Input[_builtins.str] date_expected_capacity_handover: The date by which the capacity requested by customers before dateFinalCustomerOrder needs to be fulfilled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: Meaningful text about the capacity request.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OccCapacityRequestDetailArgs', 'OccCapacityRequestDetailArgsDict']]]] details: A list of different resources requested by the user.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) An user-friendly name for the capacity request. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed State.
        :param pulumi.Input[_builtins.str] namespace: The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        :param pulumi.Input[_builtins.str] occ_availability_catalog_id: The OCID of the availability catalog against which capacity request is made.
        :param pulumi.Input[_builtins.str] occ_customer_group_id: The OCID of the customer group to which this customer belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OccCapacityRequestPatchOperationArgs', 'OccCapacityRequestPatchOperationArgsDict']]]] patch_operations: (Updatable)
        :param pulumi.Input[_builtins.str] region: The name of the region for which the capacity request is made.
        :param pulumi.Input[_builtins.str] request_state: (Updatable) The subset of request states available for creating the capacity request.
        :param pulumi.Input[_builtins.str] request_type: Type of Capacity Request(New or Transfer)
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time when the capacity request was created.
        :param pulumi.Input[_builtins.str] time_updated: The time when the capacity request was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OccCapacityRequestState.__new__(_OccCapacityRequestState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["date_expected_capacity_handover"] = date_expected_capacity_handover
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["details"] = details
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["occ_availability_catalog_id"] = occ_availability_catalog_id
        __props__.__dict__["occ_customer_group_id"] = occ_customer_group_id
        __props__.__dict__["patch_operations"] = patch_operations
        __props__.__dict__["region"] = region
        __props__.__dict__["request_state"] = request_state
        __props__.__dict__["request_type"] = request_type
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return OccCapacityRequest(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The availability domain (AD) in which the new resource is to be placed. If this is specified then the capacity will be validated and fulfilled within the scope of this AD. Note that this field is NOT required for Capacity request Transfer requests.
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        Since all resources are at tenancy level hence this will be the ocid of the tenancy where operation is to be performed.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dateExpectedCapacityHandover")
    def date_expected_capacity_handover(self) -> pulumi.Output[_builtins.str]:
        """
        The date by which the capacity requested by customers before dateFinalCustomerOrder needs to be fulfilled.
        """
        return pulumi.get(self, "date_expected_capacity_handover")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Meaningful text about the capacity request.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def details(self) -> pulumi.Output[Sequence['outputs.OccCapacityRequestDetail']]:
        """
        A list of different resources requested by the user.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) An user-friendly name for the capacity request. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed State.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="occAvailabilityCatalogId")
    def occ_availability_catalog_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the availability catalog against which capacity request is made.
        """
        return pulumi.get(self, "occ_availability_catalog_id")

    @_builtins.property
    @pulumi.getter(name="occCustomerGroupId")
    def occ_customer_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the customer group to which this customer belongs to.
        """
        return pulumi.get(self, "occ_customer_group_id")

    @_builtins.property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> pulumi.Output[Optional[Sequence['outputs.OccCapacityRequestPatchOperation']]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "patch_operations")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the region for which the capacity request is made.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="requestState")
    def request_state(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The subset of request states available for creating the capacity request.
        """
        return pulumi.get(self, "request_state")

    @_builtins.property
    @pulumi.getter(name="requestType")
    def request_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of Capacity Request(New or Transfer)


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "request_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the capacity request was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the capacity request was updated.
        """
        return pulumi.get(self, "time_updated")

