# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OccmDemandSignalItemArgs', 'OccmDemandSignalItem']

@pulumi.input_type
class OccmDemandSignalItemArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 demand_quantity: pulumi.Input[_builtins.str],
                 demand_signal_catalog_resource_id: pulumi.Input[_builtins.str],
                 demand_signal_id: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 request_type: pulumi.Input[_builtins.str],
                 resource_properties: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 time_needed_before: pulumi.Input[_builtins.str],
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 target_compartment_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OccmDemandSignalItem resource.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the tenancy from which the demand signal item was created.
        :param pulumi.Input[_builtins.str] demand_quantity: (Updatable) The quantity of the resource that you want to demand from OCI.
        :param pulumi.Input[_builtins.str] demand_signal_catalog_resource_id: The OCID of the correponding demand signal catalog resource.
        :param pulumi.Input[_builtins.str] demand_signal_id: The OCID of the demand signal under which we need to create this item.
        :param pulumi.Input[_builtins.str] region: (Updatable) The name of region for which you want to request the Oracle Cloud Infrastructure resource.
        :param pulumi.Input[_builtins.str] request_type: The type of request (DEMAND or RETURN) that you want to make for this demand signal item.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_properties: (Updatable) A map of various properties associated with the Oracle Cloud Infrastructure resource.
        :param pulumi.Input[_builtins.str] time_needed_before: (Updatable) the date before which you would ideally like the Oracle Cloud Infrastructure resource to be delivered to you. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] availability_domain: (Updatable) The name of the availability domain for which you want to request the Oracle Cloud Infrastructure resource. This is an optional parameter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] notes: (Updatable) This field will serve as notes section for you. You can use this section to convey a message to Oracle Cloud Infrastructure regarding your resource request.
               
               NOTE: The previous value gets overwritten with the new one for this once updated.
        :param pulumi.Input[_builtins.str] target_compartment_id: (Updatable) The OCID of the tenancy for which you want to request the Oracle Cloud Infrastructure resource for. This is an optional parameter.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "demand_quantity", demand_quantity)
        pulumi.set(__self__, "demand_signal_catalog_resource_id", demand_signal_catalog_resource_id)
        pulumi.set(__self__, "demand_signal_id", demand_signal_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "request_type", request_type)
        pulumi.set(__self__, "resource_properties", resource_properties)
        pulumi.set(__self__, "time_needed_before", time_needed_before)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if target_compartment_id is not None:
            pulumi.set(__self__, "target_compartment_id", target_compartment_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the tenancy from which the demand signal item was created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="demandQuantity")
    def demand_quantity(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The quantity of the resource that you want to demand from OCI.
        """
        return pulumi.get(self, "demand_quantity")

    @demand_quantity.setter
    def demand_quantity(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "demand_quantity", value)

    @_builtins.property
    @pulumi.getter(name="demandSignalCatalogResourceId")
    def demand_signal_catalog_resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the correponding demand signal catalog resource.
        """
        return pulumi.get(self, "demand_signal_catalog_resource_id")

    @demand_signal_catalog_resource_id.setter
    def demand_signal_catalog_resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "demand_signal_catalog_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="demandSignalId")
    def demand_signal_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the demand signal under which we need to create this item.
        """
        return pulumi.get(self, "demand_signal_id")

    @demand_signal_id.setter
    def demand_signal_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "demand_signal_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The name of region for which you want to request the Oracle Cloud Infrastructure resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="requestType")
    def request_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of request (DEMAND or RETURN) that you want to make for this demand signal item.
        """
        return pulumi.get(self, "request_type")

    @request_type.setter
    def request_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "request_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceProperties")
    def resource_properties(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        (Updatable) A map of various properties associated with the Oracle Cloud Infrastructure resource.
        """
        return pulumi.get(self, "resource_properties")

    @resource_properties.setter
    def resource_properties(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "resource_properties", value)

    @_builtins.property
    @pulumi.getter(name="timeNeededBefore")
    def time_needed_before(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) the date before which you would ideally like the Oracle Cloud Infrastructure resource to be delivered to you. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_needed_before")

    @time_needed_before.setter
    def time_needed_before(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "time_needed_before", value)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of the availability domain for which you want to request the Oracle Cloud Infrastructure resource. This is an optional parameter.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) This field will serve as notes section for you. You can use this section to convey a message to Oracle Cloud Infrastructure regarding your resource request.

        NOTE: The previous value gets overwritten with the new one for this once updated.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notes", value)

    @_builtins.property
    @pulumi.getter(name="targetCompartmentId")
    def target_compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the tenancy for which you want to request the Oracle Cloud Infrastructure resource for. This is an optional parameter.
        """
        return pulumi.get(self, "target_compartment_id")

    @target_compartment_id.setter
    def target_compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_compartment_id", value)


@pulumi.input_type
class _OccmDemandSignalItemState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 demand_quantity: Optional[pulumi.Input[_builtins.str]] = None,
                 demand_signal_catalog_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 demand_signal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 demand_signal_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_needed_before: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OccmDemandSignalItem resources.
        :param pulumi.Input[_builtins.str] availability_domain: (Updatable) The name of the availability domain for which you want to request the Oracle Cloud Infrastructure resource. This is an optional parameter.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the tenancy from which the demand signal item was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] demand_quantity: (Updatable) The quantity of the resource that you want to demand from OCI.
        :param pulumi.Input[_builtins.str] demand_signal_catalog_resource_id: The OCID of the correponding demand signal catalog resource.
        :param pulumi.Input[_builtins.str] demand_signal_id: The OCID of the demand signal under which we need to create this item.
        :param pulumi.Input[_builtins.str] demand_signal_namespace: The name of the Oracle Cloud Infrastructure service in consideration for demand signal submission. For example: COMPUTE, NETWORK, GPU etc.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] notes: (Updatable) This field will serve as notes section for you. You can use this section to convey a message to Oracle Cloud Infrastructure regarding your resource request.
               
               NOTE: The previous value gets overwritten with the new one for this once updated.
        :param pulumi.Input[_builtins.str] region: (Updatable) The name of region for which you want to request the Oracle Cloud Infrastructure resource.
        :param pulumi.Input[_builtins.str] request_type: The type of request (DEMAND or RETURN) that you want to make for this demand signal item.
        :param pulumi.Input[_builtins.str] resource_name: The name of the Oracle Cloud Infrastructure resource that you want to request.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_properties: (Updatable) A map of various properties associated with the Oracle Cloud Infrastructure resource.
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] target_compartment_id: (Updatable) The OCID of the tenancy for which you want to request the Oracle Cloud Infrastructure resource for. This is an optional parameter.
        :param pulumi.Input[_builtins.str] time_needed_before: (Updatable) the date before which you would ideally like the Oracle Cloud Infrastructure resource to be delivered to you. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if demand_quantity is not None:
            pulumi.set(__self__, "demand_quantity", demand_quantity)
        if demand_signal_catalog_resource_id is not None:
            pulumi.set(__self__, "demand_signal_catalog_resource_id", demand_signal_catalog_resource_id)
        if demand_signal_id is not None:
            pulumi.set(__self__, "demand_signal_id", demand_signal_id)
        if demand_signal_namespace is not None:
            pulumi.set(__self__, "demand_signal_namespace", demand_signal_namespace)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if request_type is not None:
            pulumi.set(__self__, "request_type", request_type)
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)
        if resource_properties is not None:
            pulumi.set(__self__, "resource_properties", resource_properties)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_compartment_id is not None:
            pulumi.set(__self__, "target_compartment_id", target_compartment_id)
        if time_needed_before is not None:
            pulumi.set(__self__, "time_needed_before", time_needed_before)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of the availability domain for which you want to request the Oracle Cloud Infrastructure resource. This is an optional parameter.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the tenancy from which the demand signal item was created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="demandQuantity")
    def demand_quantity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The quantity of the resource that you want to demand from OCI.
        """
        return pulumi.get(self, "demand_quantity")

    @demand_quantity.setter
    def demand_quantity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "demand_quantity", value)

    @_builtins.property
    @pulumi.getter(name="demandSignalCatalogResourceId")
    def demand_signal_catalog_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the correponding demand signal catalog resource.
        """
        return pulumi.get(self, "demand_signal_catalog_resource_id")

    @demand_signal_catalog_resource_id.setter
    def demand_signal_catalog_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "demand_signal_catalog_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="demandSignalId")
    def demand_signal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the demand signal under which we need to create this item.
        """
        return pulumi.get(self, "demand_signal_id")

    @demand_signal_id.setter
    def demand_signal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "demand_signal_id", value)

    @_builtins.property
    @pulumi.getter(name="demandSignalNamespace")
    def demand_signal_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Oracle Cloud Infrastructure service in consideration for demand signal submission. For example: COMPUTE, NETWORK, GPU etc.
        """
        return pulumi.get(self, "demand_signal_namespace")

    @demand_signal_namespace.setter
    def demand_signal_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "demand_signal_namespace", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) This field will serve as notes section for you. You can use this section to convey a message to Oracle Cloud Infrastructure regarding your resource request.

        NOTE: The previous value gets overwritten with the new one for this once updated.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notes", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of region for which you want to request the Oracle Cloud Infrastructure resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="requestType")
    def request_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of request (DEMAND or RETURN) that you want to make for this demand signal item.
        """
        return pulumi.get(self, "request_type")

    @request_type.setter
    def request_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Oracle Cloud Infrastructure resource that you want to request.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceProperties")
    def resource_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) A map of various properties associated with the Oracle Cloud Infrastructure resource.
        """
        return pulumi.get(self, "resource_properties")

    @resource_properties.setter
    def resource_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_properties", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="targetCompartmentId")
    def target_compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the tenancy for which you want to request the Oracle Cloud Infrastructure resource for. This is an optional parameter.
        """
        return pulumi.get(self, "target_compartment_id")

    @target_compartment_id.setter
    def target_compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="timeNeededBefore")
    def time_needed_before(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) the date before which you would ideally like the Oracle Cloud Infrastructure resource to be delivered to you. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_needed_before")

    @time_needed_before.setter
    def time_needed_before(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_needed_before", value)


@pulumi.type_token("oci:CapacityManagement/occmDemandSignalItem:OccmDemandSignalItem")
class OccmDemandSignalItem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 demand_quantity: Optional[pulumi.Input[_builtins.str]] = None,
                 demand_signal_catalog_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 demand_signal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_needed_before: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Occm Demand Signal Item resource in Oracle Cloud Infrastructure Capacity Management service.

        This API will create a demand signal item representing a resource request. This needs to be grouped under a demand signal.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_occm_demand_signal_item = oci.capacitymanagement.OccmDemandSignalItem("test_occm_demand_signal_item",
            compartment_id=compartment_id,
            demand_quantity=occm_demand_signal_item_demand_quantity,
            demand_signal_catalog_resource_id=test_resource["id"],
            demand_signal_id=test_demand_signal["id"],
            region=occm_demand_signal_item_region,
            request_type=occm_demand_signal_item_request_type,
            resource_properties=occm_demand_signal_item_resource_properties,
            time_needed_before=occm_demand_signal_item_time_needed_before,
            availability_domain=occm_demand_signal_item_availability_domain,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            notes=occm_demand_signal_item_notes,
            target_compartment_id=test_compartment["id"])
        ```

        ## Import

        OccmDemandSignalItems can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CapacityManagement/occmDemandSignalItem:OccmDemandSignalItem test_occm_demand_signal_item "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_domain: (Updatable) The name of the availability domain for which you want to request the Oracle Cloud Infrastructure resource. This is an optional parameter.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the tenancy from which the demand signal item was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] demand_quantity: (Updatable) The quantity of the resource that you want to demand from OCI.
        :param pulumi.Input[_builtins.str] demand_signal_catalog_resource_id: The OCID of the correponding demand signal catalog resource.
        :param pulumi.Input[_builtins.str] demand_signal_id: The OCID of the demand signal under which we need to create this item.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] notes: (Updatable) This field will serve as notes section for you. You can use this section to convey a message to Oracle Cloud Infrastructure regarding your resource request.
               
               NOTE: The previous value gets overwritten with the new one for this once updated.
        :param pulumi.Input[_builtins.str] region: (Updatable) The name of region for which you want to request the Oracle Cloud Infrastructure resource.
        :param pulumi.Input[_builtins.str] request_type: The type of request (DEMAND or RETURN) that you want to make for this demand signal item.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_properties: (Updatable) A map of various properties associated with the Oracle Cloud Infrastructure resource.
        :param pulumi.Input[_builtins.str] target_compartment_id: (Updatable) The OCID of the tenancy for which you want to request the Oracle Cloud Infrastructure resource for. This is an optional parameter.
        :param pulumi.Input[_builtins.str] time_needed_before: (Updatable) the date before which you would ideally like the Oracle Cloud Infrastructure resource to be delivered to you. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OccmDemandSignalItemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Occm Demand Signal Item resource in Oracle Cloud Infrastructure Capacity Management service.

        This API will create a demand signal item representing a resource request. This needs to be grouped under a demand signal.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_occm_demand_signal_item = oci.capacitymanagement.OccmDemandSignalItem("test_occm_demand_signal_item",
            compartment_id=compartment_id,
            demand_quantity=occm_demand_signal_item_demand_quantity,
            demand_signal_catalog_resource_id=test_resource["id"],
            demand_signal_id=test_demand_signal["id"],
            region=occm_demand_signal_item_region,
            request_type=occm_demand_signal_item_request_type,
            resource_properties=occm_demand_signal_item_resource_properties,
            time_needed_before=occm_demand_signal_item_time_needed_before,
            availability_domain=occm_demand_signal_item_availability_domain,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            notes=occm_demand_signal_item_notes,
            target_compartment_id=test_compartment["id"])
        ```

        ## Import

        OccmDemandSignalItems can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CapacityManagement/occmDemandSignalItem:OccmDemandSignalItem test_occm_demand_signal_item "id"
        ```

        :param str resource_name: The name of the resource.
        :param OccmDemandSignalItemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OccmDemandSignalItemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 demand_quantity: Optional[pulumi.Input[_builtins.str]] = None,
                 demand_signal_catalog_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 demand_signal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_needed_before: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OccmDemandSignalItemArgs.__new__(OccmDemandSignalItemArgs)

            __props__.__dict__["availability_domain"] = availability_domain
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if demand_quantity is None and not opts.urn:
                raise TypeError("Missing required property 'demand_quantity'")
            __props__.__dict__["demand_quantity"] = demand_quantity
            if demand_signal_catalog_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'demand_signal_catalog_resource_id'")
            __props__.__dict__["demand_signal_catalog_resource_id"] = demand_signal_catalog_resource_id
            if demand_signal_id is None and not opts.urn:
                raise TypeError("Missing required property 'demand_signal_id'")
            __props__.__dict__["demand_signal_id"] = demand_signal_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["notes"] = notes
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if request_type is None and not opts.urn:
                raise TypeError("Missing required property 'request_type'")
            __props__.__dict__["request_type"] = request_type
            if resource_properties is None and not opts.urn:
                raise TypeError("Missing required property 'resource_properties'")
            __props__.__dict__["resource_properties"] = resource_properties
            __props__.__dict__["target_compartment_id"] = target_compartment_id
            if time_needed_before is None and not opts.urn:
                raise TypeError("Missing required property 'time_needed_before'")
            __props__.__dict__["time_needed_before"] = time_needed_before
            __props__.__dict__["demand_signal_namespace"] = None
            __props__.__dict__["resource_name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
        super(OccmDemandSignalItem, __self__).__init__(
            'oci:CapacityManagement/occmDemandSignalItem:OccmDemandSignalItem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            demand_quantity: Optional[pulumi.Input[_builtins.str]] = None,
            demand_signal_catalog_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            demand_signal_id: Optional[pulumi.Input[_builtins.str]] = None,
            demand_signal_namespace: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            notes: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            request_type: Optional[pulumi.Input[_builtins.str]] = None,
            resource_name_: Optional[pulumi.Input[_builtins.str]] = None,
            resource_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_needed_before: Optional[pulumi.Input[_builtins.str]] = None) -> 'OccmDemandSignalItem':
        """
        Get an existing OccmDemandSignalItem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_domain: (Updatable) The name of the availability domain for which you want to request the Oracle Cloud Infrastructure resource. This is an optional parameter.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the tenancy from which the demand signal item was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] demand_quantity: (Updatable) The quantity of the resource that you want to demand from OCI.
        :param pulumi.Input[_builtins.str] demand_signal_catalog_resource_id: The OCID of the correponding demand signal catalog resource.
        :param pulumi.Input[_builtins.str] demand_signal_id: The OCID of the demand signal under which we need to create this item.
        :param pulumi.Input[_builtins.str] demand_signal_namespace: The name of the Oracle Cloud Infrastructure service in consideration for demand signal submission. For example: COMPUTE, NETWORK, GPU etc.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] notes: (Updatable) This field will serve as notes section for you. You can use this section to convey a message to Oracle Cloud Infrastructure regarding your resource request.
               
               NOTE: The previous value gets overwritten with the new one for this once updated.
        :param pulumi.Input[_builtins.str] region: (Updatable) The name of region for which you want to request the Oracle Cloud Infrastructure resource.
        :param pulumi.Input[_builtins.str] request_type: The type of request (DEMAND or RETURN) that you want to make for this demand signal item.
        :param pulumi.Input[_builtins.str] resource_name_: The name of the Oracle Cloud Infrastructure resource that you want to request.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] resource_properties: (Updatable) A map of various properties associated with the Oracle Cloud Infrastructure resource.
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] target_compartment_id: (Updatable) The OCID of the tenancy for which you want to request the Oracle Cloud Infrastructure resource for. This is an optional parameter.
        :param pulumi.Input[_builtins.str] time_needed_before: (Updatable) the date before which you would ideally like the Oracle Cloud Infrastructure resource to be delivered to you. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OccmDemandSignalItemState.__new__(_OccmDemandSignalItemState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["demand_quantity"] = demand_quantity
        __props__.__dict__["demand_signal_catalog_resource_id"] = demand_signal_catalog_resource_id
        __props__.__dict__["demand_signal_id"] = demand_signal_id
        __props__.__dict__["demand_signal_namespace"] = demand_signal_namespace
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["notes"] = notes
        __props__.__dict__["region"] = region
        __props__.__dict__["request_type"] = request_type
        __props__.__dict__["resource_name"] = resource_name_
        __props__.__dict__["resource_properties"] = resource_properties
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_compartment_id"] = target_compartment_id
        __props__.__dict__["time_needed_before"] = time_needed_before
        return OccmDemandSignalItem(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The name of the availability domain for which you want to request the Oracle Cloud Infrastructure resource. This is an optional parameter.
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the tenancy from which the demand signal item was created.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="demandQuantity")
    def demand_quantity(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The quantity of the resource that you want to demand from OCI.
        """
        return pulumi.get(self, "demand_quantity")

    @_builtins.property
    @pulumi.getter(name="demandSignalCatalogResourceId")
    def demand_signal_catalog_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the correponding demand signal catalog resource.
        """
        return pulumi.get(self, "demand_signal_catalog_resource_id")

    @_builtins.property
    @pulumi.getter(name="demandSignalId")
    def demand_signal_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the demand signal under which we need to create this item.
        """
        return pulumi.get(self, "demand_signal_id")

    @_builtins.property
    @pulumi.getter(name="demandSignalNamespace")
    def demand_signal_namespace(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Oracle Cloud Infrastructure service in consideration for demand signal submission. For example: COMPUTE, NETWORK, GPU etc.
        """
        return pulumi.get(self, "demand_signal_namespace")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def notes(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) This field will serve as notes section for you. You can use this section to convey a message to Oracle Cloud Infrastructure regarding your resource request.

        NOTE: The previous value gets overwritten with the new one for this once updated.
        """
        return pulumi.get(self, "notes")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The name of region for which you want to request the Oracle Cloud Infrastructure resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="requestType")
    def request_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of request (DEMAND or RETURN) that you want to make for this demand signal item.
        """
        return pulumi.get(self, "request_type")

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Oracle Cloud Infrastructure resource that you want to request.
        """
        return pulumi.get(self, "resource_name")

    @_builtins.property
    @pulumi.getter(name="resourceProperties")
    def resource_properties(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) A map of various properties associated with the Oracle Cloud Infrastructure resource.
        """
        return pulumi.get(self, "resource_properties")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="targetCompartmentId")
    def target_compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the tenancy for which you want to request the Oracle Cloud Infrastructure resource for. This is an optional parameter.
        """
        return pulumi.get(self, "target_compartment_id")

    @_builtins.property
    @pulumi.getter(name="timeNeededBefore")
    def time_needed_before(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) the date before which you would ideally like the Oracle Cloud Infrastructure resource to be delivered to you. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_needed_before")

