# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVirtualNodePoolsResult',
    'AwaitableGetVirtualNodePoolsResult',
    'get_virtual_node_pools',
    'get_virtual_node_pools_output',
]

@pulumi.output_type
class GetVirtualNodePoolsResult:
    """
    A collection of values returned by getVirtualNodePools.
    """
    def __init__(__self__, cluster_id=None, compartment_id=None, display_name=None, filters=None, id=None, states=None, virtual_node_pools=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if states and not isinstance(states, list):
            raise TypeError("Expected argument 'states' to be a list")
        pulumi.set(__self__, "states", states)
        if virtual_node_pools and not isinstance(virtual_node_pools, list):
            raise TypeError("Expected argument 'virtual_node_pools' to be a list")
        pulumi.set(__self__, "virtual_node_pools", virtual_node_pools)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[_builtins.str]:
        """
        The cluster the virtual node pool is associated with. A virtual node pool can only be associated with one cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        Compartment of the virtual node pool.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Display name of the virtual node pool. This is a non-unique value.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVirtualNodePoolsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def states(self) -> Optional[Sequence[_builtins.str]]:
        """
        The state of the Virtual Node Pool.
        """
        return pulumi.get(self, "states")

    @_builtins.property
    @pulumi.getter(name="virtualNodePools")
    def virtual_node_pools(self) -> Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolResult']:
        """
        The list of virtual_node_pools.
        """
        return pulumi.get(self, "virtual_node_pools")


class AwaitableGetVirtualNodePoolsResult(GetVirtualNodePoolsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualNodePoolsResult(
            cluster_id=self.cluster_id,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            states=self.states,
            virtual_node_pools=self.virtual_node_pools)


def get_virtual_node_pools(cluster_id: Optional[_builtins.str] = None,
                           compartment_id: Optional[_builtins.str] = None,
                           display_name: Optional[_builtins.str] = None,
                           filters: Optional[Sequence[Union['GetVirtualNodePoolsFilterArgs', 'GetVirtualNodePoolsFilterArgsDict']]] = None,
                           states: Optional[Sequence[_builtins.str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualNodePoolsResult:
    """
    This data source provides the list of Virtual Node Pools in Oracle Cloud Infrastructure Container Engine service.

    List all the virtual node pools in a compartment, and optionally filter by cluster.

    ## Example Usage


    :param _builtins.str cluster_id: The OCID of the cluster.
    :param _builtins.str compartment_id: The OCID of the compartment.
    :param _builtins.str display_name: Display name of the virtual node pool. This is a non-unique value.
    :param Sequence[_builtins.str] states: A virtual node pool lifecycle state to filter on. Can have multiple parameters of this name.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['states'] = states
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ContainerEngine/getVirtualNodePools:getVirtualNodePools', __args__, opts=opts, typ=GetVirtualNodePoolsResult).value

    return AwaitableGetVirtualNodePoolsResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        states=pulumi.get(__ret__, 'states'),
        virtual_node_pools=pulumi.get(__ret__, 'virtual_node_pools'))
def get_virtual_node_pools_output(cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVirtualNodePoolsFilterArgs', 'GetVirtualNodePoolsFilterArgsDict']]]]] = None,
                                  states: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVirtualNodePoolsResult]:
    """
    This data source provides the list of Virtual Node Pools in Oracle Cloud Infrastructure Container Engine service.

    List all the virtual node pools in a compartment, and optionally filter by cluster.

    ## Example Usage


    :param _builtins.str cluster_id: The OCID of the cluster.
    :param _builtins.str compartment_id: The OCID of the compartment.
    :param _builtins.str display_name: Display name of the virtual node pool. This is a non-unique value.
    :param Sequence[_builtins.str] states: A virtual node pool lifecycle state to filter on. Can have multiple parameters of this name.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['states'] = states
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ContainerEngine/getVirtualNodePools:getVirtualNodePools', __args__, opts=opts, typ=GetVirtualNodePoolsResult)
    return __ret__.apply(lambda __response__: GetVirtualNodePoolsResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        states=pulumi.get(__response__, 'states'),
        virtual_node_pools=pulumi.get(__response__, 'virtual_node_pools')))
