# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AppCatalogSubscriptionArgs', 'AppCatalogSubscription']

@pulumi.input_type
class AppCatalogSubscriptionArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 listing_id: pulumi.Input[_builtins.str],
                 listing_resource_version: pulumi.Input[_builtins.str],
                 oracle_terms_of_use_link: pulumi.Input[_builtins.str],
                 signature: pulumi.Input[_builtins.str],
                 time_retrieved: pulumi.Input[_builtins.str],
                 eula_link: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AppCatalogSubscription resource.
        :param pulumi.Input[_builtins.str] compartment_id: The compartmentID for the subscription.
        :param pulumi.Input[_builtins.str] listing_id: The OCID of the listing.
        :param pulumi.Input[_builtins.str] listing_resource_version: Listing resource version.
        :param pulumi.Input[_builtins.str] oracle_terms_of_use_link: Oracle TOU link
        :param pulumi.Input[_builtins.str] signature: A generated signature for this listing resource version retrieved the agreements API.
        :param pulumi.Input[_builtins.str] time_retrieved: Date and time the agreements were retrieved, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] eula_link: EULA link
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "listing_id", listing_id)
        pulumi.set(__self__, "listing_resource_version", listing_resource_version)
        pulumi.set(__self__, "oracle_terms_of_use_link", oracle_terms_of_use_link)
        pulumi.set(__self__, "signature", signature)
        pulumi.set(__self__, "time_retrieved", time_retrieved)
        if eula_link is not None:
            pulumi.set(__self__, "eula_link", eula_link)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The compartmentID for the subscription.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the listing.
        """
        return pulumi.get(self, "listing_id")

    @listing_id.setter
    def listing_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "listing_id", value)

    @_builtins.property
    @pulumi.getter(name="listingResourceVersion")
    def listing_resource_version(self) -> pulumi.Input[_builtins.str]:
        """
        Listing resource version.
        """
        return pulumi.get(self, "listing_resource_version")

    @listing_resource_version.setter
    def listing_resource_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "listing_resource_version", value)

    @_builtins.property
    @pulumi.getter(name="oracleTermsOfUseLink")
    def oracle_terms_of_use_link(self) -> pulumi.Input[_builtins.str]:
        """
        Oracle TOU link
        """
        return pulumi.get(self, "oracle_terms_of_use_link")

    @oracle_terms_of_use_link.setter
    def oracle_terms_of_use_link(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "oracle_terms_of_use_link", value)

    @_builtins.property
    @pulumi.getter
    def signature(self) -> pulumi.Input[_builtins.str]:
        """
        A generated signature for this listing resource version retrieved the agreements API.
        """
        return pulumi.get(self, "signature")

    @signature.setter
    def signature(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "signature", value)

    @_builtins.property
    @pulumi.getter(name="timeRetrieved")
    def time_retrieved(self) -> pulumi.Input[_builtins.str]:
        """
        Date and time the agreements were retrieved, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_retrieved")

    @time_retrieved.setter
    def time_retrieved(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "time_retrieved", value)

    @_builtins.property
    @pulumi.getter(name="eulaLink")
    def eula_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        EULA link
        """
        return pulumi.get(self, "eula_link")

    @eula_link.setter
    def eula_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eula_link", value)


@pulumi.input_type
class _AppCatalogSubscriptionState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 eula_link: Optional[pulumi.Input[_builtins.str]] = None,
                 listing_id: Optional[pulumi.Input[_builtins.str]] = None,
                 listing_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 listing_resource_version: Optional[pulumi.Input[_builtins.str]] = None,
                 oracle_terms_of_use_link: Optional[pulumi.Input[_builtins.str]] = None,
                 publisher_name: Optional[pulumi.Input[_builtins.str]] = None,
                 signature: Optional[pulumi.Input[_builtins.str]] = None,
                 summary: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_retrieved: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppCatalogSubscription resources.
        :param pulumi.Input[_builtins.str] compartment_id: The compartmentID for the subscription.
        :param pulumi.Input[_builtins.str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] eula_link: EULA link
        :param pulumi.Input[_builtins.str] listing_id: The OCID of the listing.
        :param pulumi.Input[_builtins.str] listing_resource_id: Listing resource id.
        :param pulumi.Input[_builtins.str] listing_resource_version: Listing resource version.
        :param pulumi.Input[_builtins.str] oracle_terms_of_use_link: Oracle TOU link
        :param pulumi.Input[_builtins.str] publisher_name: Name of the publisher who published this listing.
        :param pulumi.Input[_builtins.str] signature: A generated signature for this listing resource version retrieved the agreements API.
        :param pulumi.Input[_builtins.str] summary: The short summary to the listing.
        :param pulumi.Input[_builtins.str] time_created: Date and time at which the subscription was created, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z`
        :param pulumi.Input[_builtins.str] time_retrieved: Date and time the agreements were retrieved, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if eula_link is not None:
            pulumi.set(__self__, "eula_link", eula_link)
        if listing_id is not None:
            pulumi.set(__self__, "listing_id", listing_id)
        if listing_resource_id is not None:
            pulumi.set(__self__, "listing_resource_id", listing_resource_id)
        if listing_resource_version is not None:
            pulumi.set(__self__, "listing_resource_version", listing_resource_version)
        if oracle_terms_of_use_link is not None:
            pulumi.set(__self__, "oracle_terms_of_use_link", oracle_terms_of_use_link)
        if publisher_name is not None:
            pulumi.set(__self__, "publisher_name", publisher_name)
        if signature is not None:
            pulumi.set(__self__, "signature", signature)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_retrieved is not None:
            pulumi.set(__self__, "time_retrieved", time_retrieved)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compartmentID for the subscription.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="eulaLink")
    def eula_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        EULA link
        """
        return pulumi.get(self, "eula_link")

    @eula_link.setter
    def eula_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eula_link", value)

    @_builtins.property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the listing.
        """
        return pulumi.get(self, "listing_id")

    @listing_id.setter
    def listing_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listing_id", value)

    @_builtins.property
    @pulumi.getter(name="listingResourceId")
    def listing_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Listing resource id.
        """
        return pulumi.get(self, "listing_resource_id")

    @listing_resource_id.setter
    def listing_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listing_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="listingResourceVersion")
    def listing_resource_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Listing resource version.
        """
        return pulumi.get(self, "listing_resource_version")

    @listing_resource_version.setter
    def listing_resource_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listing_resource_version", value)

    @_builtins.property
    @pulumi.getter(name="oracleTermsOfUseLink")
    def oracle_terms_of_use_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Oracle TOU link
        """
        return pulumi.get(self, "oracle_terms_of_use_link")

    @oracle_terms_of_use_link.setter
    def oracle_terms_of_use_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oracle_terms_of_use_link", value)

    @_builtins.property
    @pulumi.getter(name="publisherName")
    def publisher_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the publisher who published this listing.
        """
        return pulumi.get(self, "publisher_name")

    @publisher_name.setter
    def publisher_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "publisher_name", value)

    @_builtins.property
    @pulumi.getter
    def signature(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A generated signature for this listing resource version retrieved the agreements API.
        """
        return pulumi.get(self, "signature")

    @signature.setter
    def signature(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signature", value)

    @_builtins.property
    @pulumi.getter
    def summary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The short summary to the listing.
        """
        return pulumi.get(self, "summary")

    @summary.setter
    def summary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "summary", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time at which the subscription was created, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeRetrieved")
    def time_retrieved(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time the agreements were retrieved, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_retrieved")

    @time_retrieved.setter
    def time_retrieved(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_retrieved", value)


@pulumi.type_token("oci:Core/appCatalogSubscription:AppCatalogSubscription")
class AppCatalogSubscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eula_link: Optional[pulumi.Input[_builtins.str]] = None,
                 listing_id: Optional[pulumi.Input[_builtins.str]] = None,
                 listing_resource_version: Optional[pulumi.Input[_builtins.str]] = None,
                 oracle_terms_of_use_link: Optional[pulumi.Input[_builtins.str]] = None,
                 signature: Optional[pulumi.Input[_builtins.str]] = None,
                 time_retrieved: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the App Catalog Subscription resource in Oracle Cloud Infrastructure Core service.

        Create a subscription for listing resource version for a compartment. It will take some time to propagate to all regions.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_app_catalog_subscription = oci.core.AppCatalogSubscription("test_app_catalog_subscription",
            compartment_id=compartment_id,
            listing_id=test_listing["id"],
            listing_resource_version=app_catalog_subscription_listing_resource_version,
            oracle_terms_of_use_link=app_catalog_subscription_oracle_terms_of_use_link,
            signature=app_catalog_subscription_signature,
            time_retrieved=app_catalog_subscription_time_retrieved,
            eula_link=app_catalog_subscription_eula_link)
        ```

        ## Import

        AppCatalogSubscriptions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/appCatalogSubscription:AppCatalogSubscription test_app_catalog_subscription "compartmentId/{compartmentId}/listingId/{listingId}/listingResourceVersion/{listingResourceVersion}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The compartmentID for the subscription.
        :param pulumi.Input[_builtins.str] eula_link: EULA link
        :param pulumi.Input[_builtins.str] listing_id: The OCID of the listing.
        :param pulumi.Input[_builtins.str] listing_resource_version: Listing resource version.
        :param pulumi.Input[_builtins.str] oracle_terms_of_use_link: Oracle TOU link
        :param pulumi.Input[_builtins.str] signature: A generated signature for this listing resource version retrieved the agreements API.
        :param pulumi.Input[_builtins.str] time_retrieved: Date and time the agreements were retrieved, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppCatalogSubscriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the App Catalog Subscription resource in Oracle Cloud Infrastructure Core service.

        Create a subscription for listing resource version for a compartment. It will take some time to propagate to all regions.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_app_catalog_subscription = oci.core.AppCatalogSubscription("test_app_catalog_subscription",
            compartment_id=compartment_id,
            listing_id=test_listing["id"],
            listing_resource_version=app_catalog_subscription_listing_resource_version,
            oracle_terms_of_use_link=app_catalog_subscription_oracle_terms_of_use_link,
            signature=app_catalog_subscription_signature,
            time_retrieved=app_catalog_subscription_time_retrieved,
            eula_link=app_catalog_subscription_eula_link)
        ```

        ## Import

        AppCatalogSubscriptions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/appCatalogSubscription:AppCatalogSubscription test_app_catalog_subscription "compartmentId/{compartmentId}/listingId/{listingId}/listingResourceVersion/{listingResourceVersion}"
        ```

        :param str resource_name: The name of the resource.
        :param AppCatalogSubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppCatalogSubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eula_link: Optional[pulumi.Input[_builtins.str]] = None,
                 listing_id: Optional[pulumi.Input[_builtins.str]] = None,
                 listing_resource_version: Optional[pulumi.Input[_builtins.str]] = None,
                 oracle_terms_of_use_link: Optional[pulumi.Input[_builtins.str]] = None,
                 signature: Optional[pulumi.Input[_builtins.str]] = None,
                 time_retrieved: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppCatalogSubscriptionArgs.__new__(AppCatalogSubscriptionArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["eula_link"] = eula_link
            if listing_id is None and not opts.urn:
                raise TypeError("Missing required property 'listing_id'")
            __props__.__dict__["listing_id"] = listing_id
            if listing_resource_version is None and not opts.urn:
                raise TypeError("Missing required property 'listing_resource_version'")
            __props__.__dict__["listing_resource_version"] = listing_resource_version
            if oracle_terms_of_use_link is None and not opts.urn:
                raise TypeError("Missing required property 'oracle_terms_of_use_link'")
            __props__.__dict__["oracle_terms_of_use_link"] = oracle_terms_of_use_link
            if signature is None and not opts.urn:
                raise TypeError("Missing required property 'signature'")
            __props__.__dict__["signature"] = signature
            if time_retrieved is None and not opts.urn:
                raise TypeError("Missing required property 'time_retrieved'")
            __props__.__dict__["time_retrieved"] = time_retrieved
            __props__.__dict__["display_name"] = None
            __props__.__dict__["listing_resource_id"] = None
            __props__.__dict__["publisher_name"] = None
            __props__.__dict__["summary"] = None
            __props__.__dict__["time_created"] = None
        super(AppCatalogSubscription, __self__).__init__(
            'oci:Core/appCatalogSubscription:AppCatalogSubscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            eula_link: Optional[pulumi.Input[_builtins.str]] = None,
            listing_id: Optional[pulumi.Input[_builtins.str]] = None,
            listing_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            listing_resource_version: Optional[pulumi.Input[_builtins.str]] = None,
            oracle_terms_of_use_link: Optional[pulumi.Input[_builtins.str]] = None,
            publisher_name: Optional[pulumi.Input[_builtins.str]] = None,
            signature: Optional[pulumi.Input[_builtins.str]] = None,
            summary: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_retrieved: Optional[pulumi.Input[_builtins.str]] = None) -> 'AppCatalogSubscription':
        """
        Get an existing AppCatalogSubscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The compartmentID for the subscription.
        :param pulumi.Input[_builtins.str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] eula_link: EULA link
        :param pulumi.Input[_builtins.str] listing_id: The OCID of the listing.
        :param pulumi.Input[_builtins.str] listing_resource_id: Listing resource id.
        :param pulumi.Input[_builtins.str] listing_resource_version: Listing resource version.
        :param pulumi.Input[_builtins.str] oracle_terms_of_use_link: Oracle TOU link
        :param pulumi.Input[_builtins.str] publisher_name: Name of the publisher who published this listing.
        :param pulumi.Input[_builtins.str] signature: A generated signature for this listing resource version retrieved the agreements API.
        :param pulumi.Input[_builtins.str] summary: The short summary to the listing.
        :param pulumi.Input[_builtins.str] time_created: Date and time at which the subscription was created, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z`
        :param pulumi.Input[_builtins.str] time_retrieved: Date and time the agreements were retrieved, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppCatalogSubscriptionState.__new__(_AppCatalogSubscriptionState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["eula_link"] = eula_link
        __props__.__dict__["listing_id"] = listing_id
        __props__.__dict__["listing_resource_id"] = listing_resource_id
        __props__.__dict__["listing_resource_version"] = listing_resource_version
        __props__.__dict__["oracle_terms_of_use_link"] = oracle_terms_of_use_link
        __props__.__dict__["publisher_name"] = publisher_name
        __props__.__dict__["signature"] = signature
        __props__.__dict__["summary"] = summary
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_retrieved"] = time_retrieved
        return AppCatalogSubscription(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The compartmentID for the subscription.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="eulaLink")
    def eula_link(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        EULA link
        """
        return pulumi.get(self, "eula_link")

    @_builtins.property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the listing.
        """
        return pulumi.get(self, "listing_id")

    @_builtins.property
    @pulumi.getter(name="listingResourceId")
    def listing_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        Listing resource id.
        """
        return pulumi.get(self, "listing_resource_id")

    @_builtins.property
    @pulumi.getter(name="listingResourceVersion")
    def listing_resource_version(self) -> pulumi.Output[_builtins.str]:
        """
        Listing resource version.
        """
        return pulumi.get(self, "listing_resource_version")

    @_builtins.property
    @pulumi.getter(name="oracleTermsOfUseLink")
    def oracle_terms_of_use_link(self) -> pulumi.Output[_builtins.str]:
        """
        Oracle TOU link
        """
        return pulumi.get(self, "oracle_terms_of_use_link")

    @_builtins.property
    @pulumi.getter(name="publisherName")
    def publisher_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the publisher who published this listing.
        """
        return pulumi.get(self, "publisher_name")

    @_builtins.property
    @pulumi.getter
    def signature(self) -> pulumi.Output[_builtins.str]:
        """
        A generated signature for this listing resource version retrieved the agreements API.
        """
        return pulumi.get(self, "signature")

    @_builtins.property
    @pulumi.getter
    def summary(self) -> pulumi.Output[_builtins.str]:
        """
        The short summary to the listing.
        """
        return pulumi.get(self, "summary")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time at which the subscription was created, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeRetrieved")
    def time_retrieved(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time the agreements were retrieved, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_retrieved")

