# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBackupDestinationResult',
    'AwaitableGetBackupDestinationResult',
    'get_backup_destination',
    'get_backup_destination_output',
]

@pulumi.output_type
class GetBackupDestinationResult:
    """
    A collection of values returned by getBackupDestination.
    """
    def __init__(__self__, associated_databases=None, backup_destination_id=None, compartment_id=None, connection_string=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, local_mount_point_path=None, mount_type_details=None, nfs_mount_type=None, nfs_server_export=None, nfs_servers=None, state=None, system_tags=None, time_at_which_storage_details_are_updated=None, time_created=None, total_storage_size_in_gbs=None, type=None, utilized_storage_size_in_gbs=None, vpc_users=None):
        if associated_databases and not isinstance(associated_databases, list):
            raise TypeError("Expected argument 'associated_databases' to be a list")
        pulumi.set(__self__, "associated_databases", associated_databases)
        if backup_destination_id and not isinstance(backup_destination_id, str):
            raise TypeError("Expected argument 'backup_destination_id' to be a str")
        pulumi.set(__self__, "backup_destination_id", backup_destination_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_string and not isinstance(connection_string, str):
            raise TypeError("Expected argument 'connection_string' to be a str")
        pulumi.set(__self__, "connection_string", connection_string)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if local_mount_point_path and not isinstance(local_mount_point_path, str):
            raise TypeError("Expected argument 'local_mount_point_path' to be a str")
        pulumi.set(__self__, "local_mount_point_path", local_mount_point_path)
        if mount_type_details and not isinstance(mount_type_details, list):
            raise TypeError("Expected argument 'mount_type_details' to be a list")
        pulumi.set(__self__, "mount_type_details", mount_type_details)
        if nfs_mount_type and not isinstance(nfs_mount_type, str):
            raise TypeError("Expected argument 'nfs_mount_type' to be a str")
        pulumi.set(__self__, "nfs_mount_type", nfs_mount_type)
        if nfs_server_export and not isinstance(nfs_server_export, str):
            raise TypeError("Expected argument 'nfs_server_export' to be a str")
        pulumi.set(__self__, "nfs_server_export", nfs_server_export)
        if nfs_servers and not isinstance(nfs_servers, list):
            raise TypeError("Expected argument 'nfs_servers' to be a list")
        pulumi.set(__self__, "nfs_servers", nfs_servers)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_at_which_storage_details_are_updated and not isinstance(time_at_which_storage_details_are_updated, str):
            raise TypeError("Expected argument 'time_at_which_storage_details_are_updated' to be a str")
        pulumi.set(__self__, "time_at_which_storage_details_are_updated", time_at_which_storage_details_are_updated)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if total_storage_size_in_gbs and not isinstance(total_storage_size_in_gbs, int):
            raise TypeError("Expected argument 'total_storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "total_storage_size_in_gbs", total_storage_size_in_gbs)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if utilized_storage_size_in_gbs and not isinstance(utilized_storage_size_in_gbs, int):
            raise TypeError("Expected argument 'utilized_storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "utilized_storage_size_in_gbs", utilized_storage_size_in_gbs)
        if vpc_users and not isinstance(vpc_users, list):
            raise TypeError("Expected argument 'vpc_users' to be a list")
        pulumi.set(__self__, "vpc_users", vpc_users)

    @_builtins.property
    @pulumi.getter(name="associatedDatabases")
    def associated_databases(self) -> Sequence['outputs.GetBackupDestinationAssociatedDatabaseResult']:
        """
        List of databases associated with the backup destination.
        """
        return pulumi.get(self, "associated_databases")

    @_builtins.property
    @pulumi.getter(name="backupDestinationId")
    def backup_destination_id(self) -> _builtins.str:
        return pulumi.get(self, "backup_destination_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> _builtins.str:
        """
        For a RECOVERY_APPLIANCE backup destination, the connection string for connecting to the Recovery Appliance.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The user-provided name of the backup destination.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup destination.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A descriptive text associated with the lifecycleState. Typically contains additional displayable text
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="localMountPointPath")
    @_utilities.deprecated("""The 'local_mount_point_path' field has been deprecated. Please use 'local_mount_point_path under mount_type_details' instead.""")
    def local_mount_point_path(self) -> _builtins.str:
        """
        The local directory path on each VM cluster node where the NFS server location is mounted. The local directory path and the NFS server location must each be the same across all of the VM cluster nodes. Ensure that the NFS mount is maintained continuously on all of the VM cluster nodes.
        """
        return pulumi.get(self, "local_mount_point_path")

    @_builtins.property
    @pulumi.getter(name="mountTypeDetails")
    def mount_type_details(self) -> Sequence['outputs.GetBackupDestinationMountTypeDetailResult']:
        return pulumi.get(self, "mount_type_details")

    @_builtins.property
    @pulumi.getter(name="nfsMountType")
    def nfs_mount_type(self) -> _builtins.str:
        """
        NFS Mount type for backup destination.
        """
        return pulumi.get(self, "nfs_mount_type")

    @_builtins.property
    @pulumi.getter(name="nfsServerExport")
    def nfs_server_export(self) -> _builtins.str:
        """
        Specifies the directory on which to mount the file system
        """
        return pulumi.get(self, "nfs_server_export")

    @_builtins.property
    @pulumi.getter(name="nfsServers")
    def nfs_servers(self) -> Sequence[_builtins.str]:
        """
        Host names or IP addresses for NFS Auto mount.
        """
        return pulumi.get(self, "nfs_servers")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current lifecycle state of the backup destination.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeAtWhichStorageDetailsAreUpdated")
    def time_at_which_storage_details_are_updated(self) -> _builtins.str:
        """
        The time when the total storage size and the utilized storage size of the backup destination are updated.
        """
        return pulumi.get(self, "time_at_which_storage_details_are_updated")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the backup destination was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="totalStorageSizeInGbs")
    def total_storage_size_in_gbs(self) -> _builtins.int:
        """
        The total storage size of the backup destination in GBs, rounded to the nearest integer.
        """
        return pulumi.get(self, "total_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the backup destination.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="utilizedStorageSizeInGbs")
    def utilized_storage_size_in_gbs(self) -> _builtins.int:
        """
        The total amount of space utilized on the backup destination (in GBs), rounded to the nearest integer.
        """
        return pulumi.get(self, "utilized_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="vpcUsers")
    def vpc_users(self) -> Sequence[_builtins.str]:
        """
        For a RECOVERY_APPLIANCE backup destination, the Virtual Private Catalog (VPC) users that are used to access the Recovery Appliance.
        """
        return pulumi.get(self, "vpc_users")


class AwaitableGetBackupDestinationResult(GetBackupDestinationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackupDestinationResult(
            associated_databases=self.associated_databases,
            backup_destination_id=self.backup_destination_id,
            compartment_id=self.compartment_id,
            connection_string=self.connection_string,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            local_mount_point_path=self.local_mount_point_path,
            mount_type_details=self.mount_type_details,
            nfs_mount_type=self.nfs_mount_type,
            nfs_server_export=self.nfs_server_export,
            nfs_servers=self.nfs_servers,
            state=self.state,
            system_tags=self.system_tags,
            time_at_which_storage_details_are_updated=self.time_at_which_storage_details_are_updated,
            time_created=self.time_created,
            total_storage_size_in_gbs=self.total_storage_size_in_gbs,
            type=self.type,
            utilized_storage_size_in_gbs=self.utilized_storage_size_in_gbs,
            vpc_users=self.vpc_users)


def get_backup_destination(backup_destination_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackupDestinationResult:
    """
    This data source provides details about a specific Backup Destination resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified backup destination in an Exadata Cloud@Customer system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_backup_destination = oci.Database.get_backup_destination(backup_destination_id=test_backup_destination_oci_database_backup_destination["id"])
    ```


    :param _builtins.str backup_destination_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup destination.
    """
    __args__ = dict()
    __args__['backupDestinationId'] = backup_destination_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getBackupDestination:getBackupDestination', __args__, opts=opts, typ=GetBackupDestinationResult).value

    return AwaitableGetBackupDestinationResult(
        associated_databases=pulumi.get(__ret__, 'associated_databases'),
        backup_destination_id=pulumi.get(__ret__, 'backup_destination_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        connection_string=pulumi.get(__ret__, 'connection_string'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        local_mount_point_path=pulumi.get(__ret__, 'local_mount_point_path'),
        mount_type_details=pulumi.get(__ret__, 'mount_type_details'),
        nfs_mount_type=pulumi.get(__ret__, 'nfs_mount_type'),
        nfs_server_export=pulumi.get(__ret__, 'nfs_server_export'),
        nfs_servers=pulumi.get(__ret__, 'nfs_servers'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_at_which_storage_details_are_updated=pulumi.get(__ret__, 'time_at_which_storage_details_are_updated'),
        time_created=pulumi.get(__ret__, 'time_created'),
        total_storage_size_in_gbs=pulumi.get(__ret__, 'total_storage_size_in_gbs'),
        type=pulumi.get(__ret__, 'type'),
        utilized_storage_size_in_gbs=pulumi.get(__ret__, 'utilized_storage_size_in_gbs'),
        vpc_users=pulumi.get(__ret__, 'vpc_users'))
def get_backup_destination_output(backup_destination_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBackupDestinationResult]:
    """
    This data source provides details about a specific Backup Destination resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified backup destination in an Exadata Cloud@Customer system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_backup_destination = oci.Database.get_backup_destination(backup_destination_id=test_backup_destination_oci_database_backup_destination["id"])
    ```


    :param _builtins.str backup_destination_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup destination.
    """
    __args__ = dict()
    __args__['backupDestinationId'] = backup_destination_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getBackupDestination:getBackupDestination', __args__, opts=opts, typ=GetBackupDestinationResult)
    return __ret__.apply(lambda __response__: GetBackupDestinationResult(
        associated_databases=pulumi.get(__response__, 'associated_databases'),
        backup_destination_id=pulumi.get(__response__, 'backup_destination_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        connection_string=pulumi.get(__response__, 'connection_string'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        local_mount_point_path=pulumi.get(__response__, 'local_mount_point_path'),
        mount_type_details=pulumi.get(__response__, 'mount_type_details'),
        nfs_mount_type=pulumi.get(__response__, 'nfs_mount_type'),
        nfs_server_export=pulumi.get(__response__, 'nfs_server_export'),
        nfs_servers=pulumi.get(__response__, 'nfs_servers'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_at_which_storage_details_are_updated=pulumi.get(__response__, 'time_at_which_storage_details_are_updated'),
        time_created=pulumi.get(__response__, 'time_created'),
        total_storage_size_in_gbs=pulumi.get(__response__, 'total_storage_size_in_gbs'),
        type=pulumi.get(__response__, 'type'),
        utilized_storage_size_in_gbs=pulumi.get(__response__, 'utilized_storage_size_in_gbs'),
        vpc_users=pulumi.get(__response__, 'vpc_users')))
