# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCloudVmClustersResult',
    'AwaitableGetCloudVmClustersResult',
    'get_cloud_vm_clusters',
    'get_cloud_vm_clusters_output',
]

@pulumi.output_type
class GetCloudVmClustersResult:
    """
    A collection of values returned by getCloudVmClusters.
    """
    def __init__(__self__, cloud_exadata_infrastructure_id=None, cloud_vm_clusters=None, compartment_id=None, display_name=None, filters=None, id=None, state=None, vm_cluster_type=None):
        if cloud_exadata_infrastructure_id and not isinstance(cloud_exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'cloud_exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        if cloud_vm_clusters and not isinstance(cloud_vm_clusters, list):
            raise TypeError("Expected argument 'cloud_vm_clusters' to be a list")
        pulumi.set(__self__, "cloud_vm_clusters", cloud_vm_clusters)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vm_cluster_type and not isinstance(vm_cluster_type, str):
            raise TypeError("Expected argument 'vm_cluster_type' to be a str")
        pulumi.set(__self__, "vm_cluster_type", vm_cluster_type)

    @_builtins.property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Exadata infrastructure.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @_builtins.property
    @pulumi.getter(name="cloudVmClusters")
    def cloud_vm_clusters(self) -> Sequence['outputs.GetCloudVmClustersCloudVmClusterResult']:
        """
        The list of cloud_vm_clusters.
        """
        return pulumi.get(self, "cloud_vm_clusters")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The user-friendly name for the cloud VM cluster. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCloudVmClustersFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the cloud VM cluster.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="vmClusterType")
    def vm_cluster_type(self) -> Optional[_builtins.str]:
        """
        The vmcluster type for the VM cluster/Cloud VM cluster.
        """
        return pulumi.get(self, "vm_cluster_type")


class AwaitableGetCloudVmClustersResult(GetCloudVmClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudVmClustersResult(
            cloud_exadata_infrastructure_id=self.cloud_exadata_infrastructure_id,
            cloud_vm_clusters=self.cloud_vm_clusters,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state,
            vm_cluster_type=self.vm_cluster_type)


def get_cloud_vm_clusters(cloud_exadata_infrastructure_id: Optional[_builtins.str] = None,
                          compartment_id: Optional[_builtins.str] = None,
                          display_name: Optional[_builtins.str] = None,
                          filters: Optional[Sequence[Union['GetCloudVmClustersFilterArgs', 'GetCloudVmClustersFilterArgsDict']]] = None,
                          state: Optional[_builtins.str] = None,
                          vm_cluster_type: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudVmClustersResult:
    """
    This data source provides the list of Cloud Vm Clusters in Oracle Cloud Infrastructure Database service.

    Gets a list of the cloud VM clusters in the specified compartment. Applies to Exadata Cloud Service instances and Autonomous Database on dedicated Exadata infrastructure only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_vm_clusters = oci.Database.get_cloud_vm_clusters(compartment_id=compartment_id,
        cloud_exadata_infrastructure_id=test_cloud_exadata_infrastructure["id"],
        display_name=cloud_vm_cluster_display_name,
        state=cloud_vm_cluster_state,
        vm_cluster_type=cloud_vm_cluster_vm_cluster_type)
    ```


    :param _builtins.str cloud_exadata_infrastructure_id: If provided, filters the results for the specified cloud Exadata infrastructure.
    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param _builtins.str state: A filter to return only cloud VM clusters that match the given lifecycle state exactly.
    :param _builtins.str vm_cluster_type: A filter to return only cloud vmclusters that match the given cloud vmcluster type exactly.
    """
    __args__ = dict()
    __args__['cloudExadataInfrastructureId'] = cloud_exadata_infrastructure_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['vmClusterType'] = vm_cluster_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getCloudVmClusters:getCloudVmClusters', __args__, opts=opts, typ=GetCloudVmClustersResult).value

    return AwaitableGetCloudVmClustersResult(
        cloud_exadata_infrastructure_id=pulumi.get(__ret__, 'cloud_exadata_infrastructure_id'),
        cloud_vm_clusters=pulumi.get(__ret__, 'cloud_vm_clusters'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        vm_cluster_type=pulumi.get(__ret__, 'vm_cluster_type'))
def get_cloud_vm_clusters_output(cloud_exadata_infrastructure_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetCloudVmClustersFilterArgs', 'GetCloudVmClustersFilterArgsDict']]]]] = None,
                                 state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 vm_cluster_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudVmClustersResult]:
    """
    This data source provides the list of Cloud Vm Clusters in Oracle Cloud Infrastructure Database service.

    Gets a list of the cloud VM clusters in the specified compartment. Applies to Exadata Cloud Service instances and Autonomous Database on dedicated Exadata infrastructure only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_vm_clusters = oci.Database.get_cloud_vm_clusters(compartment_id=compartment_id,
        cloud_exadata_infrastructure_id=test_cloud_exadata_infrastructure["id"],
        display_name=cloud_vm_cluster_display_name,
        state=cloud_vm_cluster_state,
        vm_cluster_type=cloud_vm_cluster_vm_cluster_type)
    ```


    :param _builtins.str cloud_exadata_infrastructure_id: If provided, filters the results for the specified cloud Exadata infrastructure.
    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param _builtins.str state: A filter to return only cloud VM clusters that match the given lifecycle state exactly.
    :param _builtins.str vm_cluster_type: A filter to return only cloud vmclusters that match the given cloud vmcluster type exactly.
    """
    __args__ = dict()
    __args__['cloudExadataInfrastructureId'] = cloud_exadata_infrastructure_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['vmClusterType'] = vm_cluster_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getCloudVmClusters:getCloudVmClusters', __args__, opts=opts, typ=GetCloudVmClustersResult)
    return __ret__.apply(lambda __response__: GetCloudVmClustersResult(
        cloud_exadata_infrastructure_id=pulumi.get(__response__, 'cloud_exadata_infrastructure_id'),
        cloud_vm_clusters=pulumi.get(__response__, 'cloud_vm_clusters'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        vm_cluster_type=pulumi.get(__response__, 'vm_cluster_type')))
