# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetGiVersionMinorVersionsResult',
    'AwaitableGetGiVersionMinorVersionsResult',
    'get_gi_version_minor_versions',
    'get_gi_version_minor_versions_output',
]

@pulumi.output_type
class GetGiVersionMinorVersionsResult:
    """
    A collection of values returned by getGiVersionMinorVersions.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, filters=None, gi_minor_versions=None, id=None, is_gi_version_for_provisioning=None, shape=None, shape_family=None, version=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if gi_minor_versions and not isinstance(gi_minor_versions, list):
            raise TypeError("Expected argument 'gi_minor_versions' to be a list")
        pulumi.set(__self__, "gi_minor_versions", gi_minor_versions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_gi_version_for_provisioning and not isinstance(is_gi_version_for_provisioning, bool):
            raise TypeError("Expected argument 'is_gi_version_for_provisioning' to be a bool")
        pulumi.set(__self__, "is_gi_version_for_provisioning", is_gi_version_for_provisioning)
        if shape and not isinstance(shape, str):
            raise TypeError("Expected argument 'shape' to be a str")
        pulumi.set(__self__, "shape", shape)
        if shape_family and not isinstance(shape_family, str):
            raise TypeError("Expected argument 'shape_family' to be a str")
        pulumi.set(__self__, "shape_family", shape_family)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetGiVersionMinorVersionsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="giMinorVersions")
    def gi_minor_versions(self) -> Sequence['outputs.GetGiVersionMinorVersionsGiMinorVersionResult']:
        """
        The list of gi_minor_versions.
        """
        return pulumi.get(self, "gi_minor_versions")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isGiVersionForProvisioning")
    def is_gi_version_for_provisioning(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "is_gi_version_for_provisioning")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter(name="shapeFamily")
    def shape_family(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "shape_family")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        A valid Oracle Grid Infrastructure (GI) software version.
        """
        return pulumi.get(self, "version")


class AwaitableGetGiVersionMinorVersionsResult(GetGiVersionMinorVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGiVersionMinorVersionsResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            filters=self.filters,
            gi_minor_versions=self.gi_minor_versions,
            id=self.id,
            is_gi_version_for_provisioning=self.is_gi_version_for_provisioning,
            shape=self.shape,
            shape_family=self.shape_family,
            version=self.version)


def get_gi_version_minor_versions(availability_domain: Optional[_builtins.str] = None,
                                  compartment_id: Optional[_builtins.str] = None,
                                  filters: Optional[Sequence[Union['GetGiVersionMinorVersionsFilterArgs', 'GetGiVersionMinorVersionsFilterArgsDict']]] = None,
                                  is_gi_version_for_provisioning: Optional[_builtins.bool] = None,
                                  shape: Optional[_builtins.str] = None,
                                  shape_family: Optional[_builtins.str] = None,
                                  version: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGiVersionMinorVersionsResult:
    """
    This data source provides the list of Gi Version Minor Versions in Oracle Cloud Infrastructure Database service.

    Gets a list of supported Oracle Grid Infrastructure minor versions for the given major version and shape family.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_gi_version_minor_versions = oci.Database.get_gi_version_minor_versions(version=gi_version_minor_version_version,
        availability_domain=gi_version_minor_version_availability_domain,
        compartment_id=compartment_id,
        is_gi_version_for_provisioning=gi_version_minor_version_is_gi_version_for_provisioning,
        shape=gi_version_minor_version_shape,
        shape_family=gi_version_minor_version_shape_family)
    ```


    :param _builtins.str availability_domain: The target availability domain. Only passed if the limit is AD-specific.
    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.bool is_gi_version_for_provisioning: If true, returns the Grid Infrastructure versions that can be used for provisioning a cluster
    :param _builtins.str shape: If provided, filters the results for the given shape.
    :param _builtins.str shape_family: If provided, filters the results to the set of database versions which are supported for the given shape family.
    :param _builtins.str version: The Oracle Grid Infrastructure major version.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['isGiVersionForProvisioning'] = is_gi_version_for_provisioning
    __args__['shape'] = shape
    __args__['shapeFamily'] = shape_family
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getGiVersionMinorVersions:getGiVersionMinorVersions', __args__, opts=opts, typ=GetGiVersionMinorVersionsResult).value

    return AwaitableGetGiVersionMinorVersionsResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        gi_minor_versions=pulumi.get(__ret__, 'gi_minor_versions'),
        id=pulumi.get(__ret__, 'id'),
        is_gi_version_for_provisioning=pulumi.get(__ret__, 'is_gi_version_for_provisioning'),
        shape=pulumi.get(__ret__, 'shape'),
        shape_family=pulumi.get(__ret__, 'shape_family'),
        version=pulumi.get(__ret__, 'version'))
def get_gi_version_minor_versions_output(availability_domain: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetGiVersionMinorVersionsFilterArgs', 'GetGiVersionMinorVersionsFilterArgsDict']]]]] = None,
                                         is_gi_version_for_provisioning: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                         shape: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         shape_family: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         version: Optional[pulumi.Input[_builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGiVersionMinorVersionsResult]:
    """
    This data source provides the list of Gi Version Minor Versions in Oracle Cloud Infrastructure Database service.

    Gets a list of supported Oracle Grid Infrastructure minor versions for the given major version and shape family.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_gi_version_minor_versions = oci.Database.get_gi_version_minor_versions(version=gi_version_minor_version_version,
        availability_domain=gi_version_minor_version_availability_domain,
        compartment_id=compartment_id,
        is_gi_version_for_provisioning=gi_version_minor_version_is_gi_version_for_provisioning,
        shape=gi_version_minor_version_shape,
        shape_family=gi_version_minor_version_shape_family)
    ```


    :param _builtins.str availability_domain: The target availability domain. Only passed if the limit is AD-specific.
    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.bool is_gi_version_for_provisioning: If true, returns the Grid Infrastructure versions that can be used for provisioning a cluster
    :param _builtins.str shape: If provided, filters the results for the given shape.
    :param _builtins.str shape_family: If provided, filters the results to the set of database versions which are supported for the given shape family.
    :param _builtins.str version: The Oracle Grid Infrastructure major version.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['isGiVersionForProvisioning'] = is_gi_version_for_provisioning
    __args__['shape'] = shape
    __args__['shapeFamily'] = shape_family
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getGiVersionMinorVersions:getGiVersionMinorVersions', __args__, opts=opts, typ=GetGiVersionMinorVersionsResult)
    return __ret__.apply(lambda __response__: GetGiVersionMinorVersionsResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        gi_minor_versions=pulumi.get(__response__, 'gi_minor_versions'),
        id=pulumi.get(__response__, 'id'),
        is_gi_version_for_provisioning=pulumi.get(__response__, 'is_gi_version_for_provisioning'),
        shape=pulumi.get(__response__, 'shape'),
        shape_family=pulumi.get(__response__, 'shape_family'),
        version=pulumi.get(__response__, 'version')))
