# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementArgs', 'AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagement']

@pulumi.input_type
class AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementArgs:
    def __init__(__self__, *,
                 autonomous_database_id: pulumi.Input[_builtins.str],
                 enable_autonomous_database_dbm_feature: pulumi.Input[_builtins.bool],
                 feature_details: Optional[pulumi.Input['AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementFeatureDetailsArgs']] = None):
        """
        The set of arguments for constructing a AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagement resource.
        :param pulumi.Input[_builtins.str] autonomous_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database.
        :param pulumi.Input[_builtins.bool] enable_autonomous_database_dbm_feature: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input['AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementFeatureDetailsArgs'] feature_details: The details required to enable the specified Database Management feature for an Autonomous Database.
        """
        pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        pulumi.set(__self__, "enable_autonomous_database_dbm_feature", enable_autonomous_database_dbm_feature)
        if feature_details is not None:
            pulumi.set(__self__, "feature_details", feature_details)

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database.
        """
        return pulumi.get(self, "autonomous_database_id")

    @autonomous_database_id.setter
    def autonomous_database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "autonomous_database_id", value)

    @_builtins.property
    @pulumi.getter(name="enableAutonomousDatabaseDbmFeature")
    def enable_autonomous_database_dbm_feature(self) -> pulumi.Input[_builtins.bool]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_autonomous_database_dbm_feature")

    @enable_autonomous_database_dbm_feature.setter
    def enable_autonomous_database_dbm_feature(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enable_autonomous_database_dbm_feature", value)

    @_builtins.property
    @pulumi.getter(name="featureDetails")
    def feature_details(self) -> Optional[pulumi.Input['AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementFeatureDetailsArgs']]:
        """
        The details required to enable the specified Database Management feature for an Autonomous Database.
        """
        return pulumi.get(self, "feature_details")

    @feature_details.setter
    def feature_details(self, value: Optional[pulumi.Input['AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementFeatureDetailsArgs']]):
        pulumi.set(self, "feature_details", value)


@pulumi.input_type
class _AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementState:
    def __init__(__self__, *,
                 autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_autonomous_database_dbm_feature: Optional[pulumi.Input[_builtins.bool]] = None,
                 feature_details: Optional[pulumi.Input['AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementFeatureDetailsArgs']] = None):
        """
        Input properties used for looking up and filtering AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagement resources.
        :param pulumi.Input[_builtins.str] autonomous_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database.
        :param pulumi.Input[_builtins.bool] enable_autonomous_database_dbm_feature: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input['AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementFeatureDetailsArgs'] feature_details: The details required to enable the specified Database Management feature for an Autonomous Database.
        """
        if autonomous_database_id is not None:
            pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if enable_autonomous_database_dbm_feature is not None:
            pulumi.set(__self__, "enable_autonomous_database_dbm_feature", enable_autonomous_database_dbm_feature)
        if feature_details is not None:
            pulumi.set(__self__, "feature_details", feature_details)

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database.
        """
        return pulumi.get(self, "autonomous_database_id")

    @autonomous_database_id.setter
    def autonomous_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "autonomous_database_id", value)

    @_builtins.property
    @pulumi.getter(name="enableAutonomousDatabaseDbmFeature")
    def enable_autonomous_database_dbm_feature(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_autonomous_database_dbm_feature")

    @enable_autonomous_database_dbm_feature.setter
    def enable_autonomous_database_dbm_feature(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_autonomous_database_dbm_feature", value)

    @_builtins.property
    @pulumi.getter(name="featureDetails")
    def feature_details(self) -> Optional[pulumi.Input['AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementFeatureDetailsArgs']]:
        """
        The details required to enable the specified Database Management feature for an Autonomous Database.
        """
        return pulumi.get(self, "feature_details")

    @feature_details.setter
    def feature_details(self, value: Optional[pulumi.Input['AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementFeatureDetailsArgs']]):
        pulumi.set(self, "feature_details", value)


@pulumi.type_token("oci:DatabaseManagement/autonomousDatabaseAutonomousDatabaseDbmFeaturesManagement:AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagement")
class AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_autonomous_database_dbm_feature: Optional[pulumi.Input[_builtins.bool]] = None,
                 feature_details: Optional[pulumi.Input[Union['AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementFeatureDetailsArgs', 'AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementFeatureDetailsArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Autonomous Database Autonomous Database Dbm Features Management resource in Oracle Cloud Infrastructure Database Management service.

        Enables a Database Management feature for the specified Autonomous Database.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] autonomous_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database.
        :param pulumi.Input[_builtins.bool] enable_autonomous_database_dbm_feature: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Union['AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementFeatureDetailsArgs', 'AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementFeatureDetailsArgsDict']] feature_details: The details required to enable the specified Database Management feature for an Autonomous Database.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Autonomous Database Autonomous Database Dbm Features Management resource in Oracle Cloud Infrastructure Database Management service.

        Enables a Database Management feature for the specified Autonomous Database.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_autonomous_database_dbm_feature: Optional[pulumi.Input[_builtins.bool]] = None,
                 feature_details: Optional[pulumi.Input[Union['AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementFeatureDetailsArgs', 'AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementFeatureDetailsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementArgs.__new__(AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementArgs)

            if autonomous_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'autonomous_database_id'")
            __props__.__dict__["autonomous_database_id"] = autonomous_database_id
            if enable_autonomous_database_dbm_feature is None and not opts.urn:
                raise TypeError("Missing required property 'enable_autonomous_database_dbm_feature'")
            __props__.__dict__["enable_autonomous_database_dbm_feature"] = enable_autonomous_database_dbm_feature
            __props__.__dict__["feature_details"] = feature_details
        super(AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagement, __self__).__init__(
            'oci:DatabaseManagement/autonomousDatabaseAutonomousDatabaseDbmFeaturesManagement:AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            enable_autonomous_database_dbm_feature: Optional[pulumi.Input[_builtins.bool]] = None,
            feature_details: Optional[pulumi.Input[Union['AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementFeatureDetailsArgs', 'AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementFeatureDetailsArgsDict']]] = None) -> 'AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagement':
        """
        Get an existing AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] autonomous_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database.
        :param pulumi.Input[_builtins.bool] enable_autonomous_database_dbm_feature: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Union['AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementFeatureDetailsArgs', 'AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementFeatureDetailsArgsDict']] feature_details: The details required to enable the specified Database Management feature for an Autonomous Database.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementState.__new__(_AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementState)

        __props__.__dict__["autonomous_database_id"] = autonomous_database_id
        __props__.__dict__["enable_autonomous_database_dbm_feature"] = enable_autonomous_database_dbm_feature
        __props__.__dict__["feature_details"] = feature_details
        return AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database.
        """
        return pulumi.get(self, "autonomous_database_id")

    @_builtins.property
    @pulumi.getter(name="enableAutonomousDatabaseDbmFeature")
    def enable_autonomous_database_dbm_feature(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_autonomous_database_dbm_feature")

    @_builtins.property
    @pulumi.getter(name="featureDetails")
    def feature_details(self) -> pulumi.Output[Optional['outputs.AutonomousDatabaseAutonomousDatabaseDbmFeaturesManagementFeatureDetails']]:
        """
        The details required to enable the specified Database Management feature for an Autonomous Database.
        """
        return pulumi.get(self, "feature_details")

