# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CloudDbSystemCloudDatabaseManagementsManagementArgs', 'CloudDbSystemCloudDatabaseManagementsManagement']

@pulumi.input_type
class CloudDbSystemCloudDatabaseManagementsManagementArgs:
    def __init__(__self__, *,
                 cloud_db_system_id: pulumi.Input[_builtins.str],
                 enable_cloud_database_management: pulumi.Input[_builtins.bool],
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CloudDbSystemCloudDatabaseManagementsManagement resource.
        :param pulumi.Input[_builtins.str] cloud_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud DB system.
        :param pulumi.Input[_builtins.bool] enable_cloud_database_management: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.bool] is_enabled: The status of the associated service.
        :param pulumi.Input[_builtins.str] metadata: The associated service-specific inputs in JSON string format, which Database Management can identify.
        """
        pulumi.set(__self__, "cloud_db_system_id", cloud_db_system_id)
        pulumi.set(__self__, "enable_cloud_database_management", enable_cloud_database_management)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @_builtins.property
    @pulumi.getter(name="cloudDbSystemId")
    def cloud_db_system_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud DB system.
        """
        return pulumi.get(self, "cloud_db_system_id")

    @cloud_db_system_id.setter
    def cloud_db_system_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloud_db_system_id", value)

    @_builtins.property
    @pulumi.getter(name="enableCloudDatabaseManagement")
    def enable_cloud_database_management(self) -> pulumi.Input[_builtins.bool]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_cloud_database_management")

    @enable_cloud_database_management.setter
    def enable_cloud_database_management(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enable_cloud_database_management", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The status of the associated service.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The associated service-specific inputs in JSON string format, which Database Management can identify.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metadata", value)


@pulumi.input_type
class _CloudDbSystemCloudDatabaseManagementsManagementState:
    def __init__(__self__, *,
                 cloud_db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_cloud_database_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CloudDbSystemCloudDatabaseManagementsManagement resources.
        :param pulumi.Input[_builtins.str] cloud_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud DB system.
        :param pulumi.Input[_builtins.bool] enable_cloud_database_management: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.bool] is_enabled: The status of the associated service.
        :param pulumi.Input[_builtins.str] metadata: The associated service-specific inputs in JSON string format, which Database Management can identify.
        """
        if cloud_db_system_id is not None:
            pulumi.set(__self__, "cloud_db_system_id", cloud_db_system_id)
        if enable_cloud_database_management is not None:
            pulumi.set(__self__, "enable_cloud_database_management", enable_cloud_database_management)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @_builtins.property
    @pulumi.getter(name="cloudDbSystemId")
    def cloud_db_system_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud DB system.
        """
        return pulumi.get(self, "cloud_db_system_id")

    @cloud_db_system_id.setter
    def cloud_db_system_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_db_system_id", value)

    @_builtins.property
    @pulumi.getter(name="enableCloudDatabaseManagement")
    def enable_cloud_database_management(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_cloud_database_management")

    @enable_cloud_database_management.setter
    def enable_cloud_database_management(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_cloud_database_management", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The status of the associated service.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The associated service-specific inputs in JSON string format, which Database Management can identify.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metadata", value)


@pulumi.type_token("oci:DatabaseManagement/cloudDbSystemCloudDatabaseManagementsManagement:CloudDbSystemCloudDatabaseManagementsManagement")
class CloudDbSystemCloudDatabaseManagementsManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_cloud_database_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Cloud Db System Cloud Database Managements Management resource in Oracle Cloud Infrastructure Database Management service.

        Enables Database Management service for all the components of the specified
        cloud DB system (except databases).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_cloud_db_system_cloud_database_managements_management = oci.databasemanagement.CloudDbSystemCloudDatabaseManagementsManagement("test_cloud_db_system_cloud_database_managements_management",
            cloud_db_system_id=test_cloud_db_system["id"],
            enable_cloud_database_management=enable_cloud_database_management,
            is_enabled=cloud_db_system_cloud_database_managements_management_is_enabled,
            metadata=cloud_db_system_cloud_database_managements_management_metadata)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud DB system.
        :param pulumi.Input[_builtins.bool] enable_cloud_database_management: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.bool] is_enabled: The status of the associated service.
        :param pulumi.Input[_builtins.str] metadata: The associated service-specific inputs in JSON string format, which Database Management can identify.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudDbSystemCloudDatabaseManagementsManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Cloud Db System Cloud Database Managements Management resource in Oracle Cloud Infrastructure Database Management service.

        Enables Database Management service for all the components of the specified
        cloud DB system (except databases).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_cloud_db_system_cloud_database_managements_management = oci.databasemanagement.CloudDbSystemCloudDatabaseManagementsManagement("test_cloud_db_system_cloud_database_managements_management",
            cloud_db_system_id=test_cloud_db_system["id"],
            enable_cloud_database_management=enable_cloud_database_management,
            is_enabled=cloud_db_system_cloud_database_managements_management_is_enabled,
            metadata=cloud_db_system_cloud_database_managements_management_metadata)
        ```

        :param str resource_name: The name of the resource.
        :param CloudDbSystemCloudDatabaseManagementsManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudDbSystemCloudDatabaseManagementsManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_cloud_database_management: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudDbSystemCloudDatabaseManagementsManagementArgs.__new__(CloudDbSystemCloudDatabaseManagementsManagementArgs)

            if cloud_db_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_db_system_id'")
            __props__.__dict__["cloud_db_system_id"] = cloud_db_system_id
            if enable_cloud_database_management is None and not opts.urn:
                raise TypeError("Missing required property 'enable_cloud_database_management'")
            __props__.__dict__["enable_cloud_database_management"] = enable_cloud_database_management
            __props__.__dict__["is_enabled"] = is_enabled
            __props__.__dict__["metadata"] = metadata
        super(CloudDbSystemCloudDatabaseManagementsManagement, __self__).__init__(
            'oci:DatabaseManagement/cloudDbSystemCloudDatabaseManagementsManagement:CloudDbSystemCloudDatabaseManagementsManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
            enable_cloud_database_management: Optional[pulumi.Input[_builtins.bool]] = None,
            is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            metadata: Optional[pulumi.Input[_builtins.str]] = None) -> 'CloudDbSystemCloudDatabaseManagementsManagement':
        """
        Get an existing CloudDbSystemCloudDatabaseManagementsManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud DB system.
        :param pulumi.Input[_builtins.bool] enable_cloud_database_management: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.bool] is_enabled: The status of the associated service.
        :param pulumi.Input[_builtins.str] metadata: The associated service-specific inputs in JSON string format, which Database Management can identify.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudDbSystemCloudDatabaseManagementsManagementState.__new__(_CloudDbSystemCloudDatabaseManagementsManagementState)

        __props__.__dict__["cloud_db_system_id"] = cloud_db_system_id
        __props__.__dict__["enable_cloud_database_management"] = enable_cloud_database_management
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["metadata"] = metadata
        return CloudDbSystemCloudDatabaseManagementsManagement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cloudDbSystemId")
    def cloud_db_system_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud DB system.
        """
        return pulumi.get(self, "cloud_db_system_id")

    @_builtins.property
    @pulumi.getter(name="enableCloudDatabaseManagement")
    def enable_cloud_database_management(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_cloud_database_management")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        The status of the associated service.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[_builtins.str]:
        """
        The associated service-specific inputs in JSON string format, which Database Management can identify.
        """
        return pulumi.get(self, "metadata")

