# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseDbmFeaturesManagementArgs', 'DatabaseDbmFeaturesManagement']

@pulumi.input_type
class DatabaseDbmFeaturesManagementArgs:
    def __init__(__self__, *,
                 database_id: pulumi.Input[_builtins.str],
                 enable_database_dbm_feature: pulumi.Input[_builtins.bool],
                 can_disable_all_pdbs: Optional[pulumi.Input[_builtins.bool]] = None,
                 feature: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_details: Optional[pulumi.Input['DatabaseDbmFeaturesManagementFeatureDetailsArgs']] = None,
                 modify_database_dbm_feature: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a DatabaseDbmFeaturesManagement resource.
        :param pulumi.Input[_builtins.str] database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database.
        :param pulumi.Input[_builtins.bool] enable_database_dbm_feature: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input['DatabaseDbmFeaturesManagementFeatureDetailsArgs'] feature_details: The details required to enable the specified Database Management feature.
        """
        pulumi.set(__self__, "database_id", database_id)
        pulumi.set(__self__, "enable_database_dbm_feature", enable_database_dbm_feature)
        if can_disable_all_pdbs is not None:
            pulumi.set(__self__, "can_disable_all_pdbs", can_disable_all_pdbs)
        if feature is not None:
            pulumi.set(__self__, "feature", feature)
        if feature_details is not None:
            pulumi.set(__self__, "feature_details", feature_details)
        if modify_database_dbm_feature is not None:
            pulumi.set(__self__, "modify_database_dbm_feature", modify_database_dbm_feature)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter(name="enableDatabaseDbmFeature")
    def enable_database_dbm_feature(self) -> pulumi.Input[_builtins.bool]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_database_dbm_feature")

    @enable_database_dbm_feature.setter
    def enable_database_dbm_feature(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enable_database_dbm_feature", value)

    @_builtins.property
    @pulumi.getter(name="canDisableAllPdbs")
    def can_disable_all_pdbs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "can_disable_all_pdbs")

    @can_disable_all_pdbs.setter
    def can_disable_all_pdbs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "can_disable_all_pdbs", value)

    @_builtins.property
    @pulumi.getter
    def feature(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "feature")

    @feature.setter
    def feature(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "feature", value)

    @_builtins.property
    @pulumi.getter(name="featureDetails")
    def feature_details(self) -> Optional[pulumi.Input['DatabaseDbmFeaturesManagementFeatureDetailsArgs']]:
        """
        The details required to enable the specified Database Management feature.
        """
        return pulumi.get(self, "feature_details")

    @feature_details.setter
    def feature_details(self, value: Optional[pulumi.Input['DatabaseDbmFeaturesManagementFeatureDetailsArgs']]):
        pulumi.set(self, "feature_details", value)

    @_builtins.property
    @pulumi.getter(name="modifyDatabaseDbmFeature")
    def modify_database_dbm_feature(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "modify_database_dbm_feature")

    @modify_database_dbm_feature.setter
    def modify_database_dbm_feature(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "modify_database_dbm_feature", value)


@pulumi.input_type
class _DatabaseDbmFeaturesManagementState:
    def __init__(__self__, *,
                 can_disable_all_pdbs: Optional[pulumi.Input[_builtins.bool]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_database_dbm_feature: Optional[pulumi.Input[_builtins.bool]] = None,
                 feature: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_details: Optional[pulumi.Input['DatabaseDbmFeaturesManagementFeatureDetailsArgs']] = None,
                 modify_database_dbm_feature: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering DatabaseDbmFeaturesManagement resources.
        :param pulumi.Input[_builtins.str] database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database.
        :param pulumi.Input[_builtins.bool] enable_database_dbm_feature: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input['DatabaseDbmFeaturesManagementFeatureDetailsArgs'] feature_details: The details required to enable the specified Database Management feature.
        """
        if can_disable_all_pdbs is not None:
            pulumi.set(__self__, "can_disable_all_pdbs", can_disable_all_pdbs)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if enable_database_dbm_feature is not None:
            pulumi.set(__self__, "enable_database_dbm_feature", enable_database_dbm_feature)
        if feature is not None:
            pulumi.set(__self__, "feature", feature)
        if feature_details is not None:
            pulumi.set(__self__, "feature_details", feature_details)
        if modify_database_dbm_feature is not None:
            pulumi.set(__self__, "modify_database_dbm_feature", modify_database_dbm_feature)

    @_builtins.property
    @pulumi.getter(name="canDisableAllPdbs")
    def can_disable_all_pdbs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "can_disable_all_pdbs")

    @can_disable_all_pdbs.setter
    def can_disable_all_pdbs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "can_disable_all_pdbs", value)

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_id", value)

    @_builtins.property
    @pulumi.getter(name="enableDatabaseDbmFeature")
    def enable_database_dbm_feature(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_database_dbm_feature")

    @enable_database_dbm_feature.setter
    def enable_database_dbm_feature(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_database_dbm_feature", value)

    @_builtins.property
    @pulumi.getter
    def feature(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "feature")

    @feature.setter
    def feature(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "feature", value)

    @_builtins.property
    @pulumi.getter(name="featureDetails")
    def feature_details(self) -> Optional[pulumi.Input['DatabaseDbmFeaturesManagementFeatureDetailsArgs']]:
        """
        The details required to enable the specified Database Management feature.
        """
        return pulumi.get(self, "feature_details")

    @feature_details.setter
    def feature_details(self, value: Optional[pulumi.Input['DatabaseDbmFeaturesManagementFeatureDetailsArgs']]):
        pulumi.set(self, "feature_details", value)

    @_builtins.property
    @pulumi.getter(name="modifyDatabaseDbmFeature")
    def modify_database_dbm_feature(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "modify_database_dbm_feature")

    @modify_database_dbm_feature.setter
    def modify_database_dbm_feature(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "modify_database_dbm_feature", value)


@pulumi.type_token("oci:DatabaseManagement/databaseDbmFeaturesManagement:DatabaseDbmFeaturesManagement")
class DatabaseDbmFeaturesManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 can_disable_all_pdbs: Optional[pulumi.Input[_builtins.bool]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_database_dbm_feature: Optional[pulumi.Input[_builtins.bool]] = None,
                 feature: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_details: Optional[pulumi.Input[Union['DatabaseDbmFeaturesManagementFeatureDetailsArgs', 'DatabaseDbmFeaturesManagementFeatureDetailsArgsDict']]] = None,
                 modify_database_dbm_feature: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        This resource provides the Database Dbm Features Management resource in Oracle Cloud Infrastructure Database Management service.

        Enables a Database Management feature for the specified cloud database.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database.
        :param pulumi.Input[_builtins.bool] enable_database_dbm_feature: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Union['DatabaseDbmFeaturesManagementFeatureDetailsArgs', 'DatabaseDbmFeaturesManagementFeatureDetailsArgsDict']] feature_details: The details required to enable the specified Database Management feature.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseDbmFeaturesManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Database Dbm Features Management resource in Oracle Cloud Infrastructure Database Management service.

        Enables a Database Management feature for the specified cloud database.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param DatabaseDbmFeaturesManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseDbmFeaturesManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 can_disable_all_pdbs: Optional[pulumi.Input[_builtins.bool]] = None,
                 database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_database_dbm_feature: Optional[pulumi.Input[_builtins.bool]] = None,
                 feature: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_details: Optional[pulumi.Input[Union['DatabaseDbmFeaturesManagementFeatureDetailsArgs', 'DatabaseDbmFeaturesManagementFeatureDetailsArgsDict']]] = None,
                 modify_database_dbm_feature: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseDbmFeaturesManagementArgs.__new__(DatabaseDbmFeaturesManagementArgs)

            __props__.__dict__["can_disable_all_pdbs"] = can_disable_all_pdbs
            if database_id is None and not opts.urn:
                raise TypeError("Missing required property 'database_id'")
            __props__.__dict__["database_id"] = database_id
            if enable_database_dbm_feature is None and not opts.urn:
                raise TypeError("Missing required property 'enable_database_dbm_feature'")
            __props__.__dict__["enable_database_dbm_feature"] = enable_database_dbm_feature
            __props__.__dict__["feature"] = feature
            __props__.__dict__["feature_details"] = feature_details
            __props__.__dict__["modify_database_dbm_feature"] = modify_database_dbm_feature
        super(DatabaseDbmFeaturesManagement, __self__).__init__(
            'oci:DatabaseManagement/databaseDbmFeaturesManagement:DatabaseDbmFeaturesManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            can_disable_all_pdbs: Optional[pulumi.Input[_builtins.bool]] = None,
            database_id: Optional[pulumi.Input[_builtins.str]] = None,
            enable_database_dbm_feature: Optional[pulumi.Input[_builtins.bool]] = None,
            feature: Optional[pulumi.Input[_builtins.str]] = None,
            feature_details: Optional[pulumi.Input[Union['DatabaseDbmFeaturesManagementFeatureDetailsArgs', 'DatabaseDbmFeaturesManagementFeatureDetailsArgsDict']]] = None,
            modify_database_dbm_feature: Optional[pulumi.Input[_builtins.bool]] = None) -> 'DatabaseDbmFeaturesManagement':
        """
        Get an existing DatabaseDbmFeaturesManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database.
        :param pulumi.Input[_builtins.bool] enable_database_dbm_feature: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Union['DatabaseDbmFeaturesManagementFeatureDetailsArgs', 'DatabaseDbmFeaturesManagementFeatureDetailsArgsDict']] feature_details: The details required to enable the specified Database Management feature.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseDbmFeaturesManagementState.__new__(_DatabaseDbmFeaturesManagementState)

        __props__.__dict__["can_disable_all_pdbs"] = can_disable_all_pdbs
        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["enable_database_dbm_feature"] = enable_database_dbm_feature
        __props__.__dict__["feature"] = feature
        __props__.__dict__["feature_details"] = feature_details
        __props__.__dict__["modify_database_dbm_feature"] = modify_database_dbm_feature
        return DatabaseDbmFeaturesManagement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="canDisableAllPdbs")
    def can_disable_all_pdbs(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "can_disable_all_pdbs")

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database.
        """
        return pulumi.get(self, "database_id")

    @_builtins.property
    @pulumi.getter(name="enableDatabaseDbmFeature")
    def enable_database_dbm_feature(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_database_dbm_feature")

    @_builtins.property
    @pulumi.getter
    def feature(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "feature")

    @_builtins.property
    @pulumi.getter(name="featureDetails")
    def feature_details(self) -> pulumi.Output[Optional['outputs.DatabaseDbmFeaturesManagementFeatureDetails']]:
        """
        The details required to enable the specified Database Management feature.
        """
        return pulumi.get(self, "feature_details")

    @_builtins.property
    @pulumi.getter(name="modifyDatabaseDbmFeature")
    def modify_database_dbm_feature(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "modify_database_dbm_feature")

