# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCloudDbSystemsResult',
    'AwaitableGetCloudDbSystemsResult',
    'get_cloud_db_systems',
    'get_cloud_db_systems_output',
]

@pulumi.output_type
class GetCloudDbSystemsResult:
    """
    A collection of values returned by getCloudDbSystems.
    """
    def __init__(__self__, cloud_db_system_collections=None, compartment_id=None, dbaas_parent_infrastructure_id=None, deployment_type=None, display_name=None, filters=None, id=None, state=None):
        if cloud_db_system_collections and not isinstance(cloud_db_system_collections, list):
            raise TypeError("Expected argument 'cloud_db_system_collections' to be a list")
        pulumi.set(__self__, "cloud_db_system_collections", cloud_db_system_collections)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if dbaas_parent_infrastructure_id and not isinstance(dbaas_parent_infrastructure_id, str):
            raise TypeError("Expected argument 'dbaas_parent_infrastructure_id' to be a str")
        pulumi.set(__self__, "dbaas_parent_infrastructure_id", dbaas_parent_infrastructure_id)
        if deployment_type and not isinstance(deployment_type, str):
            raise TypeError("Expected argument 'deployment_type' to be a str")
        pulumi.set(__self__, "deployment_type", deployment_type)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="cloudDbSystemCollections")
    def cloud_db_system_collections(self) -> Sequence['outputs.GetCloudDbSystemsCloudDbSystemCollectionResult']:
        """
        The list of cloud_db_system_collection.
        """
        return pulumi.get(self, "cloud_db_system_collections")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dbaasParentInfrastructureId")
    def dbaas_parent_infrastructure_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the parent cloud DB Infrastructure. For VM Dbsystems , it will be the DBSystem Id. For ExaCS and ExaCC,  it will be the cloudVmClusterId and vmClusterId respectively.
        """
        return pulumi.get(self, "dbaas_parent_infrastructure_id")

    @_builtins.property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[_builtins.str]:
        """
        The deployment type of cloud dbsystem.
        """
        return pulumi.get(self, "deployment_type")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The user-friendly name for the DB system. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCloudDbSystemsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current lifecycle state of the cloud DB system resource.
        """
        return pulumi.get(self, "state")


class AwaitableGetCloudDbSystemsResult(GetCloudDbSystemsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudDbSystemsResult(
            cloud_db_system_collections=self.cloud_db_system_collections,
            compartment_id=self.compartment_id,
            dbaas_parent_infrastructure_id=self.dbaas_parent_infrastructure_id,
            deployment_type=self.deployment_type,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_cloud_db_systems(compartment_id: Optional[_builtins.str] = None,
                         dbaas_parent_infrastructure_id: Optional[_builtins.str] = None,
                         deployment_type: Optional[_builtins.str] = None,
                         display_name: Optional[_builtins.str] = None,
                         filters: Optional[Sequence[Union['GetCloudDbSystemsFilterArgs', 'GetCloudDbSystemsFilterArgsDict']]] = None,
                         state: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudDbSystemsResult:
    """
    This data source provides the list of Cloud Db Systems in Oracle Cloud Infrastructure Database Management service.

    Lists the cloud DB systems in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_db_systems = oci.DatabaseManagement.get_cloud_db_systems(compartment_id=compartment_id,
        dbaas_parent_infrastructure_id=test_dbaas_parent_infrastructure["id"],
        deployment_type=cloud_db_system_deployment_type,
        display_name=cloud_db_system_display_name,
        state=cloud_db_system_state)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str dbaas_parent_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the dbaas parent infrastructure of the cloud DB system.
    :param _builtins.str deployment_type: A filter to return cloud DB systems of the specified deployment type.
    :param _builtins.str display_name: A filter to only return the resources that match the entire display name.
    :param _builtins.str state: The lifecycle state of a resource.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['dbaasParentInfrastructureId'] = dbaas_parent_infrastructure_id
    __args__['deploymentType'] = deployment_type
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getCloudDbSystems:getCloudDbSystems', __args__, opts=opts, typ=GetCloudDbSystemsResult).value

    return AwaitableGetCloudDbSystemsResult(
        cloud_db_system_collections=pulumi.get(__ret__, 'cloud_db_system_collections'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        dbaas_parent_infrastructure_id=pulumi.get(__ret__, 'dbaas_parent_infrastructure_id'),
        deployment_type=pulumi.get(__ret__, 'deployment_type'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_cloud_db_systems_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                dbaas_parent_infrastructure_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                deployment_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetCloudDbSystemsFilterArgs', 'GetCloudDbSystemsFilterArgsDict']]]]] = None,
                                state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudDbSystemsResult]:
    """
    This data source provides the list of Cloud Db Systems in Oracle Cloud Infrastructure Database Management service.

    Lists the cloud DB systems in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_db_systems = oci.DatabaseManagement.get_cloud_db_systems(compartment_id=compartment_id,
        dbaas_parent_infrastructure_id=test_dbaas_parent_infrastructure["id"],
        deployment_type=cloud_db_system_deployment_type,
        display_name=cloud_db_system_display_name,
        state=cloud_db_system_state)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str dbaas_parent_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the dbaas parent infrastructure of the cloud DB system.
    :param _builtins.str deployment_type: A filter to return cloud DB systems of the specified deployment type.
    :param _builtins.str display_name: A filter to only return the resources that match the entire display name.
    :param _builtins.str state: The lifecycle state of a resource.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['dbaasParentInfrastructureId'] = dbaas_parent_infrastructure_id
    __args__['deploymentType'] = deployment_type
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getCloudDbSystems:getCloudDbSystems', __args__, opts=opts, typ=GetCloudDbSystemsResult)
    return __ret__.apply(lambda __response__: GetCloudDbSystemsResult(
        cloud_db_system_collections=pulumi.get(__response__, 'cloud_db_system_collections'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        dbaas_parent_infrastructure_id=pulumi.get(__response__, 'dbaas_parent_infrastructure_id'),
        deployment_type=pulumi.get(__response__, 'deployment_type'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
