# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCloudListenerServicesResult',
    'AwaitableGetCloudListenerServicesResult',
    'get_cloud_listener_services',
    'get_cloud_listener_services_output',
]

@pulumi.output_type
class GetCloudListenerServicesResult:
    """
    A collection of values returned by getCloudListenerServices.
    """
    def __init__(__self__, cloud_listener_id=None, cloud_listener_service_collections=None, filters=None, id=None, managed_database_id=None, opc_named_credential_id=None):
        if cloud_listener_id and not isinstance(cloud_listener_id, str):
            raise TypeError("Expected argument 'cloud_listener_id' to be a str")
        pulumi.set(__self__, "cloud_listener_id", cloud_listener_id)
        if cloud_listener_service_collections and not isinstance(cloud_listener_service_collections, list):
            raise TypeError("Expected argument 'cloud_listener_service_collections' to be a list")
        pulumi.set(__self__, "cloud_listener_service_collections", cloud_listener_service_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if opc_named_credential_id and not isinstance(opc_named_credential_id, str):
            raise TypeError("Expected argument 'opc_named_credential_id' to be a str")
        pulumi.set(__self__, "opc_named_credential_id", opc_named_credential_id)

    @_builtins.property
    @pulumi.getter(name="cloudListenerId")
    def cloud_listener_id(self) -> _builtins.str:
        return pulumi.get(self, "cloud_listener_id")

    @_builtins.property
    @pulumi.getter(name="cloudListenerServiceCollections")
    def cloud_listener_service_collections(self) -> Sequence['outputs.GetCloudListenerServicesCloudListenerServiceCollectionResult']:
        """
        The list of cloud_listener_service_collection.
        """
        return pulumi.get(self, "cloud_listener_service_collections")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCloudListenerServicesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
        """
        return pulumi.get(self, "managed_database_id")

    @_builtins.property
    @pulumi.getter(name="opcNamedCredentialId")
    def opc_named_credential_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "opc_named_credential_id")


class AwaitableGetCloudListenerServicesResult(GetCloudListenerServicesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudListenerServicesResult(
            cloud_listener_id=self.cloud_listener_id,
            cloud_listener_service_collections=self.cloud_listener_service_collections,
            filters=self.filters,
            id=self.id,
            managed_database_id=self.managed_database_id,
            opc_named_credential_id=self.opc_named_credential_id)


def get_cloud_listener_services(cloud_listener_id: Optional[_builtins.str] = None,
                                filters: Optional[Sequence[Union['GetCloudListenerServicesFilterArgs', 'GetCloudListenerServicesFilterArgsDict']]] = None,
                                managed_database_id: Optional[_builtins.str] = None,
                                opc_named_credential_id: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudListenerServicesResult:
    """
    This data source provides the list of Cloud Listener Services in Oracle Cloud Infrastructure Database Management service.

    Lists the database services registered with the specified cloud listener
    for the specified Managed Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_listener_services = oci.DatabaseManagement.get_cloud_listener_services(cloud_listener_id=test_cloud_listener["id"],
        managed_database_id=test_managed_database["id"],
        opc_named_credential_id=cloud_listener_service_opc_named_credential_id)
    ```


    :param _builtins.str cloud_listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud listener.
    :param _builtins.str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param _builtins.str opc_named_credential_id: The OCID of the Named Credential.
    """
    __args__ = dict()
    __args__['cloudListenerId'] = cloud_listener_id
    __args__['filters'] = filters
    __args__['managedDatabaseId'] = managed_database_id
    __args__['opcNamedCredentialId'] = opc_named_credential_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getCloudListenerServices:getCloudListenerServices', __args__, opts=opts, typ=GetCloudListenerServicesResult).value

    return AwaitableGetCloudListenerServicesResult(
        cloud_listener_id=pulumi.get(__ret__, 'cloud_listener_id'),
        cloud_listener_service_collections=pulumi.get(__ret__, 'cloud_listener_service_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        opc_named_credential_id=pulumi.get(__ret__, 'opc_named_credential_id'))
def get_cloud_listener_services_output(cloud_listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetCloudListenerServicesFilterArgs', 'GetCloudListenerServicesFilterArgsDict']]]]] = None,
                                       managed_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       opc_named_credential_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudListenerServicesResult]:
    """
    This data source provides the list of Cloud Listener Services in Oracle Cloud Infrastructure Database Management service.

    Lists the database services registered with the specified cloud listener
    for the specified Managed Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_listener_services = oci.DatabaseManagement.get_cloud_listener_services(cloud_listener_id=test_cloud_listener["id"],
        managed_database_id=test_managed_database["id"],
        opc_named_credential_id=cloud_listener_service_opc_named_credential_id)
    ```


    :param _builtins.str cloud_listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud listener.
    :param _builtins.str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param _builtins.str opc_named_credential_id: The OCID of the Named Credential.
    """
    __args__ = dict()
    __args__['cloudListenerId'] = cloud_listener_id
    __args__['filters'] = filters
    __args__['managedDatabaseId'] = managed_database_id
    __args__['opcNamedCredentialId'] = opc_named_credential_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getCloudListenerServices:getCloudListenerServices', __args__, opts=opts, typ=GetCloudListenerServicesResult)
    return __ret__.apply(lambda __response__: GetCloudListenerServicesResult(
        cloud_listener_id=pulumi.get(__response__, 'cloud_listener_id'),
        cloud_listener_service_collections=pulumi.get(__response__, 'cloud_listener_service_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        managed_database_id=pulumi.get(__response__, 'managed_database_id'),
        opc_named_credential_id=pulumi.get(__response__, 'opc_named_credential_id')))
