# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetManagedDatabaseSqlPlanBaselineConfigurationResult',
    'AwaitableGetManagedDatabaseSqlPlanBaselineConfigurationResult',
    'get_managed_database_sql_plan_baseline_configuration',
    'get_managed_database_sql_plan_baseline_configuration_output',
]

@pulumi.output_type
class GetManagedDatabaseSqlPlanBaselineConfigurationResult:
    """
    A collection of values returned by getManagedDatabaseSqlPlanBaselineConfiguration.
    """
    def __init__(__self__, auto_capture_filters=None, auto_spm_evolve_task_parameters=None, id=None, is_auto_spm_evolve_task_enabled=None, is_automatic_initial_plan_capture_enabled=None, is_high_frequency_auto_spm_evolve_task_enabled=None, is_sql_plan_baselines_usage_enabled=None, managed_database_id=None, opc_named_credential_id=None, plan_retention_weeks=None, space_budget_mb=None, space_budget_percent=None, space_used_mb=None):
        if auto_capture_filters and not isinstance(auto_capture_filters, list):
            raise TypeError("Expected argument 'auto_capture_filters' to be a list")
        pulumi.set(__self__, "auto_capture_filters", auto_capture_filters)
        if auto_spm_evolve_task_parameters and not isinstance(auto_spm_evolve_task_parameters, list):
            raise TypeError("Expected argument 'auto_spm_evolve_task_parameters' to be a list")
        pulumi.set(__self__, "auto_spm_evolve_task_parameters", auto_spm_evolve_task_parameters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_auto_spm_evolve_task_enabled and not isinstance(is_auto_spm_evolve_task_enabled, bool):
            raise TypeError("Expected argument 'is_auto_spm_evolve_task_enabled' to be a bool")
        pulumi.set(__self__, "is_auto_spm_evolve_task_enabled", is_auto_spm_evolve_task_enabled)
        if is_automatic_initial_plan_capture_enabled and not isinstance(is_automatic_initial_plan_capture_enabled, bool):
            raise TypeError("Expected argument 'is_automatic_initial_plan_capture_enabled' to be a bool")
        pulumi.set(__self__, "is_automatic_initial_plan_capture_enabled", is_automatic_initial_plan_capture_enabled)
        if is_high_frequency_auto_spm_evolve_task_enabled and not isinstance(is_high_frequency_auto_spm_evolve_task_enabled, bool):
            raise TypeError("Expected argument 'is_high_frequency_auto_spm_evolve_task_enabled' to be a bool")
        pulumi.set(__self__, "is_high_frequency_auto_spm_evolve_task_enabled", is_high_frequency_auto_spm_evolve_task_enabled)
        if is_sql_plan_baselines_usage_enabled and not isinstance(is_sql_plan_baselines_usage_enabled, bool):
            raise TypeError("Expected argument 'is_sql_plan_baselines_usage_enabled' to be a bool")
        pulumi.set(__self__, "is_sql_plan_baselines_usage_enabled", is_sql_plan_baselines_usage_enabled)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if opc_named_credential_id and not isinstance(opc_named_credential_id, str):
            raise TypeError("Expected argument 'opc_named_credential_id' to be a str")
        pulumi.set(__self__, "opc_named_credential_id", opc_named_credential_id)
        if plan_retention_weeks and not isinstance(plan_retention_weeks, int):
            raise TypeError("Expected argument 'plan_retention_weeks' to be a int")
        pulumi.set(__self__, "plan_retention_weeks", plan_retention_weeks)
        if space_budget_mb and not isinstance(space_budget_mb, float):
            raise TypeError("Expected argument 'space_budget_mb' to be a float")
        pulumi.set(__self__, "space_budget_mb", space_budget_mb)
        if space_budget_percent and not isinstance(space_budget_percent, float):
            raise TypeError("Expected argument 'space_budget_percent' to be a float")
        pulumi.set(__self__, "space_budget_percent", space_budget_percent)
        if space_used_mb and not isinstance(space_used_mb, float):
            raise TypeError("Expected argument 'space_used_mb' to be a float")
        pulumi.set(__self__, "space_used_mb", space_used_mb)

    @_builtins.property
    @pulumi.getter(name="autoCaptureFilters")
    def auto_capture_filters(self) -> Sequence['outputs.GetManagedDatabaseSqlPlanBaselineConfigurationAutoCaptureFilterResult']:
        """
        The capture filters used in automatic initial plan capture.
        """
        return pulumi.get(self, "auto_capture_filters")

    @_builtins.property
    @pulumi.getter(name="autoSpmEvolveTaskParameters")
    def auto_spm_evolve_task_parameters(self) -> Sequence['outputs.GetManagedDatabaseSqlPlanBaselineConfigurationAutoSpmEvolveTaskParameterResult']:
        """
        The set of parameters used in an SPM evolve task.
        """
        return pulumi.get(self, "auto_spm_evolve_task_parameters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isAutoSpmEvolveTaskEnabled")
    def is_auto_spm_evolve_task_enabled(self) -> _builtins.bool:
        """
        Indicates whether the Automatic SPM Evolve Advisor task is enabled (`true`) or not (`false`).
        """
        return pulumi.get(self, "is_auto_spm_evolve_task_enabled")

    @_builtins.property
    @pulumi.getter(name="isAutomaticInitialPlanCaptureEnabled")
    def is_automatic_initial_plan_capture_enabled(self) -> _builtins.bool:
        """
        Indicates whether the automatic capture of SQL plan baselines is enabled (`true`) or not (`false`).
        """
        return pulumi.get(self, "is_automatic_initial_plan_capture_enabled")

    @_builtins.property
    @pulumi.getter(name="isHighFrequencyAutoSpmEvolveTaskEnabled")
    def is_high_frequency_auto_spm_evolve_task_enabled(self) -> _builtins.bool:
        """
        Indicates whether the high frequency Automatic SPM Evolve Advisor task is enabled (`true`) or not (`false`).
        """
        return pulumi.get(self, "is_high_frequency_auto_spm_evolve_task_enabled")

    @_builtins.property
    @pulumi.getter(name="isSqlPlanBaselinesUsageEnabled")
    def is_sql_plan_baselines_usage_enabled(self) -> _builtins.bool:
        """
        Indicates whether the database uses SQL plan baselines (`true`) or not (`false`).
        """
        return pulumi.get(self, "is_sql_plan_baselines_usage_enabled")

    @_builtins.property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> _builtins.str:
        return pulumi.get(self, "managed_database_id")

    @_builtins.property
    @pulumi.getter(name="opcNamedCredentialId")
    def opc_named_credential_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "opc_named_credential_id")

    @_builtins.property
    @pulumi.getter(name="planRetentionWeeks")
    def plan_retention_weeks(self) -> _builtins.int:
        """
        The number of weeks to retain unused plans before they are purged.
        """
        return pulumi.get(self, "plan_retention_weeks")

    @_builtins.property
    @pulumi.getter(name="spaceBudgetMb")
    def space_budget_mb(self) -> _builtins.float:
        """
        The maximum `SYSAUX` space that can be used for SQL Management Base in MB.
        """
        return pulumi.get(self, "space_budget_mb")

    @_builtins.property
    @pulumi.getter(name="spaceBudgetPercent")
    def space_budget_percent(self) -> _builtins.float:
        """
        The maximum percent of `SYSAUX` space that can be used for SQL Management Base.
        """
        return pulumi.get(self, "space_budget_percent")

    @_builtins.property
    @pulumi.getter(name="spaceUsedMb")
    def space_used_mb(self) -> _builtins.float:
        """
        The space used by SQL Management Base in MB.
        """
        return pulumi.get(self, "space_used_mb")


class AwaitableGetManagedDatabaseSqlPlanBaselineConfigurationResult(GetManagedDatabaseSqlPlanBaselineConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseSqlPlanBaselineConfigurationResult(
            auto_capture_filters=self.auto_capture_filters,
            auto_spm_evolve_task_parameters=self.auto_spm_evolve_task_parameters,
            id=self.id,
            is_auto_spm_evolve_task_enabled=self.is_auto_spm_evolve_task_enabled,
            is_automatic_initial_plan_capture_enabled=self.is_automatic_initial_plan_capture_enabled,
            is_high_frequency_auto_spm_evolve_task_enabled=self.is_high_frequency_auto_spm_evolve_task_enabled,
            is_sql_plan_baselines_usage_enabled=self.is_sql_plan_baselines_usage_enabled,
            managed_database_id=self.managed_database_id,
            opc_named_credential_id=self.opc_named_credential_id,
            plan_retention_weeks=self.plan_retention_weeks,
            space_budget_mb=self.space_budget_mb,
            space_budget_percent=self.space_budget_percent,
            space_used_mb=self.space_used_mb)


def get_managed_database_sql_plan_baseline_configuration(managed_database_id: Optional[_builtins.str] = None,
                                                         opc_named_credential_id: Optional[_builtins.str] = None,
                                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseSqlPlanBaselineConfigurationResult:
    """
    This data source provides details about a specific Managed Database Sql Plan Baseline Configuration resource in Oracle Cloud Infrastructure Database Management service.

    Gets the configuration details of SQL plan baselines for the specified
    Managed Database. The details include the settings for the capture and use of
    SQL plan baselines, SPM Evolve Advisor task, and SQL Management Base.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_sql_plan_baseline_configuration = oci.DatabaseManagement.get_managed_database_sql_plan_baseline_configuration(managed_database_id=test_managed_database["id"],
        opc_named_credential_id=managed_database_sql_plan_baseline_configuration_opc_named_credential_id)
    ```


    :param _builtins.str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param _builtins.str opc_named_credential_id: The OCID of the Named Credential.
    """
    __args__ = dict()
    __args__['managedDatabaseId'] = managed_database_id
    __args__['opcNamedCredentialId'] = opc_named_credential_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabaseSqlPlanBaselineConfiguration:getManagedDatabaseSqlPlanBaselineConfiguration', __args__, opts=opts, typ=GetManagedDatabaseSqlPlanBaselineConfigurationResult).value

    return AwaitableGetManagedDatabaseSqlPlanBaselineConfigurationResult(
        auto_capture_filters=pulumi.get(__ret__, 'auto_capture_filters'),
        auto_spm_evolve_task_parameters=pulumi.get(__ret__, 'auto_spm_evolve_task_parameters'),
        id=pulumi.get(__ret__, 'id'),
        is_auto_spm_evolve_task_enabled=pulumi.get(__ret__, 'is_auto_spm_evolve_task_enabled'),
        is_automatic_initial_plan_capture_enabled=pulumi.get(__ret__, 'is_automatic_initial_plan_capture_enabled'),
        is_high_frequency_auto_spm_evolve_task_enabled=pulumi.get(__ret__, 'is_high_frequency_auto_spm_evolve_task_enabled'),
        is_sql_plan_baselines_usage_enabled=pulumi.get(__ret__, 'is_sql_plan_baselines_usage_enabled'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        opc_named_credential_id=pulumi.get(__ret__, 'opc_named_credential_id'),
        plan_retention_weeks=pulumi.get(__ret__, 'plan_retention_weeks'),
        space_budget_mb=pulumi.get(__ret__, 'space_budget_mb'),
        space_budget_percent=pulumi.get(__ret__, 'space_budget_percent'),
        space_used_mb=pulumi.get(__ret__, 'space_used_mb'))
def get_managed_database_sql_plan_baseline_configuration_output(managed_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                                opc_named_credential_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedDatabaseSqlPlanBaselineConfigurationResult]:
    """
    This data source provides details about a specific Managed Database Sql Plan Baseline Configuration resource in Oracle Cloud Infrastructure Database Management service.

    Gets the configuration details of SQL plan baselines for the specified
    Managed Database. The details include the settings for the capture and use of
    SQL plan baselines, SPM Evolve Advisor task, and SQL Management Base.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_sql_plan_baseline_configuration = oci.DatabaseManagement.get_managed_database_sql_plan_baseline_configuration(managed_database_id=test_managed_database["id"],
        opc_named_credential_id=managed_database_sql_plan_baseline_configuration_opc_named_credential_id)
    ```


    :param _builtins.str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param _builtins.str opc_named_credential_id: The OCID of the Named Credential.
    """
    __args__ = dict()
    __args__['managedDatabaseId'] = managed_database_id
    __args__['opcNamedCredentialId'] = opc_named_credential_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getManagedDatabaseSqlPlanBaselineConfiguration:getManagedDatabaseSqlPlanBaselineConfiguration', __args__, opts=opts, typ=GetManagedDatabaseSqlPlanBaselineConfigurationResult)
    return __ret__.apply(lambda __response__: GetManagedDatabaseSqlPlanBaselineConfigurationResult(
        auto_capture_filters=pulumi.get(__response__, 'auto_capture_filters'),
        auto_spm_evolve_task_parameters=pulumi.get(__response__, 'auto_spm_evolve_task_parameters'),
        id=pulumi.get(__response__, 'id'),
        is_auto_spm_evolve_task_enabled=pulumi.get(__response__, 'is_auto_spm_evolve_task_enabled'),
        is_automatic_initial_plan_capture_enabled=pulumi.get(__response__, 'is_automatic_initial_plan_capture_enabled'),
        is_high_frequency_auto_spm_evolve_task_enabled=pulumi.get(__response__, 'is_high_frequency_auto_spm_evolve_task_enabled'),
        is_sql_plan_baselines_usage_enabled=pulumi.get(__response__, 'is_sql_plan_baselines_usage_enabled'),
        managed_database_id=pulumi.get(__response__, 'managed_database_id'),
        opc_named_credential_id=pulumi.get(__response__, 'opc_named_credential_id'),
        plan_retention_weeks=pulumi.get(__response__, 'plan_retention_weeks'),
        space_budget_mb=pulumi.get(__response__, 'space_budget_mb'),
        space_budget_percent=pulumi.get(__response__, 'space_budget_percent'),
        space_used_mb=pulumi.get(__response__, 'space_used_mb')))
