# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetManagedDatabasesDatabaseParameterResult',
    'AwaitableGetManagedDatabasesDatabaseParameterResult',
    'get_managed_databases_database_parameter',
    'get_managed_databases_database_parameter_output',
]

@pulumi.output_type
class GetManagedDatabasesDatabaseParameterResult:
    """
    A collection of values returned by getManagedDatabasesDatabaseParameter.
    """
    def __init__(__self__, database_name=None, database_sub_type=None, database_type=None, database_version=None, id=None, is_allowed_values_included=None, items=None, managed_database_id=None, name=None, source=None):
        if database_name and not isinstance(database_name, str):
            raise TypeError("Expected argument 'database_name' to be a str")
        pulumi.set(__self__, "database_name", database_name)
        if database_sub_type and not isinstance(database_sub_type, str):
            raise TypeError("Expected argument 'database_sub_type' to be a str")
        pulumi.set(__self__, "database_sub_type", database_sub_type)
        if database_type and not isinstance(database_type, str):
            raise TypeError("Expected argument 'database_type' to be a str")
        pulumi.set(__self__, "database_type", database_type)
        if database_version and not isinstance(database_version, str):
            raise TypeError("Expected argument 'database_version' to be a str")
        pulumi.set(__self__, "database_version", database_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_allowed_values_included and not isinstance(is_allowed_values_included, bool):
            raise TypeError("Expected argument 'is_allowed_values_included' to be a bool")
        pulumi.set(__self__, "is_allowed_values_included", is_allowed_values_included)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if source and not isinstance(source, str):
            raise TypeError("Expected argument 'source' to be a str")
        pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> _builtins.str:
        """
        The name of the Managed Database.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter(name="databaseSubType")
    def database_sub_type(self) -> _builtins.str:
        """
        The subtype of the Oracle Database. Indicates whether the database is a Container Database, Pluggable Database, or a Non-container Database.
        """
        return pulumi.get(self, "database_sub_type")

    @_builtins.property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> _builtins.str:
        """
        The type of Oracle Database installation.
        """
        return pulumi.get(self, "database_type")

    @_builtins.property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> _builtins.str:
        """
        The Oracle Database version.
        """
        return pulumi.get(self, "database_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isAllowedValuesIncluded")
    def is_allowed_values_included(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "is_allowed_values_included")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetManagedDatabasesDatabaseParameterItemResult']:
        """
        An array of DatabaseParameterSummary objects.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> _builtins.str:
        return pulumi.get(self, "managed_database_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "source")


class AwaitableGetManagedDatabasesDatabaseParameterResult(GetManagedDatabasesDatabaseParameterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabasesDatabaseParameterResult(
            database_name=self.database_name,
            database_sub_type=self.database_sub_type,
            database_type=self.database_type,
            database_version=self.database_version,
            id=self.id,
            is_allowed_values_included=self.is_allowed_values_included,
            items=self.items,
            managed_database_id=self.managed_database_id,
            name=self.name,
            source=self.source)


def get_managed_databases_database_parameter(is_allowed_values_included: Optional[_builtins.bool] = None,
                                             managed_database_id: Optional[_builtins.str] = None,
                                             name: Optional[_builtins.str] = None,
                                             source: Optional[_builtins.str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabasesDatabaseParameterResult:
    """
    This data source provides details about a specific Managed Databases Database Parameter resource in Oracle Cloud Infrastructure Database Management service.

    Gets the list of database parameters for the specified Managed Database. The parameters are listed in alphabetical order, along with their current values.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_databases_database_parameter = oci.DatabaseManagement.get_managed_databases_database_parameter(managed_database_id=test_managed_database["id"],
        is_allowed_values_included=managed_databases_database_parameter_is_allowed_values_included,
        name=managed_databases_database_parameter_name,
        source=managed_databases_database_parameter_source)
    ```


    :param _builtins.bool is_allowed_values_included: When true, results include a list of valid values for parameters (if applicable).
    :param _builtins.str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param _builtins.str name: A filter to return all parameters that have the text given in their names.
    :param _builtins.str source: The source used to list database parameters. `CURRENT` is used to get the database parameters that are currently in effect for the database instance. `SPFILE` is used to list parameters from the server parameter file. Default is `CURRENT`.
    """
    __args__ = dict()
    __args__['isAllowedValuesIncluded'] = is_allowed_values_included
    __args__['managedDatabaseId'] = managed_database_id
    __args__['name'] = name
    __args__['source'] = source
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabasesDatabaseParameter:getManagedDatabasesDatabaseParameter', __args__, opts=opts, typ=GetManagedDatabasesDatabaseParameterResult).value

    return AwaitableGetManagedDatabasesDatabaseParameterResult(
        database_name=pulumi.get(__ret__, 'database_name'),
        database_sub_type=pulumi.get(__ret__, 'database_sub_type'),
        database_type=pulumi.get(__ret__, 'database_type'),
        database_version=pulumi.get(__ret__, 'database_version'),
        id=pulumi.get(__ret__, 'id'),
        is_allowed_values_included=pulumi.get(__ret__, 'is_allowed_values_included'),
        items=pulumi.get(__ret__, 'items'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        name=pulumi.get(__ret__, 'name'),
        source=pulumi.get(__ret__, 'source'))
def get_managed_databases_database_parameter_output(is_allowed_values_included: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                                    managed_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                    name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                    source: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedDatabasesDatabaseParameterResult]:
    """
    This data source provides details about a specific Managed Databases Database Parameter resource in Oracle Cloud Infrastructure Database Management service.

    Gets the list of database parameters for the specified Managed Database. The parameters are listed in alphabetical order, along with their current values.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_databases_database_parameter = oci.DatabaseManagement.get_managed_databases_database_parameter(managed_database_id=test_managed_database["id"],
        is_allowed_values_included=managed_databases_database_parameter_is_allowed_values_included,
        name=managed_databases_database_parameter_name,
        source=managed_databases_database_parameter_source)
    ```


    :param _builtins.bool is_allowed_values_included: When true, results include a list of valid values for parameters (if applicable).
    :param _builtins.str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param _builtins.str name: A filter to return all parameters that have the text given in their names.
    :param _builtins.str source: The source used to list database parameters. `CURRENT` is used to get the database parameters that are currently in effect for the database instance. `SPFILE` is used to list parameters from the server parameter file. Default is `CURRENT`.
    """
    __args__ = dict()
    __args__['isAllowedValuesIncluded'] = is_allowed_values_included
    __args__['managedDatabaseId'] = managed_database_id
    __args__['name'] = name
    __args__['source'] = source
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getManagedDatabasesDatabaseParameter:getManagedDatabasesDatabaseParameter', __args__, opts=opts, typ=GetManagedDatabasesDatabaseParameterResult)
    return __ret__.apply(lambda __response__: GetManagedDatabasesDatabaseParameterResult(
        database_name=pulumi.get(__response__, 'database_name'),
        database_sub_type=pulumi.get(__response__, 'database_sub_type'),
        database_type=pulumi.get(__response__, 'database_type'),
        database_version=pulumi.get(__response__, 'database_version'),
        id=pulumi.get(__response__, 'id'),
        is_allowed_values_included=pulumi.get(__response__, 'is_allowed_values_included'),
        items=pulumi.get(__response__, 'items'),
        managed_database_id=pulumi.get(__response__, 'managed_database_id'),
        name=pulumi.get(__response__, 'name'),
        source=pulumi.get(__response__, 'source')))
