# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetManagedMySqlDatabaseBinaryLogInformationResult',
    'AwaitableGetManagedMySqlDatabaseBinaryLogInformationResult',
    'get_managed_my_sql_database_binary_log_information',
    'get_managed_my_sql_database_binary_log_information_output',
]

@pulumi.output_type
class GetManagedMySqlDatabaseBinaryLogInformationResult:
    """
    A collection of values returned by getManagedMySqlDatabaseBinaryLogInformation.
    """
    def __init__(__self__, binary_log_compression=None, binary_log_compression_percent=None, binary_log_format=None, binary_log_name=None, binary_log_position=None, binary_logging=None, id=None, managed_my_sql_database_id=None):
        if binary_log_compression and not isinstance(binary_log_compression, str):
            raise TypeError("Expected argument 'binary_log_compression' to be a str")
        pulumi.set(__self__, "binary_log_compression", binary_log_compression)
        if binary_log_compression_percent and not isinstance(binary_log_compression_percent, int):
            raise TypeError("Expected argument 'binary_log_compression_percent' to be a int")
        pulumi.set(__self__, "binary_log_compression_percent", binary_log_compression_percent)
        if binary_log_format and not isinstance(binary_log_format, str):
            raise TypeError("Expected argument 'binary_log_format' to be a str")
        pulumi.set(__self__, "binary_log_format", binary_log_format)
        if binary_log_name and not isinstance(binary_log_name, str):
            raise TypeError("Expected argument 'binary_log_name' to be a str")
        pulumi.set(__self__, "binary_log_name", binary_log_name)
        if binary_log_position and not isinstance(binary_log_position, str):
            raise TypeError("Expected argument 'binary_log_position' to be a str")
        pulumi.set(__self__, "binary_log_position", binary_log_position)
        if binary_logging and not isinstance(binary_logging, str):
            raise TypeError("Expected argument 'binary_logging' to be a str")
        pulumi.set(__self__, "binary_logging", binary_logging)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_my_sql_database_id and not isinstance(managed_my_sql_database_id, str):
            raise TypeError("Expected argument 'managed_my_sql_database_id' to be a str")
        pulumi.set(__self__, "managed_my_sql_database_id", managed_my_sql_database_id)

    @_builtins.property
    @pulumi.getter(name="binaryLogCompression")
    def binary_log_compression(self) -> _builtins.str:
        """
        Indicates whether compression is enabled for transactions written to binary log files on the MySQL server.
        """
        return pulumi.get(self, "binary_log_compression")

    @_builtins.property
    @pulumi.getter(name="binaryLogCompressionPercent")
    def binary_log_compression_percent(self) -> _builtins.int:
        """
        The compression ratio for the binary log, expressed as a percentage.
        """
        return pulumi.get(self, "binary_log_compression_percent")

    @_builtins.property
    @pulumi.getter(name="binaryLogFormat")
    def binary_log_format(self) -> _builtins.str:
        """
        The binary logging format used by the MySQL server.
        """
        return pulumi.get(self, "binary_log_format")

    @_builtins.property
    @pulumi.getter(name="binaryLogName")
    def binary_log_name(self) -> _builtins.str:
        """
        The name of the binary log file.
        """
        return pulumi.get(self, "binary_log_name")

    @_builtins.property
    @pulumi.getter(name="binaryLogPosition")
    def binary_log_position(self) -> _builtins.str:
        """
        The position within the binary log file.
        """
        return pulumi.get(self, "binary_log_position")

    @_builtins.property
    @pulumi.getter(name="binaryLogging")
    def binary_logging(self) -> _builtins.str:
        """
        The status of binary logging on the MySQL server.
        """
        return pulumi.get(self, "binary_logging")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="managedMySqlDatabaseId")
    def managed_my_sql_database_id(self) -> _builtins.str:
        return pulumi.get(self, "managed_my_sql_database_id")


class AwaitableGetManagedMySqlDatabaseBinaryLogInformationResult(GetManagedMySqlDatabaseBinaryLogInformationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedMySqlDatabaseBinaryLogInformationResult(
            binary_log_compression=self.binary_log_compression,
            binary_log_compression_percent=self.binary_log_compression_percent,
            binary_log_format=self.binary_log_format,
            binary_log_name=self.binary_log_name,
            binary_log_position=self.binary_log_position,
            binary_logging=self.binary_logging,
            id=self.id,
            managed_my_sql_database_id=self.managed_my_sql_database_id)


def get_managed_my_sql_database_binary_log_information(managed_my_sql_database_id: Optional[_builtins.str] = None,
                                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedMySqlDatabaseBinaryLogInformationResult:
    """
    This data source provides details about a specific Managed My Sql Database Binary Log Information resource in Oracle Cloud Infrastructure Database Management service.

    Retrieves information pertaining to the binary log of a specific MySQL server.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_my_sql_database_binary_log_information = oci.DatabaseManagement.get_managed_my_sql_database_binary_log_information(managed_my_sql_database_id=test_managed_my_sql_database["id"])
    ```


    :param _builtins.str managed_my_sql_database_id: The OCID of the Managed MySQL Database.
    """
    __args__ = dict()
    __args__['managedMySqlDatabaseId'] = managed_my_sql_database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedMySqlDatabaseBinaryLogInformation:getManagedMySqlDatabaseBinaryLogInformation', __args__, opts=opts, typ=GetManagedMySqlDatabaseBinaryLogInformationResult).value

    return AwaitableGetManagedMySqlDatabaseBinaryLogInformationResult(
        binary_log_compression=pulumi.get(__ret__, 'binary_log_compression'),
        binary_log_compression_percent=pulumi.get(__ret__, 'binary_log_compression_percent'),
        binary_log_format=pulumi.get(__ret__, 'binary_log_format'),
        binary_log_name=pulumi.get(__ret__, 'binary_log_name'),
        binary_log_position=pulumi.get(__ret__, 'binary_log_position'),
        binary_logging=pulumi.get(__ret__, 'binary_logging'),
        id=pulumi.get(__ret__, 'id'),
        managed_my_sql_database_id=pulumi.get(__ret__, 'managed_my_sql_database_id'))
def get_managed_my_sql_database_binary_log_information_output(managed_my_sql_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedMySqlDatabaseBinaryLogInformationResult]:
    """
    This data source provides details about a specific Managed My Sql Database Binary Log Information resource in Oracle Cloud Infrastructure Database Management service.

    Retrieves information pertaining to the binary log of a specific MySQL server.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_my_sql_database_binary_log_information = oci.DatabaseManagement.get_managed_my_sql_database_binary_log_information(managed_my_sql_database_id=test_managed_my_sql_database["id"])
    ```


    :param _builtins.str managed_my_sql_database_id: The OCID of the Managed MySQL Database.
    """
    __args__ = dict()
    __args__['managedMySqlDatabaseId'] = managed_my_sql_database_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getManagedMySqlDatabaseBinaryLogInformation:getManagedMySqlDatabaseBinaryLogInformation', __args__, opts=opts, typ=GetManagedMySqlDatabaseBinaryLogInformationResult)
    return __ret__.apply(lambda __response__: GetManagedMySqlDatabaseBinaryLogInformationResult(
        binary_log_compression=pulumi.get(__response__, 'binary_log_compression'),
        binary_log_compression_percent=pulumi.get(__response__, 'binary_log_compression_percent'),
        binary_log_format=pulumi.get(__response__, 'binary_log_format'),
        binary_log_name=pulumi.get(__response__, 'binary_log_name'),
        binary_log_position=pulumi.get(__response__, 'binary_log_position'),
        binary_logging=pulumi.get(__response__, 'binary_logging'),
        id=pulumi.get(__response__, 'id'),
        managed_my_sql_database_id=pulumi.get(__response__, 'managed_my_sql_database_id')))
